<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@  taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>
<fmt:bundle basename="localization.users">
	<div class="setup-title">
		<h1>{{editUserGroupCtrl.selectedGroup.userGroupName ? '<fmt:message key="pageHeader.editDefaultUserGroup"></fmt:message>' : '<fmt:message key="pageHeader.addDefaultUserGroup" />'}}
		<cv-help-component help-text="<cv:msg key="label.defaultUserGroupHelpText" bundle="users" />"></cv-help-component>
		</h1>
	</div>
	<div class="setup-content">
		<span class="server-message {{editUserGroupCtrl.serverMessage.type}}">{{editUserGroupCtrl.serverMessage.message}}</span>
		<form name="addAssociatedSmtpForm" novalidate data-cv-submit="editUserGroupCtrl.save(tc.groups)" autocomplete="off" class="edit-users-grid-form">
			<div>
				<label for="userGroupType"><cv:msg key="label.userGroup" bundle="users" />
					<div class="user-group-multi-select" style="width: 60%">
						<isteven-multi-select
		   				  input-model="editUserGroupCtrl.groups"
		  				  button-label="name"
		  				  item-label="name"
		   				  tick-property="ticked"
		   				  class="isteven-multi-select user-group-select"
		   				  id="defaultUserGroup"
		   				  name="defaultUserGroup"
		   				  helper-elements="none filter reset"
		   				  max-labels="1"
		   				  translation="editUserGroupCtrl.localLang"
		   				  disable-property="disabled"
		   				  on-item-click="editUserGroupCtrl.validateGroupSelection()"
		   				  on-select-none="editUserGroupCtrl.validateGroupSelection()"
		   				  on-reset="editUserGroupCtrl.validateGroupSelection()"
		   				  selection-mode="single">
						</isteven-multi-select>
					</div>
					<span class="help-block" data-ng-show="editUserGroupCtrl.showUserGroupErrorMessage"><fmt:message key="error.userGroupType" /></span>
				</label>
			</div>
			<div class="button-container">
				<fmt:bundle basename="localization.messages">
			  		<button id="addEditDefaultUserGroup_button_#5602" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="editUserGroupCtrl.close()"><cv:msg key="Cancel" /></button> 
			  		<button id="addEditDefaultUserGroup_button_#7381" type="submit" class="btn btn-primary cvBusyOnAjax" ><cv:msg key="Save"/></button> 
			  	</fmt:bundle>
			</div>
		</form>
	</div>
</fmt:bundle>