(function() {
	'use strict';

	var backupSetApp = angular.module('acApp.backupSet', []);
	var subclientApp = angular.module('acApp.subclient', ['vsaApp.machineBrowse']);

	var mspMod = angular.module(
		'mspApp',
		appUtil.getAllDeps([
			'vsaApp.server',
			'vsaApp.storage',
			'vsaApp.schedule',
			'acApp.subscriptions',
			'acApp.users',
			'acApp.userGroup',
			'acApp.jobs',
			'acApp.events',
			'acApp.browse',
			'dloApp.setup',
			'dloApp.server',
			'acApp.storage',
			'acApp.security',
			'acApp.activityControl',
			'acApp.backup',
			'acApp.directives',
			'acApp.sendLogFileApp',
			'acApp.logViewer',
			'acApp.commonForAllAgents',
			'acApp.clientGroup',
			'acApp.client',
			'acApp.agent',
			'acApp.backupSet',
			'acApp.instance',
			'acApp.sendLogFileApp',
			'acApp.subclient',
			'acApp.restore',
			'dloApp.profile',
			'acApp.browseForAgents',
			'dloApp.nameServers',
			'dloApp.settings',
			'mspApp.setup',
			'common.pushInstall',
			'common.addProxy',
			'colorpicker.module',
			'dloApp.customization'
		])
	);

	appUtil.setupApp(mspMod);

	mspMod.config([
		'$stateProvider',
		'$urlRouterProvider',
		function($stateProvider, $urlRouterProvider) {
			$urlRouterProvider.otherwise(cv.nav.defaultPath);

			// Dynamically inject states based on capabilities
			for (var i = 0; i < cv.nav.routes.length; i++) {
				$stateProvider.state(cv.nav.routes[i].state, {
					url: cv.nav.routes[i].url,
					templateUrl: appUtil.appRoot + cv.nav.routes[i].templateUrl,
					controller: cv.nav.routes[i].controller,
					cvBreadcrumbs: cv.nav.routes[i].cvBreadcrumbs
				});
			}
		}
	]);
})();
