export const getColumns = function(angularLibs) {
	const columns = {
		...getScheduleNameColumn(angularLibs.cvLoc),
		...getWorkflowNameColumn(angularLibs.cvLoc),
		...getPatternColumn(angularLibs.cvLoc, angularLibs.schedulePatternFactory),
		...getScheduleStatusColumn(angularLibs.cvLoc, angularLibs.enableSchedule),
		...getActionsColumn(angularLibs.cvLoc)
	};
	return columns;
};

const freqTypeMap = {
	1: 'One_Time',
	2: 'On_Demand',
	4: 'Daily',
	8: 'Weekly',
	16: 'Monthly',
	32: 'Monthly_Relative',
	64: 'Yearly',
	128: 'Yearly_Relative',
	512: 'Smart_Schedule',
	1024: 'Automatic_Schedule',
	2048: 'Every',
	4096: 'After_Job_Completes'
};

export const getActionsColumn = function(cvLoc) {
	return {
		action: {
			title: 'Actions',
			filterable: false,
			searchable: false,
			type: 'string',
			template: `<div class="permittedActions"></div>`,
			disableViewFiltering: true,
			sortable: false,
			disableColumnFilter: true,
			width: '1%',
			attributes: {
				class: 'permitted-actions'
			}
		}
	};
};

export const getScheduleStatusColumn = function(cvLoc, enableSchedule) {
	return {
		ScheduleStatus: {
			title: 'Status',
			type: 'string',
			command: {
				name: 'status',
				template:
					'<a class="k-grid-status"><input type="checkbox" class="status-checkbox"/><label class="state-checkbox-label no-padding"></label></a>',
				click: enableSchedule
			},
			width: '1%',
			type: 'string',
			disableViewFiltering: true,
			filterType: 'checkboxmultiselect',
			data: [
				{
					value: 1,
					label: 'No'
				},
				{
					value: 0,
					label: 'Yes'
				}
			]
		}
	};
};

export const getScheduleNameColumn = function(cvLoc) {
	return {
		'subTasks[0].subTask.subTaskName': {
			title: 'Name',
			type: 'string',
			template: getNameTemplate(cvLoc),
			disableViewFiltering: false,
			width: '2%'
		}
	};
};

export const getWorkflowNameColumn = function(cvLoc) {
	return {
		workflowName: {
			title: 'Workflow',
			type: 'string',
			template: getWorkflowNameTemplate(cvLoc),
			disableViewFiltering: false,
			width: '7%'
		}
	};
};

export const getPatternColumn = function(cvLoc, schedulePatternFactory) {
	return {
		pattern: {
			title: 'Pattern',
			type: 'string',
			template: getPatternTemplate.bind(undefined, cvLoc, schedulePatternFactory),
			disableViewFiltering: false,
			width: '7%',
			sortable: false
		}
	};
};

const getPatternTemplate = (cvLoc, schedulePatternFactory, dataItem) => {
	let subTaskInfo = angular.copy(dataItem.subTasks[0]);
	subTaskInfo.pattern.freq_type = freqTypeMap[subTaskInfo.pattern.freq_type];

	let patternInfo = schedulePatternFactory.getPatternInfo(subTaskInfo);

	if (patternInfo) {
		if (patternInfo.intervalBetweenTwoJobs) {
			return (
				`<div class="crop">
					<span cv-toggle="tooltip" cv-toggle-content="` +
				patternInfo.frequencyDisplayStr +
				' After ' +
				patternInfo.intervalBetweenTwoJobs +
				`">` +
				patternInfo.frequencyDisplayStr +
				' After ' +
				patternInfo.intervalBetweenTwoJobs +
				`</span>
				</div>`
			);
		} else if (subTaskInfo.pattern.freq_type === 'One_Time') {
			let patternlLbl = 'One time on ';
			if (patternInfo.startDate) {
				patternlLbl += patternInfo.startDate + ' ';
			}

			if (patternInfo.timeStr) {
				patternlLbl += patternInfo.timeStr;
			}

			return (
				`<div class="crop">
			<span cv-toggle="tooltip" cv-toggle-content="` +
				patternlLbl +
				`">` +
				patternlLbl +
				`</span>
		</div>`
			);
		} else if (subTaskInfo.pattern.freq_type === 'Yearly') {
			if (subTaskInfo.pattern.description) {
				return (
					`<div class="crop">
				<span cv-toggle="tooltip" cv-toggle-content="` +
					subTaskInfo.pattern.description +
					`">` +
					subTaskInfo.pattern.description +
					`</span>
		</div>`
				);
			} else {
				return `<div class="crop"><span></span></div>`;
			}
		} else if (patternInfo.timeStr) {
			return (
				`<div class="crop">
		<span cv-toggle="tooltip" cv-toggle-content="` +
				patternInfo.timeStr +
				`">` +
				patternInfo.timeStr +
				`</span>
	</div>`
			);
		}
	} else {
		return `<div class="crop"><span></span></div>`;
	}
};

const getNameTemplate = cvLoc => {
	return `<div class="crop">
		<a class="crop k-grid-schedule-name" cv-toggle-content="#:subTasks[0].subTask.subTaskName#" cv-toggle="tooltip" >#:subTasks[0].subTask.subTaskName#</a>
	</div>`;
};

const getWorkflowNameTemplate = cvLoc => {
	return `<div class="crop">
		 #if(data.associations){#
		 <span cv-toggle="tooltip" cv-toggle-content="#:associations[0].workflowName#"> #:associations[0].workflowName# </span>
		 # } else { #
		 <span></span>
		 # } #
	</div>`;
};
