/**
 * @author kharkut
 */
import { formsModule } from 'common/js/modules';
import 'modules/forms/js/services/forms.svc.js';
import * as workflowColumnsTemplate from './workflows.column.template.js';

export class WorkflowListingController {
	constructor(
		$scope,
		cvUtil,
		$stateParams,
		$window,
		cvLoc,
		formsModuleService,
		ENTITY_TYPES,
		cvPermissionFactory,
		$compile,
		cvToaster,
		securityFactory,
		scheduleUIFactory,
		$rootScope,
		$dialogs,
		$modal,
		$timeout,
		cvBreadcrumbsTabsFactory
	) {
		this.$window = $window;
		this.formsModuleService = formsModuleService;
		this.$scope = $scope;
		this.cvLoc = cvLoc;
		this.ENTITY_TYPES = ENTITY_TYPES;
		this.cvPermissionFactory = cvPermissionFactory;
		this.$compile = $compile;
		this.cvToaster = cvToaster;
		this.$scope.isWorkflowGridReinitialized = false;
		this.$stateParams = $stateParams;
		this.$scope.$on('$destroy', this._destroy.bind(this));

		let folderId = $stateParams.folderId;
		if (folderId) {
			this.$scope.firstReqOfFolder = true;
			this.$scope.folderMode = true;
			this.$scope.folder = {
				id: folderId
			};
		} else {
			this.$scope.firstReqOfFolder = false;
			this.$scope.folderMode = false;
		}
		this._init();
		this.securityFactory = securityFactory;
		this.scheduleUIFactory = scheduleUIFactory;
		this.$rootScope = $rootScope;
		this.$dialogs = $dialogs;
		this.$modal = $modal;
		this.$timeout = $timeout;
		this.initializeAddscheduleListener();
		this.$scope.workflowToImport = {};
		this.$scope.onInputChange = this.onInputChange.bind(this);
		this.cvBreadcrumbsTabsFactory = cvBreadcrumbsTabsFactory;
	}

	getWorkflowSpecificActions = () => {
		return {
			EDIT_WORKFLOW: {
				label: 'Edit',
				value: 'EDIT_WORKFLOW'
			},
			CLONE_WORKFLOW: {
				label: 'Clone',
				value: 'CLONE_WORKFLOW'
			},
			EXPORT_WORKFLOW: {
				label: 'Export',
				value: 'EXPORT_WORKFLOW'
			},
			DEPLOY_WORKFLOW: {
				label: 'Deploy',
				value: 'DEPLOY_WORKFLOW'
			},
			EXECUTE_WORKFLOW: {
				label: 'Execute',
				value: 'EXECUTE_WORKFLOW'
			},
			DELETE_WORKFLOW: {
				label: 'Delete',
				value: 'DELETE_WORKFLOW'
			},
			SECURITY: {
				label: 'Security',
				value: 'SECURITY'
			},
			SCHEDULE: {
				label: 'Create Schedule',
				value: 'SCHEDULE'
			},
			SCHEDULES: {
				label: 'View Schedules',
				value: 'SCHEDULES'
			},
			VERSION_HISTORY: {
				label: 'View Version History',
				value: 'VERSION_HISTORY'
			},
			JOB_HISTORY: {
				label: 'View Job History',
				value: 'JOB_HISTORY'
			},
			TAKE_OWNERSHIP: {
				label: 'Take Ownership',
				value: 'TAKE_OWNERSHIP'
			},
			PROPERTIES: {
				label: 'Properties',
				value: 'PROPERTIES'
			},
			CONFIGURATION: {
				label: 'Configuration',
				value: 'CONFIGURATION'
			}
		};
	};

	editWorkflow(workflowId) {
		let self = this;
		window.open(`workflow/editor?id=${workflowId}`, '_blank');
	}

	cloneWorkflow(workflow) {
		let self = this;
		let $modal = this.$modal;

		var cloneModal = $modal.open({
			templateUrl: appUtil.appRoot + 'modules/workflows/partials/cloneWorkflowModal.jsp',
			isBackdrop: false,
			controllerAs: 'cloneWorkflowCtrl',
			controller: [
				'$uibModalInstance',
				'workflowToClone',
				'formsModuleService',
				'onSuccessSave',
				'onErrorSave',
				function($modalInstance, workflowToClone, formsModuleService, onSuccessSave, onErrorSave) {
					var self = this;
					self.modalTitle = 'Clone workflow';
					self.model = {};

					self.cancel = function() {
						$modalInstance.dismiss('Cancel');
					};

					self.cloneWorkflow = function() {
						self.serverMessage = undefined;

						if (!self.model.workflowName) {
							self.serverMessage = {
								message: 'Please enter a valid workflow name'
							};
							return;
						}

						if (self.model.workflowName === workflowToClone.workflowName) {
							self.serverMessage = {
								message: "Cloned workflow can't have same name as the original workflow name"
							};
							return;
						}

						formsModuleService.cloneWorkflow(workflowToClone.workflowId, self.model.workflowName).then(
							function(data) {
								$modalInstance.dismiss();
								onSuccessSave('Successfully cloned the workflow');
							},
							function(error) {
								$modalInstance.dismiss();
								onErrorSave('Failed to clone the workflow');
							}
						);
					};
				}
			],
			resolve: {
				workflowToClone: () => workflow,
				formsModuleService: () => self.formsModuleService,
				onSuccessSave: () => self.onSuccessSave.bind(self),
				onErrorSave: () => self.onErrorSave.bind(self)
			}
		});
	}

	exportWorkflow() {
		let self = this;
		self.formsModuleService.exportWorkflow(14);
	}

	deployWorkflow(workflowId, _postDeployCallBack) {
		let self = this;
		self.formsModuleService.deploy(workflowId).then(
			function(data) {
				if (data && data.data && data.data.errorCode === 0) {
					self.onSuccessSave('Successfully deployed the workflow');
					_postDeployCallBack(workflowId);
				} else {
					let errMsg = 'Failed to deploy the workflow';
					if (data.data.errorMessage) {
						errMsg += ' [ ' + data.data.errorMessage + ' ] ';
					}
					self.onErrorSave(errMsg);
				}
			},
			function(error) {
				self.onErrorSave('Failed to deploy the workflow');
			}
		);
	}

	_postDeployCallBack(workflowId) {
		openForm({ workflowId: workflowId, targetElement: wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT });
	}

	executeWorkflow(entity) {
		let $dialogs = this.$dialogs;
		let self = this;
		let workflowId = entity.entity.workflowId;
		if (!entity.deployments || !entity.deployments.length) {
			$dialogs.confirm('Confirm', 'Workflow has not been deployed.Do you want to deploy it?', {
				noFunction: function() {},
				yesFunction: function() {
					self.deployWorkflow(workflowId, self._postDeployCallBack.bind(self));
				}
			});
		} else {
			openForm({ workflowId: workflowId, targetElement: wfUtils.constants.ADMINCONSOLE_TARGET_ELEMENT });
		}
	}

	takeOwnerShip(workflowId) {
		let self = this;
		let $dialogs = this.$dialogs;
		let cvLoc = this.cvLoc;

		$dialogs.confirm('Confirm', 'Are you sure you want to take ownership of the workflow?', {
			noFunction: function() {},
			yesFunction: function() {
				self.formsModuleService.takeOwnerShip(workflowId).then(
					function(data) {
						let errMsg = 'Failed to take ownership of the workflow';
						if (data && data.data && data.data.errorCode !== undefined && data.data.errorCode === 0) {
							self.onSuccessSave('Successfully taken the ownership of the workflow');
						} else {
							if (data.data && data.data.errorMessage) {
								errMsg += ' [ ' + data.data.errorMessage + ']';
							}
							self.onErrorSave(errMsg);
						}
					},
					function(error) {
						let errMsg = 'Failed to take ownership of the workflow';
						if (error.data && error.data.errorMessage) {
							errMsg += ' [ ' + error.data.errorMessage + ']';
						}
						self.onErrorSave(errMsg);
					}
				);
			}
		});
	}

	openEmailApproval() {
		let self = this;
		let $modal = this.$modal;
		let cvLoc = this.cvLoc;

		var emailApporvalModal = $modal.open({
			templateUrl: appUtil.appRoot + 'modules/workflows/partials/emailApprovalModal.jsp',
			isBackdrop: false,
			controllerAs: 'emailApprovalCtrl',
			controller: [
				'$uibModalInstance',
				'formsModuleService',
				'onSuccessSave',
				'onErrorSave',
				function($modalInstance, formsModuleService, onSuccessSave, onErrorSave) {
					var self = this;
					self.modalTitle = 'Email approval properties';

					self.model = {
						pwdChanged: false,
						mailBoxPwd: 'dummy'
					};

					formsModuleService
						.getEmailApproval()
						.success(function(data) {
							if (data && data.approval) {
								let approval = data.approval;
								self.model.enabled = approval.isEnabled === true ? true : false;
								self.model.folder = approval.folder;
								self.model.server = approval.host;
								self.model.mailbox = approval.mailbox;
							}
						})
						.error(function(e1) {
							self.onErrorSave('Failed to load email approval properties');
							$modalInstance.dismiss();
						});

					self.onPasswordChanged = function() {
						self.model.pwdChanged = true;
					};

					self.cancel = function() {
						$modalInstance.dismiss('Cancel');
					};

					self.saveEmailApproval = function() {
						formsModuleService
							.saveEmailApproval({
								mailbox: self.model.mailbox,
								folder: self.model.folder,
								host: self.model.server,
								enable: self.model.enabled,
								mailBoxPwd: self.model.mailBoxPwd,
								pwdChanged: self.model.pwdChanged
							})
							.success(data => {
								if (data.errorCode != undefined) {
									if (data.errorCode === 0) {
										onSuccessSave('Successfully saved email approval properties');
									} else {
										onErrorSave(
											'Failed to save email aproval properties [' + data.errorMessage ? data.errorMessage : '' + ']'
										);
									}
								}
								$modalInstance.dismiss();
							})
							.error(err => {
								let errMsg = 'Failed to save email approval properties';
								if (err.data && err.data.errorMessage) {
									errMsg += ' [ ' + err.data.errorMessage + ']';
								}
								onErrorSave(errMsg);
								$modalInstance.dismiss();
							});
					};
				}
			],
			resolve: {
				formsModuleService: () => self.formsModuleService,
				onSuccessSave: () => self.onSuccessSave.bind(self),
				onErrorSave: () => self.onErrorSave.bind(self)
			}
		});
	}

	openVersionHistory(entity) {
		let self = this;
		let $modal = this.$modal;
		let cvLoc = this.cvLoc;

		var cloneModal = $modal.open({
			templateUrl: appUtil.appRoot + 'modules/workflows/partials/versionHistoryModal.jsp',
			isBackdrop: false,
			controllerAs: 'versionHistoryCtrl',
			controller: [
				'$uibModalInstance',
				'entity',
				'formsModuleService',
				'onSuccessSave',
				'onErrorSave',
				function($modalInstance, entity, formsModuleService, onSuccessSave, onErrorSave) {
					var self = this;
					self.entity = entity;
					self.modalTitle = self.entity.entity.workflowName + ' - Version History';

					self.formsModuleService = formsModuleService;
					self.onSuccessSave = onSuccessSave;
					self.onErrorSave = onErrorSave;

					self.cancel = function() {
						$modalInstance.dismiss('Cancel');
					};

					self.fetchVersionHistory = function(options) {
						this.formsModuleService
							.getVersionHistory(this.entity.entity.workflowId)
							.success(function(data) {
								if (data && data.history) {
									options.success(data.history);
								}
							})
							.error(function(e1) {
								this.onErrorSave('Failed to load version history');
								$modalInstance.dismiss();
							});
					};

					self.getDeployTemplate = function(dataItem) {
						let deployTemplate = `<div class="crop">`;
						if (
							dataItem.deployments &&
							dataItem.deployments.length > 0 &&
							dataItem.deployments[0].client &&
							dataItem.deployments[0].client.displayName
						) {
							deployTemplate +=
								`<span cv-toggle="tooltip" cv-toggle-content="` +
								dataItem.deployments[0].client.displayName +
								` (` +
								moment(dataItem.deployments[0].deployed * 1000).format('DD/MM/YYYY') +
								`)">` +
								dataItem.deployments[0].client.displayName +
								` (` +
								moment(dataItem.deployments[0].deployed * 1000).format('DD/MM/YYYY') +
								`)</span>`;
						} else {
							deployTemplate += `<span>Not Deployed</span>`;
						}
						deployTemplate += `</div>`;
						return deployTemplate;
					};

					self._initColumnDefs = function() {
						return {
							version: {
								title: 'Version',
								type: 'number',
								template: `
										#if(data.version){#
										<span>
										<a href="workflow/editor?id=#:workflow.workflowId#&version=#:version#" target="_blank" class="crop" title="">#:version#</a>
										</span>
										# } else { #
										<span></span>
										#}#
									`
							},
							deployedOn: {
								title: 'Deployments',
								type: 'string',
								template: self.getDeployTemplate.bind(undefined)
							},
							userName: {
								title: 'User',
								type: 'string',
								template: `<div class="crop">
										#if(data.user && data.user.userName){#
										<span cv-toggle="tooltip" cv-toggle-content="#:user.userName#">#:user.userName#</span>
										# } else { #
										<span></span>
										#}#
									</div>`
							},
							created: {
								title: 'Created',
								type: 'number',
								template: `<div class="crop">
										#if(data.created){#
										<span cv-toggle="tooltip" cv-toggle-content="#:moment(created * 1000).format("DD/MM/YYYY hh:mm A")#">#:moment(created * 1000).format("DD/MM/YYYY hh:mm A")#</span>
										# } else { #
										<span></span>
										#}#
									</div>`
							},
							workflowComment: {
								title: 'Comment',
								type: 'string',
								template: `
										#if(data.workflowComment){#
										<span cv-toggle="callout" data-content="#:workflowComment#">#:workflowComment#</span>
										# } else { #
										<span></span>
										#}#
										`,
								attributes: {
									class: 'no-tooltip'
								}
							}
						};
					};

					self._onGridDataBound = function() {};

					self.initGrid = function() {
						let gridOptions = {};

						gridOptions.url = self.fetchVersionHistory.bind(self);
						gridOptions.hasViews = false;
						gridOptions.columns = self._initColumnDefs();
						gridOptions.gridTitle = '';
						//gridOptions.tableName = 'workflowsTable';
						gridOptions.idField = 'historyId';
						gridOptions.sortDirection = {
							field: 'version',
							dir: 'desc'
						};
						gridOptions.beforeGridInitialize = ({ grid }) => {
							self.grid = grid;
						};
						gridOptions.afterGridInitialize = ({ grid }) => {
							self.grid = grid;
						};
						gridOptions.onGridDataBound = self._onGridDataBound.bind(self);
						gridOptions.actionMenu = [];

						self.gridOptions = gridOptions;
					};
					self.initGrid();
				}
			],
			resolve: {
				entity: () => entity,
				formsModuleService: () => self.formsModuleService,
				onSuccessSave: () => self.onSuccessSave.bind(self),
				onErrorSave: () => self.onErrorSave.bind(self)
			}
		});
	}

	openConfiguration(entity) {
		let self = this;

		var _configCallBack = function(configData) {
			console.log(configData);

			this.formsModuleService
				.saveConfigForm(entity.workflowId, configData)
				.success(data => {
					if (data.errorCode != undefined) {
						if (data.errorCode === 0) {
							self.onSuccessSave('Successfully saved configuration values');
						} else {
							self.onErrorSave(
								'Failed to save configuration values [' + data.errorMessage ? data.errorMessage : '' + ']'
							);
						}
					}
				})
				.error(err => {
					let errMsg = 'Failed to save configuration values';
					if (err.data && err.data.errorMessage) {
						errMsg += ' [ ' + err.data.errorMessage + ']';
					}
					self.onErrorSave(errMsg);
				});
		};

		self.formsModuleService
			.getConfigForm(entity.workflowId)
			.success(function(data) {
				if (data) {
					Forms.openConfigForm(
						{ inputForm: data, title: entity.workflowName + ' - Configuration' },
						_configCallBack.bind(self)
					);
				}
			})
			.error(function(e1) {});
	}

	openProperties(entity) {
		let self = this;
		let $modal = this.$modal;
		let cvLoc = this.cvLoc;

		var cloneModal = $modal.open({
			templateUrl: appUtil.appRoot + 'modules/workflows/partials/workflowPropertiesModal.jsp',
			isBackdrop: false,
			controllerAs: 'workflowPropertiesCtrl',
			controller: [
				'$uibModalInstance',
				'entity',
				'formsModuleService',
				'onSuccessSave',
				'onErrorSave',
				function($modalInstance, entity, formsModuleService, onSuccessSave, onErrorSave) {
					var self = this;
					self.entity = entity;
					self.modalTitle = self.entity.entity.workflowName + ' Properties';

					self.model = {};
					self.model.description = self.entity.description;
					self.model.autoDeploy = (self.entity.flags & 2) === 2 ? true : false;
					self.model.disabled = (self.entity.flags & 1) === 1 ? true : false;

					self.cancel = function() {
						$modalInstance.dismiss('Cancel');
					};
					self.saveProperties = function() {
						formsModuleService
							.saveProperties(self.entity.entity.workflowId, {
								description: self.model.description,
								autoDeploy: self.model.autoDeploy ? 1 : 0,
								disabled: self.model.disabled ? 1 : 0
							})
							.then(
								function(data) {
									$modalInstance.dismiss();
									onSuccessSave('Successfully updated the properties');
								},
								function(error) {
									$modalInstance.dismiss();
									onErrorSave('Failed to update the properties');
								}
							);
					};
				}
			],
			resolve: {
				entity: () => entity,
				formsModuleService: () => self.formsModuleService,
				onSuccessSave: () => self.onSuccessSave.bind(self),
				onErrorSave: () => self.onErrorSave.bind(self)
			}
		});
	}

	deleteWorkflow(workflowId) {
		let self = this;
		let $dialogs = this.$dialogs;
		let cvLoc = this.cvLoc;

		$dialogs.confirm(cvLoc('label.confirmDelete'), 'Are you sure you want to delete this workflow?', {
			noFunction: function() {},
			yesFunction: function() {
				self.formsModuleService.deleteWorkflow(workflowId).then(
					function(data) {
						self.onSuccessSave('Successfully deleted the workflow');
					},
					function(error) {
						let errMsg = 'Failed to delete the workflow';
						if (error.data && error.data.errorMessage) {
							errMsg += ' [ ' + error.data.errorMessage + ']';
						}
						self.onErrorSave(errMsg);
					}
				);
			}
		});
	}

	showSecurity(workflowId) {
		let self = this;
		let $scope = self.$scope;
		$scope.associations = self.securityFactory.createSecurityAssociationsObject();
		$scope.associationsLoaded = false;

		self.securityFactory.getSecurityAssociation('WORKFLOW_ENTITY', workflowId).success(function(data) {
			//entityType,genericEntity and formattedSecurityAssociations are required by security directive.
			$scope.associations = self.securityFactory.formatSecurityAssociationsObject(data.securityAssociations);
			self.modifySecurityAssociations(workflowId);
		});
	}

	addSchedule(entity) {
		let self = this;
		let $scope = self.$scope;
		$scope.wfInfo = entity;
		openForm({
			workflowId: entity.workflowId,
			doNotStartWorkflow: true,
			success: self.scheduleCallBack.bind(this),
			showAsModal: true
		});
	}

	scheduleCallBack(inputs) {
		let self = this;
		let $scope = this.$scope;
		$scope.workflowInput = inputs;
		console.log(inputs);
		console.log($scope.wfInfo);
		self.scheduleUIFactory.addNewWorkflowSchedule();
	}

	initializeAddscheduleListener() {
		let self = this;
		let $rootScope = self.$rootScope;
		let $scope = self.$scope;

		$scope.scheduleAddListener = $rootScope.$on(
			'scheduleAdded',
			function(evt, addedSchedule, planId) {
				let self = this;
				let $scope = this.$scope;

				addedSchedule.repeat = {
					enabled: addedSchedule.repeatEnabled,
					duration: addedSchedule.repeatDuration,
					hrs: addedSchedule.repeatHrs,
					mins: addedSchedule.repeatMins,
					time: addedSchedule.repeatTime
				};

				self.formsModuleService
					.createWorkflowSchedule({
						schedule: JSON.stringify(addedSchedule),
						workflowName: $scope.wfInfo.workflowName,
						workflowId: $scope.wfInfo.workflowId,
						workflowInput: JSON.stringify($scope.workflowInput)
					})
					.success(function(data) {
						if (data.taskId) {
							self.onSuccessSave('Schedule created');
						} else {
							let errMsg = 'Failed to create schedule';
							if (data && data.errorMessage) {
								errMsg += ' [ ' + data.errorMessage + ']';
							}
							self.onErrorSave(errMsg);
						}
					})
					.error(function(e) {
						let errMsg = 'Failed to create schedule';
						if (e.data && e.data.errorMessage) {
							errMsg += ' [ ' + e.data.errorMessage + ']';
						}
						self.onErrorSave(errMsg);
					});
			}.bind(this)
		);
	}

	modifySecurityAssociations(workflowId) {
		let self = this;
		let $scope = this.$scope;
		let params = new Object();
		params.securityAssociationArray = $scope.associations.associations;
		params.inheritedAssociationArray = $scope.associations.inheritedAssociations
			? $scope.associations.inheritedAssociations
			: [];
		params.creatorAssociationArray = $scope.associations.creatorAssociations;
		params.ownerAssociations = $scope.associations.ownerAssociations;
		params.entityType = 'WORKFLOW_ENTITY';
		params.categoryPermission = $scope.associations.ownerAssociations.categoryPermission;
		params.genericEntity = { entityId: workflowId };
		self.securityFactory.editSecurityAssociation(params).then(
			function(securityAssociations) {
				self.onSuccessSave('Successfully updated security for workflow');
				$scope.associations.associations = securityAssociations.associations;
				$scope.associations.ownerAssociations = securityAssociations.ownerAssociations;
				$scope.hasAnyAssociationsAvailable = function() {
					return (
						$scope.associations.associations.length !== 0 ||
						$scope.associations.inheritedAssociations.length != 0 ||
						$scope.associations.creatorAssociations.length != 0
					);
				};
			},
			function(failureReason) {
				let errMsg = 'Failed to update security for the workflow';
				errMsg += ' [ ' + failureReason + ']';
				self.onErrorSave(errMsg);
			}
		);
	}

	onErrorSave(err) {
		if (err) {
			this.cvToaster.showErrorMessage({
				message: err
			});
		}
	}

	onSuccessSave(msg) {
		this.grid.refreshData();
		this.cvToaster.showSuccessMessage({
			message: msg
		});
	}

	getWorkflows(options) {
		let self = this;
		let $scope = this.$scope;

		let formsModuleService = this.formsModuleService;
		let cvUtil = this.cvUtil;
		let PLAN_PERMISSIONS = this.PLAN_PERMISSIONS;
		let cvLoc = this.cvLoc;
		let ENTITY_TYPES = this.ENTITY_TYPES;
		let $filter = this.$filter;

		if ($scope.folderMode) {
			self.formsModuleService
				.getWorkflowsOfFolder($scope.folder.id)
				.success(function(folderResp) {
					if ($scope.firstReqOfFolder) {
						self.cvBreadcrumbsTabsFactory.addBreadCrumbs([
							{
								title: 'Workflows',
								link: '#workflows'
							}
						]);
						$scope.firstReqOfFolder = false;
					}
					let workflows = self._initWorkflowList.call(self, folderResp);
					workflows = folderResp.container;
					options.success(workflows);
				})
				.error(function(e1) {
					if ($scope.firstReqOfFolder) {
						self.cvBreadcrumbsTabsFactory.addBreadCrumbs([
							{
								title: 'Workflows',
								link: '#workflows'
							}
						]);
					}
					$scope.firstReqOfFolder = false;
					$scope.folderMode = false;
					self.onErrorSave('Failed to load the workflows of the specified folder');
				});
		} else {
			formsModuleService
				.getWorkflows()
				.success(function(data) {
					let folders = [];
					let workflows = [];

					formsModuleService
						.getFolders()
						.success(function(folderResp) {
							self._initWorkflowList.call(self, data);
							workflows = data.container;

							if (folderResp && folderResp.folder) {
								folders = _.map(folderResp.folder, folder => {
									return {
										entity: {
											workflowId: folder.folderEntity.smartFolderId,
											workflowName: folder.folderEntity.smartFolderName
										},
										description: folder.description,
										creator: {
											userName: folder.ownerName
										},
										isFolder: true,
										isFolderStr: 1,
										updateStatus: ''
									};
								});
							}
							options.success(folders.concat(workflows));
						})
						.error(function(e1) {
							self._initWorkflowList.call(self, data);
							options.success(data.container);
						});
				})
				.error(function(e) {
					self.$scope.serverMessage = {
						message: e,
						type: 'error'
					};
					options.error(self.$scope.serverMessage);
				});
		}
	}

	getRevision(rev, ignoreLocalModification) {
		if (rev) {
			if (ignoreLocalModification) {
				rev = rev.replace(/M/g, '');
			}
		}
		return rev;
	}

	getSoftwareStoreUpdateStatus(container) {
		let localRevision = this.getRevision(container.revision, true);
		let remoteRevision = this.getRevision(container.remoteRevision, true);
		let isValidLocalRev = this.isValidRevision(localRevision);
		let isValidRemoteRev = this.isValidRevision(remoteRevision);

		if (isValidLocalRev && isValidRemoteRev) {
			return localRevision === remoteRevision ? 'Up to date' : 'Available';
		}
		return 'N/A';
	}

	isValidRevision(rev) {
		let revTerm = '$';
		let revToken = 'Revision';
		if (rev && rev.startsWith(revTerm + revToken + ':') && rev.endsWith(revTerm)) {
			//$NON-NLS$ //$NON-NLS-1$
			let tokens = rev
				.replace(/(Revision|\$|:|\s)/g, '')
				.trim()
				.split('.'); //$NON-NLS$ //$NON-NLS-1$
			// these tokens
			if (tokens && tokens.length) {
				return tokens.length == _.filter(tokens, token => !isNaN(parseInt(token))).length;
			}
		}
		return false;
	}

	_initWorkflowList(data) {
		let self = this;
		let $scope = self.$scope;
		let _computePermittedActions = function(entity) {
			let arrayOfProfileSpecificActionsToOverride = [
				{
					EDIT_WORKFLOW: {
						show: true,
						onClick: self.editWorkflow.bind(self, entity.entity.workflowId)
					}
				},
				{
					CLONE_WORKFLOW: {
						show: true,
						onClick: self.cloneWorkflow.bind(self, entity.entity)
					}
				},
				{
					EXPORT_WORKFLOW: {
						show: true,
						href: 'exportWorkflow.do?workflowId=' + entity.entity.workflowId + '&version=' + entity.version
					}
				},
				{
					DEPLOY_WORKFLOW: {
						show: true,
						onClick: self.deployWorkflow.bind(self, entity.entity.workflowId)
					}
				},
				{
					EXECUTE_WORKFLOW: {
						show: true,
						onClick: self.executeWorkflow.bind(self, entity)
					}
				},
				{
					DELETE_WORKFLOW: {
						show: true,
						onClick: self.deleteWorkflow.bind(self, entity.entity.workflowId)
					}
				},
				{
					SECURITY: {
						show: true,
						onClick: self.showSecurity.bind(self, entity.entity.workflowId)
					}
				},
				{
					SCHEDULE: {
						show: true,
						onClick: self.addSchedule.bind(self, entity.entity)
					}
				},
				{
					SCHEDULES: {
						show: true,
						href: '#/workflows/' + entity.entity.workflowId + '/schedules'
					}
				},
				{
					VERSION_HISTORY: {
						show: true,
						onClick: self.openVersionHistory.bind(self, entity)
					}
				},
				{
					JOB_HISTORY: {
						show: true,
						href: '#/jobs?showAdminJobs=true&workflows=' + entity.entity.workflowId
					}
				},
				{
					TAKE_OWNERSHIP: {
						show: true,
						onClick: self.takeOwnerShip.bind(self, entity.entity.workflowId)
					}
				},
				{
					PROPERTIES: {
						show: true,
						onClick: self.openProperties.bind(self, entity)
					}
				},
				{
					CONFIGURATION: {
						show: entity.deployments && entity.deployments.length && entity.deployments[0].configForm ? true : false,
						onClick: self.openConfiguration.bind(self, entity.entity)
					}
				}
			];

			let profilePermittedList = [];
			profilePermittedList = self.cvPermissionFactory.updateAndGetCommonActionsList(
				arrayOfProfileSpecificActionsToOverride,
				false,
				self.getWorkflowSpecificActions()
			);
			return profilePermittedList;
		};

		if (data && data.container) {
			_.each(data.container, workflow => {
				workflow.isFolder = false;
				workflow.isFolderStr = 0;
				workflow.updateStatus = self.getSoftwareStoreUpdateStatus(workflow);
				workflow.permittedOptions = {
					//entityType: ENTITY_TYPES.WORKFLOW_ENTITY,
					entity: angular.copy(workflow.entity),
					entityId: workflow.entity.workflowId,
					entityName: workflow.entity.workflowName,
					appendToBody: true,
					permittedActionList: _computePermittedActions(workflow)
				};
			});
		} else {
			data = {
				container: []
			};
		}
	}

	_initColumnDefs() {
		return workflowColumnsTemplate.getColumns({
			cvLoc: this.cvLoc,
			cvUtil: this.cvUtil
		});
	}

	_updateGrid() {
		let sef = this;
		let $scope = this.$scope;
		$scope.isWorkflowGridReinitialized = false;
		self.$timeout(function() {
			self._setupGridOptions();
			$scope.isWorkflowGridReinitialized = true;
		}, 100);
	}

	_onGridDataBound(dataItem, row) {
		let self = this;
		let $scope = self.$scope;
		const permittedOptions = dataItem.permittedOptions;
		if (permittedOptions) {
			const id = permittedOptions.entityId;
			const template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
			this.$scope[`permittedOptions${id}`] = permittedOptions;
			row.find('.permittedActions').append(this.$compile(template)(this.$scope));
		}
	}

	_init() {
		let $scope = this.$scope;
		this._setupGridOptions();
		$scope.isWorkflowGridReinitialized = true;
	}

	_folderCallBack() {
		let self = this;
		let $scope = this.$scope;
		let $timeout = self.$timeout;

		$scope.isWorkflowGridReinitialized = false;
		$scope.folderMode = false;

		$timeout(function() {
			self.cvBreadcrumbsTabsFactory.clearBc();
			self.cvBreadcrumbsTabsFactory.addBreadCrumbs([]);
			self._setupGridOptions();
			$scope.isWorkflowGridReinitialized = true;
		}, 100);
	}

	openNewWorkflow() {
		this.$window.open('workflow/editor');
	}

	openNewBusinessLogicWorkflow() {
		this.$window.open('workflow/editor?type=businessLogic');
	}

	viewWorkflowSchedules() {
		this.$window.open('#/workflows/schedules', '_self');
	}

	viewWorkflowJobs() {
		this.$window.open('#/jobs?showAdminJobs=true&jobType=90', '_self');
	}

	importWorkflow() {
		let $timeout = this.$timeout;
		$timeout(function() {
			angular.element('.import-workflow-template-input').trigger('click');
		});
	}

	onInputChange = function(files) {
		var self = this;
		var formsModuleService = self.formsModuleService;
		var reader = new FileReader();
		if (files && files.length > 0) {
			var fd = new FormData();
			_.each(files, function(file, index) {
				fd.append('file', file, file.name);
			});
			formsModuleService
				.importWorkflow(fd)
				.success(data => {
					if (data.errorCode != undefined) {
						switch (data.errorCode) {
							case 0:
								self.onSuccessSave('Successfully imported the workflow');
								break;
							case 1000:
								self.onErrorSave(
									'Failed to import the workflow [ Invalid file extension. Only XML (*.xml) files are supported ]'
								);
								break;
							case 1001:
								self.onErrorSave(
									'Failed to import the workflow [ The content in the selected file is not a valid workflow definition template ]'
								);
								break;
							case 1002:
								self.onErrorSave(
									'Failed to import the workflow [ Invalid workflow definition structure . It must start with WorkflowDefinition tag ]'
								);
								break;
							case 1003:
								var errorMsg = 'Failed to import the workflow. Please check logs.';
								if (data.errorMessage) {
									errorMsg = 'Failed to import the workflow [ ' + data.errorMessage + ' ]';
								}
								self.onErrorSave(errorMsg);
								break;
							case 1004:
								self.onErrorSave('Failed to import the workflow');
								break;
							default:
								self.onErrorSave('Failed to import the workflow');
								break;
						}
					}
				})
				.error(err => {
					let errMsg = 'Failed to delete the workflow';
					if (err.data && err.data.errorMessage) {
						errMsg += ' [ ' + err.data.errorMessage + ']';
					}
					self.onErrorSave(errMsg);
				});
		}
	};

	_getToolbarSubOptions() {
		const self = this;
		let subOptions = [
			{
				id: 'NewWorkflow' + cvUtil.generateUUID(),
				label: 'New Workflow',
				onSelect: self.openNewWorkflow.bind(self)
			},
			{
				id: 'NewBusinessLogicWorkflow' + cvUtil.generateUUID(),
				label: 'New Business Logic Workflow',
				onSelect: self.openNewBusinessLogicWorkflow.bind(self)
			},
			{
				id: 'ImportWorkflow' + cvUtil.generateUUID(),
				label: 'Import Workflow',
				onSelect: self.importWorkflow.bind(self)
			},
			{
				id: 'ViewWorkflowSchedules' + cvUtil.generateUUID(),
				label: 'Schedules',
				onSelect: self.viewWorkflowSchedules.bind(self)
			},
			{
				id: 'ViewWorkflowJobs' + cvUtil.generateUUID(),
				label: 'Job History',
				onSelect: self.viewWorkflowJobs.bind(self)
			},
			{
				id: 'EmailApproval' + cvUtil.generateUUID(),
				label: 'Email Approval',
				onSelect: self.openEmailApproval.bind(self)
			}
		];
		/*
		 * if (!scope.planSubType || scope.planSubType !== 'Archiver') { subOption = { id: 'AddSnapCopy' +
		 * cvUtil.generateUUID(), label: 'Snap copy', onSelect: scope.AddSnapCopy };
		 * subOptions.push(subOption); }
		 */
		return subOptions;
	}

	_setupGridOptions() {
		const self = this;
		this.gridOptions = {};
		this.$scope.gridOptions = this.gridOptions;
		this.gridOptions.url = this.getWorkflows.bind(this);
		this.gridOptions.hasViews = false;
		//this.gridOptions.usePageToolbar = true;
		this.gridOptions.columns = this._initColumnDefs();
		this.gridOptions.gridTitle = 'Workflows';
		//this.gridOptions.tableName = 'workflowsTable';
		this.gridOptions.idField = 'entity.workflowId';
		this.gridOptions.sortDirection = {
			field: 'isFolderStr',
			dir: 'desc'
		};
		this.gridOptions.beforeGridInitialize = ({ grid }) => {
			self.grid = grid;
		};
		this.gridOptions.afterGridInitialize = ({ grid }) => {
			self.grid = grid;
		};
		this.gridOptions.onGridDataBound = this._onGridDataBound.bind(this);
		this.gridOptions.actionMenu = [];
		if (!self.$scope.folderMode) {
			this.gridOptions.gridToolbarMenu = [
				{
					id: 'commvaultStore',
					disableOnDeselect: false,
					label: 'Commvault Store',
					onSelect: () => window.open(`/webconsole/softwarestore/console/workflows.jsp`, '_blank')
				},
				{
					id: 'allWorkflowTasks',
					disableOnDeselect: false,
					label: 'All tasks',
					subOptions: this._getToolbarSubOptions()
				}
			];
		}
	}

	_destroy() {
		this.$scope.scheduleAddListener();
	}
}

WorkflowListingController.$inject = [
	'$scope',
	'cvUtil',
	'$stateParams',
	'$window',
	'cvLoc',
	'formsModuleService',
	'ENTITY_TYPES',
	'cvPermissionFactory',
	'$compile',
	'cvToaster',
	'securityFactory',
	'scheduleUIFactory',
	'$rootScope',
	'$dialogs',
	'$uibModal',
	'$timeout',
	'cvBreadcrumbsTabsFactory'
];

formsModule.controller('WorkflowListingController', WorkflowListingController);
