<%@  taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagementJs"></cv:cvMessages>
</script>
<div  data-ng-controller="vmOperationDialogController as vmOpsDialogCtrl">
	<div class="setup-title">
			<h1>{{vmOpsDialogCtrl.operationTitle}}</h1>
	</div>
			<div class="setup-content">
				<form ng-submit="vmOpsDialogCtrl.submit()">
					<div class="cv-modal-wrapper" data-ng-show="vmOpsDialogCtrl.vmOperationDetails.operationType === 'RENEW_VM'">
						<label for="expirationDate" class="cv-label">{{vmOpsDialogCtrl.expirationDateLabel}}</label>
						<span data-ng-if="vmOpsDialogCtrl.vmOperationDetails.renewOpType =='hours'" class="cv-inline-wrapper">
							<input type="number" name="expirationInHours" id="expirationInHours" data-ng-model="vmOpsDialogCtrl.expirationInHours" min="1" max="{{vmOpsDialogCtrl.vmOperationDetails.renewMaxHours}}">
							<label for="expirationTimeInHours" class="expirationTimeLabel input-group-btn">
							        	<cv:msg key="label.hours" bundle="restore" />
							</label>
						</span>
						<div data-ng-if="vmOpsDialogCtrl.vmOperationDetails.renewOpType =='days'" class="cv-inline-wrapper calendar-wrapper date-picker">
						<input ng-readonly="true" name="expirationInDate" id="expirationInDate" class="large-width-date-box" type="text" uib-datepicker-popup="MM/dd/yyyy"  data-min-date="vmOpsDialogCtrl.checkMinDate()" data-max-date="vmOpsDialogCtrl.checkMaxDate()" data-ng-model="vmOpsDialogCtrl.selectionDate" is-open="vmOpsDialogCtrl.datepicker" close-text="Close" datepicker-options="dateOptions" show-weeks="false" data-ng-click="vmOpsDialogCtrl.openDateSelection()"/>
						 <span class="input-group-btn">
				    		<button id="vmOperationDialog_button_#5471" type="button" class="btn btn-default" data-ng-click="vmOpsDialogCtrl.openDateSelection()" ><i class="glyphicon glyphicon-calendar"></i></button> 
				   		 </span>
						</div>						
						<div class="col-md-offset-5 col-md-7">
							<div class="{{vmOpsDialogCtrl.renewVMOpsValidation.type}}">{{vmOpsDialogCtrl.renewVMOpsValidation.message}}</div>
						</div>
					</div>
				</form>
			</div>
	<div class="setup-content">
		<div class="button-container">
			<button id="vmOperationDialog_button_#5483" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="vmOpsDialogCtrl.closeModal()"><cv:msg key="Cancel" bundle="messages"/></button> 
			<button id="vmOperationDialog_button_#4291" type="button" class="btn btn-primary cvBusyOnAjax" data-ng-click="vmOpsDialogCtrl.submit()"><cv:msg key="Submit" bundle="messages"/></button> 
		</div>
	</div>
</div>