<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="lcPolicyDetails-vmware"
			data-title='<cv:msg key="label.summary" bundle="profiles" />'
			loader="policyDetails.details">
		<ul class="list-style-secondary">
			<li data-ng-if="policyDetails.details.vmPolicyAppType" class="group" id="vmware_vmPolicyAppType_id">
			<span class="pageDetailColumn">
				 <cv:msg key="label.PolicyType" bundle="restore" />
			</span>
			  <span class="pageDetailColumn" data-ng-bind="policyDetails.policyAppType"></span>
			</li>
			<li class="group"><span class="pageDetailColumn"><cv:msg
						key="label.destinationServer" bundle="restore" /></span> <span
				class="pageDetailColumn">{{::policyDetails.details.destinationHyperV.clientName}}</span>
			</li>
			<li class="group"><span class="pageDetailColumn"><cv:msg
						key="label.accessNode" bundle="restore" /></span> <span
				class="pageDetailColumn">{{::policyDetails.details.proxyClientEntity.clientName}}</span>
			</li>
			<li class="group"
				data-ng-if="policyDetails.details.securityAssociations.users && policyDetails.details.securityAssociations.users.length > 0">
				<span class="pageDetailColumn"><cv:msg key="label.users"
						bundle="restore" /></span> <span class="pageDetailColumn">{{::policyDetails.getUserNamesInCSV(policyDetails.details.securityAssociations.users)}}</span>
			</li>
			<li class="group"
				data-ng-if="policyDetails.details.securityAssociations.userGroups && policyDetails.details.securityAssociations.userGroups.length">
				<span class="pageDetailColumn"><cv:msg key="label.userGroups"
						bundle="restore" /></span> <span class="pageDetailColumn">{{::policyDetails.getUserGroupNamesInCSV(policyDetails.details.securityAssociations.userGroups)}}</span>
			</li>
			<li class="group" data-ng-if="policyDetails.showDisplayName"><span class="pageDetailColumn"><cv:msg
						key="label.changeVmDisplayName" bundle="restore" /> ( <span
					data-ng-if="policyDetails.details.vmNameEditType === 'PREFIX'"><cv:msg
							key="label.prefix" bundle="restore" /></span> <span
					data-ng-if="policyDetails.details.vmNameEditType === 'SUFFIX'"><cv:msg
							key="label.suffix" bundle="restore" /></span> ) </span> <span
				class="pageDetailColumn">{{::policyDetails.details.vmNameEditString
					? policyDetails.details.vmNameEditString : '<cv:msg
						key="label.notSet" bundle="restore" />'}}
			</span></li>
			<li class="group"><span class="pageDetailColumn"><cv:msg
						key="label.destinationHost" bundle="restore" /></span> <span
				class="pageDetailColumn">{{::policyDetails.getDestinationHostDisplayName(policyDetails.details)}}</span>
			</li>
			<li class="group" data-ng-if="!policyDetails.distributedStorageName"><span class="pageDetailColumn"><cv:msg
						key="label.dataStore" bundle="restore" /></span> <span
				class="pageDetailColumn" data-ng-bind="policyDetails.dataStoreName"></span>
			</li>
			<li class="group" data-ng-if="policyDetails.showResourcePool"><span class="pageDetailColumn"><cv:msg
						key="label.resourcePool" bundle="restore" /></span> <span
				class="pageDetailColumn">{{::policyDetails.details.resourcePoolPath}}</span>
			</li>
			<li class="group" data-ng-if="policyDetails.details.folderPath">
				<span class="pageDetailColumn"><cv:msg key="label.vmFolder"
						bundle="restore" /></span> <span class="pageDetailColumn">{{::policyDetails.getFolderNameForId(policyDetails.details.folderPath)}}</span>
			</li>
			<li class="group"><span class="pageDetailColumn"><cv:msg
						key="label.destinationNetworkModal" bundle="restore" /></span> <span
				class="pageDetailColumn">{{::policyDetails.networkNames}}</span>
			</li>
			<li class="group" data-ng-if="policyDetails.details.maxCores"><span
				class="pageDetailColumn"><cv:msg key="label.noOfCPUs"
						bundle="restore" /></span> <span class="pageDetailColumn">{{::policyDetails.details.maxCores}}</span>
			</li>
			<li class="group" data-ng-if="policyDetails.details.maxVMQuota">
				<span class="pageDetailColumn"><cv:msg
						key="label.noOfVMsRHEV" bundle="vmManagement" /></span> <span
				class="pageDetailColumn">{{::policyDetails.details.maxVMQuota}}</span>
			</li>
			<li class="group"
				data-ng-if="policyDetails.details.minutesRetainUntil"><span
				class="pageDetailColumn"><cv:msg key="label.expirationTime"
						bundle="restore" /></span> <span class="pageDetailColumn">{{::policyDetails.details.minutesRetainUntil}}
					<cv:msg key="label.hours" bundle="schedule" />
			</span></li>
			<li class="group" data-ng-if="policyDetails.details.daysRetainUntil">
				<span class="pageDetailColumn"><cv:msg
						key="label.expirationTime" bundle="restore" /></span> <span
				class="pageDetailColumn">{{::policyDetails.details.daysRetainUntil}}
					<cv:msg key="label.days" bundle="schedule" />
			</span>
			</li>
			<li class="group" data-ng-if="policyDetails.details.maxMemory">
				<span class="pageDetailColumn"><cv:msg
						key="label.maxMemoryRHEV" bundle="restore" /></span> <span
				class="pageDetailColumn">{{::policyDetails.details.maxMemory}}</span>
			</li>
			<li class="group" data-ng-if="policyDetails.details.mediaAgent && policyDetails.details.mediaAgent.clientName">
				<span class="pageDetailColumn"><cv:msg key="label.mediaAgent"
						bundle="storage" /></span> <span class="pageDetailColumn">{{::policyDetails.details.mediaAgent.clientName}}</span>
			</li>
  		    <li class="group" data-ng-repeat="isoObj in policyDetails.details.isoInfo"><span class="pageDetailColumn"><cv:msg key="label.isoPath" bundle="restore" /> ( {{isoObj.osType}} )</span>
                      <span class="pageDetailColumn">{{isoObj.isoPath}}</span></li>
			<li class="group" data-ng-if="!!policyDetails.details.associatedClientGroup && !!policyDetails.details.associatedClientGroup.clientGroupName">
				<span class="pageDetailColumn">
						<cv:msg key="label.associateServerGroup" bundle="vmManagement" />
				</span>
				<span class="pageDetailColumn">
						{{::policyDetails.details.associatedClientGroup.clientGroupName}}
				</span>
			</li>
			 <!--  virtual lab settings details start -->
			<li class="group"  data-ng-if="!!policyDetails.details.createIsolatedNetwork"><span class="pageDetailColumn"><cv-help-text help-label="label.isolatedNetwork"
			help-text="'<cv:msg key="label.isolatedNetworkDesc" bundle="restore"/>'"></span> <span
				class="pageDetailColumn">
					{{::!!policyDetails.details.createIsolatedNetwork ? '<cv:msg
						key='label.yes' bundle='restore' />' : '<cv:msg key='label.no'
						bundle='restore' />'}}
			</span></li>
            <li class="group" data-ng-if="!!policyDetails.details.createIsolatedNetwork && !!policyDetails.details.gatewayTemplate.vmName">
                    <span class="pageDetailColumn">
                       	<cv-help-text help-label="label.gatewayTemplate" help-text="'<cv:msg
							key="label.gatewayTemplateDesc" bundle="restore" />'">
                    </span>
                    <span class="pageDetailColumn">
                        {{::policyDetails.details.gatewayTemplate.vmName}}
                    </span>
            </li>
            <li class="group" data-ng-if="!!policyDetails.details.createIsolatedNetwork && !!policyDetails.details.primaryGatewayNetwork">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.gatewayNetwork" bundle="vmManagement" />
                    </span>
                    <span class="pageDetailColumn">
                        {{::policyDetails.details.primaryGatewayNetwork}}
                    </span>
             </li>
			<li data-ng-if="!!policyDetails.details.isLiveMountEnabled" class="group"><span class="pageDetailColumn"><cv:msg
						key="label.migrateVMs" bundle="restore" /></span> <span
				class="pageDetailColumn">
					{{::!!policyDetails.details.migrateVMs ? '<cv:msg key='label.yes'
						bundle='restore' />' : '<cv:msg key='label.no' bundle='restore' />'}}
			</span></li>
			<li data-ng-if="policyDetails.existingNetworkNames" class="group" id="existing_network_list_id">
			<span class="pageDetailColumn">
				<cv-help-text help-label="<cv:msg key="label.existingNetwork" bundle="vmManagement" />" help-text='label.existingNetworkDesc'></cv-help-text>
			</span> <span
				class="pageDetailColumn">
					{{::policyDetails.existingNetworkNames}}
			</span></li>

		</ul>
		<div class="page-details-box-links">
			<span> <a class="page-action-item" href=""
				data-ng-click="policyDetails.openEditModal()" data-ng-if="!policyDetails.hideEdit"> <cv:msg
						key="action.edit" bundle="collections" />
			</a>
			</span>
		</div>
		</cv-tile-component>
	</div>
	<div class="col-md-6" data-ng-if="policyDetails.distributedStorageName">
		<cv-tile-component data-ac-id="lcPolicyDetails-vmware"
			data-title='<cv:msg key="label.commvaultDistributedStorage" bundle="vmManagement" />'
			loader="policyDetails.details">
		<ul class="list-style-secondary">
			<li class="group"><span class="pageDetailColumn"><cv:msg
						key="label.hedvigDatastore" bundle="vmManagement" /></span> <span
				class="pageDetailColumn" data-ng-bind="policyDetails.dataStoreName"></span>
			</li>
			<li class="group"><span class="pageDetailColumn"><cv:msg
						key="label.hedvigCluster" bundle="vmManagement" /></span><span
				class="pageDetailColumn" data-ng-bind="policyDetails.distributedStorageName"></span>
			</li>
		</ul>
		</cv-tile-component>
	</div>
</div>