<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagementJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.exchange"></cv:cvMessages>
	<cv:cvMessages bundle="localization.users"></cv:cvMessages>
</script>
<form name="replicationTargetForm" id="replicationTargetForm" novalidate
	class="form-horizontal edit-users-grid-form bootstrap-wrapper"
	data-cv-submit="saveData()" autocomplete="off">
	<div class="panel panel-default">
		<div class="panel-body margin-bottom-10">
			<div class="{{serverMessageTop.type}} serverMessage text-center">{{serverMessageTop.message}}</div>
			<!-- General Options Accordion -->
			<cv-plain-accordion accordion-label="label.general"
				collapsed="generalOptionsAccordion" data-ng-if="showGeneralTab"> <!-- Replication target name -->
			<div class="form-group">
				<label class="col-xs-12 col-md-5" for="replicationTargetName">
					<cv:msg key="label.policyName" bundle="vmManagement" />
				</label>
				<div class="col-xs-12 col-md-7">
					<input type="text" name="replicationTargetName"
						data-ng-model="restoreData.replicationTargetName" placeholder ="<cv:msg key="label.policyName" bundle="vmManagement" />" required />
					<div class="help-block"
						data-ng-show="!restoreData.replicationTargetName && cv.replicationTargetForm.getAttempted()">
						<i class="ion-alert-circled"></i>
						<cv:msg key="error.name" bundle="messagesJs" />
					</div>
				</div>
			</div>
			<!-- Select Destination Hypervisor -->
			<div class="form-group">
				<label for="serverId" class="col-xs-12 col-md-5"> <cv:msg
						key="label.destinationServer" bundle="restore" />
				</label>
				<div class="col-xs-12 col-md-7" data-ng-disabled="editMode">
					<cv-select-hypervisors model="model" vendor="VMW" ctrl="ctrl"> </cv-select-hypervisors>
				</div>
			</div>
			<!-- Select Proxy -->
			<div class="form-group"
				data-ng-show="restoreData.globalOptions.showProxy> 0">
				<label class="col-xs-12 col-md-5" for="destinationProxy"
					class="restorePathLabel"> <cv:msg key="label.accessNode"
						bundle="restore" />
				</label>
				<div class="col-xs-12 col-md-7">
					<cv-select-proxy model="restoreData.globalOptions" vendor="VMW"
						ctrl="ctrl" selection="single" is-replication="!isRegularPolicy" automatic-proxy="distributeWorkload"> </cv-select-proxy>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-md-5" for="usersAndUserGroups">
					<cv:msg key="label.usersAndUserGroups" bundle="restore" />
				</label>
				<div class="col-xs-12 col-md-7">
					<isteven-multi-select data-input-model="usersAndUserGroups"
						data-output-model="usersAndUserGroup" button-label="fullName"
						item-label="fullName" tick-property="selected"
						class="isteven-multi-select user-group-select"
						id="usersAndUserGroups" name="usersAndUserGroups"
						search-property="fullName" max-height="400px"
						group-property="header" helper-elements="all none filter"
						selection-mode="multiple" directive-id="usersAndUserGroups">
					</isteven-multi-select>
				</div>
			</div>
			<cv-restore-options-vmware
				data-ng-if="model.selectedHypervisor.clientId"
				destination-id="model.selectedHypervisor.clientId" vm-list="vmList"
				mode="repTarget" ctrl="ctrl" display-info="true" edit-mode="editMode" policy-app-type="vmPolicyAppType"> </cv-restore-options-vmware> </cv-plain-accordion>
			<!-- Advanced Options Accordion -->
			<span data-ng-if="isRegularPolicy">
			<cv-plain-accordion accordion-label="label.liveMountOptions"
					collapsed="additionalOptions">
				<!-- Virtual lab check box -->
				<!--    	<div class="margin-top-10 margin-bottom-10">
			    		<cv-please-note header='<cv:msg key="action.note" bundle="restoreJs" />' body='<cv:msg key="info.failoverForLiveSync" bundle="restoreJs" />'></cv-please-note>
			    	</div>-->
			 		<cv-advance-options
					data-ng-if="model.selectedHypervisor.clientId && restoreData.globalOptions.selectedProxy"
					vendor="vendor" vm-list="vmList[0]"
					source-Id="model.selectedHypervisor.clientId" edit-mode="editMode"
					mode=replicationTarget ctrl="ctrl"
					destination-Host="restoreData.vmOptions.destinationHost"
					server-Details="model.selectedHypervisor"
					policy-app-type="vmPolicyAppType">
					</cv-advance-options>

				</cv-plain-accordion>
			</span>
			<div data-ng-if="!isRegularPolicy && showTestFailoverForVMware">
				<cv-plain-accordion accordion-label="label.testFailoverOptions"
				collapsed="additionalOptions">
					<!-- Virtual lab check box -->
				<!--    	<div class="margin-top-10 margin-bottom-10">
			    		<cv-please-note header='<cv:msg key="action.note" bundle="restoreJs" />' body='<cv:msg key="info.failoverForLiveSync" bundle="restoreJs" />'></cv-please-note>
			    	</div>-->
			    	<cv-advance-options
					data-ng-if="model.selectedHypervisor.clientId && restoreData.globalOptions.selectedProxy"
					vendor="vendor" vm-list="vmList[0]"
					source-Id="model.selectedHypervisor.clientId" edit-mode="editMode"
					mode=replicationTarget ctrl="ctrl"
					destination-Host="restoreData.vmOptions.destinationHost"
					server-Details="model.selectedHypervisor"
					policy-app-type="vmPolicyAppType">
					</cv-advance-options>

				</cv-plain-accordion>
				</div>
			<div data-ng-if="(!isRegularPolicy && showTestFailoverForVMware) || isRegularPolicy">
	        <cv-plain-accordion accordion-label="label.virtualLabOptions"
				collapsed="virtualLabOptions" >
				<!-- Radio buttons of virtual lab settings -->
				<div class="form-group margin-left-15">
						<!-- Isolated network -->
				<input class="no-float" id="isolatedNetwork" type="radio"
					name="networkType" value="isolatedNetwork"
					data-ng-model="networkSelector"
					data-ng-change="virtualLabNetworkChanged('createIsolatedNetwork', networkSelector)" />
				<label for="networksettings"
					class="restore-settings-right-padding inline-label no-margin">
							<cv-help-text help-label="label.isolatedNetwork" help-text="'<cv:msg key="label.isolatedNetworkDesc" bundle="restore"/>'">
						</label>
						<!-- Existing network -->
				<input id="existingNetwork" type="radio" name="networkType"
					value="existingNetwork" data-ng-model="networkSelector"
					data-ng-change="virtualLabNetworkChanged('configureExistingNetwork', networkSelector)" />
						<label for="networksettings" class="inline-label no-margin">
							<cv-help-text help-label="label.configureExistingNetwork" help-text="'<cv:msg key="label.existingNetworkDesc" bundle="restore"/>'">
						</label>
					</div>
			<!-- End of Radio buttons of virtual lab settings --> <!-- Gateway template -->
			<div class="form-group margin-left-15"
				data-ng-if="networkSelector === 'isolatedNetwork'" data-ng-disabled="!restoreData.vmOptions.destinationHost">
						<div class="col-xs-12 col-md-5 col-lg-5">
					<label for="gatewayTemplate">
						<cv-help-text help-label="label.gatewayTemplate" help-text="'<cv:msg
							key="label.gatewayTemplateDesc" bundle="restore" />'">
							</label>
						</div>
						<div class="col-xs-12 col-md-7">
							<div class="input-group cursor-pointer">
						<input type="text" readonly id="gatewayTemplate"
							name="gatewayTemplate"
							data-ng-model="restoreData.gatewayTemplate.name"
							placeholder='<cv:msg key="label.selectGatewayTemplate" bundle="restore" />'
							data-ng-click="openBrowseGatewayTemplatesModal()" /> <span
							class="input-group-btn">
							<button id="vmLCPolicyVMWare_button_#1871" class="btn btn-default" type="button"
								data-ng-click="openBrowseGatewayTemplatesModal()">
											<cv:msg key="label.browse" bundle="restore" />
										</button>
									</span>
							</div>
					<span class="help-block" data-ng-if="gatewaytemplateMissing.message"> <i
						class="ion-alert-circled">{{gatewaytemplateMissing.message}}</i>
					</span>
						</div>
					</div>
			<!-- End of Gateway template -->
			 <!-- Gateway network -->
			<div class="form-group margin-left-15"
				data-ng-if="networkSelector === 'isolatedNetwork'"
				data-ng-disabled="!isGatewayNetworkListAvailable()">
						<div class="col-xs-12 col-md-5">
					<label for="gatewayNetwork"> <cv:msg
							key="label.gatewayNetwork" bundle="vmManagement" />
							</label>
						</div>
							<div class="col-xs-12 col-md-7">
					<isteven-multi-select data-input-model="gatewayNetworkSettingsList"
								data-output-model="model.gatewayNetwork"
								button-label="displayName" item-label="displayName"
						tick-property="selected" id="gatewayNetwork" name="gatewayNetwork"
						max-height="400px" selection-mode="single"
						translation="localLangGatewayNetwork"
						on-close="setNetworkErrorMessage()"> </isteven-multi-select>
					<span class="help-block" data-ng-if="gatewayNetworkMissing.message"> <i
						class="ion-alert-circled">{{gatewayNetworkMissing.message}}</i>
					</span>
						</div>
					</div>
			<!-- End of gateway network --> <!-- Existing network -->
			<div class="form-group margin-left-15"
				data-ng-if="networkSelector === 'existingNetwork'"
				data-ng-disabled="!isExistingNetworkListAvailable()">
						<div class="col-xs-12 col-md-5">
					<label for="network"> <cv:msg key="label.network"
							bundle="vmManagement" />
							</label>
						</div>
						<div class="col-xs-12 col-md-7">
							<isteven-multi-select
							data-input-model="existingNetworkSettingsList"
							data-output-model="model.existingNetwork"
							button-label="displayName" item-label="displayName"
							tick-property="selected" id="existingNetwork"
						name="existingNetwork" max-height="400px" selection-mode="single"
						translation="localLangExistingNetwork"
						on-close="setExistingNetworkErrorMsg()"> </isteven-multi-select>
							<span class="help-block" data-ng-if="existingNetworkMissing.message"> <i
						class="ion-alert-circled">{{existingNetworkMissing.message}}</i>
					</span>
						</div>
					</div>
			<!-- End of Existing network  --> </cv-plain-accordion>
			</div>

			<cv-plain-accordion
				accordion-label="label.virtualizeMeForReplicationTarget"
				collapsed="virtualizeOptions" data-ng-if="isRegularPolicy">
				<br/>
				<!--Virtualize Me toggle -->
				<!--  <div data-ng-disabled="!restoreData.vmOptions.destinationHost">
						<toggle-control status="configureVirtualizeMe"
							data-ng-click="manageVirtualizeMeActivity()"
							title="Enable/disable <cv:msg key='label.virtualizeMeForReplicationTarget' bundle='restore' />"></toggle-control>&nbsp;
						<span class="no-padding"><cv:msg
							key="action.replication.enable" bundle="vmsJs" /></span>
				</div>
				<br/>-->

				<!--No Of CPUs  -->
				<div class="form-group margin-left-15" id="noOfCPUs_id">
					<label class="col-xs-12 col-md-5 col-lg-5" for="noOfCPUs"><cv:msg
								key="label.noOfCPUs" bundle="restore" /></label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<input type="number" class="temporary-enabled" id="noOfCPUs"
								data-ng-change="noOfCPUsChanged()"
								data-ng-model="model.noOfCPUs" min="1" max="16" /> <span
								class="help-block"
								data-ng-if="invalidNoOfCPUs.message"> <i
								class="ion-alert-circled">{{invalidNoOfCPUs.message}}</i>
								</span>

					</div>

				</div>

				<!-- Auto select max memory -->
					<div class="form-group margin-left-15">
						<toggle-control status="model.maxmemoryToggle"
								data-ng-click="manageMaxMemoryActivity()"
								title="Enable/disable <cv:msg key='label.autoSelectMaxMemory' bundle='restore' />"></toggle-control>
								&nbsp; <span class="no-padding">
							<cv-help-text help-label="label.autoSelectMaxMemory" help-text="'<cv:msg
									key="label.autoSelectMaxMemDesc" bundle="restore" />'"></span>

				</div>

				<div class="form-group  margin-left-15">
					<!--  data-ng-show="advOptCtrl.configureVirtualizeMeFlag || advOptCtrl.isApplianceEnabledCS()">-->
					<!-- Max  memory -->
					<div data-ng-if="!maxMemoryFlag">
						<label class="col-xs-12 col-md-5 col-lg-5" for="maxMemory">
							<cv:msg key="label.maxMemoryRHEV" bundle="restore" />
						</label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<input type="number" class="temporary-enabled" id="maxMemory"
									data-ng-change="maxMemoryChanged()"
									data-ng-model="model.maxMemory" min="1" max="64" /> <span><cv:msg
									key="label.GB" bundle="restore" /> </span>
								<span class="help-block"
									data-ng-if="invalidMaxMemory.message"> <i
									class="ion-alert-circled">{{invalidMaxMemory.message}}</i>
								</span>
						</div>
					</div>
				</div>


				 <!-- iso path (windows) -->
			<div class="form-group  margin-left-15">
						<label class="col-xs-12 col-md-5 col-lg-5" for="isoPathWindows"><cv:msg
								key="label.isoPath" bundle="restore" /> (<cv:msg
								key="label.windows" bundle="profiles" />)</label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<div class="input-group">
								<input type="text" class="temporary-enabled" readonly
									id="isoPathWindows" name="isoPathWindows"
									data-ng-model="restoreData.vmOptions.isoInfo.windows.isoPath"
									placeholder="<cv:msg key="label.isoPath" bundle="restore" /> <cv:msg key="label.windows" bundle="profiles" />"
									data-ng-click="openBrowseDataStoresModal(restoreData.vmOptions.destinationHost, 'windows')" />
								<span class="input-group-btn">
									<button id="vmLCPolicyVMWare_button_#4874" class="btn btn-default" type="button"
										data-ng-click="openBrowseDataStoresModal(restoreData.vmOptions.destinationHost, 'windows')">
										<cv:msg key="label.browse" bundle="restore" />
									</button>
								</span>
							</div>
						</div>
					</div>
			<!-- iso path (unix) -->
			<div class="form-group margin-left-15">
						<label class="col-xs-12 col-md-5 col-lg-5" for="isoPathUnix"><cv:msg
						key="label.isoPath" bundle="restore" /> (<cv:msg key="label.unix"
						bundle="profiles" />)</label>
						<div class="col-xs-12 col-md-7 col-lg-7">
							<div class="input-group">
								<input type="text" class="temporary-enabled" readonly
									id="isoPathUnix" name="isoPathUnix"
									data-ng-model="restoreData.vmOptions.isoInfo.unix.isoPath"
									placeholder="<cv:msg key="label.isoPath" bundle="restore"/> <cv:msg key="label.unix" bundle="profiles" />"
									data-ng-click="openBrowseDataStoresModal(restoreData.vmOptions.destinationHost, 'unix')" />
								<span class="input-group-btn">
									<button id="vmLCPolicyVMWare_button_#9578" class="btn btn-default" type="button"
										data-ng-click="openBrowseDataStoresModal(restoreData.vmOptions.destinationHost, 'unix')">
										<cv:msg key="label.browse" bundle="restore" />
									</button>
								</span>
						</div>
					</div>
				</div>
				<!-- Server group -->
				<div class="form-group margin-left-15" data-ng-disabled="!configureVirtualizeMeFlag">
					<toggle-control status="serverGroupActivity"
						data-ng-click="manageServerGroupActivity()"
						title="Enable/disable <cv:msg key='label.virtualizeMeForReplicationTarget' bundle='restore' />"></toggle-control>&nbsp;
					<span class="no-padding"><cv:msg
							key="label.enableAssociateToServerGroup" bundle="vmManagement" /></span>
				</div>
				<div class="form-group margin-left-15" data-ng-show="serverGroupActivityFlag">
					<div class="col-xs-12 col-md-5 col-lg-5">
							<label for="serverGroups"><cv:msg
								key="label.associateServerGroup" bundle="vmManagement" />
							</label>
					</div>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<isteven-multi-select data-input-model="serverGroupList"
						data-output-model="model.serverGroup"
						button-label="name" item-label="name"
						tick-property="selected" id="serverGroup" name="serverGroup"
						max-height="400px" selection-mode="single"> </isteven-multi-select>
					</div>
				</div>
		        </cv-plain-accordion>

			<div class="button-container">
				<fmt:bundle basename="localization.messages">
					<button id="vmLCPolicyVMWare_button_#6059" type="button"
						class="btn btn-default setup-btn--hidden cvBusyOnAjax"
						data-ng-click="cancel()">
						<cv:msg key="Cancel" />
					</button>
					<button id="vmLCPolicyVMWare_button_#8834" data-ng-if="!editMode" type="submit"
						class="btn btn-primary cvBusyOnAjax">
						<cv:msg key="Add" />
					</button>
					<button id="vmLCPolicyVMWare_button_#7364" data-ng-if="editMode" type="submit"
						class="btn btn-primary cvBusyOnAjax">
						<cv:msg key="Save" />
					</button>
				</fmt:bundle>
			</div>
		</div>
	</div>
</form>