<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
</script>
<form id="replicationTargetOCIForm" name="replicationTargetOCIForm"
	novalidate data-cv-submit="rOCICtrl.save()" autocomplete="off"
	class="form-horizontal edit-users-grid-form bootstrap-wrapper">
	<div class="">
		<div class="panel-body">
		<div class="{{rOCICtrl.OCIErrorMessage.type}} rOCICtrl.OCIErrorMessage text-center">{{rOCICtrl.OCIErrorMessage.message}}</div>
			<!-- Replication target name -->
			<div class="form-group">
				<label class="col-xs-12 col-md-5" for="replicationTargetName"><cv:msg key="label.policyName" bundle="vmManagement" /></label>
				<div class="col-xs-12 col-md-7">
					<input type="text" name="replicationTargetName"	id="replicationTargetName" data-ng-model="rOCICtrl.restoreData.replicationTargetName"required />
					<div class="help-block" data-ng-if="cv.replicationTargetOCIForm.needsAttention(replicationTargetOCIForm.replicationTargetName)">
						<i class="ion-alert-circled"></i>
						<cv:msg key="error.name" bundle="messagesJs" />
					</div>
				</div>
			</div>
			<!-- Destination Hypervisor -->
			<div class="form-group">
				<label class="col-xs-12 col-md-5" for="serverId"><cv:msg key="label.destinationServer" bundle="restore" /></label>
				<div class="col-xs-12 col-md-7">
					<cv-select-hypervisors model="rOCICtrl.model"
						vendor="{{rOCICtrl.vendor}}" ctrl="rOCICtrl.ctrl">
					</cv-select-hypervisors>
				</div>
			</div>
			<!--  Proxy -->
			<div class="form-group"
				data-ng-if="rOCICtrl.model.selectedHypervisor.clientId">
				<label class="col-xs-12 col-md-5" for="destinationProxy"><cv:msg key="label.accessNode" bundle="restore"></cv:msg></label>
				<div class="col-xs-12 col-md-7">
					<cv-select-proxy model="rOCICtrl.restoreData.globalOptions"
						ctrl="rOCICtrl.ctrl"
						hypervisor="rOCICtrl.model.selectedHypervisor" selection="single">
					</cv-select-proxy>
				</div>
			</div>
 				<div class="form-group">
				<label class="col-xs-12 col-md-5" for="usersAndUserGroups"><cv:msg
						key="label.usersAndUserGroups" bundle="restore" /></label>
				<div class="col-xs-12 col-md-7">
					<isteven-multi-select
						data-input-model="rOCICtrl.usersAndUserGroups"
						data-output-model="rOCICtrl.usersAndUserGroup"
						button-label="fullName" item-label="fullName"
						tick-property="selected" id="usersAndUserGroups"
						name="usersAndUserGroups" max-height="400px"
						group-property="header" selection-mode="multiple">
					</isteven-multi-select>
				</div>
			</div>
		</div>
		<cv-restore-options-oci
			data-ng-if="rOCICtrl.model.selectedHypervisor.clientId && rOCICtrl.restoreData.globalOptions.selectedProxy"
			vendor="rOCICtrl.vendor" vm-list="rOCICtrl.vmList"
			source-Id="rOCICtrl.model.selectedHypervisor.clientId"
			edit-mode="rOCICtrl.editMode" mode=replicationTarget
			ctrl="rOCICtrl.ctrl"
			vm-policy-app-type="vmPolicyAppType">
		</cv-restore-options-oci>
	</div>
	<div class="modal-footer">
		<button id="vmLCPolicyOCI_button_#7409" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="rOCICtrl.saveOCICancelled()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="vmLCPolicyOCI_button_#4298" data-ng-if="!rOCICtrl.editMode" type="submit" class="btn btn-primary cvBusyOnAjax" >
			<cv:msg key="Add" />
		</button>
		<button id="vmLCPolicyOCI_button_#2333" data-ng-if="rOCICtrl.editMode" type="submit" class="btn btn-primary cvBusyOnAjax">
			<cv:msg key="Save" />
		</button>
	</div>
</form>