<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="lcPolicyDetails-vmware" data-title='<cv:msg key="label.summary" bundle="profiles" />' loader="policyDetails.details">
			<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.destinationServer" bundle="restore"/></span>
					<span class="pageDetailColumn">{{::policyDetails.details.destinationHyperV.clientName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.accessNode" bundle="restore"/></span>
					<span class="pageDetailColumn">{{::policyDetails.details.proxyClientEntity.clientName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.dataStore" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.details.dataStores[0].dataStoreName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.destinationNetworkModal" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.details.networkList[0].destinationNetwork}}</span>
				</li>
				<li class="group" data-ng-if="policyDetails.details.securityAssociations.users && policyDetails.details.securityAssociations.users.length > 0">
					<span class="pageDetailColumn"><cv:msg key="label.users" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.getUserNamesInCSV(policyDetails.details.securityAssociations.users)}}</span>
				</li>
				<li class="group" data-ng-if="policyDetails.details.securityAssociations.userGroups && policyDetails.details.securityAssociations.userGroups.length">
					<span class="pageDetailColumn"><cv:msg key="label.userGroups" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.getUserGroupNamesInCSV(policyDetails.details.securityAssociations.userGroups)}}</span>
				</li>
				<li class="group" data-ng-if="policyDetails.details.vmPolicyAppType"id="nutanix_vmPolicyAppType_id">
					<span class="pageDetailColumn"><cv:msg key="label.PolicyType" bundle="restore" /></span>
					<span class="pageDetailColumn"> {{::policyDetails.policyAppType}}</span>
				</li>
			</ul>
			<div class="page-details-box-links">
				<span>
					<a class="page-action-item" href="" data-ng-click="policyDetails.openEditModal()" data-ng-if="!policyDetails.hideEdit">
						<cv:msg key="action.edit" bundle="collections" />
					</a>
				</span>
			</div>
		</cv-tile-component>
	</div>
</div>