<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.messagesJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
</script>
<span class="{{serverMessageTop.type}} serverMessage">{{serverMessageTop.message}}</span>
<form name="replicationTargetForm" id="replicationTargetForm" novalidate class="form-horizontal edit-users-grid-form bootstrap-wrapper" data-cv-submit="saveData()" autocomplete="off">
    <div class="panel-body">
         <!-- Replication target name -->
        <div class="form-group">
            <label class="col-xs-12 col-md-5" for="replicationTargetName">
				<cv:msg key="label.policyName" bundle="vmManagement" />
			</label>
			<div class="col-xs-12 col-md-7">
				<input type="text" id="replicationTargetName" name="replicationTargetName" data-ng-model="restoreData.replicationTargetName" required />
				<div class="help-block" data-ng-show="!restoreData.replicationTargetName && cv.replicationTargetForm.getAttempted()">
					<i class="ion-alert-circled" ></i><cv:msg key="error.name" bundle="messagesJs"/>
				</div>
			</div>
        </div>
         <!-- Select Destination Hypervisor -->
        <div class="form-group">
            <label for="serverId" class="col-xs-12 col-md-5">
				<cv:msg key="label.destinationServer" bundle="restore" />
			</label>
			<div class="col-xs-12 col-md-7">
				<cv-select-hypervisors id="serverId"
					model="model"
					vendor="NUTANIX"
					ctrl="ctrl">
				</cv-select-hypervisors>
			</div>
         </div>
         <!-- Select Proxy -->
        <div class="form-group" data-ng-show="restoreData.globalOptions.showProxy> 0">
            <label class="col-xs-12 col-md-5" for="destinationProxy" class="restorePathLabel">
				<cv:msg key="label.accessNode" bundle="restore"/>
			</label>
			<div class="col-xs-12 col-md-7">
				 <cv-select-proxy id="destinationProxy"
					model="restoreData.globalOptions"
					vendor="NUTANIX"
					ctrl="ctrl"
					selection="single">
				 </cv-select-proxy>
			</div>
        </div>
		<cv-restore-options-nutanix data-ng-if="model.selectedHypervisor.clientId"
			vendor="vendor"
			vm-list="vmList"
			modified-vms="modifiedVms"
			source-id={{model.selectedHypervisor.clientId}}
			destination-id="model.selectedHypervisor.clientId"
			replication-type="{{attributes.replicationType}}"
			edit-mode="editMode"
			mode="repTarget"
			ctrl="ctrl">
		</cv-restore-options-nutanix>
		<div class="form-group">
				<label class="col-xs-12 col-md-5" for="usersAndUserGroups"><cv:msg key="label.usersAndUserGroups" bundle="restore"/></label>
				<div class="col-xs-12 col-md-7">
					<isteven-multi-select
			   			data-input-model="usersAndUserGroups"
			  			data-output-model="usersAndUserGroup"
			  			button-label="fullName"
						item-label="fullName"
			   			tick-property="selected"
			   			class="isteven-multi-select user-group-select"
			   			id="usersAndUserGroups"
			   			name="usersAndUserGroups"
			   			search-property="fullName"
			   			max-height="400px"
			   			group-property="header"
			   			helper-elements="all none filter"
			   			selection-mode="multiple"
			   			directive-id="usersAndUserGroups">
					</isteven-multi-select>
				</div>
		</div>
    </div>
    <div class="button-container">
        <fmt:bundle basename="localization.messages">
            <button id="vmLCPolicyNutanix_button_#0298" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" /></button> 
            <button id="vmLCPolicyNutanix_button_#2080" data-ng-if="!editMode" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Add" /></button> 
            <button id="vmLCPolicyNutanix_button_#7676" data-ng-if="editMode" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" /></button> 
        </fmt:bundle>
    </div>
</form>