<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>

<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="lcPolicyDetails-googlecloud" data-title='<cv:msg key="label.summary" bundle="profiles" />' loader="policyDetails.details">
			<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.destinationServer" bundle="restore"/></span>
					<span class="pageDetailColumn">{{::policyDetails.details.destinationHyperV.clientName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.accessNode" bundle="restore"/></span>
					<span class="pageDetailColumn">{{::policyDetails.details.proxyClientEntity.clientName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.instanceDisplayName" bundle="restore" />
						( <span data-ng-if="policyDetails.details.vmNameEditType === 'PREFIX'"><cv:msg key="label.prefix" bundle="restore" /></span>
						<span data-ng-if="policyDetails.details.vmNameEditType === 'SUFFIX'"><cv:msg key="label.suffix" bundle="restore" /></span> )
					</span>
					<span class="pageDetailColumn">{{::policyDetails.details.vmNameEditString ? policyDetails.details.vmNameEditString : '<cv:msg key="label.notSet" bundle="restore" />'}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.primaryZone" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.details.zone.primaryZoneName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.secondaryZone" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.details.zone.secondaryZoneName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.machineType" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.details.machineType.name}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.networkInterface" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.details.networkList[0].networkDisplayName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.externalIP" bundle="restore" /></span>
					<span class="pageDetailColumn">
						{{::!!policyDetails.details.isPublicIPSettingsAllowed ? '<cv:msg key='label.yes' bundle='restore' />' : '<cv:msg key='label.no' bundle='restore' />'}}
					</span>
				</li>
				<li class="group" data-ng-if="policyDetails.details.securityAssociations.users && policyDetails.details.securityAssociations.users.length > 0">
					<span class="pageDetailColumn"><cv:msg key="label.users" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.getUserNamesInCSV(policyDetails.details.securityAssociations.users)}}</span>
				</li>
				<li class="group" data-ng-if="policyDetails.details.securityAssociations.userGroups && policyDetails.details.securityAssociations.userGroups.length">
					<span class="pageDetailColumn"><cv:msg key="label.userGroups" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.getUserGroupNamesInCSV(policyDetails.details.securityAssociations.userGroups)}}</span>
				</li>
				<li class="group" data-ng-if="policyDetails.details.vmPolicyAppType" id="gc_vmPolicyAppType_id">
					<span class="pageDetailColumn"><cv:msg key="label.PolicyType" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.policyAppType}}</span>
				</li>
			</ul>
			<div class="page-details-box-links">
				<span>
					<a class="page-action-item" href="" data-ng-click="policyDetails.openEditModal()">
						<cv:msg key="action.edit" bundle="collections" />
					</a>
				</span>
			</div>
		</cv-tile-component>
	</div>
</div>
