<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.collectionsJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
</script>
<form id="replicationTargetGoogleCloudForm" name="replicationTargetGoogleCloudForm"
	novalidate data-cv-submit="rGoogleCloudCtrl.save()" autocomplete="off"
	class="form-horizontal edit-users-grid-form bootstrap-wrapper">
	<div class="">
		<div class="panel-body">
		<div class="{{rGoogleCloudCtrl.GoogleCloudErrorMessage.type}} rGoogleCloudCtrl.GoogleCloudErrorMessage text-center" data-ng-bind="rGoogleCloudCtrl.GoogleCloudErrorMessage.message"></div>
			<!-- Replication target name -->
			<div class="form-group">
				<label class="col-xs-12 col-md-5" for="replicationTargetName"><cv:msg key="label.policyName" bundle="vmManagement" /></label>
				<div class="col-xs-12 col-md-7">
					<input type="text" name="replicationTargetName"	id="replicationTargetName" data-ng-model="rGoogleCloudCtrl.restoreData.replicationTargetName"required />
					<div class="help-block" data-ng-if="cv.replicationTargetGoogleCloudForm.needsAttention(replicationTargetGoogleCloudForm.replicationTargetName)">
						<cv:msg key="error.name" bundle="messagesJs" />
					</div>
				</div>
			</div>
			<!-- Destination Hypervisor -->
			<div class="form-group">
				<label class="col-xs-12 col-md-5" for="serverId"><cv:msg key="label.destinationServer" bundle="restore" /></label>
				<div class="col-xs-12 col-md-7">
					<cv-select-hypervisors model="rGoogleCloudCtrl.model"
						vendor="{{rGoogleCloudCtrl.vendor}}" ctrl="rGoogleCloudCtrl.ctrl">
					</cv-select-hypervisors>
				</div>
			</div>
			<!--  Proxy -->
			<div class="form-group"
				data-ng-if="rGoogleCloudCtrl.model.selectedHypervisor.clientId">
				<label class="col-xs-12 col-md-5" for="destinationProxy"><cv:msg key="label.accessNode" bundle="restore"></cv:msg></label>
				<div class="col-xs-12 col-md-7">
					<cv-select-proxy model="rGoogleCloudCtrl.restoreData.globalOptions"
						ctrl="rGoogleCloudCtrl.ctrl"
						hypervisor="rGoogleCloudCtrl.model.selectedHypervisor" selection="single" is-replication="!isRegularPolicy()" automatic-proxy="rGoogleCloudCtrl.distributeWorkload">
					</cv-select-proxy>
				</div>
			</div>

			<!--  Restore Options for Google Cloud-->
			<cv-restore-options-googlecloud data-ng-if="rGoogleCloudCtrl.model.selectedHypervisor.clientId && rGoogleCloudCtrl.restoreData.globalOptions.selectedProxy"
				vendor="rGoogleCloudCtrl.vendor" 
				vm-list="rGoogleCloudCtrl.vmList"
				source-Id="rGoogleCloudCtrl.model.selectedHypervisor.clientId"
				edit-mode="rGoogleCloudCtrl.editMode" 
				mode=replicationTarget
				ctrl="rGoogleCloudCtrl.ctrl">
			</cv-restore-options-googlecloud>
			<!-- ToDo : check for user groups later-->
			<div class="form-group">
				<label class="col-xs-12 col-md-5" for="usersAndUserGroups"><cv:msg
						key="label.usersAndUserGroups" bundle="restore" /></label>
				<div class="col-xs-12 col-md-7">
					<isteven-multi-select
						data-input-model="rGoogleCloudCtrl.usersAndUserGroups"
						data-output-model="rGoogleCloudCtrl.usersAndUserGroup"
						button-label="fullName" item-label="fullName"
						tick-property="selected" id="usersAndUserGroups"
						name="usersAndUserGroups" max-height="400px"
						group-property="header" selection-mode="multiple">
					</isteven-multi-select>
				</div>
			</div>
		</div>
	</div>
	<div class="modal-footer">
		<button id="vmLCPolicyGoogleCloud_button_#7500" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="rGoogleCloudCtrl.saveGoogleCloudCancelled()">
			<cv:msg key="Cancel" bundle="messages" />
		</button>
		<button id="vmLCPolicyGoogleCloud_button_#4300" data-ng-if="!rGoogleCloudCtrl.editMode" type="submit" class="btn btn-primary cvBusyOnAjax" >
			<cv:msg key="Add" />
		</button>
		<button id="vmLCPolicyGoogleCloud_button_#2300" data-ng-if="rGoogleCloudCtrl.editMode" type="submit" class="btn btn-primary cvBusyOnAjax">
			<cv:msg key="Save" />
		</button>
	</div>
</form>