<%@ taglib prefix="c" uri="http://java.sun.com/jsp/jstl/core"%>
<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="row">
	<div class="col-md-6">
		<cv-tile-component data-ac-id="lcPolicyDetails-azure" data-title='<cv:msg key="label.summary" bundle="profiles" />' loader="policyDetails.details">
			<ul class="list-style-secondary">
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.destinationServer" bundle="restore"/></span>
					<span class="pageDetailColumn">{{::policyDetails.details.destinationHyperV.clientName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.accessNode" bundle="restore"/></span>
					<span class="pageDetailColumn">{{::policyDetails.details.proxyClientEntity.clientName}}</span>
				</li>
				<li class="group" data-ng-if="policyDetails.details.securityAssociations.users && policyDetails.details.securityAssociations.users.length > 0">
					<span class="pageDetailColumn"><cv:msg key="label.users" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.getUserNamesInCSV(policyDetails.details.securityAssociations.users)}}</span>
				</li>
				<li class="group" data-ng-if="policyDetails.details.securityAssociations.userGroups && policyDetails.details.securityAssociations.userGroups.length">
					<span class="pageDetailColumn"><cv:msg key="label.userGroups" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.getUserGroupNamesInCSV(policyDetails.details.securityAssociations.userGroups)}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.changeVmDisplayName" bundle="restore" />
						( <span data-ng-if="policyDetails.details.vmNameEditType === 'PREFIX'"><cv:msg key="label.prefix" bundle="restore" /></span>
						<span data-ng-if="policyDetails.details.vmNameEditType === 'SUFFIX'"><cv:msg key="label.suffix" bundle="restore" /></span> )
					</span>
					<span class="pageDetailColumn">{{::policyDetails.details.vmNameEditString ? policyDetails.details.vmNameEditString : '<cv:msg key="label.notSet" bundle="restore" />'}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.resourceGroup" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.details.esxServers[0].esxServerName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.storageAccount" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.details.dataStores[0].dataStoreName}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.region" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.details.region}}</span>
				</li>
				<li class="group" data-ng-if="policyDetails.isAvailabilityZoneApplicable">
					<span class="pageDetailColumn"><cv:msg key="label.availabilityZone" bundle="restore" /></span>
					<span class="pageDetailColumn" data-ng-bind="policyDetails.details.amazonPolicy.availabilityZones[0].availabilityZoneName"></span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.vmSize" bundle="restore" /></span>
				 	<span class="pageDetailColumn">
				 		{{::policyDetails.details.amazonPolicy.vmInstanceTypes[0].vmInstanceTypeName ? policyDetails.details.amazonPolicy.vmInstanceTypes[0].vmInstanceTypeName : policyDetails.defaultUIDisplay}}
				 	</span>
				</li>
				<li class="group" data-ng-if="policyDetails.isDiskSkuApplicable">
					<span class="pageDetailColumn"><cv:msg key="label.diskType" bundle="restore" /></span>
				 	<span class="pageDetailColumn">
				 		{{::policyDetails.details.amazonPolicy.volumeType ? policyDetails.details.amazonPolicy.volumeType: 'NA'}}
				 	</span>
				</li>
				<li class="group" data-ng-if="policyDetails.details.networkList.length">
				 	<span class="pageDetailColumn"><cv:msg key="label.virtualNetwork" bundle="restore" /></span>
					<span class="pageDetailColumn">{{::policyDetails.details.networkList[0].networkName ? (policyDetails.details.networkList[0].networkDisplayName ? policyDetails.details.networkList[0].networkDisplayName : policyDetails.details.networkList[0].networkName) : policyDetails.defaultUIDisplay}}</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.securityGroup" bundle="restore" /></span>
					<span class="pageDetailColumn" data-ng-if="policyDetails.details.securityGroups && policyDetails.details.securityGroups.length">
						{{::policyDetails.details.securityGroups[0].name ? policyDetails.details.securityGroups[0].name : policyDetails.defaultUIDisplay}}
					</span>
				</li>
				<li class="group">
					<span class="pageDetailColumn"><cv:msg key="label.createPublicIp" bundle="restore" /></span>
					<span class="pageDetailColumn">
						{{::!!policyDetails.details.isPublicIPSettingsAllowed ? '<cv:msg key='label.yes' bundle='restore' />' : '<cv:msg key='label.no' bundle='restore' />'}}
					</span>
				</li>
				<li class="group">
				 	<span class="pageDetailColumn"><cv:msg key="label.restoreAsManagedVM" bundle="restore" /></span>
					<span class="pageDetailColumn">
						{{::!!policyDetails.details.restoreAsManagedVM ? '<cv:msg key='label.yes' bundle='restore' />' : '<cv:msg key='label.no' bundle='restore' />'}}
					</span>
				</li>
				<!-- test failover options  -->
				<span data-ng-if="policyDetails.showTestFailoverForAzure">
					<li class="group" data-ng-if="policyDetails.details.minutesRetainUntil">
						<span class="pageDetailColumn"><cv:msg key="label.expirationTime" bundle="restore" /></span>
						<span class="pageDetailColumn">{{policyDetails.details.minutesRetainUntil}} <cv:msg key="label.hours" bundle="schedule" /></span>
					</li>
					<li class="group" data-ng-if="policyDetails.details.daysRetainUntil">
						<span class="pageDetailColumn"><cv:msg key="label.testExpirationTime" bundle="vmManagement" /></span>
						<span class="pageDetailColumn">{{policyDetails.details.daysRetainUntil}} <cv:msg key="label.days" bundle="schedule" /></span>
					</li>


					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.testVirtualNetwork" bundle="restore" /></span>
						<span class="pageDetailColumn">{{::policyDetails.details.networkInfo[0].networkName ? (policyDetails.details.networkInfo[0].label ? policyDetails.details.networkInfo[0].label : policyDetails.details.networkInfo[0].networkName) : policyDetails.defaultUIDisplay}}</span>
					</li>


					<li class="group">
						<span class="pageDetailColumn"><cv:msg key="label.testVmSize" bundle="vmManagement" /></span>
					 	<span class="pageDetailColumn">
					 		{{::policyDetails.details.amazonPolicy.instanceType[0].instanceType.vmInstanceTypeName ? policyDetails.details.amazonPolicy.instanceType[0].instanceType.vmInstanceTypeName : policyDetails.defaultUIDisplay}}
					 	</span>
					</li>
				</span>

				<li class="group" data-ng-if="policyDetails.details.templates">
					<span class="pageDetailColumn"><cv:msg key="label.vmTemplate" bundle="restore"/></span>
					<div class="view-wrapper">
						<div  data-ng-repeat="template in policyDetails.details.templates">
							<span>
								<div class="{{template.icon}}"/>
								{{::template.vmName}}
							</span>
						</div>
					</div>
				</li>
				<li class="group" id="azure_vmPolicyAppType_id" data-ng-if="policyDetails.details.vmPolicyAppType">
						<span class="pageDetailColumn"><cv:msg key="label.PolicyType" bundle="restore" /></span>
					 	<span class="pageDetailColumn">
					 		{{::policyDetails.policyAppType}}
					 	</span>
					</li>
			</ul>
			<div class="page-details-box-links">
				<span>
					<a class="page-action-item" href="" data-ng-click="policyDetails.openEditModal()" data-ng-if="!policyDetails.hideEdit">
						<cv:msg key="action.edit" bundle="collections" />
					</a>
				</span>
			</div>
		</cv-tile-component>
	</div>
</div>