<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
</script>
<span class="col-xs-12 text-center {{rAzureCtrl.azureErrorMessage.type}} serverMessage">{{rAzureCtrl.azureErrorMessage.message}}</span>
<form id="replicationTargetAzureForm"  name="replicationTargetAzureForm" novalidate
	data-cv-submit="rAzureCtrl.save()" autocomplete="off"
	class="form-horizontal edit-users-grid-form bootstrap-wrapper replication-target-form">
	<div class="panel-body">
		<div class="form-group">
			<label class="col-xs-12 col-md-5" for="replicationTargetName"><cv:msg key="label.policyName" bundle="vmManagement" /></label>
			<div class="col-xs-12 col-md-7">
				<input type="text" name="replicationTargetName" id="replicationTargetName" data-ng-model="rAzureCtrl.restoreData.replicationTargetName" required />
				<div class="help-block" data-ng-if="cv.replicationTargetAzureForm.needsAttention(replicationTargetAzureForm.replicationTargetName)">
					<i class="ion-alert-circled" ></i><cv:msg key="error.name" bundle="messagesJs"/>
				</div>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-5" for="azureSubscription"><cv:msg key="label.azureHypervisor" bundle="restore" /></label>
			<div class="col-xs-12 col-md-7">
				<cv-select-hypervisors
					model="rAzureCtrl.model"
					vendor="{{rAzureCtrl.vendor}}"
					ctrl="rAzureCtrl.ctrl"
					disabled="{{rAzureCtrl.editMode}}">
				</cv-select-hypervisors>
			</div>
		</div>

		<div data-ng-if="rAzureCtrl.model.selectedHypervisor.clientId" class="form-group">
			<div data-ng-if="rAzureCtrl.restoreData.globalOptions.showProxy">
				<label class="col-xs-12 col-md-5"  for="destinationProxy">
					<cv:msg key="label.accessNode" bundle="restore"/>
				</label>
				<div class="col-xs-12 col-md-7">
					 <cv-select-proxy
						id="destinationProxy"
						name="destinationProxy"
						model="rAzureCtrl.restoreData.globalOptions"
						ctrl="rAzureCtrl.ctrl"
						vendor="{{rAzureCtrl.vendor}}"
						selection="single"
						is-replication="rAzureCtrl.isReplicationPolicy()"
						automatic-proxy="rAzureCtrl.distributeWorkload && rAzureCtrl.vendor !== 'AZURE_STACK'">
					 </cv-select-proxy>
				</div>
			</div>
		</div>

		<div class="form-group">
			<label class="col-xs-12 col-md-5" for="usersAndUserGroups"><cv:msg key="label.usersAndUserGroups" bundle="restore"/></label>
			<div class="col-xs-12 col-md-7">
				<isteven-multi-select
		   			data-input-model="rAzureCtrl.usersAndUserGroups"
		  			data-output-model="rAzureCtrl.usersAndUserGroup"
		  			button-label="fullName"
					item-label="fullName"
		   			tick-property="selected"
		   			class="isteven-multi-select user-group-select"
		   			id="usersAndUserGroups"
		   			name="usersAndUserGroups"
		   			search-property="fullName"
		   			max-height="400px"
		   			group-property="header"
		   			selection-mode="multiple">
				</isteven-multi-select>
			</div>
		</div>
	</div>

	<div data-ng-if="rAzureCtrl.restoreData.globalOptions.server.clientId">
		<cv-restore-options-azure vendor="rAzureCtrl.vendor"
		vm-list="rAzureCtrl.vmList"
		edit-mode="rAzureCtrl.editMode"
		mode=replicationTarget
		ctrl="rAzureCtrl.ctrl"
		destination-for-vm-list="rAzureCtrl.restoreData.globalOptions.server"
		vm-options="rAzureCtrl.restoreData.vmOptions"
		vm-policy-app-type="vmPolicyAppType"/>
	</div>

	<div class="modal-footer">
		<fmt:bundle basename="localization.messages">
			<button id="vmLCPolicyAzure_button_#9820" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="Cancel" /></button>
			<button id="vmLCPolicyAzure_button_#9340" data-ng-if="!rAzureCtrl.editMode"
					type="submit" class="btn btn-primary cvBusyOnAjax" >
					<cv:msg key="Add" />
			</button>
			<button id="vmLCPolicyAzure_button_#8351" data-ng-if="rAzureCtrl.editMode" type="submit" class="btn btn-primary cvBusyOnAjax"><cv:msg key="Save" /></button>
		</fmt:bundle>
	</div>
</form>