<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.serversJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.servers"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagementJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvEnum name="Common.VSVendor"></cv:cvEnum>
</script>
<div class="row bootstrap-wrapper">
	<cv-tile-component>
			<div class="form-group">
				<label class="col-xs-12 col-lg-4" for="policyName"><cv:msg key="label.policyName" bundle="vmManagement" /></label>
					<div class="col-xs-12 col-lg-8">
						<input type="text" name="policyName" data-ng-model="policyCreate.model.policyName" id="policyName" data-ng-focus="serverMessage.message=''" autofocus />
					</div>
			</div>
			<div class="form-group" data-ng-show="false">
				<label class="col-xs-12 col-lg-4" for="policyDescription"><cv:msg key="label.policyDescription" bundle="vmManagement" /></label>
					<div class="col-xs-12 col-lg-8">
						<input type="text" name="policyDescription" data-ng-model="policyCreate.policyDetails.description" id="policyDescription" data-ng-focus="serverMessage.message=''" autofocus />
					</div>
			</div>
	</cv-tile-component>
	<cv-tile-component data-ac-id="label_hypervisorSelection-vmManagement">
			<h4 class="margin-left-15"><cv:msg key="label.hypervisorSelection" bundle="vmManagement" /></h4>
			<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="vendorTypes"><cv:msg key="label.vendorType" bundle="servers" /></label>
					<div class="col-xs-12 col-lg-8">
					<select id="vendorTypes"
						name="vendorTypes"
						data-ng-options="vendor.value as vendor.name for vendor in policyCreate.vendors | orderBy: 'name'"
						data-ng-model="policyCreate.model.vendor"
						data-ng-change="policyCreate.changeStepsByVendor(policyCreate.model.vendor)"
						data-ng-disabled="policyCreate.editMode && policyCreate.model.vendor">
						<option disabled value=""><cv:msg key="placeholder.vendorType" bundle="servers" /></option>
					</select>
				</div>
			</div>
			<div class="form-group">
					<label class="col-xs-12 col-lg-4" for="destinationServer"><cv:msg key="label.destinationServer" bundle="restore" /></label>
					<div class="col-xs-12 col-lg-8" data-ng-disabled="policyCreate.policyCategory === 'Autoscale' && policyCreate.editMode">
					<select id="destinationServer"
						 name="destinationServer"
						 data-ng-model="policyCreate.model.serverDetails"
						 data-ng-options="server as server.clientName for server in policyCreate.servers | orderBy: 'clientName'"
						 data-ng-change="policyCreate.destinationServerChanged(policyCreate.model.serverDetails, true)">
						<option disabled value="">{{(policyCreate.model.vendor && (!policyCreate.serverDetails) && (!policyCreate.servers.length)) ? '<cv:msg key="label.noDestinationServer" bundle="vmManagement" />' : '<cv:msg key="placeholder.selectHypervisor" bundle="vmManagement" />'}}</option>
					</select>
					</div>
			</div>
			<div class="form-group" data-ng-show="false">
					<label class="col-xs-12 col-lg-4" for="destinationProxy"><cv:msg key="label.proxy" bundle="restore" /></label>
					<div class="col-xs-12 col-lg-8">
	 				<select id="destinationProxy"
	 						name="destinationProxy"
	 						data-ng-model="policyCreate.model.proxy"
	 						data-ng-options="ds as ds.clientName for ds in policyCreate.proxyList track by (ds.clientName|lowercase)">
					</select>
				</div>
			</div>
	</cv-tile-component>
</div>
