<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
	<cv:cvMessages bundle="localization.security"></cv:cvMessages>
	<cv:cvMessages bundle="localization.restore"></cv:cvMessages>
	<cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div>
	<div class="setup-title">
		<h1><cv:msg key="label.addRegion" bundle="vmManagement"/></h1>
	</div>

	<div class="bootstrap-wrapper form-horizontal" >
		<form id="regionDetailsForm" name="regionDetailsForm" novalidate>
			<div class="panel-body">
				<div class="form-group" data-ng-if="!reDetailCtrl.isAzureRM">
					<label class="col-xs-12 col-md-5 col-lg-5" for="availabilityZone">
						<cv:msg key="label.availabilityZone" bundle="restore"></cv:msg>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<div class="input-group">
							<input type="text"
								readonly name="availabilityZone" id="availabilityZone"
								value="{{reDetailCtrl.model.availabilityZone}}"/>
							<span class="input-group-btn">
								<button id="RegionOptions_button_#1936" type="button" data-ng-click="reDetailCtrl.openAvailabilityZoneDialog()"
									class="btn btn-default browse-btn">
									<cv:msg key="label.browse" bundle="restore"></cv:msg>
								</button>
							</span>
						</div>
						<div class="help-block" data-ng-if="reDetailCtrl.selectContentErr.selectedZone.message">
							<i class="ion-alert-circled"></i> {{reDetailCtrl.selectContentErr.selectedZone.message}}
						</div>
					</div>
				</div>

				<div class="form-group" data-ng-if="reDetailCtrl.isAzureRM">
					<label class="col-xs-12 col-md-5 col-lg-5" for="region">
						<cv:msg key="label.region" bundle="restore"/>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<isteven-multi-select
							input-model="reDetailCtrl.model.azureRegionList"
		   				  	output-model="reDetailCtrl.model.azureRegion"
		  				  	button-label="displayName"
						  	item-label="displayName"
						  	selection-mode="single"
			   				tick-property="selected"
			   				class="isteven-multi-select user-group-select"
			   				id="region"
			   				name="region"
			   				max-labels="1"
			   				helper-elements="filster"
			   				search-property="displayName"
			   				on-item-click="reDetailCtrl.setRegion(data)">
						</isteven-multi-select>
						<div class="help-block" data-ng-if="reDetailCtrl.selectContentErr.selectedRegion.message">
							<i class="ion-alert-circled"></i> {{reDetailCtrl.selectContentErr.selectedRegion.message}}
						</div>
					</div>
				</div>

				<div class="form-group" data-ng-if="reDetailCtrl.isAzureRM" data-ng-disabled="!reDetailCtrl.model.regionName">
					<label class="col-xs-12 col-md-5 col-lg-5" for="storageAccount">
						<cv:msg key="label.storageAccount" bundle="restore"/>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<isteven-multi-select
							input-model="reDetailCtrl.model.storageAccounts"
		   				  	output-model="reDetailCtrl.model.storageAccount"
		  				  	button-label="dataStoreName"
						  	item-label="dataStoreName"
						  	selection-mode="single"
			   				tick-property="selected"
			   				class="isteven-multi-select user-group-select"
			   				id="storageAccount"
			   				name="storageAccount"
			   				max-labels="1"
			   				helper-elements="filster"
			   				search-property="dataStoreName"
			   				>
						</isteven-multi-select>
						<div class="help-block" data-ng-if="reDetailCtrl.selectContentErr.selectedStorageAccount.message">
							<i class="ion-alert-circled"></i> {{reDetailCtrl.selectContentErr.selectedStorageAccount.message}}
						</div>
					</div>
				</div>

				<div class="form-group" data-ng-disabled="!reDetailCtrl.isAzureRM ? !reDetailCtrl.model.availabilityZone : false">
					<label class="col-xs-12 col-md-5 col-lg-5" for="networkId">
						<span data-ng-if="!reDetailCtrl.isAzureRM">
							<cv:msg key="label.VPC" bundle="vmManagement"/>
						</span>
						<span data-ng-if="reDetailCtrl.isAzureRM">
							<cv:msg key="label.virtualNetwork" bundle="restore"/>
						</span>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<isteven-multi-select
							input-model="reDetailCtrl.model.networkIds"
		   				  	output-model="reDetailCtrl.model.networkId"
		  				  	button-label="networkName"
						  	item-label="networkName"
						  	selection-mode="single"
			   				tick-property="selected"
			   				class="isteven-multi-select user-group-select"
			   				id="networkId"
			   				name="networkId"
			   				max-labels="1"
			   				helper-elements="filter"
			   				search-property="networkName"
			   				on-item-click="reDetailCtrl.setNetworkId(data)">
						</isteven-multi-select>
						<div class="help-block" data-ng-if="reDetailCtrl.selectContentErr.selectedVPC.message">
							<i class="ion-alert-circled"></i> {{reDetailCtrl.selectContentErr.selectedVPC.message}}
						</div>
					</div>
				</div>

				<div class="form-group" data-ng-disabled="!reDetailCtrl.model.networkId.length > 0">
					<label class="col-xs-12 col-md-5 col-lg-5" for="subnetId">
						<cv:msg key="label.subnet" bundle="restore"/>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<isteven-multi-select
							input-model="reDetailCtrl.model.subnets"
		   				  	output-model="reDetailCtrl.model.subnet"
		  				  	button-label="label"
						  	item-label="label"
						  	selection-mode="single"
			   				tick-property="selected"
			   				class="isteven-multi-select user-group-select"
			   				id="subnetId"
			   				name="subnetId"
			   				max-labels="1"
			   				helper-elements="filter"
			   				search-property="label">
						</isteven-multi-select>
						<div class="help-block" data-ng-if="reDetailCtrl.selectContentErr.subnet.message">
							<i class="ion-alert-circled"></i> {{reDetailCtrl.selectContentErr.subnet.message}}
						</div>
					</div>
				</div>
				<div class="form-group" data-ng-disabled="!reDetailCtrl.isAzureRM ? !reDetailCtrl.model.networkId.length > 0 : false">
					<label class="col-xs-12 col-md-5 col-lg-5" for="securityGroup">
						<span data-ng-if="reDetailCtrl.isAzureRM">
							<cv:msg key="label.networkSecurityGroup" bundle="vmManagement"/>
						</span>
						<span data-ng-if="!reDetailCtrl.isAzureRM">
							<cv:msg key="label.securityGroupsLabel" bundle="restore"/>
						</span>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
					<span data-ng-show="reDetailCtrl.isAzureRM">
							<isteven-multi-select
								input-model="reDetailCtrl.model.securityGroups"
			   				  	output-model="reDetailCtrl.model.securityGroup"
			  				  	button-label="groupName"
							  	item-label="groupName"
							  	selection-mode="single"
				   				tick-property="selected"
				   				class="isteven-multi-select user-group-select"
				   				id="securityGroup"
				   				name="securityGroup"
				   				max-labels="1"
				   				group-property="msGroup"
				   				helper-elements="filter"
				   				search-property="groupName">
							</isteven-multi-select>
						</span>
						<span data-ng-show="!reDetailCtrl.isAzureRM">
							<isteven-multi-select
								input-model="reDetailCtrl.model.securityGroups"
			   				  	output-model="reDetailCtrl.model.securityGroup"
			  				  	button-label="groupName"
							  	item-label="groupName"
							  	selection-mode="multiple"
				   				tick-property="selected"
				   				class="isteven-multi-select user-group-select"
				   				id="securityGroup"
				   				name="securityGroup"
				   				max-labels="1"
				   				group-property="msGroup"
				   				helper-elements="filter"
				   				search-property="groupName">
							</isteven-multi-select>
						</span>
						<div class="help-block" data-ng-if="reDetailCtrl.selectContentErr.selectedSecurityGroup.message">
							<i class="ion-alert-circled"></i> {{reDetailCtrl.selectContentErr.selectedSecurityGroup.message}}
						</div>
					</div>
				</div>
				<div class="form-group" data-ng-if="reDetailCtrl.isAmazon && reDetailCtrl.showKeyPairOptionInAWSAutoScaleSettings" data-ng-disabled="!reDetailCtrl.model.availabilityZone">
					<label class="col-xs-12 col-md-5 col-lg-5" for="keyPair">
						<span>
							<cv:msg key="label.keyPair" bundle="vmManagement"/>
						</span>
					</label>
					<div class="col-xs-12 col-md-7 col-lg-7">
						<isteven-multi-select
							    input-model="reDetailCtrl.model.keyPairs"
								output-model="reDetailCtrl.model.keyPair"
							    button-label="keyName"
							    item-label="keyName"
							    selection-mode="single"
							    tick-property="selected"
							    class="isteven-multi-select user-group-select"
							    id="keyPair"
							    name="keyPair"
							    max-labels="1"
								helper-elements="filter"
								group-property="msGroup"
							    search-property="keyName">
						</isteven-multi-select>
					</div>
				</div>


			</div>

			<div class="button-container">
				<fmt:bundle basename="localization.messages">
					<button id="RegionOptions_button_#7836" type="button" class="btn btn-default setup-btn--hidden cvBusyOnAjax"
						data-ng-click="reDetailCtrl.cancel()">
						<cv:msg key="action.cancel" bundle="users"/>
					</button>
			 		<button id="RegionOptions_button_#3689" class="btn btn-primary" ng-click="reDetailCtrl.save()">
			 			<cv:msg key="action.save" bundle="users" />
			 		</button>
				</fmt:bundle>
			</div>
		</form>
	</div>
</div>
