<%@ taglib prefix="fmt" uri="http://java.sun.com/jsp/jstl/fmt"%>
<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
	<cv:cvMessages bundle="localization.restoreJs"></cv:cvMessages>
	<cv:cvMessages bundle="localization.profiles"></cv:cvMessages>
	<cv:cvMessages bundle="localization.vmManagement"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1>
		<cv:msg key="label.scalingOptions" bundle="vmManagement" />
	</h1>
</div>
<form id="autoScaleParamsForm" name="autoScaleParamsForm" autocomplete="off" class="form-horizontal edit-users-grid-form bootstrap-wrapper modal-margin">	
		<div class="form-group">
			<label class="col-xs-12 col-md-5 col-lg-5" for="autoScaleUpToggle">
				<cv:msg key="label.autoScaleUp" bundle="vmManagement"/>
			</label>
			<div class="col-xs-12 col-md-7 col-lg-7">
				<toggle-control class="{{asModalCtrl.model.autoScaleUp}} toggle-control" status="asModalCtrl.model.autoScaleUp" data-ng-click="asModalCtrl.manageAutoScaleUpOrDownActivity()" title="Enable/disable <cv:msg key="label.autoScaleUp" bundle="collectionsJs"/>">
				</toggle-control>
			</div>		
		</div>	
		
		<div class="form-group">
			<label class="col-xs-12 col-md-5 col-lg-5" for="autoScaleOutToggle">
				<cv:msg key="label.autoScaleOut" bundle="vmManagement"/>
			</label>
			<div class="col-xs-12 col-md-7 col-lg-7"> 
				<toggle-control class="{{asModalCtrl.model.autoScaleOut}} toggle-control" status="asModalCtrl.model.autoScaleOut" data-ng-click="asModalCtrl.manageAutoScaleOutActivity()" title="Enable/disable <cv:msg key="label.autoScaleOut" bundle="collectionsJs"/>">
				</toggle-control>
			</div>	
		</div>	
		
		<div class="form-group">
			<label class="col-xs-12 col-md-5 col-lg-5" for="autoDeployment">
				<cv:msg key="label.autoDeployment" bundle="vmManagement"/>
			</label>
			<div class="col-xs-12 col-md-7 col-lg-7">
				<toggle-control class="{{asModalCtrl.model.autoDeployment}} toggle-control" status="asModalCtrl.model.autoDeployment" data-ng-click="asModalCtrl.manageAutoDeploymentActivity()" title="Enable/disable <cv:msg key="label.autoDeployment" bundle="collectionsJs"/>">
				</toggle-control>
			</div>		
		</div>
		
		
	<div class="form-group">
	 <uib-accordion close-others="true" class="text-left">
		<div data-ng-if="asModalCtrl.model.autoScaleUp === 'enabled-activity' || asModalCtrl.model.autoScaleOut === 'enabled-activity'"uib-accordion-group is-open="asModalCtrl.generalOptionsAccordion" class="accordion">
			<uib-accordion-heading> 
			<i class="glyphicon" data-ng-class="{'glyphicon-chevron-down': asModalCtrl.generalOptionsAccordion, 'glyphicon-chevron-right': !asModal.generalOptionsAccordion}"></i>
			<cv:msg key="label.memorycpucriteria" bundle="profiles" /> 
			</uib-accordion-heading>
			
			<div class="form-group">
				<label class="col-xs-12 col-md-5 col-lg-5" for="minMemoryThreshold"> <cv:msg key="label.minMemory" bundle="vmManagement" /></label>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input class="wizard-page-skip-btn--hidden" type="number" class="temporary-enabled" id="minMemoryThreshold" min="1" max="50" data-ng-model="asModalCtrl.model.minMemoryThreshold"> 
					<span style="display: inline;">{{asModalCtrl.modal.percentage}}</span>
				</div>
			</div>
			<div class="form-group">
				<label class="col-xs-12 col-md-5 col-lg-5" for="minCpuThreshold"> <cv:msg key="label.minCpu" bundle="vmManagement" /></label>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input class="wizard-page-skip-btn--hidden" type="number" class="temporary-enabled" id="minCpuThreshold" min="1" max="50" data-ng-model="asModalCtrl.model.minCpuThreshold" /> 
					<span style="display: inline;">{{asModalCtrl.modal.percentage}}</span>
				</div>
			</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-5 col-lg-5" for="maxMemoryThreshold"> <cv:msg key="label.maxMemory" bundle="vmManagement" /></label>
			<div class="col-xs-12 col-md-7 col-lg-7">
				<input class="wizard-page-skip-btn--hidden" type="number" class="temporary-enabled" id="maxMemoryThreshold" min="51" max="100" data-ng-model="asModalCtrl.model.maxMemoryThreshold" /> 
				<span style="display: inline;">{{asModalCtrl.modal.percentage}}</span>
			</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-5 col-lg-5" for="maxCpuThreshold"> <cv:msg key="label.maxCpu" bundle="vmManagement" /></label>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input class="wizard-page-skip-btn--hidden" type="number" class="temporary-enabled" id="maxCpuThreshold" min="51" max="100" data-ng-model="asModalCtrl.model.maxCpuThreshold" /> 
					<span style="display: inline;">{{asModalCtrl.modal.percentage}}</span>
				</div>
		</div>
		<div class="form-group">
			<label class="col-xs-12 col-md-5 col-lg-5" for="hour"> <cv:msg key="label.duration" bundle="vmManagement" /></label>
				<div class="col-xs-12 col-md-7 col-lg-7">
					<input class="wizard-page-skip-btn--hidden" type="number" class="temporary-enabled" id="hour" min="1" max="100" data-ng-model="asModalCtrl.model.durationHour" /> 
					<span style="display: inline;">{{asModalCtrl.modal.hour}}</span>
				</div>
		</div>
	</div>
	
	 <div data-ng-if="asModalCtrl.model.autoScaleUp === 'enabled-activity'">
      <cv-autoscale-upordown-options policy-details = "asModalCtrl.policyDetails.details"></cv-autoscale-upordown-options>
    </div>
	
 	<div data-ng-if="asModalCtrl.model.autoScaleOut === 'enabled-activity'">
		<cv-autoscale-out-options policy-details = "asModalCtrl.policyDetails.details"></cv-autoscale-out-options>
	</div>  
	</uib-accordion>
	</div>
	<div class="button-container">
		<fmt:bundle basename="localization.messages">
			<button id="AutoScaleOptions_button_#0759" type="button" 
				class="btn btn-default setup-btn--hidden cvBusyOnAjax"
				data-ng-click="asModalCtrl.cancel()">
				<cv:msg key="Cancel" />
			</button>
			 <button id="AutoScaleOptions_button_#4911" class="btn btn-primary" 
	          ng-click="asModalCtrl.ok()"><cv:msg key="action.save" bundle="users" /></button>
		</fmt:bundle>
	</div>
</form>