import 'modules/vmManagement/js/factory/virtualMachine.factory.js';
import { vmManagementAppModule } from 'common/js/modules';

export const recoveryTargetActionsFactory = vmManagementAppModule.factory('recoveryTargetActionsFactory', [
	'$state',
	'$dialogs',
	'cvLoc',
	'cvToaster',
	'restoreService',
	'VirtualMachineConstants',
	function($state, $dialogs, cvLoc, cvToaster, restoreService, VirtualMachineConstants) {
		var factory = {};

		factory.computePermittedActions = function(policy) {
			let permittedActionsForClient = [
				{
					show: isLiveMountEnabledTarget(policy.entity.policyType),
					value: 'ACTIVE_MOUNTS',
					label: cvLoc('action.viewActiveMounts'),
					onClick: viewActiveMounts.bind(this)
				},
				{
					show: true,
					value: 'DELETE',
					label: cvLoc('Delete'),
					onClick: deletePolicy.bind(this)
				}
			];
			return permittedActionsForClient;
		};

		function deletePolicy(value, entity, entityType, actionObject, entityId, entityName) {
			$dialogs.confirm(
				cvLoc('label.confirmDelete'),
				cvLoc('label.confirmDeleteReplicationTarget', `<b>${entityName}</b>`),
				{
					yesFunction: function() {
						restoreService
							.deleteReplicationTarget(entityId)
							.success(function(data) {
								cvToaster.showSuccessMessage({
									ttl: '10000', //10 sec
									message: cvLoc('msg.targetDeletedSuccessfully')
								});
								let pageName = $state.current.name;
								switch (pageName) {
									case 'lifeCyclePolicy':
										$state.reload();
										break;
									case 'lifeCyclePolicyDetails':
										$state.go('lifeCyclePolicy');
										break;
									default:
										break;
								}
							})
							.error(function(e) {
								cvToaster.showErrorMessage({
									ttl: '10000', //10 sec
									message: e ? e : cvLoc('generic_error')
								});
							});
					},
					noFunction: function() {
						// do nothing
					}
				}
			);
		}

		function viewActiveMounts(value, entity, entityType, actionObject, entityId, entityName) {
			$state.go('virtualMachines', { policyId: entityId, isLiveMount: true, vmGUID: '' });
		}

		function isLiveMountEnabledTarget(policyType, isLiveMountEnabled) {
			return (
				policyType &&
				(policyType == VirtualMachineConstants.VMAllocationPolicyType.VMW_LIVEMOUNT ||
					policyType == VirtualMachineConstants.VMAllocationPolicyType.VMW_BACKUP_LABTEMPLATE ||
					policyType == VirtualMachineConstants.VMAllocationPolicyType.VMW_LABTEMPLATE ||
					policyType == VirtualMachineConstants.VMAllocationPolicyType.MICROSOFT ||
					(isLiveMountEnabled && policyType == VirtualMachineConstants.VMAllocationPolicyType.RHEV))
			);
		}

		return factory;
	}
]);

export default recoveryTargetActionsFactory;
