import 'modules/vmManagement/js/controllers/lifeCyclePolicy/RegionDetails.ctrl.js';
import KendoGrid from 'common/js/newGrid/kendoGrid';
import ContextMenu from 'common/js/kendocontextmenu';
import 'common/js/newGrid/cv-kendo-grid.js';
import 'modules/vmManagement/js/factory/vmLifeCyclePolicy/lifeCyclePolicy.factory.js';

//import * as GridConstants from "../../common/js/newGrid/grid.constants";

import { vsaAppServerModule } from 'common/js/modules';

var serverMod = vsaAppServerModule;

serverMod.directive('cvRegions', function() {
	return {
		restrict: 'E', //E = element
		templateUrl: appUtil.appRoot + 'modules/vmManagement/partials/lifeCyclePolicy/AutoScaleRegions.jsp',
		scope: {},
		bindToController: {
			serverId: '=',
			policyDetails: '='
		},
		controllerAs: 'asRegions',
		controller: 'autoScaleOutRegions'
	};
});

var controllers = {};

controllers.autoScaleOutRegions = [
	'cvLoc',
	'cvUtil',
	'$log',
	'cvToaster',
	'AppTypes',
	'$uibModal',
	'cvTableOptions',
	'$scope',
	'cvBreadcrumbsTabsFactory',
	'vmLifeCyclePolicyFactory',
	function(
		cvLoc,
		cvUtil,
		$log,
		cvToaster,
		AppTypes,
		$modal,
		cvTableOptions,
		$scope,
		cvBreadcrumbsTabsFactory,
		vmLifeCyclePolicyFactory
	) {
		var self = this;
		this.$onInit = function() {
			/* Function to convert security groups names into csv */
			const convertSGNamestoCSV = securityGroups =>
				securityGroups ? securityGroups.map(sg => sg.name).join(', ') : '';
			self.isAzureRM = vmLifeCyclePolicyFactory.isAzureRM(
				vmLifeCyclePolicyFactory.getVendorByPolicyType(_.get(self.policyDetails, 'entity.policyType'))
			);

			self.isAmazon = vmLifeCyclePolicyFactory.isAmazon(
				vmLifeCyclePolicyFactory.getVendorByPolicyType(_.get(self.policyDetails, 'entity.policyType'))
			);
			//Open the modal to add the region details and updates the grid data with the selected values
			self.showRegionOptions = function(rowData) {
				var modalInstance = $modal.open({
					templateUrl: appUtil.appRoot + 'modules/vmManagement/partials/lifeCyclePolicy/RegionOptions.jsp',
					controller: 'regionDetailOptions as reDetailCtrl',
					resolve: {
						browseParams: function() {
							return {
								serverID: self.serverId,
								policyDetails: self.policyDetails,
								rowData: rowData
							};
						}
					}
				});
				modalInstance.result.then(
					function(result) {
						result.securityGroupName = convertSGNamestoCSV(result.securityGroups);

						if (result.editMode) {
							$scope.data[result.index] = result;
						} else {
							$scope.data.push(result);
						}
						$scope.grid.refreshData();
						$scope.asRegions.policyDetails.scaleOption.scaleOutParam.regionSpecificInfo = $scope.data || [];
					},
					function() {
						$log.debug('Cancel clicked');
					}
				);
			};

			//Deletes the selected row
			self.deleteRow = function(rowData) {
				for (var i = 0; i < $scope.data.length; i++) {
					if (
						$scope.data[i].regionName === rowData.regionName &&
						$scope.data[i].securityGroupName === rowData.securityGroupName &&
						$scope.data[i].subnetId === rowData.subnetId
					) {
						$scope.data.splice(i, 1);
						break;
					}
				}
				$scope.grid.refreshData();
			};

			self.defaultSGClick = function() {
				self.policyDetails.scaleOption.scaleOutParam.defaultSecurityGroup = !self.policyDetails.scaleOption
					.scaleOutParam.defaultSecurityGroup;
			};
			//Initializes the grid options and grid construction
			function initializeGridOption() {
				$scope.data = self.policyDetails.scaleOption.scaleOutParam.regionSpecificInfo || [];
				self.policyDetails.scaleOption.scaleOutParam.defaultSecurityGroup = !self.isAzureRM && $scope.data.length === 0;
				$scope.data.forEach(d => {
					d.securityGroupName = convertSGNamestoCSV(d.securityGroups);
					if (!d.subnetName) {
						d.subnetName = d.subnetId;
					}
				});

				$scope.gridOptions = {
					hideGridContextMenu: true,
					height: 300,
					searchable: false,
					enablePaging: true,
					enableSorting: false, //sorting will cause record ordering
					url: function(options) {
						options.success($scope.data);
					},
					afterGridInitialize: function(grid) {
						$scope.grid = grid.grid;
					},
					gridToolbarMenu: [
						{
							id: 'addTuple',
							label: cvLoc('label.add'),
							onSelect: event => {
								self.showRegionOptions();
							}
						}
					],
					columns: {
						availabilityZone: {
							title: !self.isAzureRM ? cvLoc('label.availabilityZone') : cvLoc('label.regionName'),
							width: '10%',
							type: 'string',
							template: !self.isAzureRM
								? `<span class="crop" title="#:availabilityZone#">#:availabilityZone || ""#</span>`
								: `<span class="crop" title="#:regionName#">#:regionName || ""#</span>`,
							sortable: false
						},
						securityGroupName: {
							title: !self.isAzureRM ? cvLoc('label.securityGroup') : cvLoc('label.virtualNetwork'),
							width: '10%',
							type: 'string',
							template: !self.isAzureRM
								? `<span class="crop" title="#:securityGroupName#">#:securityGroupName || ""#</span>`
								: `<span class="crop" title="#:networkName#">#:networkName || ""#</span>`
						},
						subnetId: {
							title: cvLoc('label.subnetID'),
							width: '10%',
							type: 'string',
							template: !self.isAzureRM
								? `<span class="crop" title="#:subnetId#">#:subnetId || ""#</span>`
								: `<span class="crop" title="#:subnetId#">#:subnetName || ""#</span>`
						},
						keyPairName: {
							title: cvLoc('label.keyPair'),
							hidden: !self.isAmazon || !cvConfig.showKeyPairOptionInAWSAutoScaleSettings,
							width: '10%',
							type: 'string',
							template: `<span class="crop" title="#:keyPairName#">#:keyPairName || "None Selected"#</span>`
						}
					},
					actionMenu: [
						{
							id: 'EDIT',
							label: cvLoc('label.edit'),
							contextMenuOnly: false,
							onSelect: event => {
								self.rowData = _.get(event, 'selectedRowValues[0]', event.rowValue);
								self.rowData.editMode = true;
								self.rowData.index = event.selectedRows.index();
								self.showRegionOptions(self.rowData);
							}
						},
						{
							id: 'DELETE',
							label: cvLoc('action.delete'),
							contextMenuOnly: false,
							onSelect: event => {
								self.rowData = _.get(event, 'selectedRowValues[0]', event.rowValue);
								self.deleteRow(self.rowData);
							}
						}
					]
				};
			}

			initializeGridOption();
		};
	}
];

serverMod.controller(controllers);
export default serverMod;
