import 'vsa/js/directives/cv-vm-destinations-directive.js';
import 'users/js/services/users.svc.js';
import 'vsa/js/controllers/replication.ctrl.js';
import 'vsa/js/services/restoreSettings.factory.js';
import 'vsa/js/controllers/restoreOptions.ctrl.js';
import 'modules/servers/js/services/servers.svc.js';
import 'vsa/js/services/restore.svc.js';
import 'vsa/js/directives/cv-select-hypervisors-directive.js';
import 'vsa/js/directives/cv-select-proxy-directive.js';
import 'vsa/js/directives/cv-restore-options-vmware-directive.js';
import 'vsa/js/directives/cv-display-name-azure-directive.js';
import 'vsa/js/factories/collections.factory.js';
import 'vsa/js/factories/vmActions.factory.js';
import 'vsa/js/factories/replicationTargetActions.factory.js';
import 'modules/vmManagement/js/factory/virtualMachine.factory.js';
import 'modules/vmManagement/js/services/vmLifeCyclePolicy/lifeCylePolicy.svc.js';
import 'modules/vmManagement/js/constants/vmLifeCyclePolicy.constants.js';

import { vsaAppServerModule } from 'common/js/modules';

var serverMod = vsaAppServerModule;

var controllers = {};

controllers.replicationControllerVMW = [
	'$scope',
	'$stateParams',
	'$log',
	'restoreService',
	'serverService',
	'cvLoc',
	'cvUtil',
	'cvBreadcrumbsTabsFactory',
	'$uibModal',
	'$filter',
	'$dialogs',
	'collectionFactory',
	'restoreOptionFactory',
	'restoreSettingsFactory',
	'replicationFactory',
	'cvTreeFactory',
	'destinationHostData',
	'userService',
	'vmFactory',
	'replTargetFactory',
	'vmLifeCyclePolicyFactory',
	'clientGroupService',
	'VirtualMachineConstants',
	'vmLifeCylePolicyService',
	'VM_POLICY_APP_TYPE',
	function(
		$scope,
		$stateParams,
		$log,
		restoreService,
		serverService,
		cvLoc,
		cvUtil,
		cvBreadcrumbsTabsFactory,
		$modal,
		$filter,
		$dialogs,
		collectionFactory,
		restoreOptionFactory,
		restoreSettingsFactory,
		replicationFactory,
		cvTreeFactory,
		destinationHostData,
		userService,
		vmFactory,
		replTargetFactory,
		vmLifeCyclePolicyFactory,
		clientGroupService,
		VirtualMachineConstants,
		vmLifeCylePolicyService,
		VM_POLICY_APP_TYPE
	) {
		$scope.distributeWorkload = _.get(cvConfig, 'bEnableDistributeWorkload', true);
		$scope.generalOptionsAccordion = true;
		$scope.virtualizeOptions = true;
		$scope.virtualLabOptions = true;
		$scope.usersAndUserGroups = [];
		$scope.vendor = 'VMW';
		$scope.localLangExistingNetwork = cvUtil.getIStevenLocLabels();
		$scope.localLangExistingNetwork.nothingSelected = cvLoc('placeholder.selectNetworks');
		$scope.localLangGatewayNetwork = cvUtil.getIStevenLocLabels();
		$scope.localLangGatewayNetwork.nothingSelected = cvLoc('placeholder.selectNetworks');
		$scope.localLangAppType = cvUtil.getIStevenLocLabels();
		$scope.localLangAppType.nothingSelected = cvLoc('placeholder.selectAppType');
		// this is used to pass to calling directives to refresh data
		$scope.ctrl = {};

		$scope.hideDetails = cv.isTenantAdmin;
		$scope.generalOptionsAccordion = false;
		$scope.showTestFailoverForVMware = true;
		if ($stateParams.policyId) {
			$scope.policyId = $stateParams.policyId;
		}

		if (!$scope.editMode) {
			$scope.networkSelectorFlag = true;
			$scope.networkSelector = 'isolatedNetwork';
			$scope.model.noOfCPUs = 1;
			$scope.model.maxMemory = 8; //default to 8
		} else {
			$scope.configureVirtualizeMe = $scope.restoreData.configureVirtualizeMe;
			$scope.configureVirtualizeMe === true
				? ($scope.configureVirtualizeMeFlag = true)
				: ($scope.configureVirtualizeMeFlag = false);
			if ($scope.restoreData.vmPolicyAppType !== VM_POLICY_APP_TYPE.REPLICATION.type) {
				$scope.policyAppType = VM_POLICY_APP_TYPE.REGULAR.id;
				//$scope.applicationTypes[1].selected = true;
				$scope.isRegularPolicy = true;
				$scope.model.noOfCPUs = $scope.restoreData.noOfCPUs;
				$scope.model.maxMemory = $scope.restoreData.maxMemory;
				if ($scope.restoreData.maxMemory) {
					$scope.model.maxMemory = $scope.restoreData.maxMemory;
				} else {
					$scope.model.maxMemory = 8; //default to 8
					$scope.restoreData.maxMemory = $scope.model.maxMemory;
					if ($scope.editMode) {
						$scope.model.maxmemoryToggle = 'enabled-activity';
						$scope.maxMemoryFlag = true;
						$scope.restoreData.maxMemoryToggle = true;
					}
				}
			} else {
				$scope.isRegularPolicy = false;
				$scope.policyAppType = VM_POLICY_APP_TYPE.REPLICATION.id;
				//$scope.applicationTypes[0].selected = true;
			}
			$scope.showGeneralTab = true;
			if ($scope.restoreData.createIsolatedNetwork) {
				$scope.networkSelector = 'isolatedNetwork';
				$scope.networkSelectorFlag = true;
			} else {
				$scope.networkSelector = 'existingNetwork';
				$scope.existingNetworkFlag = true;
			}
		}

		$scope.enableVirtualLabs = $scope.showTestFailoverForVMware || $scope.isRegularPolicy;
		$scope.gatewayOptions = true;

		$scope.$on('vmPolicyAppTypeChanged', function(event, vmPolicyAppType) {
			$scope.vmPolicyAppType = vmPolicyAppType;
			$scope.setApplicationType();
		});

		$scope.noOfCPUsChanged = function() {
			if (!$scope.model.noOfCPUs) {
				$scope.invalidNoOfCPUs = cvUtil.errMsg(cvLoc('error.invalidNoOfCPUs'));
				return;
			}
			if ($scope.invalidNoOfCPUs && $scope.invalidNoOfCPUs.message) {
				$scope.invalidNoOfCPUs = {};
			}
			//$scope.noOfCPUs = $scope.model.noOfCPUs;
		};

		// auto select max memory toggle management
		$scope.manageMaxMemoryActivity = function() {
			$scope.model.maxmemoryToggle = vmLifeCyclePolicyFactory.checkToggleStatus($scope.model.maxmemoryToggle);
			$scope.model.maxmemoryToggle === 'enabled-activity'
				? ($scope.maxMemoryFlag = true)
				: ($scope.maxMemoryFlag = false);
			$scope.model.maxMemoryToggle = $scope.maxMemoryFlag;
		};

		$scope.maxMemoryChanged = function() {
			if (!$scope.model.maxMemory) {
				$scope.invalidMaxMemory = cvUtil.errMsg(cvLoc('error.invalidMaxMemory'));
				return;
			}
			if ($scope.invalidMaxMemory && $scope.invalidMaxMemory.message) {
				$scope.invalidMaxMemory = {};
			}
			//$scope.maxMemory = $scope.model.maxMemory;
		};

		$scope.ctrl.setExistingNetwork = function() {
			for (
				var i = 0;
				i <= $scope.restoreData.vmOptions.settings.networkSettingsDestinationNetworkData.length - 1;
				i++
			) {
				if ($scope.restoreData.vmOptions.settings.networkSettingsDestinationNetworkData[i] !== 'Not Connected') {
					$scope.existingNetworkSettingsList.push({
						displayName: $scope.restoreData.vmOptions.settings.networkSettingsDestinationNetworkData[i].networkName
					});
					$scope.gatewayNetworkSettingsList.push({
						displayName: $scope.restoreData.vmOptions.settings.networkSettingsDestinationNetworkData[i].networkName
					});
				}
			}
			if ($scope.editMode) {
				if (!$scope.restoreData.createIsolatedNetwork && $scope.restoreData.existingNetwork) {
					for (var i = 0; i <= $scope.existingNetworkSettingsList.length - 1; i++) {
						if (
							$scope.existingNetworkSettingsList[i].displayName === $scope.restoreData.existingNetwork[0].displayName
						) {
							$scope.existingNetworkSettingsList[i].selected = true;
						}
					}
				} else if ($scope.restoreData.createIsolatedNetwork && $scope.restoreData.gatewayTemplate) {
					for (var i = 0; i <= $scope.gatewayNetworkSettingsList.length - 1; i++) {
						if ($scope.gatewayNetworkSettingsList[i].displayName === $scope.restoreData.primaryGatewayNetwork) {
							$scope.gatewayNetworkSettingsList[i].selected = true;
						}
					}
				}
			}
		};

		// if a restoreData object is already present merge it
		$scope.restoreData = angular.merge(
			{},
			{
				globalOptions: {
					overwrite: false,
					powerOn: false,
					selectedProxy: [],
					showVirtualizeMe: false
				},
				getCurrentHostDisplayName: function() {
					if (!this.vmOptions || !this.vmOptions.destinationHost) {
						return null;
					}
					return this.vmOptions.destinationHost
						.map(function(obj) {
							return obj.displayName;
						})
						.join(', ');
				},
				getCurrentDestinationFolderDisplayName: function() {
					if (!this.vmOptions || !this.vmOptions.destinationFolder) {
						return cvLoc('placeholder.selectDestinationFolder');
					}
					return this.vmOptions.destinationHost.displayName;
				}
			},
			$scope.restoreData
		);

		// initalize
		$scope.restoreData = angular.merge(
			{},
			{
				vmOptions: {
					displayName: null,
					destinationHost: null,
					dataStore: {},
					dataStoreList: null,
					resourcePool: {},
					resourcePoolList: null,
					networkAndIpAddressSettings: {
						networkSettings: [],
						ipAddressSettings: []
					},
					settings: {
						networkSettings: {
							sourceNetwork: '',
							destinationNetwork: ''
						},
						ipAddressSettings: {
							sourceIpAddress: '',
							sourceSubnetMask: '',
							sourceDefaultGateway: '',
							destinationUseDHCP: false,
							destinationIpAddress: '',
							destinationSubnetMask: '',
							destinationDefaultGateway: '',
							destinationPreferredDnsServer: '',
							destinationAlternateDnsServer: '',
							destinationPreferredWinsServer: '',
							destinationAlternateWinsServer: ''
						}
					},
					vsMetaData: {
						vcloudOrgName: false,
						vcloudOrgVdcName: false,
						vcloudVappName: false,
						vcloudOwner: false,
						vcloudNics: false
					}
				},
				vendorType: 'VMW',
				prefixSuffixSelector: 'suffix',
				displayNamePrefixSuffix: replTargetFactory.getDefaultVMSuffixPrefixName()
			},
			$scope.restoreData
		);
		$scope.setApplicationType = function() {
			if ($scope.vmPolicyAppType === VM_POLICY_APP_TYPE.REGULAR.type) {
				$scope.policyAppType = VM_POLICY_APP_TYPE.REGULAR.id;
				$scope.isRegularPolicy = true;
				$scope.liveMountPageHeader = 'pageHeader.liveMount';
			} else {
				$scope.policyAppType = VM_POLICY_APP_TYPE.REPLICATION.id;
				$scope.isRegularPolicy = false;
				$scope.liveMountPageHeader = 'pageHeader.testFailoverOptions';
			}
			$scope.showGeneralTab = true;
			$scope.restoreData.vmOptions.settings.networkSettings.destinationNetwork = [];
			if ($scope.ctrl.setSelectionMode) {
				$scope.ctrl.setSelectionMode($scope.vmPolicyAppType);
			}
			if ($scope.ctrl.showResourcePool) {
				$scope.ctrl.showResourcePool($scope.vmPolicyAppType);
			}
			if ($scope.ctrl.showVMWareFolder) {
				$scope.ctrl.showVMWareFolder($scope.vmPolicyAppType);
			}
		};

		$scope.setApplicationType();
		// modify esx host value and datastorelabel if datastore was already present
		if ($scope.editMode) {
			// populate datastorelabel in case of error situation while retrieving
			// datastore list
			$scope.restoreData.vmOptions.dataStore.dataStoreLabel = $scope.restoreData.vmOptions.dataStore.dataStoreName;
			// populate guid for cluster to retrieve datastore,resourcepool and
			// network list
			if (
				$scope.restoreData.vmOptions.destinationHost[0].entity &&
				$scope.restoreData.vmOptions.destinationHost[0].entity.type === 'CLUSTER'
			) {
				$scope.restoreData.vmOptions.destinationHost[0].guid =
					$scope.restoreData.vmOptions.destinationHost[0].entity.name;
				$scope.restoreData.vmOptions.destinationHost[0].type =
					$scope.restoreData.vmOptions.destinationHost[0].entity.type;
			}

			// This is to disable editing some features in edit mode
			$scope.restoreData.existedVm = true;
		}

		if ($scope.restoreData.createIsolatedNetwork) {
			$scope.restoreData.gatewayTemplate.name = $scope.restoreData.gatewayTemplate.vmName;
			$scope.restoreData.expirationTime = 'Days';
		}

		// clear previously selected data for destinationHost for
		// selectRestoreDestination modal when you initialize modal
		if (!$scope.editMode) {
			destinationHostData.selection.length = 0;
		}
		$scope.restoreData.vmNameEditString = $scope.restoreData.displayNamePrefixSuffix;

		// empty list for restore options directive
		$scope.vmList = [];
		$scope.vmList.push($scope.restoreData);

		replTargetFactory.collectUsersAndUserGroups($scope.restoreData.securityAssociations).then(data => {
			$scope.usersAndUserGroups = data;
		});

		/*
		 * Returns true if required items have been selected for the specified VM options object.
		 */
		$scope.isVmOptionValid = function(vmOpts) {
			// validate name, host, datastore and resourcepool, also validate
			// orgname, orgvdcname, appname and owner for vcloud vms
			var valid = vmOpts.displayName && vmOpts.destinationHost && vmOpts.dataStore;
			if ($scope.restoreData.globalOptions.vCloud) {
				return (
					valid &&
					vmOpts.vsMetaData.vcloudOrgName &&
					vmOpts.vsMetaData.vcloudOrgVdcName &&
					vmOpts.vsMetaData.vcloudVappName &&
					vmOpts.vsMetaData.vcloudOwner &&
					vmOpts.vsMetaData.vcloudNics
				);
			} else {
				return valid && vmOpts.resourcePool;
			}
		};

		$scope.isDestinationNetworkAvailable = function() {
			var destination = $scope.restoreData.vmOptions.settings.networkSettingsDestinationNetworkData;
			return destination && destination.length && destination[0] !== cvLoc('placeholder.selectNetwork');
		};

		$scope.selectedIsoPathWindows = [];
		$scope.selectedIsoPathUnix = [];
		$scope.existingNetworkSettingsList = [];
		$scope.gatewayNetworkSettingsList = [];

		$scope.isExistingNetworkListAvailable = function() {
			return !!$scope.existingNetworkSettingsList && $scope.existingNetworkSettingsList.length > 0;
		};

		$scope.isGatewayNetworkListAvailable = function() {
			return !!$scope.gatewayNetworkSettingsList && $scope.gatewayNetworkSettingsList.length > 0;
		};

		$scope.ctrl.loadVMwareTemplateDetails = function() {
			var destinationServer = self.serverDetails;
			var clientId = destinationServer.clientId;
			self.templateList = [];
			self.isTemplateLoading = true;
			vmLifeCylePolicyService
				.getGatewayTemplates(
					clientId,
					typeof destinationServer.instanceId != 'undefined' ? destinationServer.instanceId : 0
				)
				.then(
					function(data) {
						if (data.data && data.data.scList && data.data.scList.length) {
							data.data.scList.map(function(template) {
								var templateEntity = {
									vmName: template.name,
									vmGUID: template.guid,
									esxServer: template.esxServer
								};
								self.templateList.push(templateEntity);
							});
							filterTemplates();
						}
						self.isTemplateLoading = false;
					},
					function(e) {
						$log.error(e);
						self.gatewayTemplateList = [];
						self.templateList = [];
						self.gatewayTemplateListError = true;
						self.templateListError = true;
						self.isTemplateLoading = false;
					}
				);
		};

		$scope.openBrowseDataStoresModal = function(destinationHosts, osType) {
			// load the root level data (data stores based on destination hosts)
			if (!destinationHosts || !destinationHosts.length) {
				return;
			}

			var destinationServer = $scope.model.selectedHypervisor;
			var serverId = destinationServer.clientId;
			var vendor = 'VMW';

			var cvTreeModalParams = {
				dialogTitle: cvLoc('label.isoPath'),
				treeRoot: destinationHosts.map(function(host) {
					return {
						label: vmFactory.getDestinationHostName(host),
						type: 'esxServer',
						iconClass: 'vsaIconSERVER'
					};
				}),
				// multiSelect : true,
				selectedItems: osType === 'unix' ? $scope.selectedIsoPathUnix : $scope.selectedIsoPathWindows,
				selectableTypes: ['iso'],
				loadChildren: function(entity) {
					if (entity.type === 'esxServer') {
						var destinationHostname = entity.label;

						// Load data store list
						return serverService.getDataStores(serverId, destinationHostname, destinationServer, vendor);
					} else if (entity.type === 'datastore') {
						var dataStoreName = entity.label;
						var destinationHostname = entity.destinationHostname;

						return serverService.getIsoPaths(serverId, dataStoreName, destinationServer, vendor, destinationHostname);
					} else {
						// error.. type not supported
					}
				},
				processChildren: function(entity, data) {
					if (entity.type === 'esxServer') {
						if (data.data && data.data.length) {
							return data.data.map(function(ds) {
								return {
									label: ds.dataStoreName,
									destinationHostname: entity.label,
									type: 'datastore',
									iconClass: 'vsaIconDATASTORE'
								};
							});
						}
					} else if (entity.type === 'datastore') {
						if (
							data.data &&
							data.data.hostInfo &&
							data.data.hostInfo.length > 0 &&
							data.data.hostInfo[0].dataStore &&
							data.data.hostInfo[0].dataStore.length > 0 &&
							data.data.hostInfo[0].dataStore[0].filepath &&
							data.data.hostInfo[0].dataStore[0].filepath.length > 0
						) {
							return data.data.hostInfo[0].dataStore[0].filepath.map(function(filePath) {
								return {
									label: filePath,
									iconClass: 'vsaIconLocalDisk',
									isLeaf: true,
									type: 'iso'
								};
							});
						}
					}
				}
			};

			// Saving the value
			cvTreeFactory.openCvTreeWrapperModal(cvTreeModalParams).result.then(function(result) {
				if (!$scope.restoreData.vmOptions.isoInfo) {
					$scope.restoreData.vmOptions.isoInfo = {};
				}

				// ok clicked

				if (osType === 'unix') {
					// unix
					if (result.length) {
						$scope.restoreData.vmOptions.isoInfo.unix = {
							isoPath: result[0].label,
							osType: 0
						};
					} else {
						$scope.restoreData.vmOptions.isoInfo.unix = null;
					}
				} else if (osType === 'windows') {
					// windows
					if (result.length) {
						$scope.restoreData.vmOptions.isoInfo.windows = {
							isoPath: result[0].label,
							osType: 1
						};
					} else {
						$scope.restoreData.vmOptions.isoInfo.windows = null;
					}
				}
				$scope.vmList[0].advanceOptions.configureVirtualizeMe =
					!!$scope.restoreData.vmOptions.isoInfo.windows || !!$scope.restoreData.vmOptions.isoInfo.unix;

				$scope.manageVirtualizeMeActivity($scope.vmList[0].advanceOptions.configureVirtualizeMe);
			});
		};

		/*
		 * serverGroupDetails - get serverGroupList for the vm associations
		 */
		self.serverGroupDetails = function() {
			clientGroupService
				.getClientGroups()
				.success(function(data) {
					$scope.serverGroupList = cvUtil.sortAscending(data, 'name');
					var selectedServerGroup;
					if ($scope.serverGroupList && $scope.restoreData && $scope.restoreData.associatedClientGroup) {
						angular.forEach($scope.serverGroupList, function(serverGroup) {
							if (serverGroup.name === $scope.restoreData.associatedClientGroup.clientGroupName) {
								selectedServerGroup = serverGroup;
								if (!!$scope.restoreData.configureVirtualizeMe) {
									$scope.serverGroupActivity = 'enabled-activity';
									$scope.serverGroupActivityFlag = true;
								}
								selectedServerGroup.selected = true;
								$scope.model.serverGroup = [selectedServerGroup];
								return;
							}
						});
					}

					if (!selectedServerGroup || !selectedServerGroup.name) {
						var serverGroup = data[0];
						serverGroup.selected = true;
						$scope.model.serverGroup = [serverGroup];
					}
				})
				.error(function(data, status, headers, config) {
					$scope.serverMessage = cvUtil.errMsg(data);
					return false;
				});
		};

		self.serverGroupDetails();

		$scope.restoreData.gatewayTemplate = $scope.restoreData.gatewayTemplate ? $scope.restoreData.gatewayTemplate : {};
		$scope.openBrowseGatewayTemplatesModal = function() {
			var destinationServer = $scope.model.selectedHypervisor;
			var clientId = destinationServer.clientId;
			var SERVER = 'SERVER';
			var CLUSTER = 'CLUSTER';
			var destinationType = _.get($scope, 'restoreData.vmOptions.destinationHost[0].type', 'SERVER');

			let esxServersOrCluster = [
				{
					label: _.get($scope, 'restoreData.vmOptions.destinationHost[0].displayName', ''),
					type: destinationType,
					iconClass: 'vsaIcon' + destinationType,
					guid: _.get($scope, 'restoreData.vmOptions.destinationHost[0].guid', '')
				}
			];

			// Builds the params and opens the modal for the Gateway template
			var openModal = function() {
				var cvTreeModalParams = {
					dialogTitle: cvLoc('label.gatewayTemplate'),
					treeRoot: esxServersOrCluster,
					multiSelect: false,
					selectedItems: [$scope.restoreData.gatewayTemplate],
					selectableTypes: ['gatewayTemplate'],
					loadChildren: function(entity) {
						if (entity.type === SERVER || entity.type === CLUSTER) {
							// Load gateway Templates
							return vmLifeCylePolicyService.getGatewayTemplates(
								clientId,
								typeof destinationServer.instanceId != 'undefined' ? destinationServer.instanceId : 0,
								esxServersOrCluster[0].guid || esxServersOrCluster[0].label,
								entity.type === CLUSTER ? 6 : 1
							);
						} else {
							// error.. type not supported
						}
					},
					processChildren: function(entity, data) {
						let templates = _.get(data, 'data.scList', []);
						let cvVLabGatewayPrefix = 'cv_vlab_gateway';
						templates = templates.filter(template => template.name.toLowerCase().startsWith(cvVLabGatewayPrefix));
						if (templates.length > 0) {
							return templates.map(function(gateway) {
								return {
									label: gateway.name,
									type: 'gatewayTemplate',
									isLeaf: true,
									gateway: gateway
								};
							});
						}
					}
				};

				// Saving the value
				cvTreeFactory.openCvTreeWrapperModal(cvTreeModalParams).result.then(function(result) {
					// ok clicked
					if (result.length) {
						$scope.restoreData.gatewayTemplate = result[0];
						$scope.restoreData.gatewayTemplate.name = result[0].label;
						if (
							$scope.gatewaytemplateMissing &&
							$scope.gatewaytemplateMissing.message &&
							$scope.restoreData.gatewayTemplate.name
						) {
							$scope.gatewaytemplateMissing = {};
						}
					} else {
						$scope.restoreData.gatewayTemplate = null;
					}
				});
			};
			openModal();
		};

		$scope.getDestination = function(setting) {
			if (setting.destinationUseDHCP) {
				return 'Dynamic';
			} else {
				return setting.destinationIpAddress;
			}
		};

		$scope.virtualLabNetworkChanged = function(selectionType, networkSelector) {
			if (selectionType === 'createIsolatedNetwork' && networkSelector === 'isolatedNetwork') {
				$scope.existingNetworkFlag = false;
				$scope.networkSelectorFlag = true;
			}
			if (selectionType === 'configureExistingNetwork' && networkSelector === 'existingNetwork') {
				$scope.networkSelectorFlag = false;
				$scope.existingNetworkFlag = true;
			}
		};

		// virtualize me toggle management
		$scope.manageVirtualizeMeActivity = function(isoPathsSelected) {
			//$scope.configureVirtualizeMe = vmLifeCyclePolicyFactory.checkToggleStatus($scope.configureVirtualizeMe);
			//$scope.configureVirtualizeMe === "enabled-activity" ? $scope.configureVirtualizeMeFlag = true : $scope.configureVirtualizeMeFlag = false;
			if (!!isoPathsSelected) {
				$scope.configureVirtualizeMeFlag = true;
			} else {
				$scope.serverGroupActivity = 'disabled-activity';
				$scope.serverGroupActivityFlag = false;
				$scope.configureVirtualizeMeFlag = false;
			}
			$scope.ctrl.manageVirtualizeMe($scope.configureVirtualizeMeFlag);
		};

		$scope.manageServerGroupActivity = function() {
			$scope.serverGroupActivity = vmLifeCyclePolicyFactory.checkToggleStatus($scope.serverGroupActivity);
			$scope.serverGroupActivity === 'enabled-activity'
				? ($scope.serverGroupActivityFlag = true)
				: ($scope.serverGroupActivityFlag = false);
		};

		$scope.getTooltipForSettingsGrid = function() {
			if (
				!$scope.restoreData.vmOptions ||
				!$scope.restoreData.vmOptions.destinationHost ||
				!$scope.restoreData.vmOptions.destinationHost.entity
			) {
				return cvLoc('error.destinationHost');
			} else {
				return '';
			}
		};

		$scope.addReplicationTarget = function(replicationTarget) {
			restoreService
				.addReplicationTarget(replicationTarget)
				.success(function(data) {
					$scope.$emit('replicationTargetAdded', data.entity);
				})
				.error(function(e) {
					$scope.serverMessageTop = cvUtil.errMsg(e);
				});
		};

		$scope.updateReplicationTarget = function(updatedReplicationTarget) {
			restoreService
				.updateReplicationTarget(updatedReplicationTarget)
				.success(function(data) {
					$scope.$emit('replicationTargetUpdated', data.entity);
				})
				.error(function(e) {
					$scope.serverMessageTop = cvUtil.errMsg(e);
				});
		};

		$scope.expirationTimeClick = function(source) {
			if (source === 'Hours') {
				$('#expirationTimeInHours').focus();
				$scope.restoreData.migrateVMs = false;
			} else if (source === 'Days') {
				$('#expirationTimeInDays').focus();
			} else if (source.target && source.target.id === 'expirationTimeInHours') {
				$scope.restoreData.expirationTime = 'Hours';
				$scope.restoreData.migrateVMs = false;
			} else if (source.target && source.target.id === 'expirationTimeInDays') {
				$scope.restoreData.expirationTime = 'Days';
			}
		};

		$scope.setNetworkErrorMessage = function() {
			if (
				$scope.gatewayNetworkMissing &&
				$scope.gatewayNetworkMissing.message &&
				$scope.model.gatewayNetwork.length > 0
			) {
				$scope.gatewayNetworkMissing = {};
			}
		};

		$scope.setExistingNetworkErrorMsg = function() {
			if (
				$scope.existingNetworkMissing &&
				$scope.existingNetworkMissing.message &&
				$scope.model.existingNetwork.length > 0
			) {
				$scope.existingNetworkMissing = {};
			}
		};

		$scope.isRegularAppType = function() {
			return $scope.vmPolicyAppType === VM_POLICY_APP_TYPE.REGULAR.type;
		};

		$scope.validateMaxMemory = function() {
			$scope.noMaxMemoryError = true;
			if ($scope.invalidMaxMemory && $scope.invalidMaxMemory.message) {
				$scope.noMaxMemoryError = false;
			}
			return $scope.noMaxMemoryError;
		};

		$scope.validateCPUs = function() {
			$scope.noCPUError = true;
			if ($scope.invalidNoOfCPUs && $scope.invalidNoOfCPUs.message) {
				$scope.noCPUError = false;
			}
			return $scope.noCPUError;
		};

		$scope.saveData = function() {
			let isPageValid = true;
			$scope.serverMessageTop = cvUtil.emptyMsg();

			if (
				!$scope.ctrl.validateVmOptions() ||
				($scope.showTestFailoverForVMware || $scope.isRegularAppType() ? !$scope.ctrl.validateExpirationTime() : false)
			) {
				isPageValid = false;
			}

			if (
				!$scope.ctrl.validateDestinationNetwork(
					_.get($scope.restoreData, 'vmOptions.settings.networkSettings.destinationNetwork')
				)
			) {
				isPageValid = false;
			}

			if ($scope.isRegularAppType()) {
				if (!$scope.validateMaxMemory() || !$scope.validateCPUs() || !$scope.ctrl.validateNoOfVMs()) {
					isPageValid = false;
				}
			}

			if ($scope.enableVirtualLabs) {
				let isolateNetworkGatewaySettingsRequired =
					!!($scope.model.gatewayNetwork && $scope.model.gatewayNetwork.length > 0) ||
					(!!$scope.restoreData.gatewayTemplate && !!$scope.restoreData.gatewayTemplate.name);
				if ($scope.existingNetworkFlag && (!$scope.model.existingNetwork || !$scope.model.existingNetwork.length > 0)) {
					$scope.existingNetworkMissing = cvUtil.errMsg(cvLoc('error.selectNetwork'));
					isPageValid = false;
				} else if ($scope.networkSelectorFlag && isolateNetworkGatewaySettingsRequired) {
					if (!$scope.restoreData.gatewayTemplate || !$scope.restoreData.gatewayTemplate.name) {
						$scope.gatewaytemplateMissing = cvUtil.errMsg(cvLoc('error.selectGatewayTemplate'));
						isPageValid = false;
					}
					if (!$scope.model.gatewayNetwork || !$scope.model.gatewayNetwork.length > 0) {
						$scope.gatewayNetworkMissing = cvUtil.errMsg(cvLoc('error.selectGatewayNetwork'));
						isPageValid = false;
					}
				}
			}

			if (!_.get($scope, 'restoreData.globalOptions.selectedProxy[0].clientName')) {
				let errorMessage = {
					message: cvLoc('placeholder.proxy')
				};
				$scope.ctrl.displayProxyErrorMsg(errorMessage);
				isPageValid = false;
			}

			if (!isPageValid) {
				$scope.serverMessageTop = cvUtil.errMsgLoc('error.allExistedErr');
				return;
			}

			var data = {
				entity: {
					vmAllocPolicyName: $scope.restoreData.replicationTargetName
				},
				destinationHyperV: {
					clientId: $scope.model.selectedHypervisor.clientId,
					clientName: $scope.model.selectedHypervisor.clientName
				},
				enableEditVMName: true,
				vmNameEditString: $scope.restoreData.displayNamePrefixSuffix,
				vmNameEditType: $scope.restoreData.prefixSuffixSelector.toUpperCase(),
				esxServers: $scope.restoreData.vmOptions.destinationHost.map(function(obj) {
					return {
						esxServerName: vmFactory.getDestinationHostName(obj)
					};
				}),
				dataStores: [
					{
						dataStoreName: $scope.restoreData.vmOptions.dataStore.dataStoreName
					}
				],
				resourcePoolPath: $scope.restoreData.vmOptions.resourcePool.resourcePoolPath,
				folderPath: $scope.restoreData.vmOptions.folderPath
			};

			// Set proxyClientEntity only if proxy is not Distribute workload/Automatic
			if (!$scope.restoreData.globalOptions.selectedProxy[0].autoProxy) {
				data.proxyClientEntity = {
					clientId: $scope.restoreData.globalOptions.selectedProxy[0].clientId,
					clientName: $scope.restoreData.globalOptions.selectedProxy[0].clientName
				};
			}

			//setting hedvig details if the selected datastore is hedvig configured.
			if (_.has($scope.restoreData, 'vmOptions.dataStore.hedvigInfo.dataStoreId')) {
				data.HedvigDatastore = [
					{
						dataStoreId: _.get($scope.restoreData, 'vmOptions.dataStore.hedvigInfo.dataStoreId'),
						vdiskName: _.get(
							$scope.restoreData,
							'vmOptions.dataStore.hedvigInfo.vdiskName',
							$scope.restoreData.vmOptions.dataStore.dataStoreName
						),
						distributedStorage: {
							distributedStorageId: _.get(
								$scope.restoreData,
								'vmOptions.dataStore.hedvigInfo.distributedStorage.distributedStorageId',
								''
							),
							distributedStorageName: _.get(
								$scope.restoreData,
								'vmOptions.dataStore.hedvigInfo.distributedStorage.distributedStorageName',
								''
							)
						}
					}
				];
			}

			data.networkList = [];
			for (
				var networkName = 0;
				networkName <= $scope.restoreData.vmOptions.settings.networkSettings.destinationNetwork.length - 1;
				networkName++
			) {
				data.networkList.push({
					sourceNetwork: 'Any Network',
					destinationNetwork:
						$scope.restoreData.vmOptions.settings.networkSettings.destinationNetwork[networkName].networkName
				});
			}
			if ($scope.usersAndUserGroup && $scope.usersAndUserGroup.length > 0) {
				data.securityAssociations = replTargetFactory.setUsersAndUserGroups(self.usersAndUserGroup);
			}
			var advanceOptions = $scope.vmList[0].advanceOptions;
			if ($scope.isRegularAppType()) {
				data.maxCores = $scope.model.noOfCPUs;
				if (!$scope.maxMemoryFlag) {
					data.maxMemory = $scope.model.maxMemory;
				}

				if ($scope.configureVirtualizeMeFlag) {
					//.data.restoreNetworkName = $scope.restoreData.vmOptions.destinationNetwork;
					if ($scope.restoreData.vmOptions.isoInfo) {
						data.isoInfo = [$scope.restoreData.vmOptions.isoInfo.windows, $scope.restoreData.vmOptions.isoInfo.unix];
					}
				}

				data.maxVMQuota = advanceOptions.noOfVms;
			}
			if (advanceOptions) {
				if (advanceOptions.showLiveMount) {
					data.isLiveMountEnabled = true;
					if (advanceOptions.expirationTime === 'Hours') {
						if (advanceOptions.minutesRetainUntil) {
							data.minutesRetainUntil = advanceOptions.minutesRetainUntil;
							data.daysRetainUntil = null;
						}
					} else if (advanceOptions.expirationTime === 'Days') {
						data.daysRetainUntil = advanceOptions.daysRetainUntil;
						if (advanceOptions.migrateVMs) {
							data.entity.policyType = VirtualMachineConstants.VMAllocationPolicyType.VMW_LIVEMOUNT;
							data.migrateVMs = advanceOptions.migrateVMs;
							data.waitBeforeMigrationInHours = 1; //setting default wait before migration to 1 hour
						} else {
							data.migrateVMs = false;
							data.waitBeforeMigrationInHours = null;
						}
					}
				} else {
					if (advanceOptions.daysRetainUntil) {
						data.daysRetainUntil = advanceOptions.daysRetainUntil;
						data.minutesRetainUntil = null;
					}
				}
				if (
					advanceOptions.mediaAgent &&
					advanceOptions.mediaAgent.length > 0 &&
					advanceOptions.mediaAgent[0].displayName
				) {
					data.mediaAgent = {
						clientName: advanceOptions.mediaAgent[0].mediaAgentName,
						clientId: advanceOptions.mediaAgent[0].mediaAgentId
					};
				}
			}

			if ($scope.serverGroupActivityFlag && $scope.model.serverGroup && $scope.model.serverGroup.length > 0) {
				data.associatedClientGroup = {
					clientGroupName: $scope.model.serverGroup[0].name,
					clientGroupId: $scope.model.serverGroup[0].Id
				};
			}

			if ($scope.enableVirtualLabs) {
				if ($scope.existingNetworkFlag && $scope.model.existingNetwork) {
					data.networkNames = [];
					data.networkNames.push($scope.model.existingNetwork[0].displayName);
				}

				if ($scope.networkSelectorFlag) {
					if (
						$scope.restoreData.gatewayTemplate &&
						($scope.restoreData.gatewayTemplate.vmGUID || $scope.restoreData.gatewayTemplate.entity)
					) {
						if (!data.gatewayTemplate) {
							data.gatewayTemplate = {};
						}
						data.gatewayTemplate.vmName = $scope.restoreData.gatewayTemplate.vmName
							? $scope.restoreData.gatewayTemplate.vmName
							: $scope.restoreData.gatewayTemplate.entity.gateway.name;
						data.gatewayTemplate.vmGUID = $scope.restoreData.gatewayTemplate.vmGUID
							? $scope.restoreData.gatewayTemplate.vmGUID
							: $scope.restoreData.gatewayTemplate.entity.gateway.guid;
						if ($scope.model.gatewayNetwork && $scope.model.gatewayNetwork.length > 0) {
							data.primaryGatewayNetwork = $scope.model.gatewayNetwork[0].displayName;
						}
					}
					data.createIsolatedNetwork = true;
					data.entity.policyType = VirtualMachineConstants.VMAllocationPolicyType.VMW_BACKUP_LABTEMPLATE;
				} else {
					data.createIsolatedNetwork = false;
				}
			}

			if (!data.entity.vmAllocPolicyName) {
				$scope.serverMessageTop = cvUtil.errMsgLoc('error.name');
				return;
			}

			if ($scope.usersAndUserGroups.length > 0) {
				data.securityAssociations = {};
				data.securityAssociations.users = [];
				data.securityAssociations.userGroups = [];
				$scope.usersAndUserGroups.forEach(function(user) {
					var userToAdd = {};
					var userGroupToAdd = {};
					var selectedUser = {};
					if (user.selected && (selectedUser = user.userEntity)) {
						// denotes user entity;
						userToAdd.userId = selectedUser.userId;
						userToAdd.userGUID = selectedUser.userGUID;
						userToAdd.userName = selectedUser.userName;
						data.securityAssociations.users.push(userToAdd);
					} else if (user.selected && (selectedUser = user.userGroupEntity)) {
						// denotes user group entity
						userGroupToAdd.userGroupId = selectedUser.userGroupId;
						userGroupToAdd.userGroupName = selectedUser.userGroupName;
						data.securityAssociations.userGroups.push(userGroupToAdd);
					}
				});
			}
			// setting cluster displayName at region attribute, this is temporary
			// fix, will save this in moreF attribute @esxServerEntity message
			// itself
			if ($scope.restoreData.vmOptions.destinationHost && $scope.restoreData.vmOptions.destinationHost.length > 0) {
				var destinationHost = $scope.restoreData.vmOptions.destinationHost[0];
				if (destinationHost.entity.type === 'CLUSTER') {
					data.region = destinationHost.displayName;
				}
			}

			/*
			 * Policy type will be VMW_BACKUP_LABTEMPLATE if - Isolated network has been selected - Expiration
			 * date is set to Days If policy type is not already set to VMW_BACKUP_LABTEMPLATE, then set to
			 * VMW_LIVEMOUNT if - Migration is set - Expiration is set to Hours For all other cases, set the
			 * policy type to VMWARE
			 */
			//need to check if this code really required.
			if (!data.entity.policyType) {
				if (!advanceOptions || !advanceOptions.showLiveMount) {
					data.entity.policyType = VirtualMachineConstants.VMAllocationPolicyType.VMWARE;
				} else {
					data.entity.policyType = VirtualMachineConstants.VMAllocationPolicyType.VMW_BACKUP_LABTEMPLATE;
				}
			}
			data.vmPolicyAppType = $scope.vmPolicyAppType;

			var dataCenterEntity = {};
			$scope.restoreData.vmOptions.destinationHost.forEach(function(host) {
				var DATACENTER = 'DATACENTER';
				if (host.parent && host.parent.type === DATACENTER) {
					dataCenterEntity = host.parent.entity;
				} else if (host.parent && host.parent.parent && host.parent.parent.type === DATACENTER) {
					dataCenterEntity = host.parent.parent.entity;
				}
			});

			if (!dataCenterEntity) {
				dataCenterEntity = $scope.restoreData.vmOptions.dataCenter;
			}
			data.dataCenter = {};
			if (dataCenterEntity.name) {
				data.dataCenter.dataCenterName = dataCenterEntity.name
					? dataCenterEntity.name
					: dataCenterEntity.dataCenterName;
			}
			if ($scope.model) {
				data.dataCenter.instanceEntity = {
					instanceId: $scope.model.selectedHypervisor.instanceId,
					instanceName: $scope.model.selectedHypervisor.clientName
				};
			}

			if ($scope.editMode) {
				data.entity.vmAllocPolicyId = $scope.policyId;
				$scope.updateReplicationTarget(data);
			} else {
				$scope.addReplicationTarget(data);
			}
		};
	}
];

serverMod.controller(controllers);

export default serverMod;
