import { vsaAppServerModule } from 'common/js/modules';
import 'vsa/js/directives/cv-restore-options-oci-directive.js';
import 'modules/vmManagement/js/constants/vmLifeCyclePolicy.constants.js';

var serverMod = vsaAppServerModule;
var controllers = {};
serverMod.constant('RESTORE_OPTIONS_MODE_OCI', {
	REPLICATION_TARGET: 'replicationTarget',
	RESTORE: 'restore'
});

controllers.replicationControllerOCI = [
	'$scope',
	'$stateParams',
	'$log',
	'restoreService',
	'serverService',
	'cvLoc',
	'cvUtil',
	'cvBreadcrumbsTabsFactory',
	'$uibModal',
	'$filter',
	'$dialogs',
	'collectionFactory',
	'restoreOptionFactory',
	'restoreSettingsFactory',
	'replicationFactory',
	'cvTreeFactory',
	'destinationHostData',
	'userService',
	'$q',
	'RESTORE_OPTIONS_MODE_HYPERV',
	'$rootScope',
	'replTargetFactory',
	'VM_POLICY_APP_TYPE',
	function(
		$scope,
		$stateParams,
		$log,
		restoreService,
		serverService,
		cvLoc,
		cvUtil,
		cvBreadcrumbsTabsFactory,
		$modal,
		$filter,
		$dialogs,
		collectionFactory,
		restoreOptionFactory,
		restoreSettingsFactory,
		replicationFactory,
		cvTreeFactory,
		destinationHostData,
		userService,
		$q,
		RESTORE_OPTIONS_MODE_HYPERV,
		$rootScope,
		replTargetFactory,
		VM_POLICY_APP_TYPE
	) {
		var self = this;
		self.vendor = 'ORACLE_CLOUD_INFRASTRUCTURE';
		self.editMode = $scope.editMode;
		$scope.$watch('model.vendor', function(vendor) {
			if (angular.isDefined(vendor)) {
				self.vendor = vendor;
				self.init();
			}
		});
		self.ctrl = {};
		self.model = {};
		self.ctrl.doRefresh = true;

		if ($stateParams.policyId) {
			self.policyId = $stateParams.policyId;
		}

		//Initializes the values during edit mode
		var setValues = function(restoreData) {
			self.model.selectedHypervisor = restoreData.selectedHypervisor ? restoreData.selectedHypervisor : null;
			self.restoreData.globalOptions.selectedProxy = [restoreData.proxyClientEntity];
			self.restoreData.globalOptions.server = self.model.selectedHypervisor;
		};

		//Initializes the values during creation adn edit mode
		var initializeRestoreData = function(restoreData) {
			self.restoreData = angular.merge(
				{},
				{
					globalOptions: {}
				},
				self.restoreData
			);
			//during edit mode
			if (restoreData) {
				self.restoreData = angular.merge({}, restoreData, self.restoreData);
				setValues(self.restoreData);
			} else {
				//during creation
				self.restoreData = angular.merge(
					{},
					{
						prefixSuffixSelector: 'suffix',
						displayNamePrefixSuffix: replTargetFactory.getDefaultVMSuffixPrefixName()
					},
					self.restoreData
				);
			}
			// empty list for restore options directive
			self.vmList = [];
			self.vmList.push(self.restoreData);

			replTargetFactory.collectUsersAndUserGroups(self.restoreData.securityAssociations, self.editMode).then(data => {
				self.usersAndUserGroups = data;
			});
		};

		self.init = function() {
			initializeRestoreData($scope.restoreData);
		};

		//flag to show/hide fields in override options and target
		self.displayOptionDetails = false;

		self.ctrl.refreshHypervisor = function() {
			var globalOptions = self.restoreData.globalOptions;
			var clearVmOptions = function(vmOpts) {
				vmOpts.selectedProxy = null;
			};

			if (self.model.selectedHypervisor && !self.model.selectedHypervisor.disabled) {
				var server = self.model.selectedHypervisor;
				if (globalOptions && globalOptions.server && globalOptions.server.serverId != server.clientId) {
					if (!self.editMode) {
						clearVmOptions(globalOptions);
					}
				}

				self.restoreData.globalOptions.server = angular.merge(
					{},
					{
						serverId: server.clientId,
						serverName: server.clientName
					},
					server
				);
			} else {
				self.restoreData.globalOptions.server = {};
			}

			if (self.ctrl.loadDestinationProxies) {
				self.ctrl.loadDestinationProxies(null, self.model.selectedHypervisor);
			}
		};

		//When user clicks on the cancel button in target
		self.saveOCICancelled = function() {
			$scope.$emit('replicationTargetAddCancelled');
		};

		//This function takes care of the service call where the API is called during the creation of the target
		self.addReplicationTarget = function(replicationTarget) {
			restoreService
				.addReplicationTarget(replicationTarget)
				.success(function(data) {
					$scope.$emit('replicationTargetAdded', data.entity);
				})
				.error(function(e) {
					self.OCIErrorMessage = cvUtil.errMsg(e ? e : cvLoc('error.saveReplicationTarget'));
				});
		};

		//This function takes care of the service call where the API is called when the target is edited
		self.updateReplicationTarget = function(updatedReplicationTarget) {
			restoreService
				.updateReplicationTarget(updatedReplicationTarget)
				.success(function(data) {
					$scope.$emit('replicationTargetUpdated', data.entity);
				})
				.error(function(e) {
					self.OCIErrorMessage = cvUtil.errMsg(e ? e : cvLoc('error.saveReplicationTarget'));
				});
		};

		self.isValidTarget = function(targetData) {
			if (!targetData.vmOptions.esxHostDisplayName) {
				if (!self.compartmentError) {
					self.compartmentError = cvUtil.errMsg(cvLoc('error.noCompartment'));
				}
				return;
			}
			if (
				!targetData.vmOptions.nics ||
				(targetData.vmOptions.nics && targetData.vmOptions.nics[0] && !targetData.vmOptions.nics[0].subnetId)
			) {
				return;
			}
			if (!targetData.vmOptions.vmSize) {
				self.shapeError = cvUtil.errMsg(cvLoc('error.noShape'));
				return;
			}
			if (!targetData.vmOptions.Datastore) {
				self.aDomainError = cvUtil.errMsg(cvLoc('error.noADomain'));
				return;
			}
		};

		//When the target is create/edited and then saved
		self.save = function() {
			if (!self.ctrl.validateVmOptions()) {
				return;
			} // self.isValidTarget(self.restoreData);

			var POLICY_TYPE = 15;
			var globalOptions = self.restoreData.globalOptions;
			var data = {
				entity: {
					vmAllocPolicyName: self.restoreData.replicationTargetName,
					policyType: POLICY_TYPE
				},

				destinationHyperV: {
					clientId: globalOptions.server.clientId,
					clientName: globalOptions.server.clientName
				},
				proxyClientEntity: {
					clientId:
						globalOptions.selectedProxy && globalOptions.selectedProxy.length > 0
							? globalOptions.selectedProxy[0].clientId
							: null,
					clientName:
						globalOptions.selectedProxy && globalOptions.selectedProxy.length > 0
							? globalOptions.selectedProxy[0].clientName
							: null
				},

				vmNameEditString: self.restoreData.displayNamePrefixSuffix,

				vmNameEditType: self.restoreData.prefixSuffixSelector.toUpperCase(),

				//Compartment
				esxServers: [
					{
						esxServerName: self.restoreData.vmOptions.esxHostDisplayName
						//esxServerId : self.restoreData.vmOptions.compartment.guid
					}
				],

				//Ava domain
				dataStores: [
					{
						dataStoreName: self.restoreData.vmOptions.Datastore
					}
				],

				//availability domain for OCI VMProv cases
				amazonPolicy: {
					availabilityZones: [
						{
							availabilityZoneName: self.restoreData.vmOptions.Datastore
						}
					]
				},

				//Network settings
				networkInfo: [self.restoreData.vmOptions.nics[0]],

				//public IP
				isPublicIPSettingsAllowed: self.restoreData.vmOptions.createPublicIP
					? self.restoreData.vmOptions.createPublicIP
					: false,
				vmPolicyAppType: $scope.vmPolicyAppType ? $scope.vmPolicyAppType : VM_POLICY_APP_TYPE.REPLICATION.type
			};

			//user membership
			if (self.usersAndUserGroup && self.usersAndUserGroup.length > 0) {
				data.securityAssociations = replTargetFactory.setUsersAndUserGroups(self.usersAndUserGroup);
			}

			//Staging bucket
			if (self.restoreData.vmOptions.stagingBucket) {
				data.resourcePoolPath = self.restoreData.vmOptions.stagingBucket;
			}

			//Shape
			var instanceTypes = [];
			self.shapeChanged = false;
			if (self.restoreData.vmOptions.vmSize && !self.restoreData.vmOptions.vmSize[0].instanceType) {
				angular.forEach(self.restoreData.vmOptions.vmSize, function(type) {
					instanceTypes.push({
						instanceType: {
							vmInstanceTypeName: type
						}
					});
				});
				self.shapeChanged = true;
			}
			data.amazonPolicy = {};
			if (self.shapeChanged) {
				data.amazonPolicy.instanceType = instanceTypes;
			} else {
				for (var i in self.restoreData.vmOptions.vmSize) {
					if (
						self.restoreData.vmOptions.vmSize[i].instanceType &&
						self.restoreData.vmOptions.vmSize[i].instanceType.vmInstanceTypeName === 'Auto'
					) {
						self.restoreData.vmOptions.vmSize[i].instanceType.vmInstanceTypeName = '';
					}
					break;
				}
				data.amazonPolicy.instanceType = self.restoreData.vmOptions.vmSize;
			}

			if ($scope.vmPolicyAppType === VM_POLICY_APP_TYPE.REGULAR.type) {
				if (self.restoreData.vmOptions.sshKeyFileLabel && self.restoreData.vmOptions.sshKeyData) {
					var keyPair = [
						{
							name: self.restoreData.vmOptions.sshKeyFileLabel,
							path: self.restoreData.vmOptions.sshKeyData
						}
					];
					data.keyPairs = keyPair;
				}

				if (self.restoreData.vmOptions.selectedImages) {
					var images = [];
					angular.forEach(self.restoreData.vmOptions.selectedImages, function(image) {
						images.push({
							vmName: image.name,
							vmGUID: image.strGUID
						});
					});
					data.templates = images;
				}
			}

			if (self.editMode) {
				data.entity.vmAllocPolicyId = self.policyId;
				self.updateReplicationTarget(data);
			} else {
				self.addReplicationTarget(data);
			}
		};
	}
];

serverMod.controller(controllers);
export default serverMod;
