import 'users/js/services/users.svc.js';
import 'vsa/js/controllers/replication.ctrl.js';
import 'vsa/js/services/restoreSettings.factory.js';
import 'vsa/js/controllers/restoreOptions.ctrl.js';
import 'vsa/js/services/restore.svc.js';
import 'vsa/js/factories/collections.factory.js';
import 'vsa/js/directives/cv-restore-options-nutanix-directive.js';
import 'modules/vmManagement/js/constants/vmLifeCyclePolicy.constants.js';

import { vsaAppServerModule } from 'common/js/modules';

var serverMod = vsaAppServerModule;

var controllers = {};

controllers.replicationNutanixController = [
	'$scope',
	'$log',
	'$stateParams',
	'restoreService',
	'cvLoc',
	'cvUtil',
	'cvBreadcrumbsTabsFactory',
	'$uibModal',
	'$filter',
	'$dialogs',
	'collectionFactory',
	'restoreOptionFactory',
	'restoreSettingsFactory',
	'replicationFactory',
	'cvTreeFactory',
	'destinationHostData',
	'userService',
	'vmFactory',
	'cvToaster',
	'replTargetFactory',
	'VM_POLICY_APP_TYPE',
	function(
		$scope,
		$log,
		$stateParams,
		restoreService,
		cvLoc,
		cvUtil,
		cvBreadcrumbsTabsFactory,
		$modal,
		$filter,
		$dialogs,
		collectionFactory,
		restoreOptionFactory,
		restoreSettingsFactory,
		replicationFactory,
		cvTreeFactory,
		destinationHostData,
		userService,
		vmFactory,
		cvToaster,
		replTargetFactory,
		VM_POLICY_APP_TYPE
	) {
		$scope.generalOptionsAccordion = true;
		$scope.usersAndUserGroups = [];
		$scope.vendor = 'NUTANIX';

		// this is used to pass to calling directives to refresh data
		$scope.ctrl = {};

		$scope.init = function(vendor) {
			if (vendor) {
				$scope.vendor = vendor;
			}
		};

		if ($stateParams.policyId) {
			$scope.policyId = $stateParams.policyId;
		}
		// if a restoreData object is already present merge it
		$scope.restoreData = angular.merge(
			{},
			{
				globalOptions: {
					overwrite: false,
					powerOn: false,
					selectedProxy: [],
					showVirtualizeMe: false
				},
				getCurrentDestinationFolderDisplayName: function() {
					if (!this.vmOptions || !this.vmOptions.destinationFolder) {
						return cvLoc('placeholder.selectDestinationFolder');
					}
					return this.vmOptions.destinationHost.displayName;
				}
			},
			$scope.restoreData
		);

		// initalize
		$scope.restoreData = angular.merge(
			{},
			{
				vmOptions: {
					displayName: null,
					destinationHost: null,
					dataStore: {},
					dataStoreList: null,
					resourcePool: {},
					resourcePoolList: null,
					networkAndIpAddressSettings: {
						networkSettings: [],
						ipAddressSettings: []
					},
					settings: {
						networkSettings: {
							sourceNetwork: '',
							destinationNetwork: ''
						},
						ipAddressSettings: {
							sourceIpAddress: '',
							sourceSubnetMask: '',
							sourceDefaultGateway: '',
							destinationUseDHCP: false,
							destinationIpAddress: '',
							destinationSubnetMask: '',
							destinationDefaultGateway: '',
							destinationPreferredDnsServer: '',
							destinationAlternateDnsServer: '',
							destinationPreferredWinsServer: '',
							destinationAlternateWinsServer: ''
						}
					},
					vsMetaData: {
						vcloudOrgName: false,
						vcloudOrgVdcName: false,
						vcloudVappName: false,
						vcloudOwner: false,
						vcloudNics: false
					},
					isoInfo: {
						windows: null,
						unix: null
					},
					noOfCPUs: 2,
					maxMemory: 8
				},
				vendorType: 'NUTANIX',
				prefixSuffixSelector: 'prefix'
			},
			$scope.restoreData
		);

		if ($scope.editMode) {
			$scope.restoreData.vmOptions.dataStore.dataStoreLabel = $scope.restoreData.vmOptions.dataStore.dataStoreName;
		}
		// Default values for expiration time
		$scope.restoreData.expirationTime = 'Hours';
		if ($scope.restoreData.createIsolatedNetwork) {
			$scope.restoreData.gatewayTemplate.name = $scope.restoreData.gatewayTemplate.vmName;
			$scope.restoreData.expirationTime = 'Days';
		}
		// Update the values for expiration time in editmode
		if ($scope.editMode) {
			if ($scope.restoreData.minutesRetainUntil > 0) {
				$scope.restoreData.expirationTime = 'Hours';
			}
			if ($scope.restoreData.daysRetainUntil > 0) {
				$scope.restoreData.expirationTime = 'Days';
			}
		}

		// clear previously selected data for destinationHost for selectRestoreDestination modal when you initialize modal
		if (!$scope.editMode) {
			destinationHostData.selection.length = 0;
		}

		// empty list for restore options directive
		$scope.vmList = [];
		$scope.vmList.push($scope.restoreData);

		replTargetFactory.collectUsersAndUserGroups($scope.restoreData.securityAssociations).then(data => {
			$scope.usersAndUserGroups = data;
		});

		/*
		 * Returns true if required items have been selected for the specified VM options object.
		 */
		$scope.isVmOptionValid = function(vmOpts) {
			// validate name, host, datastore and resourcepool, also validate orgname, orgvdcname, appname and owner for vcloud vms
			var valid = vmOpts.displayName && vmOpts.destinationHost && vmOpts.dataStore;
			if ($scope.restoreData.globalOptions.vCloud) {
				return (
					valid &&
					vmOpts.vsMetaData.vcloudOrgName &&
					vmOpts.vsMetaData.vcloudOrgVdcName &&
					vmOpts.vsMetaData.vcloudVappName &&
					vmOpts.vsMetaData.vcloudOwner &&
					vmOpts.vsMetaData.vcloudNics
				);
			} else {
				return valid && vmOpts.resourcePool;
			}
		};

		$scope.addReplicationTarget = function(replicationTarget) {
			restoreService
				.addReplicationTarget(replicationTarget)
				.success(function(data) {
					$scope.$emit('replicationTargetAdded', data.entity);
					cvToaster.showSuccessMessage({
						ttl: '5000',
						message: cvLoc('label.createdReplicationTarget')
					});
				})
				.error(function(e) {
					$scope.serverMessageTop = cvUtil.errMsg(e);
				});
		};

		$scope.updateReplicationTarget = function(updatedReplicationTarget) {
			restoreService
				.updateReplicationTarget(updatedReplicationTarget)
				.success(function(data) {
					$scope.$emit('replicationTargetUpdated', data.entity);
					cvToaster.showSuccessMessage({
						ttl: '5000',
						message: cvLoc('label.updatedReplicationTarget')
					});
				})
				.error(function(e) {
					$scope.serverMessageTop = cvUtil.errMsg(e);
				});
		};

		$scope.saveData = function() {
			if (!$scope.ctrl.validateDataStores() || !$scope.ctrl.validateNetwork()) {
				return;
			}

			var data = {
				entity: {
					vmAllocPolicyName: $scope.restoreData.replicationTargetName
				},
				destinationHyperV: {
					clientId: $scope.model.selectedHypervisor.clientId,
					clientName: $scope.model.selectedHypervisor.clientName
				},
				proxyClientEntity: {
					clientId: $scope.restoreData.globalOptions.selectedProxy[0].clientId,
					clientName: $scope.restoreData.globalOptions.selectedProxy[0].clientName
				},
				enableEditVMName: true,
				vmNameEditString: $scope.restoreData.displayNamePrefixSuffix,
				vmNameEditType: $scope.restoreData.prefixSuffixSelector.toUpperCase(),
				dataStores: [
					{
						dataStoreName: $scope.restoreData.vmOptions.dataStore
							? $scope.restoreData.vmOptions.dataStore[0].dataStoreName
							: ''
					}
				],
				networkList: [
					{
						sourceNetwork: 'Any Network',
						destinationNetwork: $scope.restoreData.vmOptions.settings.networkSettings.destinationNetwork
							? $scope.restoreData.vmOptions.settings.networkSettings.destinationNetwork[0].destinationNetwork
							: ''
					}
				],
				vmPolicyAppType: $scope.vmPolicyAppType ? $scope.vmPolicyAppType : VM_POLICY_APP_TYPE.REPLICATION.type
			};

			if ($scope.usersAndUserGroup && $scope.usersAndUserGroup.length > 0) {
				data.securityAssociations = replTargetFactory.setUsersAndUserGroups(self.usersAndUserGroup);
			}

			if ($scope.usersAndUserGroups.length > 0) {
				data.securityAssociations = {};
				data.securityAssociations.users = [];
				data.securityAssociations.userGroups = [];
				$scope.usersAndUserGroups.forEach(function(user) {
					var userToAdd = {};
					var userGroupToAdd = {};
					var selectedUser = {};
					if (user.selected && (selectedUser = user.userEntity)) {
						// denotes user entity;
						userToAdd.userId = selectedUser.userId;
						userToAdd.userGUID = selectedUser.userGUID;
						userToAdd.userName = selectedUser.userName;
						data.securityAssociations.users.push(userToAdd);
					} else if (user.selected && (selectedUser = user.userGroupEntity)) {
						// denotes user group entity
						userGroupToAdd.userGroupId = selectedUser.userGroupId;
						userGroupToAdd.userGroupName = selectedUser.userGroupName;
						data.securityAssociations.userGroups.push(userGroupToAdd);
					}
				});
			}

			var NUTANIX_AHV_POLICY_TYPE = 17;

			data.entity.policyType = NUTANIX_AHV_POLICY_TYPE;
			data.daysRetainUntil = null;
			data.minutesRetainUntil = null;
			data.createIsolatedNetwork = false;
			data.gatewayTemplate = null;
			data.migrateVMs = false;

			if ($scope.editMode) {
				data.entity.vmAllocPolicyId = $scope.policyId;
				$scope.updateReplicationTarget(data);
			} else {
				$scope.addReplicationTarget(data);
			}
		};
	}
];

serverMod.controller(controllers);

export default serverMod;
