import { vsaAppServerModule } from 'common/js/modules';
import 'vsa/js/services/restore.svc.js';
import 'modules/servers/js/services/servers.svc.js';
import 'browse/js/services/browse.svc.js';
import 'vsa/js/directives/cv-restore-options-hyperv-directive.js';
import 'vsa/js/factories/replicationTargetActions.factory.js';
import 'modules/vmManagement/js/constants/vmLifeCyclePolicy.constants.js';

var serverMod = vsaAppServerModule;
var controllers = {};
serverMod.constant('RESTORE_OPTIONS_MODE_HYPERV', {
	REPLICATION_TARGET: 'replicationTarget',
	RESTORE: 'restore'
});
controllers.replicationControllerHyperv = [
	'$scope',
	'$stateParams',
	'$log',
	'restoreService',
	'serverService',
	'cvLoc',
	'cvUtil',
	'cvBreadcrumbsTabsFactory',
	'$uibModal',
	'$filter',
	'$dialogs',
	'collectionFactory',
	'restoreOptionFactory',
	'restoreSettingsFactory',
	'replicationFactory',
	'cvTreeFactory',
	'destinationHostData',
	'userService',
	'$q',
	'RESTORE_OPTIONS_MODE_HYPERV',
	'$rootScope',
	'replTargetFactory',
	'VM_POLICY_APP_TYPE',
	function(
		$scope,
		$stateParams,
		$log,
		restoreService,
		serverService,
		cvLoc,
		cvUtil,
		cvBreadcrumbsTabsFactory,
		$modal,
		$filter,
		$dialogs,
		collectionFactory,
		restoreOptionFactory,
		restoreSettingsFactory,
		replicationFactory,
		cvTreeFactory,
		destinationHostData,
		userService,
		$q,
		RESTORE_OPTIONS_MODE_HYPERV,
		$rootScope,
		replTargetFactory,
		VM_POLICY_APP_TYPE
	) {
		var self = this;
		self.generalOptionsAccordion = false;
		self.vendor = 'MICROSOFT';
		self.editMode = $scope.editMode;
		$scope.$watch('model.vendor', function(vendor) {
			if (angular.isDefined(vendor)) {
				self.vendor = vendor;
				self.init();
			}
		});
		self.ctrl = {};
		self.model = {};
		self.ctrl.doRefresh = true;

		if ($stateParams.policyId) {
			self.policyId = $stateParams.policyId;
		}

		var restoreLocationEnum = {
			selectedFolder: 'selectedFolder',
			defaultFolder: 'defaultFolder'
		};
		//$scope.showLiveMountOption = true;

		//Initializes the values during edit mode
		var setValues = function(restoreData) {
			self.model.selectedHypervisor = restoreData.selectedHypervisor ? restoreData.selectedHypervisor : null;
			self.restoreData.globalOptions.selectedProxy = [restoreData.proxyClientEntity];
			var server = self.model.selectedHypervisor;
			self.restoreData.globalOptions.server = angular.merge(
				{},
				{
					serverId: server.clientId,
					serverName: server.clientName
				},
				server
			);
			if (self.restoreData && self.restoreData.dataStores && self.restoreData.dataStores.dataStoreName) {
				self.restoreData.destinationFolder = self.restoreData.dataStores.dataStoreName;
			}
			self.model.defaultRestoreLocationChecked = self.restoreData.restoreLocation === 'defaultFolder';
		};

		self.model.defaultRestoreLocationChecked = !self.editMode;

		//Initializes the values during creation adn edit mode
		var initializeRestoreData = function(restoreData) {
			self.restoreData = angular.merge(
				{},
				{
					globalOptions: {
						restoreLocation: restoreLocationEnum.defaultFolder,
						restoreLocationList: [
							{
								value: restoreLocationEnum.selectedFolder,
								displayName: cvLoc('restoreLocation.selectedFolder')
							},
							{
								value: restoreLocationEnum.defaultFolder,
								displayName: cvLoc('restoreLocation.defaultFolder')
							}
						]
					}
				},
				self.restoreData
			);

			//during edit mode
			if (restoreData) {
				self.restoreData = angular.merge({}, restoreData, self.restoreData);
				setValues(self.restoreData);
			} else {
				//during creation
				self.restoreData = angular.merge(
					{},
					{
						prefixSuffixSelector: 'suffix',
						displayNamePrefixSuffix: replTargetFactory.getDefaultVMSuffixPrefixName(),
						vmOptions: {
							networkSettingsAdapterData: []
						}
					},
					self.restoreData
				);
			}

			// empty list for restore options directive
			self.vmList = [];
			self.vmList.push(self.restoreData);

			replTargetFactory.collectUsersAndUserGroups(self.restoreData.securityAssociations).then(data => {
				self.usersAndUserGroups = data;
			});
		};

		self.init = function() {
			initializeRestoreData($scope.restoreData);
		};

		//flag to show/hide fields in override options and target
		self.displayOptionDetails = false;

		self.ctrl.refreshHypervisor = function() {
			$scope.$broadcast('refresh', { type: 'hypervisor' });
			var globalOptions = self.restoreData.globalOptions;
			var clearVmOptions = function(vmOpts) {
				vmOpts.selectedProxy = null;
			};

			if (self.model.selectedHypervisor && !self.model.selectedHypervisor.disabled) {
				var server = self.model.selectedHypervisor;
				if (globalOptions && globalOptions.server && globalOptions.server.serverId != server.clientId) {
					clearVmOptions(globalOptions);
				}

				self.restoreData.globalOptions.server = angular.merge(
					{},
					{
						serverId: server.clientId,
						serverName: server.clientName
					},
					server
				);
			} else {
				self.restoreData.globalOptions.server = {};
			}

			if (self.ctrl.loadDestinationProxies) {
				self.ctrl.loadDestinationProxies(null, self.model.selectedHypervisor);
			}
		};

		//If the restore is to default folder, then the destinationFolder should be empty
		$scope.restoreLocationChanged = function() {
			self.restoreData.destinationFolder = '';
		};

		$scope.setApplicationType = function() {
			$scope.showLiveMountOption = false;
			//show only livemount option is it is regular type set.
			if ($scope.vmPolicyAppType === VM_POLICY_APP_TYPE.REGULAR.type) {
				$scope.showLiveMountOption = true;
			}
		};

		$scope.setApplicationType();

		$scope.$on('vmPolicyAppTypeChanged', function(event, vmPolicyAppType) {
			$scope.vmPolicyAppType = vmPolicyAppType;
			$scope.setApplicationType();
		});

		//This function opens the modal to select the destination folder, if the restore is toa selected folder and sets the value
		$scope.openSelectDestinationFolder = function(subClientEntity) {
			var clientId = self.restoreData.globalOptions.selectedProxy[0].clientId;
			if (!clientId) {
				self.missingProxy = cvUtil.errMsg(cvLoc('error.missingProxy'));
				return;
			}
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'machineBrowse/partials/machineBrowse.jsp',
				controller: 'mbController',
				resolve: {
					browseParams: function() {
						return {
							clientId: clientId,
							foldersOnly: true
						};
					}
				}
			});
			modalInstance.result.then(
				function(result) {
					$log.debug('Destination path selected: ' + result.path);
					self.restoreData.destinationFolder = result.path;
				},
				function() {
					$log.debug('Cancel clicked');
				}
			);
		};

		//When user clicks on the cancel button in target
		self.saveHyperVCancelled = function() {
			$scope.$emit('replicationTargetAddCancelled');
		};

		//This function takes care of the service call where the API is called during the creation of the target
		self.addReplicationTarget = function(replicationTarget) {
			restoreService
				.addReplicationTarget(replicationTarget)
				.success(function(data) {
					$scope.$emit('replicationTargetAdded', data.entity);
				})
				.error(function(e) {
					self.hyperVErrorMessage = cvUtil.errMsg(e ? e : cvLoc('error.saveReplicationTarget'));
				});
		};

		//This function takes care of the service call where the API is called when the target is edited
		self.updateReplicationTarget = function(updatedReplicationTarget) {
			restoreService
				.updateReplicationTarget(updatedReplicationTarget)
				.success(function(data) {
					$scope.$emit('replicationTargetUpdated', data.entity);
				})
				.error(function(e) {
					self.azureErrorMessage = cvUtil.errMsg(e ? e : cvLoc('error.saveReplicationTarget'));
				});
		};

		//When the target is create/edited and the saved
		self.save = function() {
			//do check for advanced options only when $scope.showLiveMountOption set

			if ($scope.showLiveMountOption && (!self.ctrl.validateNoOfVMs() || !self.ctrl.validateExpirationTime())) {
				return;
			}

			if (_.get(self.restoreData, 'networkSetting.length', 0) <= 0) {
				$scope.$broadcast('saveLCPolicyHyperVError', { type: 'network' });
				return;
			}

			self.defaultFolderLocation = self.model.defaultRestoreLocationChecked;

			var globalOptions = self.restoreData.globalOptions;
			var advanceOptions = self.restoreData.advanceOptions;
			if (self.defaultFolderLocation) {
				self.restoreData.destinationFolder = '';
			}

			var destFolder;
			if (self.restoreData.editMode) {
				destFolder = self.restoreData.dataStores.dataStoreName;
			} else {
				destFolder = self.restoreData.destinationFolder;
			}

			var POLICY_TYPE = 2;

			var data = {
				entity: {
					vmAllocPolicyName: self.restoreData.replicationTargetName,
					policyType: POLICY_TYPE
				},
				destinationHyperV: {
					clientId: globalOptions.server.clientId,
					clientName: globalOptions.server.clientName
				},
				proxyClientEntity: {
					clientId: _.get(globalOptions, 'selectedProxy[0].clientId', null),
					clientName: _.get(globalOptions, 'selectedProxy[0].clientName', null),
					hostName: _.get(globalOptions, 'selectedProxy[0].hostName', null)
				},

				vmNameEditString: self.restoreData.displayNamePrefixSuffix,

				vmNameEditType: self.restoreData.prefixSuffixSelector.toUpperCase(),

				isDefaultFolder: self.defaultFolderLocation,

				dataStores: [
					{
						dataStoreName: destFolder
					}
				],
				esxServers: [
					{
						esxServerName: globalOptions.selectedProxy ? globalOptions.selectedProxy[0].clientName : null
					}
				],
				networkList: self.restoreData.networkSetting,

				dataCenter: {
					instanceEntity: {
						instanceId: globalOptions.server.instanceId,
						instanceName: globalOptions.server.clientName
					}
				},
				vmPolicyAppType: $scope.vmPolicyAppType ? $scope.vmPolicyAppType : VM_POLICY_APP_TYPE.REPLICATION.type
			};
			if ($scope.showLiveMountOption) {
				//data.maxCores = advanceOptions.noOfCPUs;
				//if(!advanceOptions.maxMemoryToggle) {
				//data.maxMemory = advanceOptions.maxMemory;
				//	}

				data.maxVMQuota = advanceOptions.noOfVms;

				if (advanceOptions.showLiveMount) {
					data.isLiveMountEnabled = true;
					if (!!advanceOptions.minutesRetainUntil && !advanceOptions.enableVirtualLabs) {
						data.minutesRetainUntil = advanceOptions.minutesRetainUntil;
						data.daysRetainUntil = null;
					}

					if (advanceOptions.mediaAgent && advanceOptions.mediaAgent[0].displayName) {
						data.mediaAgent = {
							clientName: advanceOptions.mediaAgent[0].mediaAgentName,
							clientId: advanceOptions.mediaAgent[0].mediaAgentId
						};
					}
				}
			}

			if (self.usersAndUserGroup && self.usersAndUserGroup.length > 0) {
				data.securityAssociations = replTargetFactory.setUsersAndUserGroups(self.usersAndUserGroup);
			}

			if (self.editMode) {
				data.entity.vmAllocPolicyId = self.policyId;
				self.updateReplicationTarget(data);
			} else {
				self.addReplicationTarget(data);
			}
		};
	}
];

serverMod.controller(controllers);
export default serverMod;
