import 'modules/servers/js/services/servers.svc.js';
import 'vsa/js/services/restore.svc.js';
import 'vsa/js/directives/cv-select-hypervisors-directive.js';
import 'vsa/js/directives/cv-restore-options-azure-directive.js';
import 'vsa/js/factories/replicationTargetActions.factory.js';
import 'modules/vmManagement/js/constants/vmLifeCyclePolicy.constants.js';

import { vsaAppServerModule } from 'common/js/modules';

var serverMod = vsaAppServerModule;
var controllers = {};
controllers.replicationControllerAzure = [
	'$scope',
	'$stateParams',
	'$log',
	'restoreService',
	'serverService',
	'cvLoc',
	'cvUtil',
	'$dialogs',
	'replTargetFactory',
	'VM_POLICY_APP_TYPE',
	'VSA_VENDOR',
	'replicationGroupFactory',
	'InstallOSType',
	function(
		$scope,
		$stateParams,
		$log,
		restoreService,
		serverService,
		cvLoc,
		cvUtil,
		$dialogs,
		replTargetFactory,
		VM_POLICY_APP_TYPE,
		VSA_VENDOR,
		replicationGroupFactory,
		InstallOSType
	) {
		var self = this;
		self.editMode = $scope.editMode;
		$scope.$watch('model.vendor', function(vendor) {
			if (angular.isDefined(vendor)) {
				self.vendor = vendor;
				self.init();
			}
		});

		self.distributeWorkload = _.get(cvConfig, 'bEnableDistributeWorkload', false);
		self.ctrl = {};
		self.model = {};
		self.ctrl.refreshCache = false;
		self.ctrl.doRefresh = true;
		self.hideDetails = cv.isTenantAdmin;
		if ($stateParams.policyId) {
			self.policyId = $stateParams.policyId;
		}

		self.isRegularPolicy = function() {
			return $scope.vmPolicyAppType === VM_POLICY_APP_TYPE.REGULAR.type;
		};

		self.isDiskSkuApplicable = self.vendor == VSA_VENDOR.AZURERM;
		self.isAvailabilityZoneApplicable = self.vendor == VSA_VENDOR.AZURERM;
		self.isReplicationPolicy = function() {
			return $scope.vmPolicyAppType === VM_POLICY_APP_TYPE.REPLICATION.type;
		};
		$scope.$on('vmPolicyAppTypeChanged', function(event, vmPolicyAppType) {
			$scope.vmPolicyAppType = vmPolicyAppType;
			self.ctrl.setApplicationType(vmPolicyAppType);

			/*
			 * If the user has already overriden the suffix prefix name, do not change it. otherwise, set the
			 * default value
			 */
			if (
				self.isRegularPolicy($scope.vmPolicyAppType) &&
				self.restoreData.displayNamePrefixSuffix === self.defaultVMSuffixPrefixName
			) {
				self.restoreData.displayNamePrefixSuffix = null;
			} else if (
				self.isReplicationPolicy($scope.vmPolicyAppType) &&
				self.restoreData.displayNamePrefixSuffix === null
			) {
				self.restoreData.displayNamePrefixSuffix = self.defaultVMSuffixPrefixName;
			}
			if (self.ctrl.displayNameChanged) {
				self.ctrl.displayNameChanged(self.restoreData.displayNamePrefixSuffix);
			}
		});

		// Initialize restoreData
		var initializeRestoreData = function(restoreData) {
			self.defaultVMSuffixPrefixName = getDefaultVMSuffixPrefixName();
			self.restoreData = angular.merge(
				{},
				{
					globalOptions: {
						overwrite: false,
						powerOn: false,
						enablePrefixSuffix: true,
						selectedProxy: {},
						platform: InstallOSType.WINDOWS,
						selectedHypervisor: {}
					}
				},
				self.restoreData
			);

			if (restoreData) {
				self.restoreData = angular.merge({}, restoreData, self.restoreData);
			} else {
				self.restoreData = angular.merge(
					{},
					{
						prefixSuffixSelector: 'suffix',
						displayNamePrefixSuffix: self.defaultVMSuffixPrefixName,
						vmOptions: {
							displayName: null,
							azureContainer: null,
							azureStorageAccount: null,
							azureVmSize: null,
							azureDiskType: null,
							azureNetworkInfo: null,
							createPublicIP: false,
							restoreAsManagedVM: true,
							securityGroup: null
						},
						minutesRetainUntil: 1,
						expirationTime: 'Hours'
					},
					self.restoreData
				);
			}
			self.model.selectedHypervisor = $scope.model.selectedHypervisor ? $scope.model.selectedHypervisor : null;
			self.restoreData.globalOptions.showProxy = true;
			// empty list for restore options directive
			self.vmList = [];
			self.vmList.push(self.restoreData);

			replTargetFactory.collectUsersAndUserGroups(self.restoreData.securityAssociations).then(data => {
				self.usersAndUserGroups = data;
			});
		};

		// MARK: Initalize:
		self.init = function() {
			initializeRestoreData($scope.restoreData);
		};
		self.ctrl.refreshHypervisor = function() {
			var globalOptions = self.restoreData.globalOptions;
			self.ctrl.refreshCache = true;
			var clearVmOptions = function(vmOpts) {
				vmOpts.azureContainer = null;
				vmOpts.azureRegion = null;
				vmOpts.azureStorageAccount = null;
				vmOpts.azureVmSize = null;
				vmOpts.azureDiskType = null;
				vmOpts.azureNetworkInfo = null;
				vmOpts.createPublicIP = null;
				vmOpts.restoreAsManagedVM = true;
				vmOpts.securityGroup = null;
				vmOpts.azureAvailabilityZone = null;
			};

			if (self.model.selectedHypervisor && !self.model.selectedHypervisor.disabled) {
				var server = self.model.selectedHypervisor;
				if (globalOptions && globalOptions.server && globalOptions.server.serverId != server.clientId) {
					if (!self.editMode) {
						clearVmOptions(self.restoreData.vmOptions);
					}
				}

				self.restoreData.globalOptions.server = angular.merge(
					{},
					{
						clientId: server.clientId,
						clientName: server.clientName
					},
					server
				);

				//caching selectedHypervisor to the clientDestination object.
				if (self.ctrl.setClientDestination) {
					self.ctrl.setClientDestination(server);
				}

				if (self.ctrl.refreshAzureContainer) {
					self.ctrl.refreshAzureContainer(self.restoreData.vmOptions);
				}
			} else {
				self.restoreData.globalOptions.server = {};
			}
		};

		self.addReplicationTarget = function(replicationTarget) {
			restoreService
				.addReplicationTarget(replicationTarget)
				.success(function(data) {
					$scope.$emit('replicationTargetAdded', data.entity);
				})
				.error(function(e) {
					self.azureErrorMessage = cvUtil.errMsg(e ? e : cvLoc('error.saveReplicationTarget'));
				});
		};

		self.updateReplicationTarget = function(updatedReplicationTarget) {
			restoreService
				.updateReplicationTarget(updatedReplicationTarget)
				.success(function(data) {
					$scope.$emit('replicationTargetUpdated', data.entity);
				})
				.error(function(e) {
					self.azureErrorMessage = cvUtil.errMsg(e ? e : cvLoc('error.saveReplicationTarget'));
				});
		};

		self.save = function() {
			/**
			 * Whenever Save is clicked, errorExisted will be set to false, only set this errorExisted = true
			 * when there is error, don't revert it to false if there is no error because this validate all
			 * fields.
			 */
			var errorExisted = false;
			self.azureErrorMessage = null;
			var vmOpt = self.restoreData.vmOptions;
			var globalOptions = self.restoreData.globalOptions;

			if (!vmOpt) {
				self.azureErrorMessage = cvUtil.errMsg(cvLoc('error.saveReplicationTarget'));
				return false;
			}

			if (!globalOptions.server || !globalOptions.server.clientId) {
				errorExisted = true;
				return;
			}

			var vmSize = angular.copy(vmOpt.azureVmSize);
			var volumeType = angular.copy(vmOpt.azureDiskType);
			var selectedProxy = globalOptions.selectedProxy ? globalOptions.selectedProxy[0] : null;
			var networkList = null;
			var securityGroup = angular.copy(vmOpt.securityGroup);
			if (vmOpt.azureRegion) {
				var region = angular.copy(vmOpt.azureRegion);
			}
			let availabilityZone = '';
			const autoOption = 'Auto';

			if (self.vendor == VSA_VENDOR.AZURERM && vmOpt.azureAvailabilityZone) {
				availabilityZone = angular.copy(vmOpt.azureAvailabilityZone);
				if (vmOpt.azureAvailabilityZone === autoOption) {
					availabilityZone = '';
				}
			}

			if (!self.restoreData.vmOptions.azureStorageAccount || self.restoreData.vmOptions.azureStorageAccount.notValid) {
				errorExisted = true;
				if (self.ctrl.displayStorageAccountError) {
					self.ctrl.displayStorageAccountError(errorExisted);
				}
			}

			if (!selectedProxy || !self.model.selectedHypervisor || !vmOpt.azureContainer) {
				errorExisted = true;
			}

			// Network info bases on if this is new one or existing one
			if (vmOpt.azureNetworkInfo) {
				networkList = [
					{
						networkName: vmOpt.azureNetworkInfo.networkName,
						name: vmOpt.azureNetworkInfo.name,
						subnetId: vmOpt.azureNetworkInfo.subNetId,
						networkDisplayName: vmOpt.azureNetworkInfo.networkDisplayName
					}
				];

				/*
				 * networkInfo = vmOpt.azureNetworkInfo.newNetwork ? [ { networkName :
				 * vmOpt.azureNetworkInfo.networkName, subnetNames : [ { name :
				 * vmOpt.azureNetworkInfo.subnetName, networkAddress : vmOpt.azureNetworkInfo.networkAddress, } ] } ] : [ {
				 * networkName : vmOpt.azureNetworkInfo.networkName, subnetNames : [ { name :
				 * vmOpt.azureNetworkInfo.name, subnetId : vmOpt.azureNetworkInfo.subNetId, } ] } ];
				 */
			}

			if (
				vmSize &&
				(!vmSize.id || vmSize.id === cvLoc('label.autoSelect') || vmSize.name === cvLoc('label.autoSelect'))
			) {
				vmSize.name = '';
			}

			if (securityGroup && !securityGroup.groupId) {
				securityGroup.groupName = '';
			}

			if (self.editMode) {
				if (!self.restoreData.vmOptions.dataCenter.dataCenterName) {
					//region is optional
					if (!vmOpt.azureStorageAccount) {
						errorExisted = true;
						self.ctrl.displayRegionError(errorExisted);
					}
				} else {
					//region is mandatory
					if (!vmOpt.azureRegion) {
						errorExisted = true;
						self.ctrl.displayRegionError(errorExisted);
					}
				}
			} else {
				//during creation, region is mandated
				if (!vmOpt.azureRegion) {
					errorExisted = true;
					self.ctrl.displayRegionError(errorExisted);
				}
			}

			if (errorExisted) {
				return;
			}

			var POLICY_TYPE = self.vendor == 'AZURE_V2' ? 7 : self.vendor == 'AZURE_STACK' ? 16 : 3;

			var data = {
				entity: {
					vmAllocPolicyName: self.restoreData.replicationTargetName,
					policyType: POLICY_TYPE,
					vCenterName: self.model.selectedHypervisor.clientName,
					dataCenterName: vmOpt.azureRegion && vmOpt.azureRegion.guid ? vmOpt.azureRegion.guid : ''
				},
				destinationHyperV: {
					clientId: globalOptions.server.clientId,
					clientName: globalOptions.server.clientName
				},
				enableEditVMName: true,
				vmNameEditString: self.restoreData.displayNamePrefixSuffix,
				vmNameEditType: self.restoreData.prefixSuffixSelector.toUpperCase(),
				inPlaceRestore: true,
				isPublicIPSettingsAllowed: vmOpt.createPublicIP ? vmOpt.createPublicIP : false,
				restoreAsManagedVM: vmOpt.restoreAsManagedVM ? vmOpt.restoreAsManagedVM : false,
				vmPolicyAppType: $scope.vmPolicyAppType,
				amazonPolicy: {
					vmInstanceTypes: [
						{
							vmInstanceTypeName: vmSize ? vmSize.name : ''
						}
					],
					availabilityZones: [
						{
							availabilityZoneName: availabilityZone ? availabilityZone : ''
						}
					],
					volumeType: vmOpt.azureDiskType ? vmOpt.azureDiskType.id : ''
				},
				securityGroups: [
					{
						name: securityGroup && securityGroup.groupName ? securityGroup.groupName : securityGroup.name,
						groupId: securityGroup ? securityGroup.groupId : null
					}
				],
				destVendor: self.vendor,
				esxServers: [
					{
						esxServerName: vmOpt.azureContainer
					}
				],
				region: vmOpt.azureRegion && vmOpt.azureRegion.displayName ? vmOpt.azureRegion.displayName : '',
				dataStores: [
					{
						dataStoreName: vmOpt.azureStorageAccount ? vmOpt.azureStorageAccount.dataStoreName : null
					}
				],
				dataCenter: {
					instanceEntity: {
						instanceId: globalOptions.server.instanceId,
						instanceName: globalOptions.server.clientName
					},
					dataCenterName: vmOpt.azureRegion && vmOpt.azureRegion.guid ? vmOpt.azureRegion.guid : '',
					vCenterName: self.model.selectedHypervisor.clientName
				}
			};

			// Set proxyClientEntity only if proxy is not Distribute workload/Automatic
			if (!selectedProxy.autoProxy) {
				data.proxyClientEntity = {
					clientId: selectedProxy ? selectedProxy.clientId : null,
					clientName: selectedProxy ? selectedProxy.clientName : null
				};
			}

			if (self.isRegularPolicy()) {
				let azureTemplates = self.ctrl.getAzureTemplates();

				if (azureTemplates && azureTemplates.length) {
					data.templates = azureTemplates;
				}
			}

			if (self.usersAndUserGroup && self.usersAndUserGroup.length > 0) {
				data.securityAssociations = replTargetFactory.setUsersAndUserGroups(self.usersAndUserGroup);
			}

			// Set Network List (Virtual network - VMWAdvancedRestoreOptionsNic)
			if (networkList) {
				data.networkList = networkList;
			}

			// test failover options
			if (vmOpt.azureTestNetwork && self.restoreData.expirationTime) {
				// Set Test Network Info set

				if (self.restoreData.expirationTime === 'Hours') {
					data.minutesRetainUntil = !!self.restoreData.minutesRetainUntil ? self.restoreData.minutesRetainUntil : 1;
				} else {
					data.daysRetainUntil = !!self.restoreData.daysRetainUntil ? self.restoreData.daysRetainUntil : 1;
				}

				let testNetworkInfo = [
					{
						networkName: vmOpt.azureTestNetwork.networkName,
						name: vmOpt.azureTestNetwork.name,
						label: vmOpt.azureTestNetwork.networkDisplayName,
						subnetNames: [
							{
								subnetId: vmOpt.azureTestNetwork.subNetId,
								name: vmOpt.azureTestNetwork.subnetName,
								label: vmOpt.azureTestNetwork.subnetLabel
							}
						]
					}
				];
				data.networkInfo = testNetworkInfo;

				let testVmSize = angular.copy(vmOpt.azureTestVmSize);

				if (
					testVmSize &&
					(!testVmSize.id ||
						testVmSize.id === cvLoc('label.autoSelect') ||
						testVmSize.name === cvLoc('label.autoSelect'))
				) {
					testVmSize.name = '';
					testVmSize.id = '';
				}

				data.amazonPolicy = angular.merge(data.amazonPolicy, {
					instanceType: [
						{
							cpuCores: testVmSize ? JSON.stringify(testVmSize.numOfCpu) : '',
							maxDiskSizeGB: testVmSize ? testVmSize.numOfDisks : 0,
							memory: testVmSize ? JSON.stringify(testVmSize.memoryInMB) : '',
							instanceType: {
								vmInstanceTypeName: _.get(testVmSize, 'name', '')
							}
						}
					]
				});

				data.deletionGracePeriodDays = 0; //delete immediately after expiration this is added for test failover
			}

			if (self.editMode) {
				data.entity.vmAllocPolicyId = self.policyId;
				self.updateReplicationTarget(data);
			} else {
				self.addReplicationTarget(data);
			}
		};

		self.destinationServerChanged = function(server) {
			if (server) {
				self.restoreData.globalOptions.server = angular.merge(
					{},
					{
						serverId: server.clientId,
						serverName: server.name
					},
					server
				);

				getProxyByClient(server.clientId);
			} else {
				self.restoreData.globalOptions.server = {};
			}
		};

		function getDefaultVMSuffixPrefixName() {
			return self.isReplicationPolicy($scope.vmPolicyAppType)
				? replTargetFactory.getDefaultVMSuffixPrefixName(self.vendor)
				: null;
		}
	}
];
serverMod.controller(controllers);
export default serverMod;
