import 'modules/servers/js/services/servers.svc.js';
import 'modules/vmManagement/js/controllers/lifeCyclePolicy/AutoScaleModal.ctrl.js';
import 'modules/vmManagement/js/factory/vmLifeCyclePolicy/lifeCyclePolicy.factory.js';
import 'modules/vmManagement/js/factory/vmLifeCyclePolicy/recoveryTargetActions.factory.js';
import 'vsa/js/factories/replication.factory.js';
import 'vsa/js/factories/vmActions.factory.js';
import 'vsa/js/services/restore.svc.js';
import 'vsa/js/services/restoreSettings.factory.js';
import 'modules/vmManagement/js/constants/vmLifeCyclePolicy.constants.js';
import 'vsa/js/constants/servers.constants.js';

import { vmManagementAppModule } from 'common/js/modules';

var vmManagementMod = vmManagementAppModule;

vmManagementMod.controller('policyDetailsController', [
	'$state',
	'$stateParams',
	'$scope',
	'restoreService',
	'serverService',
	'cvLoc',
	'cvUtil',
	'cvBreadcrumbsTabsFactory',
	'$uibModal',
	'$dialogs',
	'vmLifeCyclePolicyFactory',
	'recoveryTargetActionsFactory',
	'$log',
	'vmFactory',
	'replicationFactory',
	'restoreSettingsFactory',
	'VM_POLICY_APP_TYPE',
	'VSA_VENDOR',
	'settingsService',
	'ENTITY_TYPES',
	'VirtualMachineConstants',
	function(
		$state,
		$stateParams,
		$scope,
		restoreService,
		serverService,
		cvLoc,
		cvUtil,
		cvBreadcrumbsTabsFactory,
		$modal,
		$dialogs,
		vmLifeCyclePolicyFactory,
		recoveryTargetActionsFactory,
		$log,
		vmFactory,
		replicationFactory,
		restoreSettingsFactory,
		VM_POLICY_APP_TYPE,
		VSA_VENDOR,
		settingsService,
		ENTITY_TYPES,
		VirtualMachineConstants
	) {
		var breadCrumbs = [
			{
				title: cvLoc('label.lifeCyclePolicies'),
				link: '#lifeCyclePolicies'
			}
		];
		cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);

		var self = this;
		_init_();

		/* PUBLIC FUNCTIONS START */
		self.getFolderNameForId = vmFactory.getFolderNameForId;

		self.getPageUrl = function(filePath) {
			return appUtil.appRoot + 'modules/vmManagement/partials/lifeCyclePolicy/vendors/' + filePath;
		};

		self.showAutoScaleOptions = function() {
			var policyDetails = self.details;
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'modules/vmManagement/partials/lifeCyclePolicy/AutoScaleOptions.jsp',
				controller: 'autoScaleModalController as asModalCtrl',
				resolve: {
					browseParams: function() {
						return {
							details: policyDetails
						};
					}
				}
			});

			modalInstance.result.then(
				function(result) {
					$log.debug('Destination path selected: ');
				},
				function() {
					$log.debug('Cancel clicked');
				}
			);
		};

		self.isOracleCloudInfrastructure = function() {
			return !!self.details.entity.policyType === 'ORACLE_CLOUD_INFRASTRUCTURE';
		};

		self.isVMware = function() {
			return !!self.details.entity.policyType === 'VMWARE';
		};

		self.getUserNamesInCSV = function(users) {
			var userNamesInCSV = '';
			users &&
				users.forEach(function(user) {
					userNamesInCSV += user.userName + ', ';
				});

			return userNamesInCSV.length > 0 ? userNamesInCSV.substring(0, userNamesInCSV.lastIndexOf(',')) : '';
		};

		self.getUserGroupNamesInCSV = function(userGroups) {
			var userGroupNamesInCSV = '';
			userGroups &&
				userGroups.forEach(function(userGroup) {
					userGroupNamesInCSV += userGroup.userGroupName + ', ';
				});

			return userGroupNamesInCSV.length > 0
				? userGroupNamesInCSV.substring(0, userGroupNamesInCSV.lastIndexOf(','))
				: '';
		};

		self.getShapesInTarget = function(shapes) {
			var shapesInTarget = '';
			shapes &&
				shapes.forEach(function(shape) {
					shapesInTarget += shape.instanceType.vmInstanceTypeName + ', ';
				});

			return shapesInTarget.length > 0 ? shapesInTarget.substring(0, shapesInTarget.lastIndexOf(',')) : '';
		};

		self.getSubnetsInTarget = function(subnets) {
			var subnetsInTarget = '';
			subnets &&
				subnets.forEach(function(subnet) {
					subnetsInTarget += subnet.name + ', ';
				});

			return subnetsInTarget.length > 0 ? subnetsInTarget.substring(0, subnetsInTarget.lastIndexOf(',')) : '';
		};

		// Network settings
		self.editExistingNetworkSetting = function(existingNetworkSettingToEdit) {
			replicationFactory.openAddNetworkSettingsDialog(existingNetworkSettingToEdit, self.restoreData);
		};

		self.removeNetworkSetting = function(networkSetting) {
			restoreSettingsFactory.removeNetworkSetting(
				self.restoreData.vmOptions.networkAndIpAddressSettings.networkSettings,
				networkSetting
			);
			// check if there are no network Settings left in the grid then hide it
			if (self.restoreData.vmOptions.networkAndIpAddressSettings.networkSettings.length == 0) {
				self.restoreData.vmOptions.settings.networkSettingsLoaded = false;
			}
		};

		self.networkSettingsGridOptions = replicationFactory.createNetworkSettingsGrid('details.networkList');
		// Remove actions column from the grid
		self.networkSettingsGridOptions.gridOptions.columnDefs.splice(2, 1);

		self.ipAddressSettingsGridOptions = replicationFactory.createIpAddressSettingsGrid(
			'details.replication.ipAddressSettings'
		);

		self.openAddNetworkSettingsDialog = function(existingNetworkSettingToEdit) {
			replicationFactory.openAddNetworkSettingsDialog(existingNetworkSettingToEdit, self.restoreData);
		};

		self.openAddIpAddressSettingsDialog = function(existingIpAddressSettingToEdit) {
			self.restoreData.vmOptions.settings.ipAddressSettings = {
				sourceIpAddress: '',
				sourceSubnetMask: '',
				sourceDefaultGateway: '',
				destinationUseDHCP: false,
				destinationIpAddress: '',
				destinationSubnetMask: '',
				destinationDefaultGateway: '',
				destinationPrefDnsServer: '',
				destinationAltDnsServer: '',
				destinationPrefWinsServer: '',
				destinationAltWinsServer: ''
			};

			if (existingIpAddressSettingToEdit) {
				self.localizedTitle = cvLoc('label.editIpAddressSettings');
				self.existingIpAddressSettingToEdit = existingIpAddressSettingToEdit;
				self.existingIpAddressSettingToEditIndex = restoreSettingsFactory.findIpAddressSettingInList(
					self.restoreData.vmOptions.networkAndIpAddressSettings.ipAddressSettings,
					existingIpAddressSettingToEdit
				);

				self.restoreData.vmOptions.settings.ipAddressSettings = angular.copy(existingIpAddressSettingToEdit);
			} else {
				self.existingIpAddressSettingToEdit = null;
				self.existingIpAddressSettingToEditIndex = null;
				self.localizedTitle = cvLoc('label.addressSettings');
			}

			$modal.open({
				templateUrl: appUtil.appRoot + 'vsa/partials/addIpAddressSettingsModal.jsp',
				backdrop: 'static',
				scope: $scope,
				controller: [
					'$rootScope',
					'$scope',
					'$uibModalInstance',
					'$state',
					'cvLoc',
					'$log',
					function($rootScope, $scope, $modalInstance, $state, cvLoc, $log) {
						$rootScope.$on('addIpAddressSettingsCancelled', function() {
							$log.debug('received addIpAddressSettingsCancelled event - closing dialog');
							$modalInstance.dismiss('cancel');
						});

						$rootScope.$on('newIpAddressSettingsAdded', function(evt) {
							$log.debug('received newIpAddressSettingsAdded event - closing dialog');
							$modalInstance.dismiss();
						});
					}
				]
			});
		};

		self.openEditModal = function() {
			self.restoreData = getEditValues(self.details);

			return replicationFactory.showAddReplicationTarget({
				restoreData: self.restoreData,
				serverDetails: self.serverDetails,
				replicationTargetId: self.policyId
			});
		};

		self.getDestinationHostDisplayName = function(replicationDetails) {
			var destinationHostDisplayName;
			if (replicationDetails) {
				if (!!replicationDetails.region) {
					destinationHostDisplayName = replicationDetails.region;
				}
				if (!destinationHostDisplayName && replicationDetails.esxServers && replicationDetails.esxServers.length > 0) {
					destinationHostDisplayName = replicationDetails.esxServers[0].esxServerName;
				}
			}
			return destinationHostDisplayName;
		};
		/* PUBLIC FUNCTIONS END */

		/* PRIVATE FUNCTIONS START */
		function _init_() {
			self.restoreData = {};
			self.policyId = $stateParams['policyId'];
			self.defaultUIDisplay = cvLoc('label.autoSelect');
			if (cvConfig.showAutoScalePolicy) {
				self.EnableAutoScalePolicy = true;
			}
			const ROLE_MSP_USER = 'Role_MSP_User';
			const ROLE_TENANT_USER = 'Role_Tenant_User';
			const AzureResourceManagerVendor = 'AZURE_RESOURCE_MANAGER';

			self.showTestFailoverForAzure = !!cvConfig.showTestFailoverForAzure;
			self.showTestFailoverForAmazon = !!cvConfig.showTestFailoverForAmazon;

			restoreService.getReplicationTarget(self.policyId).success(function(details) {
				self.details = details;
				var policyData = details;

				// initialize values
				self.serverDetails = self.serverDetails || {};
				self.serverDetails.clientId = policyData.destinationHyperV.clientId;
				self.serverDetails.clientName = policyData.destinationHyperV.clientName;
				self.serverDetails.instanceId = policyData.dataCenter.instanceEntity.instanceId;
				self.destinationHostName = self.details.esxServers ? self.details.esxServers[0].esxServerName : '';
				self.dataStoreName = _.get(self.details, 'dataStores[0].dataStoreName', '');
				self.distributedStorageName = _.get(
					self.details,
					'HedvigDatastore[0].distributedStorage.distributedStorageName',
					''
				);
				self.showTestFailoverForAzure =
					!!cvConfig.showTestFailoverForAzure &&
					!(_.get(self, 'details.entity.policyType') === VirtualMachineConstants.VMAllocationPolicyType.AZURE_STACK);

				if (policyData.scaleOption) {
					self.autoScaleUp = policyData.scaleOption.autoScaleUp;
					self.autoScaleOut = policyData.scaleOption.autoScaleOut;
					self.autoPowerManagement = policyData.scaleOption.powerManagement;
					self.autoDeploymentEnabled = policyData.scaleOption.useForAutoDeployment;
				}
				self.vmAppPolicyType = policyData.vmPolicyAppType;
				self.showResourcePool = true;
				setAutoScaleParams(self.autoScaleUp, self.autoScaleOut, self.vmAppPolicyType);

				if (self.details.dataCenter && !!self.details.dataCenter.dataCenterName) {
					self.dataCenterName = self.details.dataCenter.dataCenterName;
				}
				var templateNames = '';
				angular.forEach(self.details.templates, function(template, key) {
					if (template.vmName) {
						templateNames += template.vmName;
						if (self.details.templates.length - 1 != key) {
							templateNames += ', ';
						}
					}
					switch (
						template.vmGUID
							.split(':')
							.slice(-1)
							.pop()
					) {
						case 'Linux':
							template.icon = 'azure-rm-icon linux';
							break;
						case 'Windows':
							template.icon = 'azure-rm-icon microsoft';
							break;
						default:
							template.icon = 'azure-rm-icon generic';
					}
				});
				self.templateNames = templateNames;

				self.policyData = policyData;

				if (details.entity.policyType === 'ORACLE_CLOUD_INFRASTRUCTURE') {
					// get flat model, to be used in jsp, based on the data returned
					// from server
					self.ociRTDetails = getOCIRTDetails(details);
					var compartmentDetials = self.details.esxServers[0].esxServerName.split('|');
					if (compartmentDetials.length == 2) {
						self.destinationHostName = compartmentDetials[1];
					}

					var subnetNames = '';
					if (self.details.networkInfo && self.details.networkInfo.length > 0) {
						angular.forEach(self.details.networkInfo[0].subnetNames, function(subnet, key) {
							if (subnet.name) {
								subnetNames += subnet.name;
								if (self.details.networkInfo[0].subnetNames.length - 1 != key) {
									subnetNames += ', ';
								}
							}
						});
						self.subnetNames = subnetNames;
					}
				}

				if (policyData.entity.policyType === 'RHEV') {
					self.redHatDetails = getredHatDetails(details);
					self.destinationHostLabel = cvLoc('label.destinationCluster');
				} else {
					self.destinationHostLabel = cvLoc('label.destinationHost');
					self.dataCenterNameLabel = cvLoc('label.dataCenter');
				}

				if (self.details.entity.policyType === 'AMAZON') {
					if (self.details.securityGroups.length > 0) {
						const appender = (acc, curr) => `${acc}, ${curr.name}`;
						self.details.securityGroups.displayName = self.details.securityGroups.reduce(appender, '').substr(2);
					}
				}

				if (
					policyData.entity.policyType === AzureResourceManagerVendor ||
					policyData.entity.policyType === VSA_VENDOR.AZURERM
				) {
					if (_.get(self, 'details.amazonPolicy.availabilityZones[0].availabilityZoneName', undefined) === '') {
						self.details.amazonPolicy.availabilityZones[0].availabilityZoneName = 'Auto';
					}
				}

				self.showDisplayName = true;

				var networkNames = '';
				if (policyData.networkList && policyData.networkList.length > 0) {
					angular.forEach(policyData.networkList, function(network, key) {
						if (network.destinationNetwork) {
							networkNames += network.destinationNetwork;
							if (policyData.networkList.length - 1 != key) {
								networkNames += ', ';
							}
						}
					});
				}
				var existingNetworknames = '';
				if (policyData.networkNames && policyData.networkNames.length > 0) {
					angular.forEach(policyData.networkNames, function(network, key) {
						if (network) {
							existingNetworknames += network;
							if (policyData.networkNames.length - 1 != key) {
								existingNetworknames += ', ';
							}
						}
					});
				}
				self.networkNames = networkNames;
				self.existingNetworkNames = existingNetworknames;
				if (self.existingNetworkNames) {
					self.details.existingNetworkNames = [
						{
							displayName: self.existingNetworkNames
						}
					];
				}
				self.details.networkNames = [
					{
						displayName: self.networkNames
					}
				];
				prepareNetworkDisplayNameForHyperV();
				self.policyAppType =
					self.details.vmPolicyAppType === VM_POLICY_APP_TYPE.REGULAR.type
						? VM_POLICY_APP_TYPE.REGULAR.name
						: VM_POLICY_APP_TYPE.REPLICATION.name;

				// If proxy is chosen to be auto selected set the UI string
				if (
					policyData.entity.policyType !== VSA_VENDOR.HYPERV &&
					(_.get(self, 'details.proxyClientEntity.clientId', 0) === 0 ||
						_.get(self, 'details.proxyClientEntity.clientId', 0) === details.destinationHyperV.clientId)
				) {
					details.proxyClientEntity.clientName = cvLoc('label.distributeWorkload');
				}
				//in-case of end user(MSP or tenant), if they does not have agent/administrative management permissions on the
				//destination hypervisor, they donot have recovery target edit capability.
				if (cv.userRole === ROLE_MSP_USER || cv.userRole === ROLE_TENANT_USER) {
					let administrativeMgmt = false;
					let agentMgmt = false;

					settingsService
						.getEntityCapabilities(self.serverDetails.clientId, ENTITY_TYPES.CLIENT_ENTITY, $stateParams._cn)
						.success(function(capabilitiesResponse) {
							for (var i = 0; i < capabilitiesResponse.length; i++) {
								var stringRep = capabilitiesResponse[i].permissionId.toString();
								if (capabilitiesResponse[i].permissionId === 1) {
									//checking for adiministrative management permission
									administrativeMgmt = true;
								} else if (capabilitiesResponse[i].permissionId === 2) {
									//checking for agent management permission
									agentMgmt = true;
								}
							}
							if (administrativeMgmt === false || agentMgmt === false) {
								self.hideEdit = true;
							} else {
								self.hideEdit = false;
							}
						});
				}

				self.permittedOptions = {
					entitySecurityData: { permissionIds: [] },
					entityType: ENTITY_TYPES.VM_ALLOCATION_POLICY_ENTITY,
					entity: angular.copy(self.details),
					entityId: self.details.entity.vmAllocPolicyId,
					entityName: self.details.entity.vmAllocPolicyName,
					permittedActionsList: recoveryTargetActionsFactory.computePermittedActions(self.details)
				};
			});
		}

		function prepareNetworkDisplayNameForHyperV() {
			self.networkDisplayNameForHyperV =
				_.get(self.details, 'networkList.length', 0) > 0
					? self.details.networkList.map(network => network.networkName).join(', ')
					: self.defaultUIDisplay;
		}

		function setAutoScaleParams(autoScaleUp, autoScaleOut, vmPolicyAppType) {
			const toggleStatus = {
				true: 'enabled-activity',
				false: 'disabled-activity'
			};
			self.autoScaleUp = autoScaleUp === true ? toggleStatus.true : toggleStatus.false;
			self.autoScaleOut = autoScaleOut === true ? toggleStatus.true : toggleStatus.false;

			if (vmPolicyAppType === 'AUTO_SCALE_MANAGEMENT') {
				self.policyCategory = 'Autoscale';
			}
		}

		function getEditValues(details) {
			var restoreData = {};
			if (details.entity.policyType === 'AMAZON') {
				restoreData = details;
			} else if (
				details.entity.policyType === 'AZURE_RESOURCE_MANAGER' ||
				details.entity.policyType === 'AZURE_STACK'
			) {
				var amazonPolicy = details.amazonPolicy;
				restoreData = getRestoreData(details);
				if (amazonPolicy && details) {
					var customizedRestoreData = vmFactory.modifyRestoreDataForAzure(details, amazonPolicy);
					restoreData.vmOptions = angular.merge({}, customizedRestoreData, restoreData.vmOptions);
				}
			} else if (details.entity.policyType === 'MICROSOFT') {
				restoreData = getHyperVRTDetails(details);
			} else if (details.entity.policyType === 'ORACLE_CLOUD_INFRASTRUCTURE') {
				restoreData = getOCIRTDetails(details);
			} else if (details.entity.policyType === 'OPENSTACK') {
				restoreData = getOpenStackDetails(details);
			} else if (details.entity.policyType === 'RHEV') {
				restoreData = getredHatDetails(details);
			} else if (details.entity.policyType === 'GOOGLE_CLOUD') {
				restoreData = getGoogleCloudDetails(details);
			} else {
				restoreData = getRestoreData(details);
			}
			if (vmLifeCyclePolicyFactory.getVendorByPolicyType(details.entity.policyType) === 'VMW') {
				restoreData.advanceOptions = {
					noOfVms: restoreData.vmOptions.noOfVms,
					minutesRetainUntil: restoreData.minutesRetainUntil,
					daysRetainUntil: restoreData.daysRetainUntil,
					isLiveMountEnabled: restoreData.isLiveMountEnabled,
					migrateVMs: restoreData.migrateVMs
				};

				restoreData.noOfCPUs = restoreData.vmOptions.noOfCPUs;
				restoreData.maxMemory = restoreData.vmOptions.maxMemory;

				if (details.associatedClientGroup) {
					restoreData.associatedClientGroup = details.associatedClientGroup;
				}

				if (details.networkNames) {
					restoreData.existingNetwork = details.existingNetworkNames;
				}
				restoreData.createIsolatedNetwork = details.createIsolatedNetwork;

				if (details.primaryGatewayNetwork) {
					restoreData.primaryGatewayNetwork = details.primaryGatewayNetwork;
				}

				if (details.isoInfo) {
					restoreData.vmOptions.isoInfo = {};

					for (var i = 0; i <= details.isoInfo.length - 1; i++) {
						if (details.isoInfo[i].osType.toLowerCase() === 'windows') {
							restoreData.vmOptions.isoInfo.windows = details.isoInfo[i];
						} else {
							restoreData.vmOptions.isoInfo.unix = details.isoInfo[i];
						}
					}

					//configureVirtualizeMe option should help to decide whether enable/disable associate server group or not.
					if (details.isoInfo && details.isoInfo.length > 0) {
						restoreData.configureVirtualizeMe = true;
						restoreData.advanceOptions.configureVirtualizeMe = true;
					}
				}

				if (details.mediaAgent) {
					restoreData.advanceOptions.mediaAgent = details.mediaAgent;
				}
			}

			if (details.vmPolicyAppType) {
				restoreData.vmPolicyAppType = details.vmPolicyAppType;
			} else {
				restoreData.vmPolicyAppType = VM_POLICY_APP_TYPE.REPLICATION.type;
			}
			return restoreData;
		}

		function getRestoreData(details) {
			return {
				entity: self.details.entity ? self.details.entity : {},
				replicationTargetName: details.entity.vmAllocPolicyName,
				displayNamePrefixSuffix: details.vmNameEditString,
				prefixSuffixSelector: details.vmNameEditType,
				replicationType: details.entity.policyType,
				globalOptions: {
					selectedProxy: [
						{
							clientId: details.proxyClientEntity.clientId,
							clientName: details.proxyClientEntity.clientName
						}
					],
					showVirtualizeMe: !!(details.isoInfo && details.isoInfo.length)
				},
				vmOptions: {
					destinationHost:
						details.esxServers &&
						details.esxServers.map(function(obj) {
							return {
								entity: {
									name: obj.esxServerName,
									type: details.region ? 'CLUSTER' : ''
								},
								displayName: self.getDestinationHostDisplayName(details)
							};
						}),
					dataCenter: {
						dataCenterName: details.dataCenter.dataCenterName,
						dataCenterId: details.dataCenter.dataCenterId
					},
					dataStore: {
						dataStoreName: details.dataStores.length > 0 ? details.dataStores[0].dataStoreName : ''
					},
					resourcePool: {
						resourcePoolPath: details.resourcePoolPath
					},
					folderPath: details.folderPath,
					networkAndIpAddressSettings: {
						networkSettings: details.networkList || []
					},
					networkList: details.networkList || [],
					settings: {
						networkSettings:
							details.networkList && details.networkList.length
								? details.networkList[0]
								: {
										sourceNetwork: '',
										destinationNetwork: ''
								  },
						ipAddressSettings: {
							sourceIpAddress: '',
							sourceSubnetMask: '',
							sourceDefaultGateway: '',
							destinationUseDHCP: false,
							destinationIpAddress: '',
							destinationSubnetMask: '',
							destinationDefaultGateway: '',
							destinationPreferredDnsServer: '',
							destinationAlternateDnsServer: '',
							destinationPreferredWinsServer: '',
							destinationAlternateWinsServer: ''
						}
					},
					vsMetaData: {
						vcloudOrgName: false,
						vcloudOrgVdcName: false,
						vcloudVappName: false,
						vcloudOwner: false,
						vcloudNics: false
					},
					restoreNetwork: details.restoreNetworkName,
					noOfCPUs: details.maxCores,
					maxMemory: details.maxMemory,
					noOfVms: details.maxVMQuota,
					createPublicIP: details.isPublicIPSettingsAllowed,
					restoreAsManagedVM: details.restoreAsManagedVM,
					templates: details.templates
				},
				showVirtualLab:
					details.createIsolatedNetwork || details.minutesRetainUntil || details.daysRetainUntil || details.migrateVMs
						? true
						: false,
				gatewayTemplate: details.gatewayTemplate,
				createIsolatedNetwork: details.createIsolatedNetwork ? true : false,
				minutesRetainUntil: details.minutesRetainUntil,
				daysRetainUntil: details.daysRetainUntil,
				migrateVMs: details.migrateVMs,
				securityAssociations: details.securityAssociations,
				isLiveMountEnabled: details.isLiveMountEnabled,
				expirationTime: !!details.minutesRetainUntil ? 'Hours' : 'Days'
			};

			if (details.isoInfo && details.isoInfo.length) {
				details.isoInfo.forEach(function(isoInfoObj) {
					if (isoInfoObj.osType === 'WINDOWS') {
						restoreData.vmOptions.isoInfo.windows = isoInfoObj;
					} else if (isoInfoObj.osType === 'UNIX') {
						restoreData.vmOptions.isoInfo.unix = isoInfoObj;
					}
				});
			}
		}

		function getAmazonRTDetails(rtDetails) {
			var amazonRTDetails = {};
			if (rtDetails) {
				if (rtDetails.amazonPolicy) {
					if (rtDetails.amazonPolicy.availabilityZones && rtDetails.amazonPolicy.availabilityZones.length > 0) {
						amazonRTDetails.availabilityZone = rtDetails.amazonPolicy.availabilityZones[0].availabilityZoneName;
					}
					if (rtDetails.amazonPolicy.instanceType && rtDetails.amazonPolicy.instanceType.length > 0) {
						amazonRTDetails.instanceType = rtDetails.amazonPolicy.instanceType[0].instanceType.vmInstanceTypeName;
					}
				}
				if (rtDetails.dataStores && rtDetails.dataStores.length > 0) {
					amazonRTDetails.amazonBucket = rtDetails.dataStores[0].dataStoreName;
				}
				if (rtDetails.networkList && rtDetails.networkList.length > 0) {
					amazonRTDetails.networkSettings = rtDetails.networkList[0].name; // replication
					// target
					// .x
					// has
					// network
					// path
					// in
					// "name"
					// node
				}

				if (rtDetails.vmCredentials) {
					amazonRTDetails.vmCredentials = rtDetails.vmCredentials; // replication
					// target
					// .x
					// has
					// network
					// path
					// in
					// "name"
					// node
				}

				if (rtDetails.securityGroups && rtDetails.securityGroups.length > 0) {
					amazonRTDetails.securtiyGroups =
						rtDetails.securityGroups[0].name !== '' && rtDetails.securityGroups[0].name
							? rtDetails.securityGroups[0].groupId + '|' + rtDetails.securityGroups[0].name
							: rtDetails.securityGroups[0].groupId;
				}
				amazonRTDetails.securityAssociations = rtDetails.securityAssociations;
			}
			return amazonRTDetails;
		}

		function getHyperVRTDetails(rtDetails) {
			var hyperVRTDetails = {};
			const restoreLocationEnum = {
				selectedFolder: 'selectedFolder',
				defaultFolder: 'defaultFolder'
			};

			if (rtDetails) {
				hyperVRTDetails.dataStores = rtDetails.dataStores && rtDetails.dataStores.length ? rtDetails.dataStores[0] : '';
				hyperVRTDetails.selectedHypervisor = rtDetails.destinationHyperV;

				let instanceId = _.get(rtDetails, 'dataCenter.instanceEntity.instanceId');
				if (instanceId) {
					hyperVRTDetails.selectedHypervisor = angular.merge(
						{},
						{
							type: VSA_VENDOR.HYPERV,
							instanceId: instanceId
						},
						hyperVRTDetails.selectedHypervisor
					);
				}

				hyperVRTDetails.proxyClientEntity = rtDetails.proxyClientEntity;
				hyperVRTDetails.prefixSuffixSelector = rtDetails.vmNameEditType;
				hyperVRTDetails.displayNamePrefixSuffix = rtDetails.vmNameEditString;
				hyperVRTDetails.entity = rtDetails.entity;
				hyperVRTDetails.replicationTargetName = rtDetails.entity.vmAllocPolicyName;
				rtDetails.dataStores && rtDetails.dataStores[0].dataStoreName !== ''
					? (hyperVRTDetails.isDefaultFolder = false)
					: (hyperVRTDetails.isDefaultFolder = true);
				hyperVRTDetails.isDefaultFolder
					? (hyperVRTDetails.restoreLocation = restoreLocationEnum.defaultFolder)
					: (hyperVRTDetails.restoreLocation = restoreLocationEnum.selectedFolder);
				hyperVRTDetails.vmOptions = {
					networkSettingsAdapter: rtDetails.networkList && rtDetails.networkList.length ? rtDetails.networkList : []
				};
				hyperVRTDetails.securityAssociations = rtDetails.securityAssociations;
				hyperVRTDetails.advanceOptions = {
					noOfCPUs: rtDetails.maxCores,
					maxMemory: rtDetails.maxMemory,
					noOfVms: rtDetails.maxVMQuota,
					minutesRetainUntil: rtDetails.minutesRetainUntil
				};
			}
			return hyperVRTDetails;
		}

		function getOCIRTDetails(rtDetails) {
			var ociRTDetails = {};
			if (rtDetails) {
				ociRTDetails.selectedHypervisor = rtDetails.destinationHyperV;
				ociRTDetails.proxyClientEntity = rtDetails.proxyClientEntity;
				ociRTDetails.prefixSuffixSelector = rtDetails.vmNameEditType;
				ociRTDetails.displayNamePrefixSuffix = rtDetails.vmNameEditString;
				ociRTDetails.entity = rtDetails.entity;
				ociRTDetails.replicationTargetName = rtDetails.entity.vmAllocPolicyName;
				ociRTDetails.vmOptions = {
					Datastore: rtDetails.dataStores && rtDetails.dataStores.length ? rtDetails.dataStores[0].dataStoreName : '', // Ava
					// domain
					vmSize: rtDetails.amazonPolicy.instanceType, // shape
					nics: [
						{
							// vcn and subnet
							label: rtDetails.networkInfo[0].label,
							networkName: rtDetails.networkInfo[0].networkName,
							subnetNames: rtDetails.networkInfo[0].subnetNames
						}
					],
					createPublicIP: rtDetails.isPublicIPSettingsAllowed
				};
				//Before Sp17: AvailabilityDomain were stored in availabilityZones field, so caching it here for upgrade cases.
				let availabilityDomain = _.get(rtDetails, 'amazonPolicy.availabilityZones[0].availabilityZoneName');
				if (!ociRTDetails.vmOptions.Datastore && !!availabilityDomain) {
					ociRTDetails.vmOptions.Datastore = availabilityDomain;
					rtDetails.dataStores = [{ dataStoreName: availabilityDomain }];
				}
				// staging bucket
				if (rtDetails.resourcePoolPath) {
					ociRTDetails.vmOptions.stagingBucket = rtDetails.resourcePoolPath;
				}
				if (rtDetails.keyPairs && rtDetails.keyPairs.length) {
					ociRTDetails.vmOptions.sshKeyFileLabel = rtDetails.keyPairs[0].name;
					ociRTDetails.vmOptions.sshKeyData = rtDetails.keyPairs[0].path;
				}

				// compartment
				if (rtDetails.esxServers && rtDetails.esxServers[0].esxServerName) {
					var compartmentDetails = rtDetails.esxServers[0].esxServerName.split('|');
					if (compartmentDetails.length == 2) {
						ociRTDetails.vmOptions.esxHost = compartmentDetails[0];
						ociRTDetails.esxHostDiplayName = compartmentDetails[1];
					}
				}

				let imagesList = [];
				if (rtDetails.templates && rtDetails.templates.length > 0) {
					angular.forEach(rtDetails.templates, function(template) {
						if (template.vmGUID) {
							let image = {
								strGUID: template.vmGUID,
								name: template.vmName
							};
							imagesList.push(image);
						}
					});
				}

				if (imagesList && imagesList.length) {
					ociRTDetails.vmOptions.selectedImages = imagesList;
				}

				ociRTDetails.securityAssociations = rtDetails.securityAssociations;
			}

			return ociRTDetails;
		}

		function getOpenStackDetails(replicationDetails) {
			var openstackDetails = {};
			if (replicationDetails) {
				(openstackDetails.entity = self.details.entity ? self.details.entity : {}),
					(openstackDetails.replicationTargetName = replicationDetails.entity.vmAllocPolicyName),
					(openstackDetails.displayNamePrefixSuffix = replicationDetails.vmNameEditString),
					(openstackDetails.prefixSuffixSelector = replicationDetails.vmNameEditType),
					(openstackDetails.replicationType = replicationDetails.entity.policyType),
					(openstackDetails.globalOptions = {
						selectedProxy: [
							{
								clientId: replicationDetails.proxyClientEntity.clientId,
								clientName: replicationDetails.proxyClientEntity.clientName
							}
						]
					}),
					(openstackDetails.vmOptions = {
						destinationHost: replicationDetails.esxServers.map(function(obj) {
							return {
								entity: {
									name: obj.esxServerName,
									type: replicationDetails.region ? 'CLUSTER' : ''
								},
								displayName: self.getDestinationHostDisplayName(replicationDetails)
							};
						}),
						dataStores: replicationDetails.dataStores,
						keyPairs: replicationDetails.keyPairs,
						networkLists: replicationDetails.networkList,
						securityGroups: replicationDetails.securityGroups,
						flavors: replicationDetails.amazonPolicy.vmInstanceTypes,
						dataStoreList: replicationDetails.dataStores
					});
			}

			return openstackDetails;
		}

		function getGoogleCloudDetails(replicationDetails) {
			let googleClooudDetails = {};
			if (replicationDetails) {
				let destination =
					replicationDetails.zone && replicationDetails.zone.primaryZoneName
						? replicationDetails.zone.primaryZoneName.split('\\')
						: [];
				let dataStore = _.get(replicationDetails, 'dataStores[0]', []);
				(googleClooudDetails.entity = self.details.entity ? self.details.entity : {}),
					(googleClooudDetails.selectedHypervisor = replicationDetails.destinationHyperV),
					(googleClooudDetails.replicationTargetName = replicationDetails.entity.vmAllocPolicyName),
					(googleClooudDetails.displayNamePrefixSuffix = replicationDetails.vmNameEditString),
					(googleClooudDetails.prefixSuffixSelector = replicationDetails.vmNameEditType),
					(googleClooudDetails.replicationType = replicationDetails.entity.policyType),
					(googleClooudDetails.securityAssociations = replicationDetails.securityAssociations),
					(googleClooudDetails.globalOptions = {
						selectedProxy: [
							{
								clientId: replicationDetails.proxyClientEntity.clientId,
								clientName: replicationDetails.proxyClientEntity.clientName
							}
						]
					}),
					(googleClooudDetails.vmOptions = {
						destinationHost: {
							entity: {
								name: _.get(destination, '[1]')
							},
							project: {
								name: _.get(destination, '[0]'),
								strGUID: _.get(destination, '[0]')
							},
							region: {
								name: dataStore.dataStoreName
							},
							replicaZones: [_.get(destination, '[1]')],
							displayName: _.get(destination, '[1]'),
							secondaryZones: [{ name: replicationDetails.zone.secondaryZoneName }]
						},
						machineType: replicationDetails.machineType,
						nics: replicationDetails.networkList,
						networkList: replicationDetails.networkList
					});
				if (_.get(googleClooudDetails, 'vmOptions.nics[0]', false)) {
					googleClooudDetails.vmOptions.nics[0].subnet = googleClooudDetails.vmOptions.nics[0].name;
				}
				googleClooudDetails.vmOptions.createPublicIP = replicationDetails.isPublicIPSettingsAllowed;
				if (_.get(replicationDetails, 'zone.secondaryZoneName')) {
					googleClooudDetails.vmOptions.destinationHost.replicaZones.push(replicationDetails.zone.secondaryZoneName);
					googleClooudDetails.vmOptions.multipleZones = true;
				}
			}

			return googleClooudDetails;
		}

		function getredHatDetails(policyDetails) {
			var redHatDetails = {};
			if (policyDetails) {
				redHatDetails.selectedHypervisor = policyDetails.destinationHyperV;
				redHatDetails.proxyClientEntity = policyDetails.proxyClientEntity;
				redHatDetails.prefixSuffixSelector = policyDetails.vmNameEditType;
				redHatDetails.displayNamePrefixSuffix = policyDetails.vmNameEditString;
				redHatDetails.entity = policyDetails.entity;
				redHatDetails.replicationTargetName = policyDetails.entity.vmAllocPolicyName;
				redHatDetails.networkNames = policyDetails.networkNames;
				redHatDetails.isLiveMountEnabled = policyDetails.isLiveMountEnabled;
				redHatDetails.securityAssociations = policyDetails.securityAssociations;
				redHatDetails.advanceOptions = {
					noOfCPUs: policyDetails.maxCores,
					maxMemory: policyDetails.maxMemory,
					noOfVms: policyDetails.maxVMQuota,
					minutesRetainUntil: policyDetails.minutesRetainUntil
				};
				if (policyDetails.mediaAgent) {
					redHatDetails.advanceOptions.mediaAgent = policyDetails.mediaAgent;
				}
				if (policyDetails.esxServers && policyDetails.esxServers.length > 0) {
					redHatDetails.esxServers = policyDetails.esxServers[0].esxServerName;
				}
			}
			return redHatDetails;
		}

		/* PRIVATE FUNCTIONS END */
	}
]);

export default vmManagementMod;
