import { vmManagementAppModule } from 'common/js/modules';
import 'vsa/js/directives/cv-availability-zones-directive.js';
import 'modules/vmManagement/js/factory/vmLifeCyclePolicy/lifeCyclePolicy.factory.js';

var vmManagementMod = vmManagementAppModule;

var controllers = {};

controllers.regionDetailOptions = [
	'cvUtil',
	'cvLoc',
	'$uibModalInstance',
	'$uibModal',
	'cvToaster',
	'$state',
	'serverService',
	'browseParams',
	'vmLifeCyclePolicyFactory',
	function(
		cvUtil,
		cvLoc,
		$modalInstance,
		$modal,
		cvToaster,
		$state,
		serverService,
		browseParams,
		vmLifeCyclePolicyFactory
	) {
		const self = this;

		let securityGroupLoadingISteven = loadingISteven('groupName');
		let subnetLoadingISteven = loadingISteven('label');
		let networkIdLoadingISteven = loadingISteven('networkName');
		let storageAccountLoadingISteven = loadingISteven('dataStoreName');
		let keyPairLoadingISteven = loadingISteven('keyName');
		let editMode = false;
		let rowData = {}; // holds a copy of the rowData in case of edit
		self.vendor = vmLifeCyclePolicyFactory.getVendorByPolicyType(
			_.get(browseParams.policyDetails, 'entity.policyType')
		);
		self.isAzureRM = vmLifeCyclePolicyFactory.isAzureRM(self.vendor);
		self.isAmazon = vmLifeCyclePolicyFactory.isAmazon(self.vendor);
		self.showKeyPairOptionInAWSAutoScaleSettings = cvConfig.showKeyPairOptionInAWSAutoScaleSettings;
		let regionSpecificInfo = browseParams.policyDetails.scaleOption.scaleOutParam.regionSpecificInfo || [];
		let selectedRegions = regionSpecificInfo.map(region => region.regionName);
		const notSet = 'Not set';

		function _init_() {
			self.model = {
				/* inputs */
				securityGroups: [],
				subnets: [],
				networkIds: [],
				availabilityZone: '',
				keyPairs: [],
				/* functions */
				getSelectedNetwork: function() {
					if (this.networkId && this.networkId.length > 0) {
						return this.networkId[0];
					} else {
						return {};
					}
				},
				resourceGroupName: _.get(browseParams.policyDetails, 'esxServers[0].esxServerName')
			};

			if (browseParams.rowData && browseParams.rowData.editMode) {
				editMode = true;
				rowData = angular.copy(browseParams.rowData);
				if (_.get(rowData, 'securityGroups.length', 0) > 0) {
					rowData.securityGroups.forEach(sg => (sg.groupName = sg.name));
				}
				self.model.regionName = rowData.regionName;
				self.model.availabilityZone = rowData.availabilityZone;

				//for azure we can call populate region/network/securityGroups by default
				if (self.isAmazon) {
					getNetworkAndSecurityGroup();
					getKeyPairs();
				}
			}

			if (self.isAzureRM) {
				self.loadRegions();
			}
		}

		self.loadRegionDefault = function() {
			let isPreviousSelectedRegioAvailable = false;
			if (_.isArray(self.model.azureRegionList)) {
				if (!!self.model.regionName) {
					for (var i = 0; i < self.model.azureRegionList.length; i++) {
						if (
							self.model.regionName === self.model.azureRegionList[i].guid ||
							self.model.regionName === self.model.azureRegionList[i].displayName
						) {
							self.model.azureRegionList[i].selected = isPreviousSelectedRegioAvailable = true;
							break;
						}
					}
				}
			}

			if (isPreviousSelectedRegioAvailable) {
				self.getStorageAccounts();
				getNetworkAndSecurityGroup();
			}
		};

		self.setRegion = function(selectedRegion) {
			if (selectedRegions.includes(selectedRegion.guid)) {
				self.selectContentErr = {
					selectedRegion: {
						message: cvLoc('error.duplicateRegion', selectedRegion.displayName)
					}
				};
				self.model.regionName = undefined;
				self.duplicateRegionNameSet = true;
			} else {
				self.selectContentErr = {
					selectedRegion: {}
				};
				self.duplicateRegionNameSet = false;
				self.model.regionName = selectedRegion.guid;
				self.getStorageAccounts();
				getNetworkAndSecurityGroup();
			}
		};

		self.loadRegions = function() {
			// Reset data
			self.azureRegionList = null;

			let vendor = self.vendor;
			let serverId = browseParams.serverID;
			let regionInventoryPath = '\\NONE:Regions';

			serverService
				.vsaInventoryBrowse(serverId, regionInventoryPath)
				.success(function(data) {
					self.model.azureRegionList = data;
					self.loadRegionDefault();
				})
				.error(function(err) {
					self.errorMessage = 'Regions could not be loaded';
				});
		};

		function showStorageAccounts() {
			if (_.isArray(self.model.storageAccounts)) {
				if (!!rowData.storageAccount) {
					for (var i = 0; i < self.model.storageAccounts.length; i++) {
						if (rowData.storageAccount === self.model.storageAccounts[i].dataStoreName) {
							self.model.storageAccounts[i].selected = true;
							break;
						}
					}
				}
			}
		}

		self.getStorageAccounts = function() {
			resetValues('storageAccount');
			self.model.storageAccounts.push(storageAccountLoadingISteven);
			let hostname = '|' + self.model.regionName;
			serverService.getAzureStorageOptions(browseParams.serverID, hostname, undefined, self.vendor).then(
				function(data) {
					if (data && data.data.length > 0) {
						let storageAccounts = _.sortBy(data.data, 'dataStoreName');
						self.model.storageAccounts = storageAccounts;
						showStorageAccounts();
					} else {
						resetValues('storageAccount');
					}
				},
				function(err) {
					if (!err.data) {
						err.data = cvLoc('generic_error');
					}
					resetValues('storageAccount');
				}
			);
		};

		self.openAvailabilityZoneDialog = function() {
			var modalInstance = $modal.open({
				templateUrl: appUtil.appRoot + 'vsa/partials/selectRestoreAvailabilityZoneModal.jsp',
				backdrop: 'static',
				controller: [
					'$scope',
					'$uibModalInstance',
					'cvLoc',
					'destinationHostData',
					'server',
					'selectedRegions',
					function($scope, $modalInstance, cvLoc, destinationHostData, server, selectedRegions) {
						$scope.server = server;

						$scope.cancel = function() {
							$modalInstance.dismiss('cancel');
						};

						$scope.select = function() {
							let selected = {};
							if (destinationHostData.selection.length > 0) {
								selected = destinationHostData.selection[0];
							} else {
								/* Initialize selected to avoid null checks */
								selected = {
									entity: {},
									parent: {
										entity: {}
									}
								};
							}

							/*
							 * Indicates duplication region selection
							 */
							if (selectedRegions.includes(selected.parent.entity.strGUID)) {
								const result = {
									duplicationRegion: true,
									regionName: selected.parent.entity.strGUID
								};
								$modalInstance.close(result);
							} else {
								const result = {
									availabilityZone: selected.entity.name,
									regionName: selected.parent.entity.strGUID
								};
								$modalInstance.close(result);
							}
						};
					}
				],
				resolve: {
					server: function() {
						return {
							clientId: browseParams.serverID,
							vendor: self.vendor
						};
					},
					selectedRegions: function() {
						/*
						 * List of all the selected regions is returned to avoid duplication selection of
						 * region
						 */
						let regionSpecificInfo = browseParams.policyDetails.scaleOption.scaleOutParam.regionSpecificInfo || [];
						let selectedRegions = regionSpecificInfo.map(region => region.regionName);
						if (editMode) {
							const index = selectedRegions.indexOf(self.model.regionName);
							selectedRegions.splice(index, 1);
						}
						return selectedRegions;
					}
				}
			});

			/*
			 * If duplicate region selection, shown an error message. Else, save the region and the
			 * availability zone information
			 */
			modalInstance.result.then(function(result) {
				if (result.duplicationRegion) {
					self.selectContentErr = {
						selectedZone: {
							message: cvLoc('error.duplicateRegion', result.regionName)
						}
					};
				} else {
					self.selectContentErr = {};
					self.model.availabilityZone = result.availabilityZone;
					self.model.regionName = result.regionName;
					getNetworkAndSecurityGroup();
					getKeyPairs();
				}
			});
		};

		//This function sets the I/P model of the available network IDs(VPCs) for the respective regions
		function getNetworkID(data) {
			self.model.networkIds = data;
			if (editMode) {
				let networkId = self.isAzureRM ? rowData.networkId : rowData.vpc;
				var indexToSelect = self.model.networkIds.findIndex(network => network.networkId === networkId);
				self.model.networkIds[indexToSelect].selected = true;
				self.model.networkId = [self.model.networkIds[indexToSelect]];

				if (!self.isAzureRM) {
					showSecurityGroups();
				}
				showSubnets();
			}
		}

		/*
		 * Called on select of a VPC. Sets the available security group's of the vpc Sets the available
		 * subnets of the vpc
		 */
		self.setNetworkId = function(data) {
			if (!self.isAzureRM) {
				showSecurityGroups();
			}
			showSubnets();
		};

		/*
		 * Shows the list of available security groups for the selected vpc. In case of edit, set the existing
		 * value as selected.
		 */
		function showSecurityGroups() {
			let securityGroupObj = [];
			let selectedNetwork;

			if (!self.isAzureRM) {
				selectedNetwork = self.model.getSelectedNetwork();
				securityGroupObj = self.resultData.find(data => data.networkId === selectedNetwork.networkId) || {};
				securityGroupObj = securityGroupObj.securityGroups || [];
				self.model.securityGroups = securityGroupObj;
			} else {
				securityGroupObj.push({
					groupId: 0,
					groupName: notSet
				});

				securityGroupObj.push({
					groupName: cvLoc('label.networkSecurityGroup'),
					msGroup: true
				});
				securityGroupObj = securityGroupObj.concat(self.model.securityGroups);
				securityGroupObj.push({ msGroup: false });

				self.model.securityGroups = securityGroupObj;
			}
			if (securityGroupObj.length < 1) {
				self.model.securityGroups.push({
					id: 0,
					groupName: cvLoc('msg.nosecurityGroupsAvailable'),
					selected: true,
					disableSelection: true
				});
			}

			if (editMode) {
				rowData.securityGroups.forEach(selectedSG => {
					var found = self.model.securityGroups.find(sg => sg.groupName === selectedSG.groupName);
					if (found) {
						found.selected = true;
					}
				});
			}
		}
		function getSecurityGroup() {
			self.model.securityGroups.push(securityGroupLoadingISteven);
			var serverDetailsInfo = {
				clientId: browseParams.serverID,
				serverName: ''
			};
			let hostname = '|' + self.model.regionName;

			serverService.getSecurityGroups(serverDetailsInfo, hostname, self.vendor).then(
				function(data) {
					if (data && data.data.length > 0) {
						let securityGroups = _.sortBy(data.data, 'groupName');
						self.model.securityGroups = securityGroups;
						showSecurityGroups();
					} else {
						resetValues('sg');
					}
				},
				function(err) {
					if (!err.data) {
						err.data = cvLoc('generic_error');
					}
					resetValues('sg');
				}
			);
		}

		function getNetworkAndSecurityGroup() {
			resetValues('sg');
			self.model.networkIds.push(networkIdLoadingISteven);
			var serverDetailsInfo = {
				clientId: browseParams.serverID,
				serverName: ''
			};
			let hostname = self.isAzureRM ? '|' + self.model.regionName : self.model.availabilityZone;

			if (self.isAzureRM) {
				getSecurityGroup();
			}

			serverService.getNetworkInfo(serverDetailsInfo, hostname, self.vendor).then(
				function(data) {
					if (data && data.data.length > 0) {
						sortContents(data.data);
						self.resultData = angular.copy(data.data);
						getNetworkID(data.data);
					} else {
						resetValues('vpc');
					}
				},
				function(err) {
					if (!err.data) {
						err.data = cvLoc('generic_error');
					}
					resetValues('vpc');
				}
			);
		}

		function getKeyPairs() {
			if (!self.showKeyPairOptionInAWSAutoScaleSettings) return;
			resetValues('keyPairs');
			self.model.keyPairs.push(keyPairLoadingISteven);
			let serverDetailsInfo = {
				clientId: browseParams.serverID,
				serverName: ''
			};
			let hostname = self.model.availabilityZone;
			let serverId = browseParams.serverID;
			serverService.getKeyPairs(serverId, serverDetailsInfo, hostname, self.vendor).then(
				function(response) {
					if (_.get(response, 'data.length', 0) > 0) {
						sorter(response.data, 'keyId');
						let keyPairsObj = [];
						keyPairsObj.push({
							groupId: 0,
							keyName: notSet
						});
						keyPairsObj.push({
							keyName: cvLoc('label.keyPair'),
							msGroup: true
						});
						keyPairsObj = keyPairsObj.concat(response.data);
						keyPairsObj.push({ msGroup: false });
						self.model.keyPairs = keyPairsObj;
						if (editMode) {
							let indexToSelect = self.model.keyPairs.findIndex(
								keyPairObject => keyPairObject.keyName === rowData.keyPairName
							);
							indexToSelect = indexToSelect == -1 ? 0 : indexToSelect;
							self.model.keyPairs[indexToSelect].selected = true;
							self.model.keyPair = [self.model.keyPairs[indexToSelect]];
						}
					} else {
						resetValues('keyPairs');
					}
				},
				function(err) {
					if (!err.data) {
						err.data = cvLoc('generic_error');
					}
					resetValues('keyPair');
				}
			);
		}

		/*
		 * Shows the list of available subnets for the selected vpc. In case of edit, set the existing value
		 * as selected.
		 */
		function showSubnets() {
			var selectedNetwork = self.model.getSelectedNetwork();
			var subnetObj = self.resultData.find(data => data.networkId === selectedNetwork.networkId) || {};
			subnetObj = subnetObj.subnets || [];
			self.model.subnets = subnetObj;

			if (subnetObj.length < 1) {
				self.model.subnets.push({
					id: 0,
					subnetId: cvLoc('msg.nosubnetsAvailable'),
					selected: true,
					disableSelection: true,
					label: cvLoc('msg.nosubnetsAvailable')
				});
			}
			self.model.subnets.forEach(subnet => {
				if (_.isEmpty(subnet.label)) {
					subnet.label = subnet.name;
				}
				if (_.isEmpty(subnet.label)) {
					subnet.label = subnet.subnetId;
				}
			});

			if (editMode) {
				var found = self.model.subnets.find(
					subnet => subnet.subnetId === rowData.subnetId || subnet.name === rowData.subnetId
				);
				if (found) {
					found.selected = true;
				}
			}
		}

		self.save = function() {
			let subetnetId = _.get(self.model, 'subnet[0].subnetId', '');
			let subnetName = _.get(self.model, 'subnet[0].name', subetnetId);
			let regionDetails = {
				regionName: self.model.regionName || '',
				availabilityZone: self.model.availabilityZone || '',
				vpc: _.get(self.model, 'networkId[0].networkId', ''),
				securityGroups:
					_.get(self.model, 'securityGroup[0].groupName', '') === notSet ? [] : self.model.securityGroup || [],
				subnetId: subetnetId,
				subnetName: subnetName,
				subnetLabel: _.get(self.model, 'subnet[0].label', ''),
				networkId: _.get(self.model, 'networkId[0].networkId', ''),
				networkName: _.get(self.model, 'networkId[0].networkName', ''),
				storageAccount: _.get(self.model, 'storageAccount[0].dataStoreName', ''),
				keyPairName: _.get(self.model, 'keyPair[0].keyName', notSet) === notSet ? '' : self.model.keyPair[0].keyName
			};
			regionDetails.securityGroups.forEach(sg => (sg.name = sg.groupName));
			if (!!regionDetails) {
				self.selectContentErr = {};
				let errorExists = false;

				if (!self.isAzureRM) {
					if (!regionDetails.availabilityZone) {
						self.selectContentErr.selectedZone = cvUtil.errMsg(cvLoc('error.availabilityZone'));
						errorExists = true;
					}

					if (!regionDetails.vpc) {
						self.selectContentErr.selectedVPC = cvUtil.errMsg(cvLoc('error.vpc'));
						errorExists = true;
					}

					if (
						!regionDetails.securityGroups ||
						regionDetails.securityGroups.length === 0 ||
						regionDetails.securityGroups.filter(sg => sg.disableSelection).length > 0
					) {
						self.selectContentErr.selectedSecurityGroup = cvUtil.errMsg(cvLoc('error.securityGroups'));
						errorExists = true;
					}
				} else {
					if (!self.duplicateRegionNameSet) {
						if (!regionDetails.regionName) {
							self.selectContentErr.selectedRegion = cvUtil.errMsg(cvLoc('error.region'));
							errorExists = true;
						}
					} else {
						errorExists = true;
					}

					if (!regionDetails.networkId) {
						self.selectContentErr.selectedVPC = cvUtil.errMsg(cvLoc('error.networkName'));
						errorExists = true;
					}
					if (!regionDetails.storageAccount) {
						self.selectContentErr.selectedStorageAccount = cvUtil.errMsg(cvLoc('error.storageAccount'));
						errorExists = true;
					}
				}

				if (!regionDetails.subnetId || self.model.subnet.filter(sg => sg.disableSelection).length > 0) {
					errorExists = true;
					self.selectContentErr.subnet = cvUtil.errMsg(cvLoc('error.subnet'));
				}

				if (errorExists) {
					return;
				}
			}

			if (editMode) {
				regionDetails.editMode = editMode;
				regionDetails.index = browseParams.rowData.index;
			}

			$modalInstance.close(regionDetails);
		};

		self.cancel = function() {
			$modalInstance.dismiss('cancel');
		};

		_init_();

		/*
		 * Resets the value of the inputs and selected values to empty.
		 */
		function resetValues(level) {
			switch (level) {
				case 'zone':
					self.model.region = [];
					self.model.availabilityZone = '';
					resetValues('vpc');
					break;
				case 'vpc':
					self.model.networkIds = [];
					self.model.networkId = [];
					if (self.isAzureRM) {
						resetValues('subnet');
					} else {
						resetValues('sg');
					}
					break;
				case 'sg':
					self.model.securityGroups = [];
					self.model.securityGroup = [];
					if (!self.isAzureRM) {
						resetValues('subnet');
					}
					break;
				case 'subnet':
					self.model.subnets = [];
					self.model.subnet = [];
					break;
				case 'storageAccount':
					self.model.storageAccounts = [];
					self.model.storageAccount = [];
					break;
				case 'keyPairs':
					self.model.keyPairs = [];
					self.model.keyPair = [];
					break;
			}
		}

		function loadingISteven(name) {
			var loading = {
				id: 0,
				selected: true,
				disableSelection: true // disable from using this as a value to save
			};
			loading[name] = cvLoc('Loading');

			return loading;
		}

		/*
		 * Sorts the VPC's, security groups and subnets
		 */
		function sortContents(data) {
			if (!data || data.length === 0) {
				return;
			}

			sorter(data, 'networkId');
			data.forEach(network => {
				//for amazon, some cases the network name would be empty, so copying the networkid to match.
				if (_.isEmpty(network.networkName)) {
					network.networkName = network.networkId;
				}

				if (network.securityGroups) {
					sorter(network.securityGroups, 'groupName');
				}

				if (network.subnets) {
					sorter(network.subnets, 'subnetId');
				}
			});
		}

		/*
		 * For a given array, sorts the contents based on the property
		 */
		function sorter(data, property) {
			data.sort(function(a, b) {
				var x = a[property].toUpperCase();
				var y = b[property].toUpperCase();
				return x < y ? -1 : x > y ? 1 : 0;
			});
		}
	}
];

controllers.selectRestoreAvailabilityZoneController = [
	'$scope',
	'destinationHostData',
	function($scope, destinationVmData) {
		$scope.selectionStore = destinationVmData.selection;
	}
];

vmManagementMod.controller(controllers);

export default vmManagementMod;
