import 'modules/vmManagement/js/factory/vmLifeCyclePolicy/lifeCyclePolicy.factory.js';
import 'modules/vmManagement/js/directives/autoScalePolicy/cv-autoscale-upordown-options-directive.js';
import 'modules/vmManagement/js/directives/autoScalePolicy/cv-autoscale-out-options-directive.js';

import { vmManagementAppModule } from 'common/js/modules';

var vmManagementMod = vmManagementAppModule;

var controllers = {};

controllers.autoScaleModalController = [
	'cvUtil',
	'cvLoc',
	'browseParams',
	'vmLifeCyclePolicyFactory',
	'$uibModalInstance',
	'restoreService',
	'cvToaster',
	'$state',
	'serverService',
	function(
		cvUtil,
		cvLoc,
		browseParams,
		vmLifeCyclePolicyFactory,
		$modalInstance,
		restoreService,
		cvToaster,
		$state,
		serverService
	) {
		var thresholdLimit = {
			minThreshold: 30,
			maxThreshold: 80,
			percentage: '%',
			durationHour: 1,
			hour: 'hour'
		};

		var toggleStatus = {
			true: 'enabled-activity',
			false: 'disabled-activity'
		};

		var self = this;
		self.model = {};
		self.model.minMemoryThreshold = browseParams.details.scaleOption.minMemThresholdPercent
			? browseParams.details.scaleOption.minMemThresholdPercent
			: thresholdLimit.minThreshold;
		self.model.minCpuThreshold = browseParams.details.scaleOption.minCPUThresholdPercent
			? browseParams.details.scaleOption.minCPUThresholdPercent
			: thresholdLimit.minThreshold;
		self.model.maxMemoryThreshold = browseParams.details.scaleOption.maxMemThresholdPercent
			? browseParams.details.scaleOption.maxMemThresholdPercent
			: thresholdLimit.maxThreshold;
		self.model.maxCpuThreshold = browseParams.details.scaleOption.maxCPUThresholdPercent
			? browseParams.details.scaleOption.maxCPUThresholdPercent
			: thresholdLimit.maxThreshold;
		self.model.percentage = thresholdLimit.percentage;
		self.model.autoScaleUp = toggleStatus[!!browseParams.details.scaleOption.autoScaleUp];
		self.model.autoScaleOut = toggleStatus[!!browseParams.details.scaleOption.autoScaleOut];
		self.model.autoDeployment = toggleStatus[!!browseParams.details.scaleOption.useForAutoDeployment];
		self.model.durationHour = browseParams.details.scaleOption.durationHrs
			? browseParams.details.scaleOption.durationHrs
			: thresholdLimit.durationHour;
		self.model.hour = thresholdLimit.hour;
		self.policyDetails = browseParams;
		if (browseParams.details.scaleOption.autoScaleUp) {
			self.generalOptionsAccordion = true;
		}

		self.model.vendor = vmLifeCyclePolicyFactory.getVendorByPolicyType(self.policyDetails.details.entity.policyType);

		self.editPolicySettings = function(policyDetails) {
			self.model.policyName = policyDetails.details.entity.vmAllocPolicyName;
			self.model.serverDetails = {
				clientId: policyDetails.details.destinationHyperV.clientId,
				clientName: policyDetails.details.destinationHyperV.clientName
			};
			self.model.vmAllocationPolicyId = policyDetails.details.entity.vmAllocPolicyId;
			self.model.amazonPolicy = policyDetails.details.amazonPolicy;
			self.model.securityGroups = policyDetails.details.securityGroups;
			self.model.vmCredentials = policyDetails.details.vmCredentials;
			self.model.associatedClientGroup = policyDetails.details.associatedClientGroup;
			self.model.roleInfo = policyDetails.details.roleInfo;
		};

		self.manageAutoScaleUpOrDownActivity = function() {
			self.model.autoScaleUp = vmLifeCyclePolicyFactory.checkToggleStatus(self.model.autoScaleUp, toggleStatus);
		};

		self.manageAutoScaleOutActivity = function() {
			self.model.autoScaleOut = vmLifeCyclePolicyFactory.checkToggleStatus(self.model.autoScaleOut, toggleStatus);
		};

		self.manageAutoDeploymentActivity = function() {
			self.model.autoDeployment = vmLifeCyclePolicyFactory.checkToggleStatus(self.model.autoDeployment, toggleStatus);
		};

		self.ok = function() {
			self.editPolicySettings(self.policyDetails);
			var policyData = vmLifeCyclePolicyFactory.savePolicy(self.model, null, self.model.vendor);
			policyData.vmNameEditString = self.policyDetails.details.vmNameEditString;
			policyData.vmNameEditType = self.policyDetails.details.vmNameEditType;
			policyData.scaleOption.scaleUpParam = self.policyDetails.details.scaleOption.scaleUpParam;

			var regionSpecificDetails = self.policyDetails.details.scaleOption.scaleOutParam.regionSpecificInfo;
			var securityGroups = [{}];
			if (
				self.policyDetails.details.scaleOption.scaleOutParam &&
				self.policyDetails.details.scaleOption.scaleOutParam.regionSpecificInfo &&
				self.policyDetails.details.scaleOption.scaleOutParam.regionSpecificInfo.length
			) {
				for (var i = 0; i < regionSpecificDetails.length; i++) {
					regionSpecificDetails[i].securityGroups = [
						{
							name: regionSpecificDetails[i].securityGroupName
						}
					];
					delete regionSpecifiDetails[i].securityGroupName;
				}
				self.policyDetails.details.scaleOption.scaleOutParam.regionSpecificInfo = regionSpecificDetails;
			}
			policyData.scaleOption.scaleOutParam = self.policyDetails.details.scaleOption.scaleOutParam;

			restoreService
				.updateReplicationTarget(policyData)
				.success(function(data) {
					cvToaster.showSuccessMessage({ ttl: '15000', message: cvLoc('msg.policyUpdated') });
					$modalInstance.dismiss();
					$state.reload();
				})
				.error(function(e) {
					cvToaster.showErrorMessage({ message: e });
				});
		};

		self.cancel = function() {
			$modalInstance.dismiss('cancel');
		};
	}
];

vmManagementMod.controller(controllers);

export default vmManagementMod;
