/**
 * A controller for handling the functionality on the preferences.jsp page.
 */
angular.module('common.userPreference').controller('userPreferencesController', [
	'$scope',
	'userPrefService',
	'cvToaster',
	function($scope, userPrefService, cvToaster) {
		/**
		 * Checks if the given argument is an object.
		 *
		 * @param mixed
		 *            value - The object to check if it's an object.
		 * @return If the given value is an object; False otherwise.
		 */
		$scope.isObject = angular.isObject;

		$scope.userPrefs = {};

		/**
		 * Retrieves the user preferences from the backend.
		 */
		var getUserPrefs = function() {
			userPrefService.updateUserPrefs().success(function(userPrefs) {
				for (var key in userPrefs) {
					var parsed;
					try {
						parsed = JSON.parse(userPrefs[key]);
					} catch (e) {
						parsed = userPrefs[key];
					}

					$scope.userPrefs[key] = {
						value: angular.isObject(parsed) ? JSON.stringify(parsed, null, 4) : parsed,
						isObject: angular.isObject(parsed)
					};
				}
			});
		};

		getUserPrefs();

		/**
		 * Refreshes the user preferences.
		 */
		$scope.refresh = function() {
			getUserPrefs();
		};

		/**
		 * Removes a user preferences.
		 *
		 * @param string
		 *            key - The key of the user preference to remove.
		 */
		$scope.remove = function(key) {
			if (confirm('Are you sure you want to remove this preference?')) {
				userPrefService.removeUserPref(key).success(function() {
					cvToaster.showSuccessMessage({
						message: 'Preference Removed'
					});
					delete $scope.userPrefs[key];
				});
			}
		};

		/**
		 * Save's a user preference.
		 *
		 * @param string
		 *            key - The key of the user preference.
		 * @param mixed
		 *            value - The user preference's value.
		 */
		$scope.save = function(key, userPref) {
			var value = userPref.isObject ? JSON.stringify(JSON.parse(userPref.value)) : userPref.value;
			userPrefService.setUserPref(key, value).success(function() {
				cvToaster.showSuccessMessage({
					message: 'Saved'
				});
				$scope.userPrefs[key].value = userPref.isObject ? JSON.stringify(JSON.parse(userPref.value), null, 4) : value;
				$scope.userPrefs[key].touched = false;
			});
		};

		$scope.add = function(key, userPref) {
			userPrefService.setUserPref(key, JSON.stringify(JSON.parse(userPref))).success(function() {
				cvToaster.showSuccessMessage({
					message: 'User Preference Added'
				});
				getUserPrefs();
				$scope.adding = false;
				$scope.newPreferenceKey = '';
				$scope.newPreferenceValue = '';
			});
		};
	}
]);
