import { acAppDirectivesModule } from 'common/js/modules';
import 'common/js/tags/tags.svc.js';
import 'modules/settings/js/factories/cvActionsEvent.factory.js';
var acAppDirectives = acAppDirectivesModule;

/**
 * Directive takes in following inpput  params.
 * @enttiy{object} = object should be of type {
 * 		entityId(integer)
 *      entityType(constant String)
 *      entityName(string)
 * }
 */

acAppDirectives.directive('cvEntityTagsTile', [
	function() {
		return {
			restrict: 'E',
			templateUrl: appUtil.appRoot + 'modules/tags/partials/cvEntityTagsTile.jsp',
			bindToController: {
				entity: '=',
				hasEditPermissions: '='
			},
			controllerAs: 'manageEntityTagsCtrl',
			controller: [
				'$log',
				'cvLoc',
				'cvToaster',
				'tagsService',
				'EntityTypes',
				'cvActionsEventFactory',
				function($log, cvLoc, cvToaster, tagsService, EntityTypes, cvActionsEventFactory) {
					const self = this;
					self.dataLoaded = false;

					self.enableTags = cvConfig.enableTags;
					self.manageEntityTags = function() {
						cvActionsEventFactory
							._manageTags(self.entity.entityId, self.entity.entityName, self.entity.entityType)
							.result.then(
								function(data) {
									self.tags = data;
								},
								function(err) {
									console.log(err);
								}
							);
					};
					self.tags = [];

					this.$onInit = function() {
						self.init = () => {
							self.noTagsToDisplay = cvLoc('info.noTagsToDisplay', self.entity.entityName);
							tagsService
								.getTagsForEntity(self.entity)
								.success(function(data) {
									self.dataLoaded = true;
									if (!_.isNil(data) && !_.isNil(data.tags) && !_.isNil(data.tags[0]) && !_.isNil(data.tags[0].tag)) {
										self.tags = data.tags[0].tag;
									}
								})
								.error(function(err) {
									self.dataLoaded = true;
								});
						};
						self.init();
					};
				}
			]
		};
	}
]);

export default acAppDirectives;
