import { ediscoveryAppModule } from 'common/js/modules';
import 'modules/tags/js/services/tagManager.svc.js';

class AddTagController {
	constructor(isEdit, tagset, tag, $uibModalInstance, cvLoc, cvToaster, tagManagerService) {
		this.isEdit = isEdit;
		this.tagset = tagset;
		this.tag = tag;
		this.$uibModalInstance = $uibModalInstance;
		this.cvLoc = cvLoc;
		this.cvToaster = cvToaster;
		this.tagManagerService = tagManagerService;

		this.init();
	}

	init() {
		if (this.isEdit) {
			this.tagName = this.tag.name;
		}
	}

	save(isValid) {
		this.serverMessage = undefined;
		if (!isValid) {
			return;
		}
		if (this.isEdit) {
			this.updateTag();
		} else {
			this.createTag();
		}
	}

	createTag() {
		this.tagManagerService
			.createTag(this.createTagRequest(this.tagset.containerId, this.tagName))
			.then(
				resp => {
					if (!_.isUndefined(_.get(resp, 'data.errList[0].errLogMessage'))) {
						this.showErrorNotification(this.tagName, resp.data.errList[0].errLogMessage);
					} else {
						this.$uibModalInstance.close(resp.data);
						this.cvToaster.showSuccessMessage({
							ttl: '5000',
							message: this.cvLoc('info.tag.added', this.tagName, this.tagset.name)
						});
					}
				},
				err => {
					this.showErrorNotification(this.tagName);
				}
			)
			.catch(err => {
				console.error(err);
				this.showErrorNotification(this.tagName);
				this.$uibModalInstance.dismiss();
			});
	}

	updateTag() {
		this.tagManagerService
			.updateTag(this.createTagRequest(this.tagset.containerId, this.tagName, this.tag.tagId))
			.then(
				resp => {
					if (!_.isUndefined(_.get(resp, 'data.errList[0].errLogMessage'))) {
						this.showErrorNotification(this.tagName, resp.data.errList[0].errLogMessage);
					} else {
						this.$uibModalInstance.close(resp.data);
						this.cvToaster.showSuccessMessage({
							ttl: '5000',
							message: this.cvLoc('info.tagset.edited', this.tagName)
						});
					}
				},
				err => {
					this.showErrorNotification(this.tagName);
				}
			)
			.catch(err => {
				console.error(err);
				this.showErrorNotification(this.tagName);
				this.$uibModalInstance.dismiss();
			});
	}

	createTagRequest(tagsetId, tagName, tagId) {
		const container = { containerId: tagsetId };
		const tags = [{ name: tagName, tagId }];
		const req = { container, tags };
		return req;
	}

	showErrorNotification(tagName, errorMessage) {
		this.serverMessage = errorMessage;
		this.cvToaster.showErrorMessage({
			ttl: '10000',
			message: this.isEdit ? this.cvLoc('error.tagset.edit', tagName) : this.cvLoc('error.tagset.add', tagName)
		});
	}
}

AddTagController.$inject = ['isEdit', 'tagset', 'tag', '$uibModalInstance', 'cvLoc', 'cvToaster', 'tagManagerService'];

ediscoveryAppModule.controller('addTagController', AddTagController);
export default ediscoveryAppModule;
