<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<script nonce="${sessionScope.cspNonce}" >
  <cv:cvMessages bundle="localization.storage"></cv:cvMessages>
  <cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
  <cv:cvMessages bundle="localization.clients"></cv:cvMessages>
</script>
<div class="row">
    <div class="col-md-12">
        <span ><cv-changename 
            obj='changeNameObj'
            callback="updateTapeLibrayName"
            service-method="updateTapeLibrayDetails.do"
            class="float-left"></cv-changename></span>
    </div>
</div>
<div>
    <cv-tab-nav></cv-tab-nav>
</div>
<div class="row">
    <div class="col-md-6" ng-if="isRPStore">
        <cv-tile-component data-title='<cv:msg key="title.general" bundle="storage" />'>
            <ul class="group list-style-secondary">
                <li class="group"><span class="pageDetailColumn"><cv:msg key="label.libraryName" bundle="storage" /></span>
                    <span class="pageDetailColumn" data-ng-bind="libDetails.library.libraryName"></span>
                </li>
                <li class="group"><span class="pageDetailColumn"><cv:msg key="label.associatedMedia" bundle="storage" /></span>
                    <span>{{libDetails.magLibSummary.associatedMediaAgents}}</span></li>
                <li class="group"><span class="pageDetailColumn"><cv:msg key="label.mountPath" bundle="storage" /></span>
                    <span>{{libDetails.rpStoreLibraryInfo.mountPathName}}</span></li>
                <!--
			 	<li class="group"><span class="pageDetailColumn"><cv:msg key="label.minimumThreshold" bundle="storage" /></span>
			 	<span>{{libDetails.rpStoreLibraryInfo.minSpacePerRPStoreGB}}</span></li>
			 	<li class="group"><span class="pageDetailColumn"><cv:msg key="label.maximumThreshold" bundle="storage" /></span>
			 	<span>{{libDetails.rpStoreLibraryInfo.maxSpacePerRPStoreGB}}</span></li>
        		</li>
        		 -->
            </ul>
            <div class="page-details-box-links">
                <a href="" data-ng-click="editRPStore()">
                    <cv:msg key="action.edit" bundle="storage" />
                </a>
            </div>
        </cv-tile-component>
    </div>
    <div class="col-md-6" ng-if="!isRPStore">
        <cv-tile-component data-ac-id="tapeLibraryDetails-title_general-storage" data-title='<cv:msg key="title.general" bundle="storage" />'>
            <ul class="group list-style-secondary">
                <li class="group"><span class="pageDetailColumn"><cv:msg key="label.libraryName" bundle="storage" /></span>
                    <span class="pageDetailColumn" data-ng-bind="libDetails.library.libraryName"></span>
                </li>
                <li class="group"><span class="pageDetailColumn"><cv:msg key="label.manufacturer" bundle="storage" /></span>
                    <span class="pageDetailColumn" data-ng-bind="libDetails.manufacturer"></span></li>
                <li class="group"><span class="pageDetailColumn"><cv:msg key="label.model" bundle="storage" /></span>
                    <span class="pageDetailColumn" data-ng-bind="libDetails.tapeLibSummary.model"></span></li>
                <li class="group"><span class="pageDetailColumn"><cv:msg key="label.firmwareRevision" bundle="storage" /></span>
                    <span class="pageDetailColumn" data-ng-bind="libDetails.tapeLibSummary.firmwareRevision"></span></li>
                <li class="group"><span class="pageDetailColumn"><cv:msg key="label.barcodeReader" bundle="storage" /></span>
                    <span class="pageDetailColumn" data-ng-bind="libDetails.tapeLibSummary.barcodeReader"></span></li>
                <li class="group"><span class="pageDetailColumn"><cv:msg key="label.serialNumber" bundle="storage" /></span>
                    <span class="pageDetailColumn" data-ng-bind="libDetails.tapeLibSummary.serialNumber"></span></li>
            </ul>
        </cv-tile-component>
    </div>
    <div class="col-md-6" data-ng-if ="!deconfiguredLibrary &&(!isRPStore)">
        <cv-tile-component data-ac-id="tapeLibraryDetails-label_reports-storage" data-title='<cv:msg key="label.reports" bundle="storage"/>'>
            <ul class="group list-style-secondary">
                <li class="group">
                    <span class="pageDetailColumn"><a href='#slotView?input.libraryId={{libDetails.library.libraryId}}&libraryId={{libDetails.library.libraryId}}&model={{libDetails.model}}&libraryName={{libDetails.library.libraryName | encodeParam}}' ><cv:msg key="label.slots" bundle="storage" /></a></span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn"><a href='#IEPortView?input.libraryId={{libDetails.library.libraryId}}&libraryId={{libDetails.library.libraryId}}&model={{libDetails.model}}&libraryName={{libDetails.library.libraryName | encodeParam}}'><cv:msg key="label.IEports" bundle="storage" /></a></span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn"><a href='#LibraryController?input.libraryId={{libDetails.library.libraryId}}&libraryId={{libDetails.library.libraryId}}&model={{libDetails.model}}&libraryName={{libDetails.library.libraryName | encodeParam}}'><cv:msg key="title.libraryControllerMediaagents" bundle="storage" /></a></span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn"><a href='#tapeDriveUsage?input.libraryName={{libDetails.library.libraryName | encodeParam}}&libraryId={{libDetails.library.libraryId}}&model={{libDetails.model}}&libraryName={{libDetails.library.libraryName | encodeParam}}'><cv:msg key="title.driveUsage" bundle="storage" /></a></span>
                </li>
                <li class="group">
                    <span class="pageDetailColumn"><a href='#tapeMediaUsage?input.libraryId={{libDetails.library.libraryId}}&libraryId={{libDetails.library.libraryId}}&model={{libDetails.model}}&libraryName={{libDetails.library.libraryName | encodeParam}}'><cv:msg key="title.mediaUsage" bundle="storage" /></a></span>
                </li>
            </ul>
        </cv-tile-component>
    </div>
    <div class="col-md-6" data-ng-if="deconfiguredLibrary">
        <cv-tile-component data-ac-id="tapeLibraryDetails-title_mediaDetails-storage" data-title='<cv:msg key="title.mediaDetails" bundle="storage" />'>
            <ul class="group list-style-secondary">
                <li class="group"><span class="pageDetailColumn"><cv:msg key="label.associatedMedia" bundle="storage" /></span>
                    <a href='#MediaInLibrary?input.libraryId={{libDetails.library.libraryId}}&input.filterType={{filtermediaInLibrary}}&libraryId={{libDetails.library.libraryId}}&model={{libDetails.model}}&libraryName={{libDetails.library.libraryName}}'>
                        {{libDetails.tapeLibSummary.numOfAssignedMedia}}
                    </a>
                </li>
            </ul>
        </cv-tile-component>
    </div>
</div>
<div class="row" data-ng-if ="!deconfiguredLibrary && (!isRPStore)">
    <div class="col-md-6">
        <cv-tile-component data-ac-id="tapeLibraryDetails-title_status-storage" data-title='<cv:msg key="title.status" bundle="storage" />'>
            <ul class="group list-style-secondary">
                <li class="group">
                    <span class="pageDetailColumn">
                        <cv-help-text help-label="label.enable" help-text="info.tapeStatusInfo" />
                    </span>
                    <span class="pageDetailColumn">
						<toggle-control class={{status}} status="status"   bundle='storage' data-ng-click = 'updateTapeLibraryStatus()'></toggle-control>
					</span>
                </li>
                <li class="group">
                    <!-- TODO: needs to come from API
                        <cv-activity-control label='<cv:msg key="label.maintenanceMode" bundle="storage" />' 
                    help-text='<cv:msg key="info.maMaintenanceMode" bundle="storage"/>' 
                    ac-params="libDetails" 
                    enable-delay ="libDetails.TapeProps.enableTapeAfterDelay" 
                    delay-time="libDetails.TapeProps.enableTapeAtDateTime" 
                    activity-controller="toggleTapeMaintenanceMode" 
                    flip="true" 
                    enable-backup="libDetails.TapeProps.markTapeOfflineForMaintenance" 
                    activate-delay-string="label.willBeDisabled" 
                    enabled-delay-string="label.disableAfterDelay"></cv-activity-control> -->
                    <span class="pageDetailColumn">
                        <cv-help-text help-label="label.maintenanceMode" help-text="info.tapeMaintenanceModeInfo" />
                    </span>
                    <span class="pageDetailColumn">
                        <toggle-control class={{maintenanceMode}} status="maintenanceMode"   bundle='storage' data-ng-click = 'updateMaintenanceMode(libDetails.tapeLibSummary.attribute)'></toggle-control>
                    </span>
                </li>
                <li class="group" ng-if="libDetails.tapeLibSummary.offlineReason !== notApplicableLabel">
                    <span class="pageDetailColumn">
                        <cv:msg key="label.offlineReason" bundle="storage" />
                    </span>
                    <span class="pageDetailColumn" data-ng-bind="libDetails.tapeLibSummary.offlineReason"></span>
                </li>
            </ul>
        </cv-tile-component>
    </div>
</div>
<div data-ng-if="(!deconfiguredLibrary && !isRPStore)">
    <cv-kendo-grid cv-grid-options="gridDrive.options">
        <svg data-cv-on-grid-empty class="add-new-placeholder" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 160 200" xml:space="preserve"><path d="M122.815,166.783h-92.24V33.217H93.69v27.966h29.08h0.046v52.496l2-2.155V58.376L96.589,31.217 H30.575h-2v2v133.566v2h2h92.24h2v-2V127.24l-2,2.815V166.783z M95.69,33.217v-0.09l0.094,0.09l26.986,25.966H95.69V33.217z"/><rect x="41.686" y="73.696" width="72" height="3"/> <rect x="41.686" y="85.696" width="72" height="3"/> <rect x="41.686" y="96.696" width="72" height="3"/><path d="M131.051,108.074c-0.193,0-0.449,0.154-0.745,0.472l-15.325,16.516v-1.99h-2H80.858h-2v2v32.124v2 h2h32.124h2v-2v-19.57l14.464-20.355c0.627-0.882,1.249-2.483,1.381-3.557l0.576-4.657 C131.483,108.414,131.338,108.074,131.051,108.074z M112.982,157.196H80.858v-32.124h32.124v2.145l-12.13,13.073 c-0.393,0.424-0.939,0.64-1.485,0.64c-0.476,0-0.953-0.164-1.331-0.496l-8.414-7.393c-0.362-0.318-0.806-0.474-1.246-0.474 c-0.548,0-1.09,0.241-1.466,0.708l-3.875,4.815c-0.679,0.843-0.601,2.152,0.173,2.909l13.323,13.031 c0.76,0.743,2.237,1.335,3.314,1.335c0.02,0,0.04,0,0.06-0.001l0.542-0.011c1.082-0.023,2.48-0.763,3.107-1.645l9.429-13.269 V157.196z"/></svg>
    </cv-kendo-grid>
</div>
<div class="margin-top-20" data-ng-if="fecthedStoragPoolList">
    <cv-kendo-grid cv-grid-options="storagePoolGrid.options">
	    <svg data-cv-on-grid-empty class="add-new-placeholder" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 160 200" xml:space="preserve"><path d="M60.9,87.9h0a20.5,20.5,0,0,1-3.8-4.6V99.2h0V98.8c0,0.2,0,.5,0,0.7a13.3,13.3,0,0,0,3.9,9c6.8,7.4,21.6,12.6,38.9,12.6s32.2-5.2,38.9-12.6a13.3,13.3,0,0,0,3.9-9V83.3a20.5,20.5,0,0,1-3.8,4.6c-7.2,6.7-20.4,11.3-36.1,11.8H97c-15.7-.5-28.9-5.1-36.1-11.8h0Z"/><path d="M57.2,139.8a12.2,12.2,0,0,0,2.1,6.7c5.6,8.6,21.7,14.8,40.7,14.8s35.1-6.2,40.7-14.8a12.2,12.2,0,0,0,2.1-6.7V127.4l-0.6,1-0.3.4-0.5.6-0.3.4-0.5.6-0.3.4-0.6.6-0.3.3-0.9.9-0.3.3-0.7.6-0.4.3-0.7.5-0.5.3-0.8.5-0.4.3-1.2.8-0.3.2-1,.6-0.5.3-0.9.5-0.6.3-1,.4-0.5.2-1.3.6H127l-1.6.6-0.6.2-1.1.4-0.6.2-1.1.3-0.6.2-1.4.4h-0.4l-1.8.4h-0.5l-1.4.3h-0.7l-1.3.2h-0.7l-1.4.2h-0.6l-2,.2h-0.4l-1.7.2H92.8l-1.7-.2H90.8l-2-.2H88.2l-1.4-.2H86.1l-1.3-.2H84.2l-1.4-.3H82.3l-1.8-.4H80.1l-1.4-.4-0.6-.2-1.1-.3-0.6-.2-1.1-.4-0.6-.2-1.6-.6H72.8l-1.4-.6-0.5-.2-1-.4-0.6-.3-0.9-.5-0.5-.3-1-.6-0.3-.2-1.2-.8-0.4-.3-0.8-.5-0.5-.3-0.7-.5-0.4-.3-0.7-.6-0.3-.3-0.9-.9-0.3-.3-0.6-.6-0.3-.4-0.5-.6-0.3-.4-0.5-.6-0.3-.4-0.6-1v12.4Z"/><path d="M100,123.1c-18,0-33.2-5.3-40.4-13.1a19.2,19.2,0,0,1-2.5-3.3v12.9c0,0.3,0,.5,0,0.8,0,11.9,19.2,21.5,42.8,21.5s42.8-9.6,42.8-21.5V106.7a19.2,19.2,0,0,1-2.5,3.3C133.2,117.8,118,123.1,100,123.1Z"/><path d="M57.2,76.2c0,3.8,1.9,7.3,5.3,10.4,7.3,6.6,21.4,11.2,37.5,11.2s30.2-4.5,37.5-11.2c3.4-3.1,5.3-6.6,5.3-10.4a12.2,12.2,0,0,0-2.1-6.6C135.2,60.9,119,54.6,100,54.6S64.8,60.9,59.3,69.5A12.2,12.2,0,0,0,57.2,76.2Z"/><path d="M19.2,55.3V71.2h0V70.8c0,0.2,0,.5,0,0.7a13.3,13.3,0,0,0,3.9,9c5.9,6.4,17.8,11.1,32.1,12.3V75.9h0a13.4,13.4,0,0,1,.9-4.4c-14.4-1-26.4-5.4-33.1-11.6A20.5,20.5,0,0,1,19.2,55.3Z"/><path d="M19.2,99.4v12.4a12.2,12.2,0,0,0,2.1,6.7c4.9,7.5,17.9,13.2,33.9,14.5v-13h0v-4.4C37.9,114.3,24.2,107.9,19.2,99.4Z"/><path d="M21.6,81.9a19.2,19.2,0,0,1-2.5-3.3V91.5c0,0.3,0,.5,0,0.8,0,10.7,15.6,19.6,36,21.2V99.3h0V94.8C40.2,93.7,27.9,88.8,21.6,81.9Z"/><path d="M102.7,41.5C97.2,32.9,81,26.6,62,26.6S26.8,32.9,21.3,41.5a12.2,12.2,0,0,0-2.1,6.6c0,3.8,1.9,7.3,5.3,10.4,6.5,5.9,18.5,10.2,32.5,11l0.6-1.1C63.7,59,80.7,52.6,100,52.6h3.8a11.5,11.5,0,0,0,1-4.6A12.2,12.2,0,0,0,102.7,41.5Z"/></svg>    
    </cv-kendo-grid>
</div>