<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<div class="graph-outer-wrapper create-new-button-wrapper">
	<div class="input-group">
		<isteven-multi-select id="{{selectId}}"
			input-model="optionList"
			output-model="selectedOption"
			button-label="{{keyLabel}}"
			item-label="{{keyLabel}}"
			directive-id="selectId"
			tick-property="selected"
			selection-mode="single"
			class="isteven-multi-select single-select"
			name="{{selectName}}"
			helper-elements="filter"
			translation="localLang"
			min-search-length="1"
			search-property="{{keyLabel}}"
			on-item-click="handlerOnChange()">
		</isteven-multi-select>
		<span data-ng-if="!showSaveDiscardButton" class="input-group-btn">
			<button id="{{'selectWithCreateButton_button_#2034_' + selectId}}"
				type="button"
				class="icon-style cv-material-button browse"
				data-ng-if="!selectDisabled && !createButtonDisabled" 
				data-ng-click="handlerOpenCreateModal()">
				<div class="cv-material-button-icon cursor-pointer">
					<span class="k-icon k-i-plus create-new-button font-size-page-title primary-theme-color"></span>
				</div><div class="cv-material-button-tooltip"><cv:msg key="string.createNew" bundle="archiving" /></div>
			</button>
		</span>
		<span data-ng-if="isCredential && !showSaveDiscardButton" data-ng-disabled="editDisabled" class="input-group-btn">
			<button id="{{'selectWithCreateButton_button_#2035_' + selectId}}"
				type="button"
				class="icon-style cv-material-button browse"
				data-ng-click="handlerOpenEditModal()">
				<div class="cv-material-button-icon cursor-pointer">
					<svg width="19px" height="19px" fill="currentColor" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24"><path d="M3 17.25V21h3.75L17.81 9.94l-3.75-3.75L3 17.25zM20.71 7.04a1 1 0 0 0 0-1.41l-2.34-2.34a1 1 0 0 0-1.41 0l-1.83 1.83 3.75 3.75 1.83-1.83z"></path></svg>
				</div>
				<div class="cv-material-button-tooltip"><cv:msg key="label.edit" bundle="security" /></div>
			</button>
		</span>
		<span data-ng-if="showSaveDiscardButton"><a class="inline-editor-button" data-ng-click="handlerUpdateCredential()"><i class="k-icon k-i-check"></i></a></span>
		<span data-ng-if="showSaveDiscardButton"><a class="inline-editor-button" data-ng-click="handlerDiscardChanges()"><i class="k-icon k-i-close"></i></a></span>
	</div>
</div>