<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv" %>
<script nonce="${sessionScope.cspNonce}" >
  <cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>
<h1 class="page-title">{{mpDetails.mountPathSummary.libraryName}}</h1>
<div class="group row" >
    <div class="col-md-6">
        <cv-tile-component data-ac-id="mountPathDetails-title_general-storage" data-title="<cv:msg key="title.general" bundle="storage" />" loader="mpDetails">
            <ul class="list-style-secondary">     
                <li class="group" data-ng-if="mpDetails.mountPathSummary.totalSpace > 0"><span class="pageDetailColumn"><cv:msg key="Total Capacity" bundle="storage"/></span>
                    <span class="pageDetailColumn ">{{mpDetails.mountPathSummary.totalSpace * 1024  * 1024 | capacity}}</span></li>
                <li class="group" data-ng-if="mpDetails.mountPathSummary.totalFreeSpace > 0"><span class="pageDetailColumn"><cv:msg key="Free Space" bundle="storage"/></span>
                    <span class="pageDetailColumn ">{{mpDetails.mountPathSummary.totalFreeSpace * 1024  * 1024 | capacity}}</span></li>
                <li class="group">
                    <span class="pageDetailColumn" data-ng-bind="deviceLabelPath"></span>
                    <a class="pageDetailColumn " data-ng-click="onClickPath(deviceList[0])">{{deviceList[0].path}}</a>
                </li>
            </ul>
        </cv-tile-component>
    </div>
    <div class ="col-md-6">
        <cv-tile-component data-ng-if="control.showCredentials" data-title='<cv:msg key="heading.configuration" bundle="storage"/>'>
                     <ul class="list-style-secondary" data-ng-if="control.showCredentials">
                        <li class="group">
                            <span class="pageDetailColumn padding-top-10"><cv-help-text help-label="<cv:msg key="label.Storageacceleratorcredentials" bundle="storage"/>" help-text="'<cv:msg key='label.StorageacceleratorcredentialsHelpText' bundle='storage' />'"/></span>
                            <span class="pageDetailColumn padding-left-5" >
			                        <select-with-create-button
			                            select-id="credential"
			                            select-name="credential"
			                            key-label="credentialName"
			                            key-id="credentialId"
			                            option-list="savedStorageAcceleratorCredentials"
			                            on-change-option="onChangeCredential"
			                            create-button-disabled = "control.isEditingCredentials"
			                            selected-option="control.outputCredentialList"
			                            on-click-create-button="openCreateCredentialModal"
			                            class="no-float-auto tile-large-width"
			                            placeholder='<cv:msg key="placeholder.credential" bundle="storage"/>'
										edit-disabled="control.selectedCredential.credentialId === 0"
			                            on-click-edit-button="openEditCredentialModal"
			                            show-save-discard-button="control.isEditingCredentials"
			                            is-credential="true && !control.isEditingCredentials"
			                            on-Update-Credentials ="updateCredential"
			                            on-Discard-Changes = "onDiscardChanges">
			                        </select-with-create-button>
			                        <span class="error"  data-ng-show="showUpdateCredError">
			                            {{credentialUpdateError.message}}
			                        </span>
                    		 </span>
                        </li>
                    </ul>
         </cv-tile-component>
    </div>
</div>

<cv-kendo-grid data-cv-grid-options="gridOptionsKendo"></cv-kendo-grid>
<span class="{{libraryMessage.type}}">{{libraryMessage.message}}</span>
