<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}" >
	<cv:cvMessages bundle="localization.storage"></cv:cvMessages>
</script>
<div class="setup-title">
	<h1><cv:msg key="action.addPartition" bundle="storage"/></h1>
</div>
<div id="addDDBCloudModal" class="setup-content">
	<form class="bootstrap-wrapper" novalidate autocomplete="off" id="addDDBCloudForm" name="addDDBCloudForm" >
		<div class="modal-list">
			<div class = "form-group row">
				<label for="mediaAgent" class="col-xs-5 col-sm-5"><cv:msg key="label.mediaAgent" bundle="storage"/></label>
		        <div class="col-xs-7 col-sm-7 text-align-left" id="mediaAgent">
					<isteven-multi-select
						directive-id="mediaAgentList"
						input-model="mediaAgentList"
						output-model="storageInfo.mediaAgent"
						button-label="displayName"
						item-label="displayName"
						id="mediaAgent"
						tick-property="selected"
						class="grid-filter-isteven-multi-select isteven-multi-select user-group-select grid-column-filter"
						helper-elements="filter"
						translation="localLang"
						min-search-length="1"
						search-property="displayName"
						selection-mode="single"
						on-item-click="setMediaAgent(data)">
					</isteven-multi-select>
	                <span class="help-block" data-ng-show="mediaAgentError || cv.addCollectionForm.needsAttention(addCollectionForm.mediaAgent)"><cv:msg key="error.mediaAgent" bundle="storage"/></span>
				</div>
			</div>

			<div class="form-group row">
				<label class="col-xs-5 col-sm-5" for="partitionPath"><cv:msg key="label.partitionPath" bundle="storage"/>
				</label>
				<div class="col-xs-7 col-sm-7 text-align-left">
	                <div class="input-group">
	                    <input type="text" class="indexServerPath"
	                    name="ddbPartitionPath" id="ddbPartitionPath" data-ng-model="storageInfo.ddbPartitionPath"
	                    data-ng-pattern="pathPattern.pattern" />
	                    <span class="input-group-btn">
	                        <button id="addCloudTemplate_button_#8694" class="icon-style cv-material-button browse" type="button" data-ng-click="browseForPartitionPath({isDDBLocation: true})">
	                            <div class="cv-material-button-icon cursor-pointer">
	                                <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path d="M0 0h24v24H0z" fill="none"/><path d="M19 4H5c-1.11 0-2 .9-2 2v12c0 1.1.89 2 2 2h4v-2H5V8h14v10h-4v2h4c1.1 0 2-.9 2-2V6c0-1.1-.89-2-2-2zm-7 6l-4 4h3v6h2v-6h3l-4-4z"/></svg>
	                            </div><div class="cv-material-button-tooltip"><cv:msg key="Browse" bundle="storage" /></div>
	                        </button>
	                    </span>
	                </div>
                    <span class="help-block" data-ng-show="cv.addDDBCloudForm.needsAttention(addDDBCloudForm.ddbPartitionPath)"><cv:msg key="error.partitionPathAdd" bundle="storage"/></span>
                    <span class="help-block" data-ng-show="addDDBCloudForm.ddbPartitionPath.$error.pattern"><cv:msg key="error.partitionPath.invalid" bundle="storage"/></span>
				</div>
			</div>
		</div>
		<div class="button-container">
			<button id="addRegionWindowModal_button_#1641" type="button" class="btn btn-default cvBusyOnAjax" data-ng-click="cancel()"><cv:msg key="action.cancel" bundle="storage"/></button>
			<button id="addRegionWindowModal_button_#7116" type="submit" class="btn btn-primary cvBusyOnAjax" data-ng-click="addCloudDDBToGrid()" data-ng-disabled="addDDBCloudForm.ddbPartitionPath.$error.pattern"><cv:msg key="action.save" bundle="storage"/></button>
		</div>
	</form>
</div>
