<%@ taglib uri="/WEB-INF/cvtaglib.tld" prefix="cv"%>
<script nonce="${sessionScope.cspNonce}">
    <cv:cvMessages bundle="localization.messages"></cv:cvMessages>
    <cv:cvMessages bundle="localization.storage"></cv:cvMessages>
    <cv:cvMessages bundle="localization.schedule"></cv:cvMessages>
    <cv:cvMessages bundle="localization.ediscovery"></cv:cvMessages>
</script>
<div class="setup-title">
    <h1>
        <cv:msg key="title.exportMediaCriteriaBased" bundle="storage" />
    </h1>
</div>
<div class="padding-left-15 margin-right-15 margin-bot-20 no-padding setup-content">
<div class="{{generalSetupMessage.type}} serverErrorMessage">{{generalSetupMessage.message}}</div>
    <div class="row">
        <label>
            <cv:msg key="label.policyName" bundle="storage" />
            <input type="text" class="float-right width-60-percentage" data-ng-model="data.policyName.value" class="ng-pristine ng-untouched ng-valid">
            <span class="help-block" data-ng-if="data.policyName.hasError">
                <cv:msg key="error.policyName" bundle="schedule"/>
            </span>
        </label>
    </div>
    <div class="row">
        <label class="add-collection-form form-group">
            <cv:msg key="label.description" bundle="storage" />
            <textarea name="description" class="toggle-control"
                data-ng-model="data.description.value"  id="description" rows="4">
            </textarea>
        </label>
    </div>
</div>
<div>
    <form class="form-panel-holder setup-content" name="exportMediaForm" novalidate data-cv-submit="exportMedia()" autocomplete="off" class="edit-users-grid-form">
        <uib-accordion close-others="true" class="text-left">
            <div is-open="statusExportMedia" uib-accordion-group data-ng-init="statusExportMedia=true">
                <uib-accordion-heading>
                    <i class="glyphicon" data-ng-class="{'glyphicon-chevron-down': statusExportMedia, 'glyphicon-chevron-right': !statusExportMedia}">
                    </i>
                    <cv:msg key="title.mediaStatus" bundle="storage" />
                </uib-accordion-heading>
                    <div>
                        <div class="row padding-left-20 padding-top-15">
                            <span class="col-md-6 col-xs-6 backup-window-list">
                                <cv:msg key="label.fullTapes" bundle="storage" />
                            </span>
                            <div class="col-md-6 col-xs-6">
                                <toggle-control data-ng-class="{'enabled-activity': data.fullTape.value , 'disabled-activity': !data.fullTape.value}"
                                                status="data.fullTape.value ? 'enabled-activity' : 'disabled-activity'" data-ng-click="changeSelective('full_tape')">
                                </toggle-control>
                            </div>
                        </div>
                        <div class="row padding-left-20 padding-top-15">
                            <span class="col-md-6 col-xs-6 backup-window-list">
                                <cv:msg key="label.includeTapes" bundle="storage" />
                            </span>
                            <div class="col-md-6 col-xs-6">
                                <toggle-control data-ng-class="{'enabled-activity': data.includeTape.value , 'disabled-activity': !data.includeTape.value}"
                                                status="data.includeTape.value ? 'enabled-activity' : 'disabled-activity'" data-ng-click="changeSelective('include_tape')">
                                </toggle-control>
                            </div>
                        </div>
                        <div class="row padding-left-20 padding-top-15">
                            <span class="col-md-6 col-xs-6 backup-window-list form-policy-division">
                                <cv:msg key="label.tapeLast" bundle="storage" />
                            </span>
                            <div class="col-md-6 col-xs-6">
                                <input class="max-width-200 float-left full-width" type="number" min="1" max="9999" name="TapeLast" data-ng-change="changeInput('lastTape')" data-ng-model="data.lastTape.value"/>
                                <span class="form-policy-division margin-0 padding-top-10">
                                    {{data.lastTape.value > 1
                                        ? '<cv:msg key="label.days" bundle="storage" />'
                                        : '<cv:msg key="label.day" bundle="storage" />'
                                    }}
                                </span>
                                <div class="error help-block ng-scope full-width margin-0" data-ng-if="data.lastTape.hasError">
                                    <cv:msg key="error.lastTape" bundle="schedule" />
                                </div>
                            </div>
                        </div>
                        <div class="row padding-left-20 padding-top-15">
                            <span class="col-md-6 col-xs-6 backup-window-list">
                                <cv:msg key="label.excludeMedia" bundle="storage" />
                            </span>
                            <div class="col-md-6 col-xs-6">
                                <toggle-control data-ng-class="{'enabled-activity': data.excludeMedia.value , 'disabled-activity': !data.excludeMedia.value}"
                                                status="data.excludeMedia.value ? 'enabled-activity' : 'disabled-activity'" data-ng-click="changeSelective('exclude_media')">
                                </toggle-control>
                            </div>
                        </div>
                        <div class="row padding-left-20 padding-top-15">
                            <span class="col-md-6 col-xs-6 backup-window-list form-policy-division">
                                <cv:msg key="label.limitMedia" bundle="storage" />
                            </span>
                            <div class="col-md-6 col-xs-6">
                                <input class="max-width-200 float-left full-width" type="number" min="1" max="1000" name="limitMedia" data-ng-change="changeInput('limitMedia')" data-ng-model="data.limitMedia.value" />
                                <div class="error help-block ng-scope full-width margin-0" data-ng-if="data.limitMedia.hasError">
                                    <cv:msg key="error.limitMedia" bundle="schedule" />
                                </div>
                            </div>
                        </div>
                    </div>
            </div>
        </uib-accordion>
        <div class="panel-body padding-top-10 text-left">
            <h4 class="padding-left-5 col-md-12"><cv:msg key="label.detinations" bundle="storage" /></h4>
            <div class="row padding-left-20 padding-top-15">
                <span class="col-md-6 col-xs-6 backup-window-list float-left form-policy-division">
                    <cv:msg key="label.exportDestination" bundle="storage" />
                </span>
                <div class="col-md-6 col-xs-6 padding-0 margin-left-15 max-width-200">
                    <select-and-create
                        available-options="availableDestinations"
                        select-id="'toExportDestination'"
                        selected-option="data.exportDestination.value"
                        on-item-click="arrayControllerSelection"
                        ng-if="isLoadedLocations">
                    </select-and-create>
                    <div class="error help-block ng-scope full-width margin-0" data-ng-if="data.exportDestination.hasError">
                        <cv:msg key="error.exportDestination" bundle="schedule"/>
                    </div>
                </div>
            </div>
            <div class="row padding-left-20 padding-top-15">
                <span class="col-md-6 col-xs-6 backup-window-list">
                    <cv:msg key="label.trackTransit" bundle="storage" />
                </span>
                <div class="col-md-6 col-xs-6">
                    <toggle-control data-ng-class="{'enabled-activity': data.trackTransit.isShow , 'disabled-activity': !data.trackTransit.isShow}"
                                    status="data.trackTransit.isShow ? 'enabled-activity' : 'disabled-activity'" data-ng-click="changeValue('trackTransit')">
                    </toggle-control>
                </div>
            </div>
            <div>
                <div class="row padding-left-20 padding-top-15" data-ng-if="data.trackTransit.isShow">
                    <span class="col-md-6 col-xs-6 backup-window-list float-left form-policy-division">
                        <cv:msg key="label.trackTransitLocation" bundle="storage" />
                    </span>
                    <div class="col-md-6 col-xs-6 padding-0 margin-left-15 max-width-200">
                        <select-and-create
                            available-options="availableTransit"
                            select-id="'toTrackTransit'"
                            selected-option="data.trackTransit.value"
                            on-item-click="arrayControllerSelection"
                            ng-if="isLoadedLocations">
                        </select-and-create>
                        <div class="error help-block float-left margin-0 row" data-ng-if="data.trackTransit.hasError">
                            <cv:msg key="error.trackTransit" bundle="schedule"/>
                        </div>
                    </div>
                </div>                
            </div>
        </div>
        <uib-accordion close-others="true" class="text-left">
            <div uib-accordion-group data-ng-init="statusExportMedia=false" is-open="statusExportMedia">
                <uib-accordion-heading>
                    <i class="glyphicon" data-ng-class="{'glyphicon-chevron-down': statusExportMedia, 'glyphicon-chevron-right': !statusExportMedia}">
                    </i>
                    <cv:msg key="title.associatedSchedules" bundle="storage" />
                    <a class="pull-right accordion-heading-action-link" href="" title="Add" data-ng-click="addSchedule()" data-ng-if="scheduleObject.subTasks.length === 0">
                        <cv:msg key="label.addSchedule" bundle="schedule" />
                    </a>
                </uib-accordion-heading>
                <div class="margin-left-right">
                    <div class="schedule-list">
                        <ul class="add-schedule__List group" data-ng-repeat="schedule in scheduleObject.subTasks track by $index">
                            <li class="ellipsis-parent ellipsis-content ">
                                <a class="always-enabled" data-ng-click="editSchedule(schedule)">{{schedule.name}} </a>
                            </li>
                        </ul>
                        <ul class="add-schedule__List group" data-ng-if="scheduleObject.subTasks.length==0">
                            <li class="ellipsis-parent ellipsis-content "><cv:msg key="error.noScheduleAdded" bundle="schedule"/> </li>
                        </ul>
                    </div>
                </div>
            </div>
        </uib-accordion>
        <div class="button-container">
            <fmt:bundle basename="localization.messages">
                <button id="ExportMediaCriteria_button_#3420" type="button" class="btn btn-default cvBusyOnAjax setup-btn--hidden" data-ng-click="cancel()"> 
                    <cv:msg key="Cancel" bundle="messages" />
                </button>
                <button id="ExportMediaCriteria_button_#8295" type="submit" class="btn btn-primary cvBusyOnAjax"> 
                    <cv:msg key="action.save" bundle="storage" />
                </button>
            </fmt:bundle>
        </div>
    </form>
</div>