export const getMediaAgentColumn = cvLoc => ({
	mediaAgent: {
		searchField: 'mediaAgent',
		title: cvLoc('label.mediaAgentName'),
		template:
			'<div class="ellipsis-parent"><span class="ellipsis-content" uib-tooltip="#:mediaAgent#" tooltip-append-to-body="true" tooltip-placement="left">#:mediaAgent#</span></div>',
		width: '20%',
		type: 'string'
	}
});

export const getPathColumn = cvLoc => ({
	path: {
		searchField: 'path',
		title: cvLoc('Path'),
		template:
			'<div class="ellipsis-parent"><span class="ellipsis-content" uib-tooltip="#:path#" tooltip-append-to-body="true" tooltip-placement="left">#:path#</span></div>',
		width: '20%',
		type: 'string'
	}
});

export const getCapacityColumn = cvLoc => ({
	capacity: {
		searchField: 'capacity',
		title: cvLoc('label.capacity'),
		template:
			'<div class="ellipsis-parent"><span class="ellipsis-content" uib-tooltip="#:capacity#" tooltip-append-to-body="true" tooltip-placement="left">#:capacity#</span></div>',
		width: '20%',
		type: 'string'
	}
});

export const getFreeSpaceColumn = cvLoc => ({
	freeSpace: {
		searchField: 'freeSpace',
		title: cvLoc('label.freeSpace'),
		template:
			'<div class="ellipsis-parent"><span class="ellipsis-content" uib-tooltip="#:freeSpace#" tooltip-append-to-body="true" tooltip-placement="left">#:freeSpace#</span></div>',
		width: '20%',
		type: 'string'
	}
});

export const getDDBDiskInformationColumnTemplate = angularLibs => ({
	...getMediaAgentColumn(angularLibs.cvLoc),
	...getPathColumn(angularLibs.cvLoc),
	...getCapacityColumn(angularLibs.cvLoc),
	...getFreeSpaceColumn(angularLibs.cvLoc)
});
