export const getNameColumn = cvLoc => ({
	name: {
		searchField: 'mediaAgentEntity.displayName',
		title: cvLoc('title.mediaAgent'),
		template:
			'<div class="ellipsis-parent"><span class="ellipsis-content" uib-tooltip="#:mediaAgentEntity.displayName#" tooltip-append-to-body="true" tooltip-placement="left">#:mediaAgentEntity.displayName#</span></div>',
		width: '25%'
	}
});

export const getPathColumn = (cvLoc, labelBucket, model, storagePoolType) => ({
	path: {
		searchField: 'pathRename',
		title: model === 'Cloud' ? cvLoc(labelBucket) : cvLoc('Path'),
		template: `# if (${storagePoolType != 'SCALE_OUT'}) {#
        <a uib-tooltip="#:pathRename#" tooltip-append-to-body="true" tooltip-placement="bottom" class="crop k-grid-pathEdit">#:pathRename#</a>
      #} else if (${storagePoolType == 'SCALE_OUT'}) {#
        <span class="ngCellText" uib-tooltip="#:pathRename#" tooltip-append-to-body="true" tooltip-placement="bottom">#:pathRename#</span>
      #}#`,
		width: '25%'
	}
});

export const getUserNameColumn = (cvLoc, libraryVendorType) => ({
	userName: {
		searchField: 'userName',
		title: cvLoc('User Name'),
		template: `# if (${libraryVendorType == 400}) {#
						<div>N/A</div>
					#} else {#
		        		<div>#:userName#</div>
		      		#}#`,
		// template: '<div class="ellipsis-parent"><span class="ellipsis-content" uib-tooltip="#:mediaAgentEntity.displayName#" tooltip-append-to-body="true" tooltip-placement="left">#:mediaAgentEntity.displayName#</span></div>',
		width: '14%'
	}
});

export const getAccessTypeColumn = cvLoc => ({
	accessType: {
		searchField: 'accessType',
		title: cvLoc('label.accessType'),
		template: '<div>#:formatedAccessType#</div>',
		width: '13%'
	}
});

export const getAccessibleColumn = cvLoc => ({
	accessible: {
		field: 'accessible',
		title: cvLoc('label.accessible'),
		template: '<div>#:formatedAccessible#</div>',
		width: '13%'
	}
});

export const getActionsColumn = cvLoc => ({
	action: {
		title: cvLoc('Actions'),
		type: 'string',
		template: `<div class="permittedActions"></div>`,
		disableViewFiltering: true,
		sortable: false,
		disableColumnFilter: true,
		width: '10%',
		attributes: {
			class: 'permitted-actions'
		}
	}
});

export const getMountPathColumnTemplate = angularLibs => ({
	...getNameColumn(angularLibs.cvLoc),
	...getPathColumn(angularLibs.cvLoc, angularLibs.labelBucket, angularLibs.model, angularLibs.storagePoolType),
	...getUserNameColumn(angularLibs.cvLoc, angularLibs.libraryVendorType),
	...getAccessTypeColumn(angularLibs.cvLoc),
	...getAccessibleColumn(angularLibs.cvLoc),
	...getActionsColumn(angularLibs.cvLoc)
});

// globalGridOptions, {
//     data: 'deviceList',
//     columnDefs: [{
//       field: "mediaAgentEntity.displayName",
//       displayName: cvLoc("Name"),
//       cellClass: "crop",
//       enableHiding: false
//     }, {
//       field: "path",
//       name: cvLoc("Path"),
//       cellTooltip: true,
//       cellClass: "crop",
//       cellTemplate: '<span class="ngCellText" data-ng-if="grid.appScope.storagePoolType != \'SCALE_OUT\'"><a uib-tooltip="{{row.entity.path}}" tooltip-append-to-body="true" tooltip-placement="bottom"' + 'data-ng-click="grid.appScope.controllerDetails(row.entity.deviceId, row.entity.deviceControllerId, row.entity.mediaAgentEntity, row.entity.path, row.entity.userName, row.entity.accessType, row.entity.protocolType, row.entity.numWriters, row.entity.enabled, row.entity.accessible, row.entity.savedCredential.credentialId, row.entity.savedCredential.credentialName, row.entity.storageClassId);$event.stopPropagation();">' + '{{row.entity.path}}' + '</a></span>' + '<span class="ngCellText" data-ng-if="grid.appScope.storagePoolType == \'SCALE_OUT\'"uib-tooltip="{{row.entity.path}}" tooltip-append-to-body="true" tooltip-placement="bottom">' + '{{row.entity.path}}' + '</span>'
//     }, {
//       field: "userName",
//       displayName: cvLoc("User\ Name"),
//       cellClass: "crop"
//     }, {
//       field: "accessType",
//       displayName: cvLoc("label.accessType"),
//       cellTemplate: '<div>{{row.entity.accessType | accessType}}</div>'
//     // }, {
//     //   field: "numWriters",
//     //   displayName: cvLoc("label.maximumAllowedWriters"),
//     //   cellTemplate: '<div><span data-ng-show="{{((row.entity.accessType | accessTypeValue) ==' + StorageConstants.READ_DEVICEACCESS + ')}}">' + cvLoc("label.N_SLASH_A") + '</span>' + '<span data-ng-hide="{{((row.entity.accessType | accessTypeValue) ==' + StorageConstants.READ_DEVICEACCESS + ')}}">{{row.entity.numWriters | numWriters}}</span></div>'
//     }, {
//       field: "accessible",
//       displayName: cvLoc("label.accessible"),
//       cellTemplate: '<div>{{row.entity.accessible | yesNo}}</div>'
//     }, {
//       name: cvLoc('Actions'),
//       cellTooltip: true,
//       cellTemplate: '<div class="btn-group" uib-dropdown><a data-ng-if="grid.appScope.storagePoolType!=\'SCALE_OUT\'" href class="uib-dropdown-toggle" uib-dropdown-toggle data-ng-disabled="disabled"><span class="grid-action-icon"></span></a><ul uib-dropdown-menu class="dropdown-menu" role="menu">' + '<li><a class="crop" data-ng-click="grid.appScope.deleteController(row.entity.deviceId, row.entity.deviceControllerId, row.entity.mediaAgentEntity, row.entity.path, row.entity.userName, row.entity.accessType, row.entity.protocolType, row.entity.numWriters, row.entity.enabled, row.entity.accessible);">' + cvLoc('action.delete') + '</a></li></ul></div>',
//       enableHiding: false,
//       enableFiltering: false,
//       enableSorting: false,
//       width: '10%'
//     }]
//   });
