import { acAppStorageModule } from 'common/js/modules';

var storageMod = acAppStorageModule;
storageMod.factory('tapeStorageListColumnsTemplateService', [
	'cvLoc',
	function(cvLoc) {
		var factory = {
			getColumns: getColumns
		};

		function getColumns() {
			const columnList = [
				getNameColumn(),
				getStatusColumn(),
				getManufacterColumn(),
				getModelColumn(),
				getActionColumn()
			];
			const columns = {};
			columnList.forEach(column => {
				const field = Object.keys(column)[0];
				columns[field] = column[field];
			});
			return columns;
		}

		function getNameColumn() {
			return {
				'lib.library.libraryName': {
					title: cvLoc('Name'),
					type: 'string',
					attributes: {
						class: 'crop'
					},
					template: `
                    <a href="\\#tapeLibrary?libraryId=#:link.libraryId#&libraryName=#:link.libraryName#&model=#:link.model#">
                        #:lib.library.libraryName#
                    </a>
                `,
					disableViewFiltering: false,
					width: '15%'
				}
			};
		}

		function getStatusColumn() {
			return {
				'lib.status': {
					title: cvLoc('label.status'),
					type: 'string',
					template: `
                    <span> #:lib.status# </span>
                `
				}
			};
		}

		function getManufacterColumn() {
			return {
				'lib.manufacturer': {
					title: cvLoc('label.manufacturer'),
					type: 'string',
					template: `
                    <span> #:lib.manufacturer# </span>
                `
				}
			};
		}

		function getModelColumn() {
			return {
				'lib.libraryVendorId': {
					title: cvLoc('label.model'),
					type: 'string',
					attributes: {
						class: 'crop'
					},
					template: `
                    <span> #:lib.model# </span>
                `
				}
			};
		}

		function getActionColumn() {
			return {
				'lib.library.libraryId': {
					title: cvLoc('Actions'),
					filterable: false,
					searchable: false,
					type: 'string',
					disableViewFiltering: true,
					sortable: false,
					disableColumnFilter: true,
					attributes: {
						class: 'permitted-actions'
					},
					template: `<div class="permittedActions"></div>`,
					width: '10%'
				}
			};
		}
		return factory;
	}
]);

storageMod.factory('tapeVaulTrackerColumnsTemplateService', [
	'cvLoc',
	function(cvLoc) {
		var factory = {
			getColumns: getColumns
		};

		function getColumns() {
			const columnList = [
				getVaultrackerNameColumn(),
				getVaultrackerDestinationColumn(),
				getVaultrackerStatusColumn(),
				getActionColumn()
			];
			const columns = {};
			columnList.forEach(column => {
				const field = Object.keys(column)[0];
				columns[field] = column[field];
			});
			return columns;
		}

		function getVaultrackerNameColumn() {
			return {
				'vault.trackingPolicy.trackingPolicyName': {
					title: cvLoc('Name'),
					type: 'string',
					attributes: {
						class: 'crop'
					},
					template: `
                    <a href="\\#vaultTracker?vaultId=#:vault.trackingPolicy.trackingPolicyId#&vaultName=#:vault.trackingPolicy.trackingPolicyName#&libraryId=#:link.libraryId#&libraryName=#:link.libraryName#&model=#:link.model#">
                        #:vault.trackingPolicy.trackingPolicyName#
                    </a>
                `,
					disableViewFiltering: false,
					width: '15%'
				}
			};
		}

		function getVaultrackerDestinationColumn() {
			return {
				'vault.description': {
					title: cvLoc('label.destination'),
					type: 'string',
					template: `
                    <div class="ellipsis-parent" tooltip-append-to-body="true" 
                        uib-tooltip="#:vault.getDestinationName()#" 
                        tooltip-placement="top" class="ellipsis-content">
                        <span class="ellipsis-content"> 
                            #:vault.getDestinationName()# 
                        </span>
                    </div>
                `
				}
			};
		}

		function getVaultrackerStatusColumn() {
			return {
				'vault.enable': {
					title: cvLoc('label.online'),
					type: 'string',
					template: `
                #if (vault.enable){#
                    <span> Enabled </span>
                #}else {#
                    <span> Disabled </span>
                #};#
                `
				}
			};
		}

		function getActionColumn() {
			return {
				'vault.trackingPolicy.trackingPolicyId': {
					title: cvLoc('Actions'),
					filterable: false,
					searchable: false,
					type: 'string',
					disableViewFiltering: true,
					sortable: false,
					disableColumnFilter: true,
					attributes: {
						class: 'permitted-actions'
					},
					template: `<div class="permittedActions"></div>`,
					width: '10%'
				}
			};
		}
		return factory;
	}
]);

storageMod.factory('tapeDriveColumnsTemplateService', [
	'cvLoc',
	function(cvLoc) {
		var factory = {
			getColumns: getColumns
		};

		function getColumns() {
			const columnList = [
				getDriveNameColumn(),
				getDriveTypeColumn(),
				getStatusColumn(),
				getAccessColumn(),
				getBarCodeColumn(),
				getMountStatusColumn(),
				getActionColumn()
			];
			const columns = {};
			columnList.forEach(column => {
				const field = Object.keys(column)[0];
				columns[field] = column[field];
			});
			return columns;
		}

		function getDriveNameColumn() {
			return {
				'drive.driveId': {
					title: cvLoc('Name'),
					type: 'string',
					attributes: {
						class: 'crop'
					},
					template: `
                    #if (link.stateName === 'tapeLibraryDetails'){#
                        <a href="\\#/drive?libraryId=#:link.libraryId#&libraryName=#:link.libraryName#&model=#:link.model#&driveId=#:drive.driveId#">
                            #:drive.driveName#
                        </a>
                    #}else if (link.stateName === 'tapeStoragePoolDetails'){#
                        <a href="\\#storagePoolDrive?storagePoolName=#:link.storagePoolName#&storagePoolId=#:link.storagePoolId#&storagePoolType=#:link. c#&libraryId=#:link.libraryId#&libraryName=#:link.libraryName#&model=#:link.model#&driveId=#:drive.driveId#">
                            #:drive.driveName#
                        </a>
                    #};#
                `,
					disableViewFiltering: false,
					width: '20%'
				}
			};
		}

		function getDriveTypeColumn() {
			return {
				'drive.driveType': {
					title: cvLoc('label.driveType'),
					type: 'string',
					width: '15%'
				}
			};
		}

		function getStatusColumn() {
			return {
				'drive.status': {
					title: cvLoc('label.online'),
					type: 'string',
					width: '10%'
				}
			};
		}

		function getAccessColumn() {
			return {
				'drive.access': {
					title: cvLoc('label.status'),
					type: 'string',
					width: '15%'
				}
			};
		}

		function getBarCodeColumn() {
			return {
				'drive.barcode': {
					title: cvLoc('label.barcode'),
					type: 'string',
					width: '15%'
				}
			};
		}

		function getMountStatusColumn() {
			return {
				'drive.mountStatus': {
					title: cvLoc('label.mountStatus'),
					type: 'string',
					width: '15%'
				}
			};
		}

		function getActionColumn() {
			return {
				'drive.driveID': {
					title: cvLoc('Actions'),
					filterable: false,
					searchable: false,
					type: 'string',
					disableViewFiltering: true,
					sortable: false,
					disableColumnFilter: true,
					attributes: {
						class: 'permitted-actions'
					},
					template: `<div class="permittedActions"></div>`,
					width: '10%'
				}
			};
		}

		return factory;
	}
]);

export default storageMod;
