import { acAppStorageModule } from 'common/js/modules';

var storageMod = acAppStorageModule;

storageMod.factory('encryptService', [
	'$log',
	'$state',
	'cvLoc',
	'cvToaster',
	'storagePolicyService',
	function($log, $state, cvLoc, cvToaster, storagePolicyService) {
		var factory = {};

		factory.isChangedkeyManagement = false;

		factory.updateEncryption = function(encryption, storagePolicyCopy, opts) {
			let data = {
				storagePolicyCopyInfo: {
					StoragePolicyCopy: storagePolicyCopy,
					copyFlags: {
						auxCopyReencryptData: encryption.encrypt === true ? 1 : 0,
						preserveEncryptionModeAsInSource: encryption.encrypt === false ? 1 : 0,
						storeKeyOnMedia: encryption.storeOnMedia === true ? 1 : 0
					},
					dataEncryption: {},
					extendedFlags: {
						encryptOnDependentPrimary: encryption.encrypt === true ? 1 : 0
					}
				}
			};

			if (encryption.encrypt) {
				data.storagePolicyCopyInfo.dataEncryption.encryptionKeyLength = opts.selectedKeyLength[0].length;
				data.storagePolicyCopyInfo.dataEncryption.encryptionType = opts.selectedCipher[0].name;
			} else {
				data.storagePolicyCopyInfo.dataEncryption.encryptionType = 0;
				data.storagePolicyCopyInfo.dataEncryption.encryptionKeyLength = 0;
			}

			if (factory.isChangedkeyManagement) {
				data.storagePolicyCopyInfo.dataEncryption.keyProvider = {
					keyProviderId: opts.selectedKeyManagement[0].keyProviderId,
					keyProviderName: opts.selectedKeyManagement[0].keyProviderName
				};
				data.storagePolicyCopyInfo.dataEncryption.keyProviderName = opts.selectedKeyManagement[0].keyProviderName;
				data.storagePolicyCopyInfo.dataEncryption.rotateMasterKey = true;
			}

			return storagePolicyService
				.updateStoragePolicyCopy(storagePolicyCopy.storagePolicyId, storagePolicyCopy.copyId, data)
				.then(({ data }) => {
					if ((data.error && data.error.errorCode === 0) || data.errorCode === 0) {
						$log.debug(cvLoc('log.succesUpdatePolicy'));
						$state.forceReload();
					} else {
						$log.error(cvLoc('log.errorUpdatePolicy'));
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: data.error.errorMessage ? data.error.errorMessage : cvLoc('popup.errorFetchingMedia')
						});

						return data;
					}
				})
				.catch(({ data }) => {
					$log.error(cvLoc('log.errorUpdatePolicy'));
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: data.errorMessage ? data.errorMessage : cvLoc('popup.errorFetchingMedia')
					});

					return data;
				});
		};

		return factory;
	}
]);

storageMod.factory('addEncryptionDialogFactory', [
	'$uibModal',
	'encryptService',
	function($modal, encryptService) {
		var factory = {};

		factory.showAddEncryptionDialog = function({ encryption, storagePolicyCopy, cipherList, getkeyLengths }) {
			var uibModalInstance = $modal.open({
				templateUrl: appUtil.appRoot + '/modules/storage/partials/addEncryptionDialogTemplate.jsp',
				backdrop: 'static',
				windowClass: 'small-size',
				controllerAs: 'vm',
				controller: [
					'$uibModalInstance',
					function($uibModalInstance) {
						var vm = this;
						onInit();
						function onInit() {
							vm.test = {
								selectedCipher: [],
								selectedKeyLength: []
							};
							vm.cipherList = [...cipherList];
							vm.keyLengths = []; // avoid undefined
							vm.getkeyLengths = getkeyLengths.bind(vm); // bind in order to reuse logic that's outside of this controller
							vm.addEncrypt = addEncrypt;
							vm.cancel = cancel;
							vm.canSubmit = canSubmit;
						}

						function addEncrypt() {
							encryptService
								.updateEncryption(encryption, storagePolicyCopy, vm.test)
								.then(data => {
									if (data.error || data.errorMessage) {
										encryption.encrypt = false;
									}
								})
								.finally(() => {
									$uibModalInstance.dismiss();
								});
						}

						function canSubmit() {
							return vm.test.selectedCipher.length > 0 && vm.test.selectedKeyLength.length > 0;
						}

						function cancel() {
							encryption.encrypt = false;
							$uibModalInstance.dismiss();
						}
					}
				]
			});
			return uibModalInstance;
		};
		return factory;
	}
]);

export default storageMod;
