import { acAppStorageModule } from 'common/js/modules';

class storageIndexCacheController {
	constructor(cvLoc) {
		this.cvLoc = cvLoc;

		this.mountPaths = [];
	}

	$onInit() {
		this._initlizeGrid();
	}

	_initlizeGrid() {
		this.tileTitle = this.tileTitle || this.cvLoc('title.storageIndex');
		if (this.diskLibrary) {
			this.mountPaths = this.diskLibrary.MountPathList || [];

			this.cvGridOptions = {
				hasTitle: false,
				tableName: 'storageIndexTable',
				hideToolbar: true,
				enableFiltering: false,
				hasViews: false,
				enableColumnMenu: false,
				enablePaging: true,
				pageSize: 10,
				columns: {
					mountPathName: {
						title: this.cvLoc('Path'),
						type: 'string'
					},
					status: {
						title: this.cvLoc('title.status'),
						type: 'string'
					}
				},
				data: this.mountPaths
			};
		}
	}
}

storageIndexCacheController.$inject = ['cvLoc'];

acAppStorageModule.directive('storageIndexCacheTile', () => ({
	restrict: 'E',
	bindToController: true,
	controller: storageIndexCacheController,
	template: `
            <cv-tile-component title="{{ SICController.tileTitle }}">
                <cv-kendo-grid ng-if="SICController.cvGridOptions" class="storage-retention-grid" cv-grid-options="SICController.cvGridOptions" />
            </cv-tile-component>
        `,
	controllerAs: 'SICController',
	scope: {
		diskLibrary: '=',
		tileTitle: '@?'
	}
}));

export default acAppStorageModule;
