import 'adminConsole/js/directives/cv-detect-tape-library.js';
import 'browse/js/controllers/browse.ctrl.js';
import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'storage/js/services/storage.svc.js';
import 'webScale/js/controllers/storagePool.ctrl.js';
import 'adminConsole/js/controllers/cloudLibConstants.js';
import 'dlo/js/controllers/profile.ctrl.js';
import 'adminConsole/js/factories/rpstore.factory.js';
import 'adminConsole/js/controllers/rpstore.ctrl.js';
import 'modules/policies/storagePolicy/js/services/storagePolicy.svc';

import { acAppStorageModule } from 'common/js/modules';

var storageMod = acAppStorageModule;

const storageControllers = {};

storageControllers.wizardController = [
	'$scope',
	'sharedData',
	'cvLoc',
	'cvUtil',
	'storageService',
	'$filter',
	'$timeout',
	'StorageConstants',
	'$log',
	function($scope, sharedData, cvLoc, cvUtil, storageService, $filter, $timeout, StorageConstants, $log) {
		var steps = ['step1.html', 'step2.html'];
		$scope.steps = steps;
		$scope.currStep = 0;
		$scope.test = {};
		var maList = [];
		$scope.windowsOS = true;
		$scope.wrongMASelection = false;

		var form = {};
		$scope.setForm = function(shareDiskform) {
			form = shareDiskform;
			return;
		};

		$scope.cancel = function() {
			$scope.$emit('shareMountPathCancelled');
		};
		$scope.next = function() {
			if ($scope.currStep == $scope.steps.length - 1) {
				setTimeout(function() {
					angular.element('#btnSubmit').click();
				}, 2);
				return;
			}
			if ($scope.agentList != undefined && $scope.agentList.length == 0) {
				$scope.cancel();
				return;
			}
			maList = [];
			$scope.windowsOS = true;
			$scope.wrongMASelection = false;
			//$scope.selectedRows = $scope.gridApi.selection.getSelectedRows();
			if ($scope.selected.rows.length < 1) {
				$scope.serverMessage = cvUtil.errMsg(cvLoc('error.pickingMAForSharing'));
				return;
			} else {
				for (var i = 0; i < $scope.selected.rows.length; i++) {
					maList.push({
						mediaAgentId: $scope.selected.rows[i].mediaAgent.mediaAgentId,
						mediaAgentName: $scope.selected.rows[i].mediaAgent.mediaAgentName,
						osVersion: $scope.selected.rows[i].osVersion,
						readWriteMode: $scope.selected.rows[i].readWriteMode,
						mediaAgent: {
							mediaAgentId: $scope.selected.rows[i].mediaAgent.mediaAgentId,
							mediaAgentName: $scope.selected.rows[i].mediaAgent.mediaAgentName,
							displayName: $scope.selected.rows[i].mediaAgent.displayName
						}
					});
				}
				sharedData.selectedRows = maList;
				if (sharedData.data.model == cvLoc('label.cloud') || sharedData.data.model == cvLoc('label.disk')) {
					$scope.addEditShareLibrary();
					return;
				} else {
					for (var i = 0; i < maList.length; i++) {
						if (i == 0) {
							if (maList[0].osVersion.search('Windows') == -1) {
								$scope.windowsOS = false;
							}
							continue;
						}
						if ($scope.windowsOS && maList[i].osVersion.search('Windows') == -1) {
							$scope.windowsOS = false;
							$scope.serverMessage = cvUtil.errMsg(cvLoc('error.maSelectionForSharing'));
							$scope.wrongMASelection = true;
							break;
						}
						if (!$scope.windowsOS && maList[i].osVersion.search('Windows') >= 0) {
							$scope.windowsOS = true;
							$scope.serverMessage = cvUtil.errMsg(cvLoc('error.maSelectionForSharing'));
							$scope.wrongMASelection = true;
							break;
						}
					}
					if (!$scope.wrongMASelection) {
						$scope.currStep++;
						if ($scope.typeOfStorage.type == 'localStorage') {
							$scope.pathPattern.pattern = !$scope.windowsOS ? $scope.linuxPathPattern : $scope.localPathPattern;
						} else {
							$scope.pathPattern.pattern = $scope.networkPathPattern;
						}
						$scope.libraryInfo.controller.mediaAgentId = maList[0].mediaAgent.mediaAgentId;
					}
				}
			}
		};

		$scope.prev = function() {
			console.debug($scope.currStep);
			if ($scope.currStep == 0) {
				return;
			}
			$scope.selected.rows = [];
			maList = [];
			sharedData.selectedRows = [];
			$scope.currStep--;
		};

		$scope.isNextButtonEnabled = function() {
			return $scope.selected.rows && $scope.selected.rows.length > 0;
		};

		$scope.getNextBtnText = function() {
			if ($scope.currStep == $scope.steps.length - 1) {
				return cvLoc('label.finish');
			}
			if ($scope.agentList != undefined && $scope.agentList.length > 0) {
				if (sharedData.data.model != cvLoc('label.cloud') && sharedData.data.model != cvLoc('label.disk')) {
					return cvLoc('label.next');
				}
			}
			return cvLoc('action.save');
		};

		$scope.getPrevBtnText = function() {
			if ($scope.currStep == $scope.steps.length - 1) {
				return cvLoc('label.previous');
			} else {
				return null;
			}
		};

		////////
		$scope.libraryInfo = $scope.maEntity;

		/*
		 * The incoming format could be something like - [mat42_D] \\mat42\c$\Arun_NW_Test so we parse out the MA
		 * name and look for the \\
		 */
		if ($scope.libraryInfo.mountPath.name.charAt(0) === '[') {
			$scope.libraryInfo.mountPath.name = $scope.libraryInfo.mountPath.name.substring(
				$scope.libraryInfo.mountPath.name.lastIndexOf(']') + 2
			);
		}

		if ($scope.libraryInfo.mountPath.name.indexOf('\\\\') == 0) {
			$scope.typeOfStorage = {
				type: 'networkStorage'
			};
			$scope.pathPattern = {
				pattern: $scope.networkPathPattern
			};
		} else {
			$scope.typeOfStorage = {
				type: 'localStorage'
			};
		}
		$scope.addEditShareLibrary = function() {
			$scope.serverMessage = {
				message: '',
				type: ''
			};

			var libraryInfo = angular.extend({}, $scope.libraryInfo);
			if (libraryInfo.writersNumber.maxWriters == -1) {
				libraryInfo.controller.numWriters = -1;
			} else {
				libraryInfo.controller.numWriters = libraryInfo.writersNumber.allowedWritersNumber;
			}
			if (libraryInfo.enabled) {
				libraryInfo.controller.enabled = 1;
			} else {
				libraryInfo.controller.enabled = 0;
			}
			if (libraryInfo.accessible) {
				libraryInfo.controller.accessible = 1;
			} else {
				libraryInfo.controller.accessible = 0;
			}
			if (sharedData.data.model == cvLoc('label.disk') && sharedData.data.model != cvLoc('label.cloud')) {
				libraryInfo.controller.protocolType = StorageConstants.AUTOMATIC_DEVICEACCESS;
			}
			if (libraryInfo.controller.protocolType != 0) {
				libraryInfo.mountPath.name = '';
			} else if (
				(sharedData.data.model != cvLoc('label.cloud') && libraryInfo.mountPath.name == '') ||
				libraryInfo.mountPath.name == undefined
			) {
				$scope.serverMessage = cvUtil.errMsg(cvLoc('error.mountpath.required'));
				return;
			}

			const ma = sharedData.selectedRows.map(mediaAgent => ({
				...mediaAgent,
				readWriteMode: sharedData.data.model === 'Disk' ? ($scope.typeOfStorage.type === 'networkStorage' ? 6 : 4) : 6
			}));

			storageService
				.shareDiskOrCloudMountPath(ma, libraryInfo, $scope.typeOfStorage.type, $scope.action)
				.success(() => isReadyForAPICall('storageShared', 'shared storage'))
				.error(function(e) {
					if (!$scope.isAPICall) {
						$log.error('Sharing storage failed');
						$scope.serverMessage = cvUtil.errMsg(e);
					}
				});
		};

		const responseApiFromAgentList = options => {
			storageService
				.getMAToShareMountPath($scope.libraryInfo.mountPath.id)
				.success(function(data) {
					$scope.agentList = data;
					if (data.length == 0) {
						$scope.serverMessage = cvUtil.errMsg('No MediaAgents available');
					}
					if (
						$scope.libraryInfo.controller.dataServerType != undefined &&
						$scope.libraryInfo.controller.dataServerType != 0
					) {
						var transportTypeString = $filter('TransportTypeString')($scope.libraryInfo.controller.dataServerType);
						var transportType = $filter('TransportType')($scope.libraryInfo.controller.dataServerType);
						$scope.shareTypes = [
							{
								text: cvLoc('label.Regular'),
								value: 0
							},
							{
								text: transportTypeString,
								value: transportType
							}
						];
					}
					$scope.flagShowGrid = true;
					options.success(data);
				})
				.error(function(data, status, headers, config) {
					$scope.serverMessage = cvUtil.errMsg(data);
					options.error(data);
					return false;
				});
		};
		$scope.libraryInfo.mountPath.name = '';

		// initialize iif not initialized
		if ($scope.savedCredentials === undefined) {
			$scope.savedCredentials = [];
		}
		$scope.showCredentialDropDown = $scope.libraryInfo.selectedCredential.credentialId !== 0;
		$scope.switchToCM = $scope.showCredentialDropDown ? 'enabled-activity' : 'disabled-activity';

		$scope.kendGridOptions = {};
		$scope.selected = $scope.selected ? { ...$scope.selected, rows: [] } : { rows: [] };
		$scope.kendGridOptions.gridOptions = {
			url: options => {
				responseApiFromAgentList(options);
			},
			enableCheckBoxColumn: true,
			idField: 'mediaAgent.displayName',
			hasViews: false,
			tableName: 'mediaAgent.displayName',
			pageSize: 10,
			pageSizes: [5, 10, 15],
			sortDirection: {
				field: 'mediaAgent.displayName',
				dir: 'asc'
			},
			columns: {
				'mediaAgent.displayName': {
					title: cvLoc('Name'),
					type: 'string',
					width: '80%',
					attributes: {
						class: 'crop'
					},
					template: `
              <span> #:mediaAgent.displayName# </span>
          `
				}
			},
			onGridSelectionChange: e => {
				$timeout(function() {
					$scope.selected.rows = e.values;
					$scope.selected.saveButtonEnable = e.values && e.values.length > 0;
				}, 100);
			},
			beforeGridInitialize: ({ grid }) => {
				$scope.flagShowGrid = false;
			},
			hideToolbar: true,
			enableFiltering: false,
			enableColumnMenu: false,
			gridEmptyMessage: '<div class="text-align-center">' + cvLoc('label.noMediaAgentsAvailable') + '</div>',
			gridEmptySvg: `<svg class="add-new-placeholder" version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" viewBox="0 0 160 200" xml:space="preserve"><path d="M121,167a5,5,0,0,0,5-5V38a5,5,0,0,0-5-5H39a5,5,0,0,0-5,5V162a5,5,0,0,0,5,5h82ZM44.8,53.3h70.4v3H44.8v-3Zm0,12h70.4v3H44.8v-3Zm0,12h70.4v3H44.8v-3Zm0,12h70.4v3H44.8v-3ZM72,134.8a8,8,0,1,1,8,8A8,8,0,0,1,72,134.8Z"/></svg>`
		};

		const isReadyForAPICall = (eventName, debugMessage) => {
			if ($scope.isAPICall) {
				return;
			} else {
				$scope.$emit(eventName);
				$log.debug(debugMessage);
			}
		};
	}
];

storageMod.controller(storageControllers);

export default storageMod;
