import { acAppStorageModule } from 'common/js/modules';
import 'adminConsole/js/directives/cv-detect-tape-library.js';
import 'browse/js/controllers/browse.ctrl.js';
import 'modules/storage/js/filters/storage.filters.js';
import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'storage/js/services/storage.svc.js';
import 'webScale/js/controllers/storagePool.ctrl.js';
import 'adminConsole/js/controllers/cloudLibConstants.js';
import 'dlo/js/controllers/profile.ctrl.js';
import 'adminConsole/js/factories/rpstore.factory.js';
import 'adminConsole/js/controllers/rpstore.ctrl.js';
import 'modules/policies/storagePolicy/js/services/storagePolicy.svc';
import 'credentialManager/js/constants/credentialManager.constant.js';
import * as mountPathColumnTemplates from '../mountPath.column.template';

var storageMod = acAppStorageModule;

const storageControllers = {};

storageControllers.mountPathDetailsController = [
	'CLOUD_TYPE_LIST',
	'CLOUD_TYPE_LABELS',
	'sharedData',
	'$scope',
	'$http',
	'storageService',
	'storageFactory',
	'cvToaster',
	'$rootScope',
	'$uibModal',
	'cvBreadcrumbsTabsFactory',
	'$stateParams',
	'cvTableOptions',
	'cvLoc',
	'$filter',
	'StorageConstants',
	'$dialogs',
	'cvUtil',
	'$log',
	'$state',
	'CREDENTIAL_TYPE',
	'CLOUD_VENDOR_TYPE',
	'$compile',
	function(
		CLOUD_TYPE_LIST,
		CLOUD_TYPE_LABELS,
		sharedData,
		$scope,
		$http,
		storageService,
		storageFactory,
		cvToaster,
		$rootScope,
		$modal,
		cvBreadcrumbsTabsFactory,
		$stateParams,
		cvTableOptions,
		cvLoc,
		$filter,
		StorageConstants,
		$dialogs,
		cvUtil,
		$log,
		$state,
		CREDENTIAL_TYPE,
		CLOUD_VENDOR_TYPE,
		$compile
	) {
		$scope.mountPathId = $stateParams.mountPathId;
		$scope.libraryId = $stateParams['libraryId'];
		$scope.libraryName = $stateParams['libraryName'];
		$scope.model = $stateParams['model'];
		$scope.storagePoolId = $stateParams['storagePoolId'];
		$scope.storagePoolName = $stateParams['storagePoolName'];
		$scope.storagePoolType = $stateParams['storagePoolType'];
		$scope.stateName = $state.current.name;
		$scope.libraryVendorId = $stateParams['libraryVendorId'];
		$scope.control = {};
		$scope.control.enableMp = true;
		$scope.control.disableForWrite = false;
		$scope.control.showPrepareForRetirement = false;
		$scope.control.preventRef = false;
		$scope.control.showCredentials = false;
		$scope.credentialType = 100;
		$scope.savedStorageAcceleratorCredentials = [];
		$scope.control.outputCredentialList = [];
		$scope.control.isEditingCredentials = false;
		$scope.credentialUpdateError = {
			message: '',
			type: ''
		};
		$scope.showUpdateCredError = false;
		$scope.control.originalStorageAcceleratorCredentials = {
			credentialId: 0,
			credentialName: ''
		};
		$scope.control.selectedCredential = {
			credentialId: 0,
			credentialName: ''
		};
		sharedData.data = {
			libId: $scope.libraryId,
			libName: $scope.libraryName,
			model: $scope.model,
			libraryVendorId: $scope.libraryVendorId || 0
		};
		$scope.cvLoc = cvLoc;
		$scope.HPE_CATALYST_STORAGE = 59;
		const initSCGrid = function() {
			setupGridOptions();
		};
		$scope.updateMPStatus = () => {
			$scope.control.enableMp = !$scope.control.enableMp;
			$scope.libraryInfo = {
				libraryName: $scope.libraryName,
				mountPath: {
					id: $scope.mountPathId,
					name: $scope.mountPathId
				},
				mediaAgent: $scope.mpDetails.mountPathSummary.associatedMA[0],
				enabledMP: $scope.control.enableMp ? 1 : 0
			};
			return storageService
				.updateStatus($scope.libraryInfo)
				.success(function(data) {
					$scope.$emit('mountPathEdited');
					$log.debug('mountPathEdited');
				})
				.error(function(e) {
					$log.error('Editing mountPath failed');
					$scope.serverMessage = cvUtil.errMsg(e);
				});
		};

		$scope.enableDisableForWrites = () => {
			$scope.control.disableForWrite = !$scope.control.disableForWrite;
			$scope.libraryInfo = {
				libraryName: $scope.libraryName,
				mountPath: {
					id: $scope.mountPathId,
					name: $scope.mountPathId
				},
				mediaAgent: $scope.mpDetails.mountPathSummary.associatedMA[0],
				numOfWritersForMountpath: $scope.control.disableForWrite ? 0 : 1000,
				preventDataBlockReferences: $scope.control.disableForWrite ? ($scope.control.preventRef ? 1 : 0) : 0
			};
			return storageService
				.updateWriters($scope.libraryInfo)
				.success(function(data) {
					$scope.$emit('mountPathEdited');
					$log.debug('mountPathEdited');
					$scope.control.showPrepareForRetirement = $scope.control.disableForWrite;
				})
				.error(function(e) {
					$scope.control.disableForWrite = !$scope.control.disableForWrite;
					$log.error('Editing mountPath failed');
					$scope.serverMessage = cvUtil.errMsg(e);
				});
		};

		$scope.enableDisableForReferences = () => {
			$scope.control.preventRef = !$scope.control.preventRef;
			$scope.libraryInfo = {
				libraryName: $scope.libraryName,
				mountPath: {
					id: $scope.mountPathId,
					name: $scope.mountPathId
				},
				mediaAgent: $scope.mpDetails.mountPathSummary.associatedMA[0],
				preventDataBlockReferences: $scope.control.preventRef ? 1 : 0,
				numOfWritersForMountpath: $scope.control.disableForWrite ? 0 : 1000
			};
			return storageService
				.updateWriters($scope.libraryInfo)
				.success(function(data) {
					$scope.$emit('mountPathEdited');
					$log.debug('mountPathEdited');
				})
				.error(function(e) {
					$scope.control.preventRef = !$scope.control.preventRef;
					$log.error('Editing mountPath failed');
					$scope.serverMessage = cvUtil.errMsg(e);
				});
		};

		const getGridTitle = () => {
			switch ($scope.model) {
				case 'Cloud': {
					return sharedData.data.libraryVendorId === $scope.HPE_CATALYST_STORAGE
						? cvLoc('label.hpeCatalystStorageAccessPaths')
						: cvLoc('label.cloudAccessPaths');
				}
				default: {
					return cvLoc('label.diskAccessPaths');
				}
			}
		};

		const setupGridOptions = function() {
			let gridOptions = {};
			gridOptions.enableResizing = true;
			gridOptions.columns = initColumnDefs();
			gridOptions.gridTitle = getGridTitle();
			// cvServerMessage: "mediaAgentMessage",
			gridOptions.tableName = 'mediaAgentsTable';
			gridOptions.enableCheckBoxColumn = false;
			gridOptions.url = fetchDataMountPath.bind(this);
			gridOptions.onGridDataBound = _onGridDataBound.bind(this);
			gridOptions.enablePaging = true;
			gridOptions.pageSize = 20;
			gridOptions.pageSizes = [5, 10, 20, 50, 100];
			gridOptions.hasViews = true;
			gridOptions.gridToolbarMenu = [
				{
					id: 'AddMediaAgent',
					disableOnDeselect: false,
					label: cvLoc('pageHeader.addMediaAgent'),
					onSelect: () => {
						$scope.openWizard();
					}
				}
			];
			$scope.gridOptionsKendo = gridOptions;
		};

		function _computePermittedActionsForMountPath(entity) {
			const arrayOfActionsToMountPath = [
				{
					show: true,
					value: 'DELETE',
					label: cvLoc('action.delete'),
					onClick: () =>
						$scope.deleteController(
							entity.deviceId,
							entity.deviceControllerId,
							entity.mediaAgentEntity,
							entity.path,
							entity.userName,
							entity.accessType,
							entity.protocolType,
							entity.numWriters,
							entity.enabled,
							entity.accessible
						)
				}
			];
			return arrayOfActionsToMountPath;
		}

		function fetchDataMountPath(options) {
			return storageService
				.getDeviceInfoForMountPath($scope.mountPathId)
				.success(function(mpDetails) {
					$scope.deviceList = mpDetails.deviceList;
					$scope.mpDetails = mpDetails;
					sharedData.data.libraryVendorId = $scope.mpDetails.libraryVendorId;
					$scope.metallicStorageInfo = {
						licenseType: mpDetails.metallicStorageInfo.licenseType,
						region: mpDetails.metallicStorageInfo.hasOwnProperty('region')
							? mpDetails.metallicStorageInfo.region[0]
							: null,
						storageClass: mpDetails.metallicStorageInfo.hasOwnProperty('storageClass')
							? mpDetails.metallicStorageInfo.storageClass[0]
							: 0,
						replication: mpDetails.metallicStorageInfo.hasOwnProperty('replication')
							? mpDetails.metallicStorageInfo.replication[0]
							: 0
					};
					if ($scope.mpDetails.savedCredential.credentialId === undefined) {
						$scope.control.selectedCredential = {
							credentialId: 0,
							credentialName: ''
						};
					} else {
						$scope.control.selectedCredential.credentialId = $scope.mpDetails.savedCredential.credentialId;
						$scope.control.selectedCredential.credentialName = $scope.mpDetails.savedCredential.credentialName;
						$scope.control.originalStorageAcceleratorCredentials = angular.copy($scope.control.selectedCredential);
					}
					initializeCredentials();

					$scope.deviceList.forEach(device => {
						device.originalUserName = angular.copy(device.userName);
						const proxyStart = device.originalUserName.indexOf('!!');
						if (proxyStart > 0) {
							device.originalUserName = device.originalUserName.substring(0, proxyStart);
						}
						const credIndex = device.originalUserName.indexOf('|-|');
						if (credIndex > 0) {
							device.originalUserName = device.originalUserName.substring(0, credIndex + 3);
							device.originalUserName = device.originalUserName.concat('__CVCREDID__');
						}
					});

					$scope.deviceList = $scope.deviceList.map(device => {
						const userName = device.userName;
						if (userName && userName.includes('@')) {
							const n = userName.indexOf('@');
							const n1 = userName.indexOf('/');
							device.userName = userName.substring(0, n) + userName.substring(n1);
							device.storageClassId = parseInt(n1 > 0 ? userName.substring(n + 1, n1) : userName.substring(n + 1));
						}
						device.path = device.path;
						device.pathRename = transformPathName(device.path);
						device.formatedAccessType = $filter('accessType')(device.accessType);
						device.formatedAccessible = $filter('yesNo')(device.accessible);
						device.permittedOptions = {
							entityId: device.mediaAgent.id,
							appendToBody: true,
							permittedActionList: _computePermittedActionsForMountPath(device)
						};

						return device;
					});

					if ($scope.stateName === 'storagePoolMountPathDetailsChart') {
						cvBreadcrumbsTabsFactory.addBreadCrumbs([
							{
								title: $scope.mpDetails.mountPathSummary.libraryName,
								link:
									'#/storagePoolMountPath?storagePoolName=' +
									encodeURIComponent($scope.storagePoolName) +
									'&storagePoolId=' +
									$scope.storagePoolId +
									'&storagePoolType=' +
									$scope.storagePoolType +
									'&libraryName=' +
									$scope.libraryName +
									'&model=' +
									$scope.model +
									'&mountPathId=' +
									$scope.mountPathId
							}
						]);
					} else if ($scope.stateName === 'mountPathDetailsChart') {
						cvBreadcrumbsTabsFactory.addBreadCrumbs([
							{
								title: $scope.mpDetails.mountPathSummary.libraryName,
								link:
									'#/mountPath?libraryId=' +
									$scope.libraryId +
									'&libraryName=' +
									encodeURIComponent($scope.libraryName) +
									'&model=' +
									$scope.model +
									'&storagePoolType=' +
									$scope.storagePoolType +
									'&mountPathId=' +
									$scope.mountPathId
							}
						]);
					}
					$scope.mediaAgentMessage = cvUtil.emptyMsg();
					$scope.control.enableMp = $scope.mpDetails.enabledMP;
					$scope.control.disableForWrite = $scope.mpDetails.disabledForNewWrite;
					$scope.control.showPrepareForRetirement = $scope.control.disableForWrite;
					$scope.control.preventRef = $scope.mpDetails.preventDataBlockReferences;
					options.success($scope.deviceList);
				})
				.error(function(e) {
					$scope.mediaAgentMessage = cvUtil.errMsg(e);
					options.error(e);
				});
		}
		function _onGridDataBound(dataItem, row) {
			const permittedOptions = dataItem.permittedOptions;
			const id = permittedOptions.entityId;
			const template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
			const tooltip = `<span class="crop" cv-toggle-content="${dataItem.path}" cv-toggle="tooltip"></span>`;
			$scope[`permittedOptions${id}`] = permittedOptions;
			row.find('.permittedActions').append($compile(template)($scope));
			row.find('#cv-k-grid-td-path').append($compile(tooltip)($scope)); // tooltip for show the path

			const detailLink = row.find('.k-grid-pathEdit');
			detailLink.click(() => $scope.onClickPath(dataItem));
		}

		$scope.onClickPath = dataItem => {
			$scope.controllerDetails(
				dataItem.deviceId,
				dataItem.deviceControllerId,
				dataItem.mediaAgentEntity,
				dataItem.path,
				dataItem.userName,
				dataItem.accessType,
				dataItem.protocolType,
				dataItem.numWriters,
				dataItem.enabled,
				dataItem.accessible,
				dataItem.savedCredential.credentialId,
				dataItem.savedCredential.credentialName,
				dataItem.storageClassId,
				dataItem.originalUserName
			);
		};

		function setCloudPathColumn() {
			var serverType = null;
			if (sharedData.data.libraryVendorId !== 0) {
				CLOUD_TYPE_LIST.CloudType.forEach(cloudtype => {
					if (cloudtype.id === parseInt(sharedData.data.libraryVendorId)) {
						serverType = cloudtype;
					}
				});
			}

			if (!serverType || serverType.name === '') {
				serverType = CLOUD_TYPE_LIST.CloudType[0];
			}

			$scope.serverLabelBucket = CLOUD_TYPE_LABELS.CloudLabel[serverType.id].label_Bucket;
		}
		function initializeCredentials() {
			setShowCredentials();
			// Initially $scope.credentialType contains base value, which is 100
			// If libraryVendorId is 'Amazon S3'(2) then set CredentialType to CLOUD_VENDOR_TYPE.AMAZON(13)
			// If libraryVendorId is 'Microsoft Azure Storage'(3) then set CredentialType to  CLOUD_VENDOR_TYPE.MICROSOFT_AZURE_TYPE(14)
			if ($scope.control.showCredentials) {
				if (parseInt($scope.libraryVendorId) === 2) {
					$scope.credentialType = CLOUD_VENDOR_TYPE.AMAZON;
				} else if (parseInt($scope.libraryVendorId) === 3) {
					$scope.credentialType = CLOUD_VENDOR_TYPE.MICROSOFT_AZURE_TYPE;
				} else {
					$scope.credentialType = parseInt($scope.libraryVendorId) + parseInt($scope.credentialType);
				}
				//Send request only if its cloud vendor
				storageService.getCredentials($scope.credentialType).then(credentialsList => {
					$scope.savedStorageAcceleratorCredentials = credentialsList.list;
					$scope.savedStorageAcceleratorCredentials.forEach(function(item, index) {
						if (item.credentialId === $scope.control.selectedCredential.credentialId) {
							item.selected = true;
						}
					});
				});
			}
		}
		function setShowCredentials() {
			if (
				$scope.libraryVendorId === undefined ||
				!storageService.getCloudCredentialsSupport(parseInt($scope.libraryVendorId))
			) {
				$scope.control.showCredentials = false;
			} else {
				$scope.control.showCredentials = true;
			}
		}

		$scope.openCreateCredentialModal = () => {
			storageFactory.openCreateCredentialModal($scope.credentialType).then(credentialsList => {
				if (credentialsList) {
					$scope.savedStorageAcceleratorCredentials = credentialsList.list || $scope.savedStorageAcceleratorCredentials;
					//To Reset the changes
					$scope.savedStorageAcceleratorCredentials.forEach(function(credential, index) {
						if (credential.credentialName === credentialsList.name) {
							$scope.control.selectedCredential.credentialId = credential.credentialId;
							$scope.control.selectedCredential.credentialName = credential.credentialName;
							$scope.control.isEditingCredentials = true;
						}
					});
				}
			});
		};
		$scope.openEditCredentialModal = function(credentialEntity) {
			storageFactory.openEditCredentialModal($scope.control.selectedCredential).then(editedCredentialName => {
				if (editedCredentialName) {
					$scope.control.selectedCredential.credentialName = editedCredentialName;
					$scope.savedStorageAcceleratorCredentials.forEach(function(credential, index) {
						if (credential.credentialId === $scope.control.selectedCredential.credentialId) {
							credential.credentialName = editedCredentialName;
						}
					});
				}
			});
		};
		$scope.onChangeCredential = credential => {
			if (
				$scope.control.selectedCredential != undefined &&
				$scope.control.originalStorageAcceleratorCredentials.credentialId !=
					$scope.control.outputCredentialList[0].credentialId
			) {
				$scope.control.isEditingCredentials = true;
				$scope.isCredential = false;
			}
			$scope.control.selectedCredential = $scope.control.outputCredentialList[0];
		};
		$scope.onDiscardChanges = () => {
			$scope.control.selectedCredential.credentialId =
				$scope.control.originalStorageAcceleratorCredentials.credentialId;
			$scope.control.selectedCredential.credentialName =
				$scope.control.originalStorageAcceleratorCredentials.credentialName;
			$scope.control.isEditingCredentials = false;
			$scope.isCredential = true;

			//To Reset the changes
			$scope.savedStorageAcceleratorCredentials.forEach(function(item, index) {
				if (item.selected) {
					item.selected = false;
				} else if (item.credentialId === $scope.control.selectedCredential.credentialId) {
					item.selected = true;
				}
			});
		};

		$scope.updateCredential = () => {
			let updateLibReq = {
				//MM_LIBRARY_OPERATION_EDIT_MOUNTPATH 8
				//We have to send Library/Mountpath name details for Audit
				library: {
					libraryName: $scope.libraryName,
					libraryId: $scope.libraryId,
					mountPathId: $scope.mountPathId,
					mountPath: $scope.mpDetails.mountPathName,
					opType: '8',
					mediaAgentId: $scope.deviceList[0].mediaAgentEntity.mediaAgentId,
					mediaAgentName: $scope.deviceList[0].mediaAgentEntity.mediaAgentName
				},
				libNewProp: {
					secondaryCredential: {
						credentialId: $scope.control.selectedCredential.credentialId,
						credentialName: $scope.control.selectedCredential.credentialName
					}
				}
			};
			return storageService
				.updateLibrary(updateLibReq)
				.success(function(libInfo) {
					$scope.control.isEditingCredentials = false;
					$scope.isCredential = true;
					$scope.showUpdateCredError = false;
				})
				.error(function(e) {
					$log.error('Updating secondary credentials failed');
					$scope.showUpdateCredError = true;
					$scope.credentialUpdateError = cvUtil.errMsg(e);
					onDiscardChanges();
				});
		};
		function initColumnDefs() {
			setCloudPathColumn();
			return mountPathColumnTemplates.getMountPathColumnTemplate({
				cvLoc,
				labelBucket: $scope.serverLabelBucket,
				model: $scope.model,
				storagePoolType: $scope.storagePoolType,
				libraryVendorType: $scope.libraryVendorId
			});
		}

		initSCGrid();
		// var removeColumns = function (columnDefsList, gridColDefs) {
		//   if (columnDefsList && gridColDefs) {
		//     for (var i = 0; i < columnDefsList.length; i++) {
		//       for (var idx = 0; idx < gridColDefs.length; idx++) {
		//         if (gridColDefs[idx].field === columnDefsList[i]) {
		//           gridColDefs.splice(idx, 1);
		//           break;
		//         }
		//       }
		//     }
		//   }
		// };

		// var gridColDefs = $scope.mediaAgentListGridOptions.gridOptions.columnDefs;
		// if ($scope.storagePoolType == "SCALE_OUT") {
		//   removeColumns(['userName', 'accessType', 'numWriters'], gridColDefs);
		//   if (gridColDefs[3].name === cvLoc('Actions')) {
		//     gridColDefs.splice(3, 1);
		//   }
		// }

		$scope.openWizard = function() {
			$scope.maEntity = {
				controller: {
					mediaAgentId: 0,
					mediaAgentName: '',
					displayName: '',
					mountPathId: 0,
					path: '',
					userName: '',
					accessType: '',
					protocolType: 0,
					numWriters: '',
					deviceControllerId: 0,
					deviceId: ($scope.deviceList && $scope.deviceList[0].deviceId) || 0,
					accessTypeValue: 0,
					accessible: true,
					dataServerType: $scope.mpDetails.dataServerType
				},
				libraryEntity: {
					libraryName: $scope.libraryName,
					libraryId: $scope.libraryId
				},
				mountPath: {
					id: $scope.mountPathId,
					name: $scope.mpDetails.mountPathSummary.libraryName
				},
				writersNumber: {
					maxWriters: -1,
					allowedWritersNumber: 5
				},
				loginName: '',
				serverType: {
					id: 0,
					name: ''
				},
				serverHost: '',
				preferred: false,
				enabled: true,
				libraryVendorId: 0,
				selectedCredential: {
					credentialId: 0,
					credentialName: ''
				}
			};

			const gethelpTextForMaShareWizardModal = () => {
				switch ($scope.model) {
					case 'Cloud': {
						return sharedData.data.libraryVendorId === $scope.HPE_CATALYST_STORAGE
							? cvLoc('label.addMediaAgentHelpTextForHPECatalystStorage')
							: cvLoc('label.addMediaAgentHelpTextForCloud');
					}
					default: {
						return cvLoc('label.addMediaAgentHelpTextForDisk');
					}
				}
			};

			$modal.open({
				templateUrl: appUtil.appRoot + 'adminConsole/partials/maShareWizard.jsp',
				windowClass: 'addServerModal',
				backdrop: 'static',
				controller: [
					'$scope',
					'$log',
					'$uibModalInstance',
					'$state',
					'cvLoc',
					'maEntity',
					function($scope, $log, $modalInstance, $state, cvLoc, maEntity) {
						$scope.addMediaAgentHelpText = gethelpTextForMaShareWizardModal();
						$scope.maEntity = maEntity;
						$scope.action = 'shareDisk';
						$scope.cvLoc = cvLoc;
						$rootScope.$on('storageShared', function() {
							$log.debug('storageShared....');
							$modalInstance.dismiss();
							$state.forceReload();
						});
						$rootScope.$on('shareMountPathCancelled', function() {
							$log.debug('shareMountPathCancelled....');
							$modalInstance.dismiss();
						});
					}
				],
				resolve: {
					maEntity: function() {
						return $scope.maEntity;
					}
				}
			});
		};

		function transformPathName(pathname) {
			const rexgexForIP = /^IP\b/;
			const regexForFC = /^FC\b/;
			if (rexgexForIP.test(pathname)) {
				pathname = cvLoc('label.viaNetwork');
			}

			if (regexForFC.test(pathname)) {
				pathname = cvLoc('label.viaFibreChannel');
			}

			return pathname;
		}
		let breadCrumbs = [];

		if ($scope.stateName === 'mountPathDetails') {
			cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: cvLoc('label.nav.storageTargets'),
					link: '#storage'
				},
				{
					title: sharedData.data.libName,
					link:
						'#/diskLibrary?libraryId=' +
						sharedData.data.libId +
						'&libraryName=' +
						encodeURIComponent(sharedData.data.libName) +
						'&model=' +
						sharedData.data.model
				}
			]);
		} else if ($scope.stateName === 'diskMountPathDetails') {
			breadCrumbs.push(
				{
					title: cvLoc('label.disk'),
					link: '#storage/disk'
				},
				{
					title: $scope.storagePoolName,
					link:
						'#/diskStoragePoolInfo?storagePoolName=' +
						encodeURIComponent($scope.storagePoolName) +
						'&storagePoolId=' +
						$scope.storagePoolId +
						'&storagePoolType=' +
						$scope.storagePoolType
				}
			);
			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
			$scope.deviceLabelPath = cvLoc('Path');
		} else if ($scope.stateName === 'cloudMountPathDetails') {
			breadCrumbs.push(
				{
					title: cvLoc('label.cloud'),
					link: '#storage/cloud'
				},
				{
					title: $scope.storagePoolName,
					link:
						'#/cloudStoragePoolInfo?storagePoolName=' +
						encodeURIComponent($scope.storagePoolName) +
						'&storagePoolId=' +
						$scope.storagePoolId +
						'&storagePoolType=' +
						$scope.storagePoolType
				}
			);
			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
			$scope.deviceLabelPath = cvLoc($scope.serverLabelBucket);
		} else if ($scope.stateName === 'storagePoolScaleOutStorageDiskDetails') {
			cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: cvLoc('label.nav.storagePool'),
					link: '#storagePool'
				},
				{
					title: $scope.storagePoolName,
					link:
						'#/storagePoolInfo?storagePoolName=' +
						encodeURIComponent($scope.storagePoolName) +
						'&storagePoolId=' +
						$scope.storagePoolId +
						'&storagePoolType=' +
						$scope.storagePoolType +
						'&input.storagePoolName=' +
						encodeURIComponent($scope.storagePoolName) +
						'&input.storagePoolId=' +
						$scope.storagePoolId
				}
			]);
		} else if ($scope.stateName === 'storagePoolMountPathDetailsChart') {
			cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: cvLoc('label.nav.storagePool'),
					link: '#storagePool'
				},
				{
					title: $scope.storagePoolName,
					link:
						'#/diskStoragePoolInfo?storagePoolName=' +
						encodeURIComponent($scope.storagePoolName) +
						'&storagePoolId=' +
						$scope.storagePoolId +
						'&storagePoolType=' +
						$scope.storagePoolType
				}
			]);
		} else if ($scope.stateName === 'mountPathDetailsChart') {
			cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: cvLoc('label.nav.storageTargets'),
					link: '#storage'
				},
				{
					title: sharedData.data.libName,
					link:
						'#/diskLibrary?libraryId=' +
						sharedData.data.libId +
						'&libraryName=' +
						encodeURIComponent(sharedData.data.libName) +
						'&model=' +
						sharedData.data.model
				}
			]);
		}

		$scope.mediaAgentMessage = cvUtil.infoMsgLoc('Loading');

		$scope.controllerDetails = function(
			deviceId,
			controllerId,
			maAgent,
			devicePath,
			user,
			access,
			protocolType,
			writers,
			enabled,
			accessible,
			credentialId,
			credentialName,
			storageClassId,
			originalUserName
		) {
			$scope.maEntity = {
				controller: {
					mediaAgentId: maAgent.mediaAgentId,
					mediaAgentName: maAgent.mediaAgentName,
					displayName: maAgent.displayName,
					mountPathId: $scope.mountPathId,
					path: devicePath,
					userName: user,
					accessType: access,
					protocolType: protocolType,
					numWriters: writers,
					deviceControllerId: controllerId,
					deviceId: deviceId,
					accessTypeValue: 0,
					enabled: enabled,
					accessible: accessible,
					storageClassId: storageClassId,
					originalUserName: originalUserName
				},
				libraryEntity: {
					libraryName: sharedData.data.libName,
					libraryId: sharedData.data.libId
				},
				mountPath: {
					id: $scope.mountPathId,
					name: devicePath
				},
				writersNumber: {
					maxWriters: -1,
					allowedWritersNumber: 5
				},
				loginName: '',
				serverType: {
					id: 0,
					name: ''
				},
				serverHost: '',
				preferred: false,
				enabled: true,
				libraryVendorId: sharedData.data.libraryVendorId,
				selectedCredential: {
					credentialId: credentialId,
					credentialName: credentialName
				},
				metallicStorageInfo: {
					licenseType: $scope.metallicStorageInfo.licenseType,
					region: $scope.metallicStorageInfo.region,
					storageClass: $scope.metallicStorageInfo.storageClass,
					replication: $scope.metallicStorageInfo.replication
				}
			};

			$scope.changeTransportType = function() {
				if ($scope.maEntity.controller.protocolType != 0) {
					$scope.isDataServer = true;
				} else {
					$scope.isDataServer = false;
				}
			};

			var template = 'adminConsole/partials/addDiskStorage.jsp';
			if (sharedData.data.model == 'Cloud') {
				template = 'adminConsole/partials/addCloudStorage.jsp';
			}
			$modal
				.open({
					templateUrl: appUtil.appRoot + template,
					windowClass: 'addServerModal',
					backdrop: 'static',
					scope: $scope,
					controller: [
						'$scope',
						'$log',
						'$uibModalInstance',
						'$state',
						'cvLoc',
						'maEntity',
						'StorageConstants',
						'cvUtil',
						'$controller',
						function($scope, $log, $modalInstance, $state, cvLoc, maEntity, StorageConstants, cvUtil, $controller) {
							sharedData.data.isEditingCloud = sharedData.data.model === 'Cloud';
							$scope.serverMessage = cvUtil.emptyMsg();
							$scope.maEntity = maEntity;
							$scope.cvLoc = cvLoc;
							$scope.action = 'editMP';
							$scope.maEntity.controller.accessTypeValue = $filter('accessTypeValue')(
								$scope.maEntity.controller.accessType
							);

							var shareType = $filter('TransportType')($scope.maEntity.controller.accessType);
							$scope.maEntity.controller.protocolType = shareType;

							if ($scope.maEntity.controller.numWriters == -1) {
								$scope.maEntity.writersNumber.maxWriters = -1;
							} else {
								$scope.maEntity.writersNumber.maxWriters = 0;
								$scope.maEntity.writersNumber.allowedWritersNumber = $scope.maEntity.controller.numWriters;
							}
							if (
								$scope.maEntity.controller.accessType ==
									(StorageConstants.READWRITE_DEVICEACCESS | StorageConstants.PREFERRED_DEVICEACCESS) ||
								$scope.maEntity.controller.accessType ==
									(StorageConstants.READ_DEVICEACCESS | StorageConstants.PREFERRED_DEVICEACCESS) ||
								$scope.maEntity.controller.accessType ==
									(StorageConstants.DATASERVER_IP_DEVICEACCESS |
										StorageConstants.READ_DEVICEACCESS |
										StorageConstants.PREFERRED_DEVICEACCESS) ||
								$scope.maEntity.controller.accessType ==
									(StorageConstants.DATASERVER_FC_DEVICEACCESS |
										StorageConstants.READ_DEVICEACCESS |
										StorageConstants.PREFERRED_DEVICEACCESS) ||
								$scope.maEntity.controller.accessType ==
									(StorageConstants.DATASERVER_iSCSI_DEVICEACCESS |
										StorageConstants.READ_DEVICEACCESS |
										StorageConstants.PREFERRED_DEVICEACCESS) ||
								$scope.maEntity.controller.accessType ==
									(StorageConstants.DATASERVER_IP_DEVICEACCESS |
										StorageConstants.READWRITE_DEVICEACCESS |
										StorageConstants.PREFERRED_DEVICEACCESS) ||
								$scope.maEntity.controller.accessType ==
									(StorageConstants.DATASERVER_FC_DEVICEACCESS |
										StorageConstants.READWRITE_DEVICEACCESS |
										StorageConstants.PREFERRED_DEVICEACCESS) ||
								$scope.maEntity.controller.accessType ==
									(StorageConstants.DATASERVER_iSCSI_DEVICEACCESS |
										StorageConstants.READWRITE_DEVICEACCESS |
										StorageConstants.PREFERRED_DEVICEACCESS)
							) {
								$scope.maEntity.preferred = true;
							} else {
								$scope.maEntity.preferred = false;
							}
							if ($scope.maEntity.controller.enabled == 1) {
								$scope.maEntity.enabled = true;
							} else {
								$scope.maEntity.enabled = false;
							}
							if ($scope.maEntity.controller.accessible == 1) {
								$scope.maEntity.accessible = true;
							} else {
								$scope.maEntity.accessible = false;
							}
							$scope.changeTransportType();
							$rootScope.$on('editMountPath', function() {
								$log.debug('editMountPath....');
								$modalInstance.dismiss();
								$state.forceReload();
							});
							$rootScope.$on('editMountPathCancelled', function() {
								$log.debug('editMountPathCancelled....');
								$modalInstance.dismiss();
							});

							$scope.showSwitchToCM = false;
							$scope.showCredentialDropDown = true;

							// If this MP is using the old style credentials, meaning credentialId is 0,
							// we need to show a toggle to provide the user with the option to switching
							// to a saved credential
							$scope.setShowSwitchToCM = function() {
								if ($scope.maEntity.selectedCredential.credentialId === 0) {
									$scope.showSwitchToCM = true;
									$scope.showCredentialDropDown = false;
									$scope.switchToCM = 'disabled-activity';
								} else {
									$scope.switchToCM = 'enabled-activity';
								}
							};

							// For cloud MPs see if we support credential manager for the cloud vendor type
							// For eg. Oracle types we don't support credential manager and we only show
							// username / password always
							// For disk MPs, if it already uses credential, only show credential
							// else show both username / password and credential manager
							if (sharedData.data.model === 'Cloud') {
								if (storageService.getCloudCredentialsSupport(sharedData.data.libraryVendorId)) {
									$scope.showCredentialDropDown = true;
									$scope.setShowSwitchToCM();
								} else {
									$scope.showCredentialDropDown = false;
								}
								angular.extend(this, $controller('addStorageController', { $scope: $scope }));
							} else {
								$scope.setShowSwitchToCM();
							}
						}
					],
					resolve: {
						maEntity: function() {
							return $scope.maEntity;
						}
					}
				})
				.result.then(
					() => {},
					data => {
						sharedData.data.isEditingCloud = false;
					}
				);
		};

		/// this function is being call from general tile - only for DISK
		$scope.openModal = function() {
			const device = $scope.deviceList[0];
			$scope.controllerDetails(
				device.deviceId,
				device.deviceControllerId,
				device.mediaAgentEntity,
				device.path,
				device.userName,
				device.accessType,
				device.protocolType,
				device.numWriters,
				device.enabled,
				device.accessible,
				device.savedCredential.credentialId,
				device.savedCredential.credentialName,
				device.storageClassId
			);
		};

		$scope.deleteController = function(
			deviceId,
			controllerId,
			maAgent,
			devicePath,
			user,
			access,
			protocolType,
			writers,
			enabled,
			accessible
		) {
			$scope.maEntity = {
				controller: {
					mediaAgentId: maAgent.mediaAgentId,
					mediaAgentName: maAgent.mediaAgentName,
					displayName: maAgent.displayName,
					mountPathId: $scope.mountPathId,
					path: devicePath,
					userName: user,
					accessType: access,
					protocolType: protocolType,
					numWriters: writers,
					deviceControllerId: controllerId,
					deviceId: deviceId,
					accessTypeValue: 0,
					enabled: enabled,
					accessible: accessible
				},
				libraryEntity: {
					libraryName: sharedData.data.libName,
					libraryId: sharedData.data.libId
				},
				mountPath: {
					id: $scope.mountPathId,
					name: devicePath
				},
				writersNumber: {
					maxWriters: -1,
					allowedWritersNumber: 5
				},
				loginName: '',
				serverType: {
					id: 0,
					name: ''
				},
				serverHost: '',
				preferred: false,
				enabled: true,
				libraryVendorId: 0
			};

			if ($scope.deviceList.length == 1) {
				$dialogs.error(cvLoc('label.error'), cvLoc('label.deleteDeleteController'));
			} else {
				var libInfo = $scope.maEntity;
				var callBackFunctions = {
					noFunction: function() {},
					yesFunction: function() {
						libInfo.controller.accessible = libInfo.controller.accessible ? 1 : 0;
						storageService
							.delMAController(libInfo)
							.success(function(data) {
								$log.debug('Delete Controller success');
								$state.forceReload();
							})
							.error(function(data) {
								$dialogs.error(cvLoc('label.error'), cvUtil.errMsg(data).message);
								$log.error('Deletion of Controller failed');
							});
					}
				};
				$dialogs.confirm(
					cvLoc('label.confirmDelete'),
					cvLoc('label.confirmationDeleteController', '<b>' + maAgent.displayName + '</b>'),
					callBackFunctions
				);
			}
		};
	}
];

storageMod.controller(storageControllers);

export default storageMod;
