import 'adminConsole/js/directives/cv-detect-tape-library.js';
import 'browse/js/controllers/browse.ctrl.js';
import 'modules/storage/js/filters/storage.filters.js';
import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'webScale/js/controllers/storagePool.ctrl.js';
import 'adminConsole/js/controllers/cloudLibConstants.js';
import 'dlo/js/controllers/profile.ctrl.js';
import 'adminConsole/js/factories/rpstore.factory.js';
import 'adminConsole/js/controllers/rpstore.ctrl.js';
import 'modules/schedule/js/factory/schedule.factory.js';
import 'storage/js/services/storage.svc.js';
import { acAppStorageModule } from 'common/js/modules';

var storageMod = acAppStorageModule;

const storageControllers = {};

storageControllers.driveDetailsController = [
	'sharedData',
	'$scope',
	'$http',
	'storageService',
	'cvToaster',
	'$rootScope',
	'$uibModal',
	'cvBreadcrumbsTabsFactory',
	'$stateParams',
	'cvTableOptions',
	'cvLoc',
	'$state',
	'DriveConstants',
	function(
		sharedData,
		$scope,
		$http,
		storageService,
		cvToaster,
		$rootScope,
		$modal,
		cvBreadcrumbsTabsFactory,
		$stateParams,
		cvTableOptions,
		cvLoc,
		$state,
		DriveConstants
	) {
		$scope.driveId = $stateParams['driveId'];
		$scope.libraryId = $stateParams['libraryId'];
		$scope.libraryName = $stateParams['libraryName'];
		$scope.model = $stateParams['model'];
		$scope.storagePoolId = $stateParams['storagePoolId'];
		$scope.storagePoolName = $stateParams['storagePoolName'];
		$scope.storagePoolType = $stateParams['storagePoolType'];
		$scope.stateName = $state.current.name;
		$scope.driveName = $stateParams['driveName'];
		$scope.maintenanceMode = 'enabled-activity';
		$scope.status = 'enabled-activity';
		$scope.markForReadOnly = 'enabled-activity';
		sharedData.data = {
			libId: $scope.libraryId,
			libName: $scope.libraryName,
			model: $scope.model,
			libraryVendorId: 0
		};
		$scope.cvLoc = cvLoc;
		var globalGridOptions = angular.copy(cvTableOptions.commonNgGridOptions);
		angular.extend(globalGridOptions, {
			data: 'drivePoolList',
			enableGridMenu: false,
			columnDefs: [
				{
					field: 'mediaAgentName',
					displayName: cvLoc('Name'),
					enableHiding: false
				},
				{
					field: 'drivePoolName',
					displayName: cvLoc('label.drivePool'),
					enableHiding: false
				}
			]
		});
		$scope.drivePoolListGridOptions = {
			cvGridTitle: cvLoc('label.mediaAgents'),
			cvIsPageTitle: true,
			cvTableName: 'drivePoolListTable',
			cvSearchFields: ['mediaAgentName', 'drivePoolName'],
			gridOptions: globalGridOptions
		};

		if ($scope.stateName === 'driveDetails') {
			cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: cvLoc('label.nav.tape'),
					link: '#storage/tape'
				},
				{
					title: sharedData.data.libName,
					link:
						'#/tapeLibrary?libraryId=' +
						sharedData.data.libId +
						'&libraryName=' +
						encodeURIComponent(sharedData.data.libName) +
						'&model=' +
						sharedData.data.model
				}
			]);
		} else if ($scope.stateName === 'storagePoolDriveDetails') {
			cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: $scope.storagePoolName,
					link:
						'#/tapeStoragePoolInfo?storagePoolName=' +
						encodeURIComponent($scope.storagePoolName) +
						'&storagePoolId=' +
						$scope.storagePoolId +
						'&storagePoolType=' +
						$scope.storagePoolType
				}
			]);
		} else if (
			($scope.stateName === 'driveUsage' || $scope.stateName === 'mediaAgentsReport') &&
			!$scope.storagePoolName
		) {
			cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: cvLoc('label.nav.tape'),
					link: '#storage/tape'
				},
				{
					title: $scope.libraryName,
					link:
						'#/tapeLibrary?libraryId=' +
						$scope.libraryId +
						'&libraryName=' +
						encodeURIComponent($scope.libraryName) +
						'&model=' +
						$scope.model
				},
				{
					title: $scope.driveName,
					link:
						'#/drive?libraryId=' +
						$scope.libraryId +
						'&libraryName=' +
						encodeURIComponent($scope.libraryName) +
						'&model=' +
						$scope.model +
						'&driveId=' +
						$scope.driveId +
						'&driveName=' +
						$scope.driveName
				}
			]);
		} else if (
			($scope.stateName === 'driveUsage' || $scope.stateName === 'mediaAgentsReport') &&
			$scope.storagePoolName
		) {
			cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: cvLoc('label.nav.tape'),
					link: '#storage/tape'
				},
				{
					title: $scope.storagePoolName,
					link:
						'#/tapeStoragePoolInfo?storagePoolName=' +
						encodeURIComponent($scope.storagePoolName) +
						'&storagePoolId=' +
						$scope.storagePoolId +
						'&storagePoolType=' +
						$scope.storagePoolType
				},
				{
					title: $scope.driveName,
					link:
						'#/storagePoolDrive?storagePoolName=' +
						encodeURIComponent($scope.storagePoolName) +
						'&storagePoolId=' +
						$scope.storagePoolId +
						'&storagePoolType=' +
						$scope.storagePoolType +
						'&libraryId=' +
						$scope.libraryId +
						'&libraryName=' +
						encodeURIComponent($scope.libraryName) +
						'&model=' +
						$scope.model +
						'&driveId=' +
						$scope.driveId +
						'&driveName=' +
						encodeURIComponent($scope.driveName)
				}
			]);
		}

		if ($scope.stateName != 'driveUsage') {
			storageService
				.getDriveInfo($scope.driveId)
				.success(function(driveDetails) {
					$scope.drivePoolList = driveDetails.drivePoolList;
					$scope.summary = driveDetails.driveSummary;
					$scope.maintenanceMode =
						($scope.summary.attribute & DriveConstants.DRIVE_MARKED_FOR_MAINTENANCE) != 0
							? 'enabled-activity'
							: 'disabled-activity';
					$scope.markForReadOnly =
						($scope.summary.attribute & DriveConstants.DRIVE_MARKED_FOR_READONLY) != 0
							? 'enabled-activity'
							: 'disabled-activity';
					$scope.status = $scope.summary.isEnabled == 1 ? 'enabled-activity' : 'disabled-activity';

					//$scope.driveDetails.push(driveDetails);
					$scope.drivePoolMessage = {
						message: ' ', // space is needed
						type: 'ok'
					};
					$scope.driveUsageReportslink =
						'#driveUsage?input.libraryName=' +
						encodeURIComponent($scope.libraryName) +
						'&input.driveName=' +
						encodeURIComponent($scope.summary.driveName) +
						'&libraryId=' +
						$scope.libraryId +
						'&model=' +
						$scope.model +
						'&libraryName=' +
						encodeURIComponent($scope.libraryName) +
						'&driveId=' +
						$scope.driveId +
						'&driveName=' +
						encodeURIComponent($scope.summary.driveName);

					$scope.mediaAgentsReportslink =
						'#mediaAgentsReport?input.driveId=' +
						encodeURIComponent($scope.driveId) +
						'&input.driveName=' +
						encodeURIComponent($scope.summary.driveName) +
						'&libraryId=' +
						$scope.libraryId +
						'&model=' +
						$scope.model +
						'&libraryName=' +
						encodeURIComponent($scope.libraryName) +
						'&driveId=' +
						$scope.driveId +
						'&driveName=' +
						encodeURIComponent($scope.summary.driveName);

					if ($scope.storagePoolName) {
						$scope.driveUsageReportslink +=
							'&storagePoolName=' +
							encodeURIComponent($scope.storagePoolName) +
							'&storagePoolId=' +
							$scope.storagePoolId +
							'&storagePoolType=' +
							$scope.storagePoolType;
						$scope.mediaAgentsReportslink +=
							'&storagePoolName=' +
							encodeURIComponent($scope.storagePoolName) +
							'&storagePoolId=' +
							$scope.storagePoolId +
							'&storagePoolType=' +
							$scope.storagePoolType;
					}
				})
				.error(function(e) {
					$scope.drivePoolMessage = {
						message: e,
						type: 'error'
					};
				});
		}
		/*
		 * Operation : update Drive Status (Input: libraryID)
		 */
		$scope.updateDriveStatus = function() {
			var statusInt = $scope.status == 'enabled-activity' ? 0 : 1;
			storageService
				.updateDriveStatus($scope.driveId, statusInt)
				.success(function(data) {
					if (data.errorCode == 0) {
						$scope.status = $scope.status == 'enabled-activity' ? 'disabled-activity' : 'enabled-activity';
					} else {
						cvToaster.showErrorMessage({
							ttl: '5000', //5 sec
							message: data.errorMessage
						});
						$log.error('update status option failed');
					}
				})
				.error(function(error) {
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: error ? error : cvLoc('generic_error')
					});
				});
		};
		/*
		 * Operation : update Drive Maintenance mode (Input: libraryID)
		 */
		$scope.updateDriveMaintenanceMode = function(maintenanceModeInt) {
			maintenanceModeInt =
				$scope.maintenanceMode == 'enabled-activity'
					? maintenanceModeInt ^ DriveConstants.DRIVE_MARKED_FOR_MAINTENANCE
					: maintenanceModeInt | DriveConstants.DRIVE_MARKED_FOR_MAINTENANCE;

			storageService
				.updateDriveMaintenanceMode($scope.driveId, maintenanceModeInt)
				.success(function(data) {
					if (data.errorCode == 0) {
						$scope.maintenanceMode =
							$scope.maintenanceMode == 'enabled-activity' ? 'disabled-activity' : 'enabled-activity';
						$scope.summary.attribute = maintenanceModeInt;
					} else {
						cvToaster.showErrorMessage({
							ttl: '5000', //5 sec
							message: data.errorMessage
						});
						$log.error('update Maintenance mode option failed');
					}
				})
				.error(function(error) {
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: error ? error : cvLoc('generic_error')
					});
				});
		};

		$scope.updateMarkForReadOnly = function(markForReadOnlyInt) {
			markForReadOnlyInt =
				$scope.markForReadOnly == 'enabled-activity'
					? markForReadOnlyInt ^ DriveConstants.DRIVE_MARKED_FOR_READONLY
					: markForReadOnlyInt | DriveConstants.DRIVE_MARKED_FOR_READONLY;

			storageService
				.updateDriveMarkForReadOnly($scope.driveId, markForReadOnlyInt)
				.success(function(data) {
					if (data.errorCode == 0) {
						$scope.markForReadOnly =
							$scope.markForReadOnly == 'enabled-activity' ? 'disabled-activity' : 'enabled-activity';
						$scope.summary.attribute = markForReadOnlyInt;
					} else {
						cvToaster.showErrorMessage({
							ttl: '5000', //5 sec
							message: data.errorMessage
						});
						$log.error('update Mark For ReadOnly option failed');
					}
				})
				.error(function(error) {
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: error ? error : cvLoc('generic_error')
					});
				});
		};
	}
];

storageMod.controller(storageControllers);

export default storageMod;
