import 'adminConsole/js/directives/cv-detect-tape-library.js';
import 'browse/js/controllers/browse.ctrl.js';
import 'modules/storage/js/filters/storage.filters.js';
import 'machineBrowse/js/controllers/machineBrowse.ctrl.js';
import 'machineBrowse/js/services/machineBrowse.svc.js';
import 'webScale/js/controllers/storagePool.ctrl.js';
import 'adminConsole/js/controllers/cloudLibConstants.js';
import 'dlo/js/controllers/profile.ctrl.js';
import 'adminConsole/js/factories/rpstore.factory.js';
import 'adminConsole/js/controllers/rpstore.ctrl.js';
import 'modules/schedule/js/factory/schedule.factory.js';
import 'storage/js/services/storage.svc.js';

import { acAppStorageModule } from 'common/js/modules';
import * as associatedEntitiesColumnTemplates from '../storagePoolAssociatedEntities.column.template';

var storageMod = acAppStorageModule;

const storageControllers = {};

storageControllers.diskLibraryAssociatedEntitiesController = [
	'sharedData',
	'$scope',
	'$http',
	'storageService',
	'cvToaster',
	'$rootScope',
	'$uibModal',
	'cvBreadcrumbsTabsFactory',
	'$stateParams',
	'cvTableOptions',
	'cvLoc',
	'$dialogs',
	'$log',
	'$state',
	'cvUtil',
	'rpStoreFactory',
	'storageFactory',
	'securityFactory',
	'tabService',
	'storagePolicyService',
	function(
		sharedData,
		$scope,
		$http,
		storageService,
		cvToaster,
		$rootScope,
		$modal,
		cvBreadcrumbsTabsFactory,
		$stateParams,
		cvTableOptions,
		cvLoc,
		$dialogs,
		$log,
		$state,
		cvUtil,
		rpStoreFactory,
		storageFactory,
		securityFactory,
		tabService,
		storagePolicyService
	) {
		$scope.storagePoolId = $stateParams['storagePoolId'];
		$scope.storagePoolName = $stateParams['storagePoolName'];
		$scope.storagePoolType = $stateParams['storagePoolType'];

		$scope.libraryId = $stateParams['libraryId'];
		$scope.libraryName = $stateParams['libraryName'];
		$scope.model = $stateParams['model'] || 'Disk';
		$scope.libraryType = $stateParams['libraryType'];
		$scope.isRPStore = $scope.libraryType && $scope.libraryType == 10;

		$scope.stateName = $state.current.name;
		$scope.storageFactory = storageFactory;
		sharedData.stateName = $scope.stateName;
		$scope.showAddOption = $scope.storagePoolType != 'SCALE_OUT';

		$scope.entityType = 'STORAGE_POLICY_ENTITY';

		$scope.genericEntity = {
			storagePolicyId: parseInt($scope.storagePoolId)
		};
		const TAB_CONFIG = {
			DISK: [
				{
					title: cvLoc('label.overview'),
					state: 'diskStoragePoolDetails',
					stateParams: $stateParams
				},
				{
					title: cvLoc('label.configuration'),
					state: 'diskStoragePoolConfiguration',
					stateParams: $stateParams
				},
				{
					title: cvLoc('label.associatedPlans'),
					state: 'diskStoragePoolAssociatedEntities',
					stateParams: $stateParams
				}
			],
			CLOUD: [
				{
					title: cvLoc('label.overview'),
					state: 'cloudStoragePoolDetails',
					stateParams: $stateParams
				},
				{
					title: cvLoc('label.configuration'),
					state: 'cloudStoragePoolConfiguration',
					stateParams: $stateParams
				},
				{
					title: cvLoc('label.associatedPlans'),
					state: 'cloudStoragePoolAssociatedEntities',
					stateParams: $stateParams
				}
			],
			SCALE_OUT: [
				{
					title: cvLoc('label.overview'),
					state: 'storageHyperscaleDetails',
					stateParams: $stateParams
				},
				{
					title: cvLoc('label.configuration'),
					state: 'storageHyperscaleConfiguration',
					stateParams: $stateParams
				},
				{
					title: cvLoc('label.associatedPlans'),
					state: 'storageHyperscaleAssociatedEntities',
					stateParams: $stateParams
				}
			]
		};
		function initTabsAndBreadCrumbs() {
			let breadCrumbs = [];
			let tabs = [];
			switch ($scope.stateName) {
				case 'storageHyperscaleAssociatedEntities':
					{
						breadCrumbs.push({
							title: cvLoc('label.nav.hyperscale'),
							link: '#storage/hyperscale'
						});
						tabs = [...TAB_CONFIG.SCALE_OUT];
					}
					break;
				case 'diskStoragePoolAssociatedEntities':
					{
						breadCrumbs.push({
							title: cvLoc('label.disk'),
							link: '#storage/disk'
						});
						tabs = [...TAB_CONFIG.DISK];
					}
					break;
				case 'cloudStoragePoolAssociatedEntities':
					{
						breadCrumbs.push({
							title: cvLoc('label.cloud'),
							link: '#storage/cloud'
						});
						tabs = [...TAB_CONFIG.CLOUD];
					}
					break;
			}

			cvBreadcrumbsTabsFactory.addBreadCrumbs(breadCrumbs);
			tabService.init({ tabs: tabs, hasParent: true });
		}

		initTabsAndBreadCrumbs();

		const initSCGrid = function() {
			setupGridOptions();
		};

		const setupGridOptions = function() {
			let gridOptions = {};
			gridOptions.enableResizing = true;
			gridOptions.columns = initColumnDefs();
			gridOptions.gridTitle = cvLoc('label.associatedPlans');
			gridOptions.tableName = 'associatedPlans';
			gridOptions.enableCheckBoxColumn = false;
			gridOptions.url = fetchDataStoragePool.bind(this);
			gridOptions.hasViews = false;
			$scope.gridOptions = gridOptions;
			$scope.gridOptionsKendo = gridOptions;
		};

		const initColumnDefs = function() {
			const storagePool = {
				name: $scope.storagePoolName,
				id: $scope.storagePoolId,
				type: $scope.storagePoolType
			};
			return associatedEntitiesColumnTemplates.getAssociatedEntitiesColumnTemplate({
				cvLoc: cvLoc,
				isRPStore: $scope.isRPStore,
				stateName: $scope.stateName,
				storagePool
			});
		};
		const fetchDataStoragePool = function(options) {
			storageService
				.getStoragePoolDetails($scope.storagePoolId)
				.success(function(poolDetails) {
					$scope.storagePoolMessage = cvUtil.emptyMsg();

					$scope.libraryId = poolDetails.libraryList[0].library.libraryId;
					$scope.planList = poolDetails.planList || [];
					$scope.libraryName = poolDetails.libraryList[0].library.libraryName;
					$scope.libraryVendorId = poolDetails.libraryList[0].libraryVendorId;
					$scope.model = poolDetails.libraryList[0].model;
					$scope.storagePoolName = poolDetails.copyInfo.StoragePolicyCopy.storagePolicyName;
					$scope.changeNameObj = {
						id: $scope.storagePoolId,
						name: $scope.storagePoolName
					};
					$scope.storagePoolDetailsPageLoaded = true;
					if ($scope.planList.length > 0) {
						$scope.planList.forEach(plan => {
							plan.associationLevel = 'Plans';
						});
					}

					sharedData.data.libraryVendorId =
						poolDetails.libraryList && poolDetails.libraryList[0] ? poolDetails.libraryList[0].libraryVendorId : 0;
					options.success($scope.planList);
				})
				.error(function(e) {
					options.error(e);
					$scope.storagePoolMessage = {
						message: e,
						type: 'error'
					};
				});
		};
		initSCGrid();

		$scope.updateStorage = (id, name) => {
			$scope.serverMessage = null;
			const copyInfo = {
				StoragePolicyCopy: {
					storagePolicyId: $scope.storagePoolId,
					storagePolicyName: $scope.storagePoolName
				}
			};

			storageService
				.updateStoragePool(copyInfo.StoragePolicyCopy, name)
				.success(function(data) {
					if (data.errorCode === 0) {
						$log.debug(cvLoc('log.succesUpdatePolicy'));
						$state.go($state.current.name, { ...$stateParams, storagePoolName: name });
					} else {
						$log.error(cvLoc('log.errorUpdatePolicy'));
						cvToaster.showErrorMessage({
							ttl: '10000',
							message: data.error.errorMessage ? data.error.errorMessage : cvLoc('popup.errorFetchingMedia')
						});
					}
				})
				.error(function(e) {
					$log.error(cvLoc('log.errorUpdatePolicy'));
					cvToaster.showErrorMessage({
						ttl: '10000',
						message: e
					});
				});
		};
	}
];

storageMod.controller(storageControllers);

export default storageMod;
