import { acAppStorageModule } from 'common/js/modules';
import 'storage/js/services/storage.svc.js';
import * as applianceNodesColumnsTemplate from './appliancesList.column.template.js';

class appliancesListController {
	constructor(
		$scope,
		cvLoc,
		cvUtil,
		storageService,
		tabService,
		$stateParams,
		$compile,
		$location,
		ENTITY_TYPES,
		cvPermissionFactory,
		$dialogs,
		$log,
		$state,
		cvBreadcrumbsTabsFactory
	) {
		this.$scope = $scope;
		this.cvLoc = cvLoc;
		this.cvUtil = cvUtil;
		this.storageService = storageService;
		this.tabService = tabService;
		this.$stateParams = $stateParams;
		this.$compile = $compile;
		this.$location = $location;
		this.ENTITY_TYPES = ENTITY_TYPES;
		this.cvPermissionFactory = cvPermissionFactory;
		this.$dialogs = $dialogs;
		this.$log = $log;
		this.$state = $state;
		this.cvBreadcrumbsTabsFactory = cvBreadcrumbsTabsFactory;

		this._init();
	}

	_init() {
		let tabActionInfo = {
			actions: [
				{
					id: 'addStoragePool',
					title: this.cvLoc('label.add.appliance')
				}
			]
		};
		var tabs = {
			APPLIANCES: {
				title: this.cvLoc('title.appliances'),
				state: 'appliances',
				tabIndex: 0
			},
			NODES: {
				title: this.cvLoc('label.nodes'),
				state: 'applianceNodes',
				tabIndex: 1
			}
		};
		this.$scope.nav = this.$stateParams['nav'];
		if (this.$scope.nav) {
			this.cvBreadcrumbsTabsFactory.addBreadCrumbs([
				{
					title: this.cvLoc('title.' + this.$scope.nav),
					link: '#' + this.$scope.nav
				}
			]);
		}

		this.tabService.init({
			tabs: [tabs.APPLIANCES, tabs.NODES],
			onActionItemSelect: function() {},
			activeTab: tabs.APPLIANCES.tabIndex
		});

		this._setupGridOptions();
	}

	_initColumnDefs() {
		return applianceNodesColumnsTemplate.getColumns({ cvLoc: this.cvLoc });
	}

	_setupGridOptions() {
		const self = this;
		this.gridOptions = {};
		this.$scope.gridOptions = this.gridOptions;
		this.gridOptions.url = this._fetchData.bind(this);
		this.gridOptions.columns = this._initColumnDefs();
		this.gridOptions.searchable = true;
		this.gridOptions.pageSize = 25;
		this.gridOptions.gridTitle = this.cvLoc('title.appliances');
		this.gridOptions.gridEmptyMessage = this.cvLoc('error.no.appliances.data');
		this.gridOptions.tableName = 'appliancesListTable';
		this.gridOptions.beforeGridInitialize = ({ grid }) => {
			self.grid = grid;
		};
		this.gridOptions.onGridDataBound = this._onGridDataBound.bind(this);
		this.gridOptions.gridToolbarMenu = [
			{
				id: 'addStoragePoolButton',
				label: this.cvLoc('label.add.appliance'),
				onSelect: this._createScaleoutStoragePool.bind(this)
			}
		];
		this.gridOptions.actionMenu = [];
	}

	_createScaleoutStoragePool() {
		this.$location.path('/createScaleoutStoragePool');
	}

	_fetchData(options) {
		let cvLoc = this.cvLoc;
		const self = this;

		self.$scope.storagePoolMessage = {
			message: cvLoc('Loading'),
			type: 'ok'
		};
		return this.storageService
			.getAllStoragePools()
			.success(data => {
				self.$scope.serverMessage = self.cvUtil.emptyMsg();
				if (data) {
					var pools = [];
					angular.forEach(data, function(pool) {
						if (pool.storagePoolType == 'SCALE_OUT') {
							pool.formattedStoragePoolType = self._getStoragePoolTypeString(pool.storagePoolType);
							pool.formattedTotalCapacity = self._getDataSizeString(pool.totalCapacity * 1024 * 1024);
							pool.formattedTotalFreeSpace = self._getDataSizeString(pool.totalFreeSpace * 1024 * 1024);
							pool.storagePoolNameLink = null;
							if (pool.numberOfNodes >= 1 && pool.statusCode == 300) {
								pool.storagePoolNameLink =
									cvUtil.getContextPath() +
									'#storagePoolInfo?storagePoolName=' +
									pool.storagePoolEntity.storagePoolName +
									'&storagePoolId=' +
									pool.storagePoolEntity.storagePoolId +
									'&storagePoolType=' +
									pool.storagePoolType +
									'&input.storagePoolName=' +
									pool.storagePoolEntity.storagePoolName +
									'&input.storagePoolId=' +
									pool.storagePoolEntity.storagePoolId +
									'&nav=appliances';
							}
							pool.permittedOptions = {
								entityType: self.ENTITY_TYPES.STORAGEPOOL_ENTITY,
								entity: angular.copy(pool),
								entityId: pool.storagePoolEntity.storagePoolId,
								entityName: pool.storagePoolEntity.storagePoolName,
								permittedActionList: self._getPermittedActions(pool),
								appendToBody: true
							};

							pools.push(pool);
						}
					});
					self.pools = pools;
					options.success(self.pools || []);
				} else {
					options.success([]);
				}
			})
			.error(err => {
				self.$scope.serverMessage = {
					message: err,
					type: 'error'
				};
				options.error(self.$scope.serverMessage);
			});
	}

	_getStoragePoolTypeString(sptype) {
		let cvLoc = this.cvLoc;
		var typeStr = '';

		if (sptype === 'DEDUPLICATION') {
			typeStr = cvLoc('label.DeduplicationSP');
		} else if (sptype === 'SECONDARY_COPY') {
			typeStr = cvLoc('label.SECONDARYCOPYSP');
		} else if (sptype === 'NON_DEDUPLICATION') {
			typeStr = cvLoc('label.NONDEDUPLICATIONSP');
		} else if (sptype === 'SCALE_OUT') {
			typeStr = cvLoc('label.SCALEOUTSP');
		} else {
			typeStr = cvLoc('label.N_SLASH_A');
		}
		return typeStr;
	}

	_getDataSizeString(dataSize) {
		let cvLoc = this.cvLoc;
		var ret = '';
		var KB = 1024;
		var MB = KB * 1024;
		var GB = MB * 1024;
		var TB = GB * 1024;
		var PB = TB * 1024;
		var EB = PB * 1024;

		var convertedDataSize = 0;
		var sizeStr = '';

		if (dataSize < 0) {
			sizeStr = cvLoc('label.N_SLASH_A');
			return sizeStr;
		} else {
			if (dataSize > EB) {
				convertedDataSize = dataSize / EB;
				sizeStr = Math.round(convertedDataSize * 100) / 100 + ' ' + cvLoc('label.EB');
			} else if (dataSize > PB) {
				convertedDataSize = dataSize / PB;
				sizeStr = Math.round(convertedDataSize * 100) / 100 + ' ' + cvLoc('label.PB');
			} else if (dataSize > TB) {
				convertedDataSize = dataSize / TB;
				sizeStr = Math.round(convertedDataSize * 100) / 100 + ' ' + cvLoc('label.TB');
			} else if (dataSize > GB) {
				convertedDataSize = dataSize / GB;
				sizeStr = Math.round(convertedDataSize * 100) / 100 + ' ' + cvLoc('label.GB');
			} else if (dataSize > MB) {
				convertedDataSize = dataSize / MB;
				sizeStr = Math.round(convertedDataSize * 100) / 100 + ' ' + cvLoc('label.MB');
			} else if (dataSize > KB) {
				convertedDataSize = dataSize / KB;
				sizeStr = Math.round(convertedDataSize * 100) / 100 + ' ' + cvLoc('label.KB');
			} else {
				convertedDataSize = dataSize;
				sizeStr = Math.round(convertedDataSize * 100) / 100 + ' ' + cvLoc('label.Bytes');
			}
			return sizeStr;
		}
	}

	_onGridDataBound(dataItem, row) {
		let self = this;
		const permittedOptions = dataItem.permittedOptions;
		const id = permittedOptions.entityId;
		const template = `<cv-permitted-actions cv-permitted-options="permittedOptions${id}"></cv-permitted-actions>`;
		this.$scope[`permittedOptions${id}`] = permittedOptions;
		row.find('.permittedActions').append(this.$compile(template)(this.$scope));
	}

	_getPermittedActions(pool) {
		const self = this;
		let actionsList = [
			{
				DELETE: {
					permissionIds: [1],
					label: self.cvLoc('action.delete'),
					onClick: self._deleteStoragePool.bind(self, pool.storagePoolEntity)
				}
			},
			{
				RECONFIGURE: {
					permissionIds: [1],
					label: self.cvLoc('action.reconfigure'),
					show: pool.numberOfNodes >= 1 && pool.statusCode == 200,
					onClick: self._reconfigureScaleoutStoragePool.bind(self, pool.storagePoolEntity)
				}
			}
		];
		return self.cvPermissionFactory.updateAndGetCommonActionsList(actionsList, false, { DELETE: {}, RECONFIGURE: {} });
	}

	_deleteStoragePool(entity) {
		const self = this;
		var callBackFunctions = {
			noFunction: function() {},
			yesFunction: function() {
				self.storageService
					.deleteStoragePool(entity.storagePoolId)
					.success(function() {
						self.$log.debug('Delete Storage Pool success');
						self.$state.forceReload();
					})
					.error(function(data) {
						self.$dialogs.error(self.cvLoc('label.error'), self.cvUtil.errMsg(data).message);
						self.$log.error('Deletion of Storage Pool failed');
					});
			}
		};
		self.$dialogs.confirm(
			self.cvLoc('label.confirmDelete'),
			self.cvLoc('label.confirmationStoragePool', '<b>' + entity.storagePoolName + '</b>'),
			callBackFunctions
		);
	}

	_reconfigureScaleoutStoragePool(entity) {
		var callBackFunctions = {
			noFunction: function() {},
			yesFunction: function() {
				self.storageService
					.reConfigureScaleoutStoragepool(entity.storagePoolId, entity.storagePoolName)
					.success(function(data) {
						self.$log.debug('Reconfigured Storage Pool successfully');
						self.$state.forceReload();
					})
					.error(function(data) {
						self.$dialogserror(cvLoc('label.error'), self.cvUtil.errMsg(data).message);
						self.$log.error('Reconfigure Storage Pool failed');
					});
			}
		};
		self.$dialogs.confirm(
			self.cvLoc('label.confirmReconfigure'),
			self.cvLoc('label.confirmationReconfigStoragePool', '<b>' + entity.storagePoolName + '</b>'),
			callBackFunctions
		);
	}
}

appliancesListController.$inject = [
	'$scope',
	'cvLoc',
	'cvUtil',
	'storageService',
	'tabService',
	'$stateParams',
	'$compile',
	'$location',
	'ENTITY_TYPES',
	'cvPermissionFactory',
	'$dialogs',
	'$log',
	'$state',
	'cvBreadcrumbsTabsFactory'
];
acAppStorageModule.controller('appliancesListController', appliancesListController);
export default acAppStorageModule;
