import { acAppStorageModule } from 'common/js/modules';
import 'storage/js/services/storage.svc.js';
import * as applianceNodesColumnsTemplate from './applianceNodes.column.template.js';

class ApplianceNodesController {
	constructor($scope, cvLoc, cvUtil, storageService, tabService, $stateParams) {
		this.$scope = $scope;
		this.cvLoc = cvLoc;
		this.cvUtil = cvUtil;
		this.storageService = storageService;
		this.tabService = tabService;
		this.$stateParams = $stateParams;

		this._init();
	}

	_init() {
		var tabs = {
			APPLIANCES: {
				title: this.cvLoc('title.appliances'),
				state: 'appliances',
				tabIndex: 0
			},
			NODES: {
				title: this.cvLoc('label.nodes'),
				state: 'applianceNodes',
				tabIndex: 1
			}
		};

		this.tabService.init({
			tabs: [tabs.APPLIANCES, tabs.NODES],
			actions: [],
			onActionItemSelect: function() {},
			activeTab: tabs.NODES.tabIndex
		});
		this._setupGridOptions();
	}

	_initColumnDefs() {
		return applianceNodesColumnsTemplate.getColumns({ cvLoc: this.cvLoc });
	}

	_setupGridOptions() {
		const self = this;
		this.gridOptions = {};
		this.$scope.gridOptions = this.gridOptions;
		this.gridOptions.url = this._fetchData.bind(this);
		this.gridOptions.columns = this._initColumnDefs();
		this.gridOptions.searchable = true;
		this.gridOptions.pageSize = 25;
		this.gridOptions.gridTitle = this.cvLoc('label.nodes');
		this.gridOptions.gridEmptyMessage = this.cvLoc('error.no.nodes.data');
		this.gridOptions.tableName = 'appliancesTable';
		this.gridOptions.beforeGridInitialize = ({ grid }) => {
			self.grid = grid;
		};
		this.gridOptions.gridToolbarMenu = [];
		this.gridOptions.actionMenu = [];
		this.gridOptions.afterViewChange = eve => {
			console.log(eve);
			this._applyViewFilter(eve.view);
			this.grid.gridDataSrc.dataSource.data(self.filteredNodesList);
		};
	}

	_fetchData(options) {
		let cvLoc = this.cvLoc;
		const self = this;

		return this.storageService
			.getApplianceNodes()
			.success(data => {
				self.$scope.serverMessage = self.cvUtil.emptyMsg();
				if (data.summaryList) {
					angular.forEach(data.summaryList, function(node) {
						if (node.nodeStatus == 1) {
							node.status = cvLoc('label.good');
							node.statusClass = 'good';
							node.statusIcon = appUtil.appRoot + 'common/img/successfulJobs.svg';
						} else {
							node.status = cvLoc('label.needs.attention');
							node.statusClass = 'attention';
							node.statusIcon = appUtil.appRoot + 'common/img/critical.svg';
						}

						let tooltip = '<table>';
						tooltip += '<tr><td>' + cvLoc('label.disk') + ':</td><td>' + node.hwSummary.diskStatusString + '</td></tr>';
						tooltip +=
							'<tr><td>' +
							cvLoc('label.cacheDrive') +
							':</td><td>' +
							node.hwSummary.flashDriveStatusString +
							'</td></tr>';
						tooltip +=
							'<tr><td>' + cvLoc('label.powerSupply') + ':</td><td>' + node.hwSummary.powerStatuString + '</td></tr>';
						tooltip += '<tr><td>' + cvLoc('label.fan') + ':</td><td>' + node.hwSummary.fanStatusString + '</td></tr>';
						tooltip += '<tr><td>' + cvLoc('label.nic') + ':</td><td>' + node.hwSummary.nicStatusString + '</td></tr>';
						tooltip +=
							'<tr><td>' +
							cvLoc('label.cpu') +
							':</td><td>' +
							node.hwSummary.cpuInfo.replace(/,/g, '<br>') +
							'</td></tr>';
						tooltip += '</table>';
						node.statusTooltip = tooltip;
					});
					self.summaryList = data.summaryList;
					self._applyViewFilter(this.grid.getViewSvc().getCurrentView());
					options.success(self.filteredNodesList || []);
				} else {
					options.success([]);
				}
			})
			.error(err => {
				self.$scope.serverMessage = {
					message: err,
					type: 'error'
				};
				options.error(self.$scope.serverMessage);
			});
	}

	_applyViewFilter(view) {
		let self = this;
		let status = view && view.advancedFilters ? view.advancedFilters.status : undefined;
		self._filterNodesList(status);
	}

	_filterNodesList(status) {
		let self = this;
		if (!status) {
			self.filteredNodesList = self.summaryList;
			return;
		}
		if (self.summaryList) {
			status = parseInt(status);
			self.filteredNodesList = self.summaryList.filter(function(node) {
				return node.nodeStatus == status;
			});
			//console.log(self.filteredNodesList);
		} else {
			self.filteredNodesList = [];
		}
	}
}

ApplianceNodesController.$inject = ['$scope', 'cvLoc', 'cvUtil', 'storageService', 'tabService', '$stateParams'];
acAppStorageModule.controller('applianceNodesController', ApplianceNodesController);
export default acAppStorageModule;
