export const getColumnTemplate = function(angularLibs) {
	const columnList = [
		getDeviceOSPath(angularLibs.cvLoc),
		getDiskSerialNumber(angularLibs.cvLoc),
		getCapacity(angularLibs.cvLoc),
		getBlockDevHealth(angularLibs.cvLoc),
		getActionsColumn(angularLibs.cvLoc)
	];
	const columns = {};
	columnList.forEach(column => {
		const field = Object.keys(column)[0];
		columns[field] = column[field];
	});
	return columns;
};

export const getDeviceOSPath = cvLoc => {
	return {
		deviceOSPath: {
			title: cvLoc('label.mountPath'),
			template:
				'<div class="ellipsis-parent"><span class="ellipsis-content" uib-tooltip="#:deviceOSPath#" tooltip-append-to-body="true" tooltip-placement="left" >#:deviceOSPath#</span></div> </span> </div>'
		}
	};
};

export const getDiskSerialNumber = cvLoc => {
	return {
		diskSerialNumber: {
			title: cvLoc('label.serialNumber'),
			template: `#if (diskSerialNumber.length !== 0) {#
            <div class="ellipsis-parent">
                <span class="ellipsis-content" uib-tooltip="#:diskSerialNumber#" tooltip-append-to-body="true" tooltip-placement="left" >#:diskSerialNumber#</span>
            </div>
        #} else if (diskSerialNumber.length === 0) {#
            <div class="ellipsis-parent">
                <span class="ellipsis-content">${cvLoc('label.N_SLASH_A')}</span>
            </div>
        #}#`
		}
	};
};

export const getCapacity = cvLoc => {
	return {
		capacity: {
			title: cvLoc('label.capacity'),
			template: '<span class="crop">#:capacity#</span>'
		}
	};
};

export const getBlockDevHealth = cvLoc => {
	return {
		blockDevHealth: {
			title: cvLoc('label.diskStatus'),
			template: `#if (overallDiskStatus === 1 || overallDiskStatus === 3) {#
                <div class="ellipsis-parent">
                    <span class="ellipsis-content protected" class="ellipsis-content" cv-toggle-content="#:granluarDiskStatusString##:physicalId#" cv-toggle="tooltip" tooltip-append-to-body="true" tooltip-placement="left">#:overallDiskStatuString#</span>
                </div>
            #} else {#
                <div class="ellipsis-parent"> 
                    <span class="ellipsis-content notProtected" class="ellipsis-content" cv-toggle-content="#:granluarDiskStatusString##:physicalId#" cv-toggle="tooltip" tooltip-append-to-body="true" tooltip-placement="left">#:overallDiskStatuString#</span>
                </div>
            #}#`
		}
	};
};

export const getActionsColumn = cvLoc => {
	return {
		Actions: {
			title: cvLoc('Actions'),
			template: `<div class="permittedActions"></div>`,
			disableViewFiltering: true,
			sortable: false,
			disableColumnFilter: true,
			width: '15%',
			attributes: {
				class: 'permitted-actions'
			}
		}
	};
};
