import { acAppStorageModule } from 'common/js/modules';

var storageMod = acAppStorageModule;

storageMod.constant('StorageConstants', {
	WRITE_DEVICEACCESS: 2,
	READ_DEVICEACCESS: 4,
	READWRITE_DEVICEACCESS: 6,
	PREFERRED_DEVICEACCESS: 8,
	DATASERVER_IP_DEVICEACCESS: 16,
	DATASERVER_FC_DEVICEACCESS: 32,
	DATASERVER_iSCSI_DEVICEACCESS: 128,
	AUTOMATIC_DEVICEACCESS: 1024
});

storageMod.constant('LibraryConstants', {
	MMS2_LIBRARY_EXT_MARKED_FOR_MAINTENANCE: 512,
	MMS2_LIBRARY_EXT_PNP_DISK_BASED: 4096, //(1 << 12)
	CV_LIB_INVALID: 0,
	CV_LIB_TAPE: 1,
	CV_LIB_OPTICAL: 2,
	CV_LIB_MAGNETIC: 3,
	CV_LIB_STANDALONE_TAPE: 4,
	CV_LIB_STANDALONE_OPTICAL: 5,
	CV_LIB_DECONFIGURED: 9
});

storageMod.constant('ReportConstants', {
	MEDIA_IN_LIBRARY_REPORT_FILTER: 0,
	DEFAULT_SCRATCH_REPORT_FILTER: 1,
	CLEANING_MEDIA_REPORT_FILTER: 2,
	AGED_MEDIA_REPORT_FILTER: 3,
	ASSIGNED_MEDIA_REPORT_FILTER: 4
});

storageMod.constant('DriveConstants', {
	DRIVE_MARKED_FOR_MAINTENANCE: 256,
	DRIVE_MARKED_FOR_READONLY: 128,
	DRIVE_CLEANBLE: 1
});

storageMod.constant('BrickHealthConstants', {
	BRICK_IO_TEST_SUCCESS: 1,
	BRICK_IO_TEST_FAILURE: 2
});

storageMod.constant('BlockDeviceHealthConstants', {
	BLOCKDEV_SMART_STATUS_GOOD: 1,
	BLOCKDEV_SMART_STATUS_BAD: 2,
	BLOCKDEV_SMART_STATUS_WARNING: 3
});

storageMod.constant('TapeConstants', {
	DEFAULT_OPERATION_TYPE: 4010,
	DEFAULT_CS_TIME_ZONE: { _type_: 55, TimeZoneID: 1000, TimeZoneName: '' }
});

storageMod.constant('VaultTrackerConstants', {
	DEFAULT_PLAN_SUB_TYPE: 'vaultTracker',
	DEFAULT_OPERATION_TYPE: 'VT',
	DEFAULT_SUB_TASK_TYPE: 'ADMIN',
	DEFAULT_CS_TIME_ZONE: { _type_: 55, TimeZoneID: 1000, TimeZoneName: '' }
});

storageMod.constant('StorageClassConstants', {
	// amazon s3
	2: [
		{ displayName: 'label.standard', id: 0 },
		{ displayName: 'label.s3ReducedRedundancyStorage', id: 1 },
		{ displayName: 'label.standardIA', id: 2 },
		{ displayName: 'label.oneZoneIA', id: 3 },
		{ displayName: 'label.intelligentTiering', id: 4 },
		{ displayName: 'label.s3Glacier', id: 8 },
		{ displayName: 'label.s3StandardGlacier', id: 9 },
		{ displayName: 'label.s3StandardIAGlacier', id: 10 },
		{ displayName: 'label.oneZoneIAGlacier', id: 11 },
		{ displayName: 'label.intelligentTieringGlacier', id: 12 },
		{ displayName: 'label.s3GlacierDA', id: 16 },
		{ displayName: 'label.s3StandardDA', id: 17 },
		{ displayName: 'label.s3StandardIADA', id: 18 },
		{ displayName: 'label.oneZoneIADA', id: 19 },
		{ displayName: 'label.intelligentTieringDA', id: 20 }
	],
	// azure
	3: [
		{ displayName: 'label.containersDefault', id: 0 },
		{ displayName: 'label.hot', id: 1 },
		{ displayName: 'label.cool', id: 2 },
		{ displayName: 'label.archive', id: 3 },
		{ displayName: 'label.hotArchive', id: 4 },
		{ displayName: 'label.coolArchive', id: 5 }
	],
	//alibaba
	23: [
		{ displayName: 'label.bucketsDefault', id: 0 },
		{ displayName: 'label.standard', id: 1 },
		{ displayName: 'label.standardIA', id: 2 },
		{ displayName: 'label.archive', id: 8 },
		{ displayName: 'label.standardArchive', id: 9 },
		{ displayName: 'label.infrequentAccessArchive', id: 10 }
	],
	//huawie
	24: [
		{ displayName: 'label.standard', id: 0 },
		{ displayName: 'label.standardIA', id: 2 },
		{ displayName: 'label.cold', id: 1 }
	]
});

storageMod.constant('AuthenticationTypeConstant', {
	// amazon
	2: [
		{
			id: 0,
			displayName: 'label.accessAndSecretKeys',
			showCredential: true
		},
		{
			id: 1,
			displayName: 'label.awsIAMRole',
			showCredential: false
		},
		{
			id: 2,
			displayName: 'label.stsAssumeRole',
			showARNRole: true,
			showCredential: true
		},
		{
			id: 3,
			displayName: 'label.assumeRoleWithRolePolicy',
			showARNRole: true,
			showCredential: false
		}
		// {
		// 	id: 4,
		// 	displayName: 'label.c2sAccessPortal',
		// 	showCredential: true
		// },
	],
	// azure
	3: [
		{ displayName: 'label.accessAndSecretKeys', id: 0 },
		{ displayName: 'label.managedIdentity', id: 2 },
		{ displayName: 'label.rbac', id: 3 }
	]
});

storageMod.constant('CloudTypesNoCredentialSupport', {
	ORACLE_CLOUD_INFRASTRUCTURE_OBJECT_STORAGE: 26,
	ORACLE_CLOUD_INFRASTRUCTURE_ARCHIVE_STORAGE: 28,
	ORACLE_STORAGE_CLOUD_SERVICE: 21,
	ORACLE_STORAGE_CLOUD_ARCHIVE_SERVICE: 22,
	HPE_CATALYST_STORAGE: 59,
	METALLIC_CLOUD_STORAGE: 400
});

storageMod.constant('ScaleoutStoragePoolDiskOpTypes', {
	NONE: 0,
	REPLACE: 1,
	BLINK: 2,
	REPLACE_ALL_DRIVES: 3
});

storageMod.constant('TAPE_STORAGEPOOL_TYPE', {
	2: 'label.secondaryTapeStorage',
	3: 'label.primaryBackupStorage'
});

storageMod.constant('MetallicStorageClass', {
	CONTAINER_DEFAULT: { value: 0, label: 'Container default' },
	HOT: { value: 1, label: 'Hot' },
	COOL: { value: 2, label: 'Cool' },
	ARCHIVE: { value: 3, label: 'Archive' }
});

storageMod.constant('MetallicReplication', {
	NONE: { value: 0, label: '' },
	LRS: { value: 1, label: 'Locally-redundant storage (LRS)' },
	ZRS: { value: 2, label: 'Zone-redundant storage (ZRS)' },
	GRS: { value: 3, label: 'Geo-redundant storage (GRS)' },
	RA_GRS: { value: 4, label: 'Read-access geo-redundant storage (RA-GRS)' },
	GZRS: { value: 5, label: 'Geo-zone-redundant storage (GZRS)' },
	RA_GZRS: { value: 6, label: 'Read-access geo-zone-redundant storage (RA-GZRS)' }
});

storageMod.constant('MetallicLicense', {
	SIM_CSL_AT_V2_METALLIC_STORAGE_SERVICE: { value: 100041, label: 'Metallic Cloud Storage Service' },
	SIM_CSL_AT_V2_METALLIC_STORAGE_SERVICE_CAT1: { value: 100042, label: 'Metallic Cloud Storage Service T2' },
	SIM_CSL_AT_V2_METALLIC_STORAGE_SERVICE_CAT2: { value: 100043, label: 'Metallic Cloud Storage Service T3' },
	SIM_CSL_AT_V2_METALLIC_STORAGE_SERVICE_CAT3: { value: 100044, label: 'Metallic Cloud Storage Service T4' },
	SIM_CSL_AT_V2_METALLIC_STORAGE_SERVICE_CAT4: { value: 100045, label: 'Metallic Cloud Storage Service T5' },
	SIM_CSL_AT_V2_METALLIC_STORAGE_SERVICE_CAT5: { value: 100046, label: 'Metallic Cloud Storage Service T6' },
	SIM_CSL_AT_V2_METALLIC_STORAGE_SERVICE_CAT6: { value: 100047, label: 'Metallic Cloud Storage Service T7' },
	SIM_CSL_AT_V2_METALLIC_STORAGE_SERVICE_CAT7: { value: 100048, label: 'Metallic Cloud Storage Service T8' },
	SIM_CSL_AT_V2_METALLIC_STORAGE_SERVICE_CAT8: { value: 100049, label: 'Metallic Cloud Storage Service T9' },
	SIM_CSL_AT_V2_METALLIC_STORAGE_SERVICE_CAT9: { value: 100050, label: 'Metallic Cloud Storage Service T10' }
});

storageMod.constant('HedvigMediaAgentAttribute', {
	DRIVES_REPLACEMENT_IN_PROGRESS: 262144
});

export default storageMod;
