import { commonSetupModule } from 'common/js/modules';

/**
 * A directive for setting the width of the setup steps based on the number of children LI tags.
 */
commonSetupModule.directive('setupSteps', [
	function() {
		return {
			link: function(scope, elem, attr) {
				scope.$watch(
					function() {
						return elem.find('li').length;
					},
					function(steps) {
						if (angular.isNumber(steps) && steps > 0) {
							var percent = 100 / steps;
							percent = Math.floor(percent * 100) / 100;
							elem.find('li').width(percent + '%');
						}
					}
				);
			}
		};
	}
]);

export default commonSetupModule;
