(function() {
	'use strict';

	var mod = angular.module('common.setup');

	/**
	 * A directive for building the app tiles that will be displayed on the getting started page.
	 */
	mod.directive('cvAppTiles', [
		'$timeout',
		function($timeout) {
			return {
				restrict: 'E',
				templateUrl: appUtil.appRoot + 'modules/setup/partials/appTiles.jsp',
				compile: function(element) {
					return {
						pre: function(scope, element, attr, controller) {
							angular.forEach(scope.apps, function(app, i) {
								app.fadeDelay = i * 200;
							});
						}
					};
				},
				controller: [
					'$q',
					'$log',
					'$scope',
					'setupService',
					'cvLoc',
					'userPrefService',
					function($q, $log, $scope, setupService, cvLoc, userPrefService) {
						/**
						 * @property {object} APP_NAME - The name of the app you are
						 *           creating an object for.
						 * @property {string} APP_NAME.appName - The display name of
						 *           the app.
						 * @property {string[]} APP_NAME.appFeatures - The features
						 *           that the app offers.
						 * @property {string} APP_NAME.appLinkBase - The base URL to
						 *           navigate to the app.
						 * @property {string} APP_NAME.appHelpLink - The link to the
						 *           help page for your app.
						 * @property {boolean=} APP_NAME.showAll - Whether or not to
						 *           show all apps along with the app you are created.
						 *           If false, then only completed apps will show
						 *           along with the app you are creating.
						 */
						$scope.appSteps = {
							ADMIN_CONSOLE: {
								appName: cvLoc('label.adminConsole'),
								appFeatures: [
									cvLoc('label.serversFeature1'),
									cvLoc('label.serversFeature2'),
									cvLoc('label.serversFeature3')
								],
								appLinkBase: appUtil.appRoot + 'adminConsole',
								appHelpLink: cvConfig.helpLink + '?p=2316.htm',
								showAll: true
							},
							//									DBS : {
							//										appName : cvLoc('label.dbs'),
							//										appFeatures : [
							//												cvLoc('label.databaseFeature1'),
							//												cvLoc('label.databaseFeature2'),
							//												cvLoc('label.databaseFeature3') ],
							//										appLinkBase : appUtil.appRoot + 'dbs'
							//									},
							ENDPOINT: {
								appName: cvLoc('label.dlo'),
								appFeatures: [
									cvLoc('label.endpointFeature1'),
									cvLoc('label.endpointFeature2'),
									cvLoc('label.endpointFeature3')
								],
								appHelpLink: cvConfig.helpLink + '?p=2649.htm',
								appLinkBase: appUtil.appRoot + 'dlo'
							},
							VSA: {
								appName: cvLoc('label.vsa'),
								appFeatures: [
									cvLoc('label.virtualizationFeature1'),
									cvLoc('label.virtualizationFeature2'),
									cvLoc('label.virtualizationFeature3')
								],
								appHelpLink: cvConfig.helpLink + '?p=2383.htm',
								appLinkBase: appUtil.appRoot + 'vsa'
							},
							//Below code shows the CloudApps tile in gettingStarted page.
							//Once documentation for CloudApps is in place, help link should be updated
							CAPPS: {
								appName: cvLoc('label.capps'),
								appFeatures: [cvLoc('label.cloudappsFeature1'), cvLoc('label.cloudappsFeature2')],
								appHelpLink: cvConfig.helpLink + '?p=2369.htm',
								appLinkBase: appUtil.appRoot + 'capps'
							},
							COMPLIANCE: {
								appName: cvLoc('label.activate'),
								appFeatures: [cvLoc('label.complianceAppFeature1'), cvLoc('label.complianceAppFeature2')],
								appHelpLink: cvConfig.helpLink + '?p=2369.htm',
								appLinkBase: appUtil.appRoot + 'activate'
							}
						};

						angular.forEach($scope.appSteps, function(step, key) {
							step.appType = key;
						});

						$scope.apps = [];

						/**
						 * Add the apps that were completed to the list of apps to be
						 * shows.
						 *
						 * @param {string=}
						 *            except - An optional app name to exclude when
						 *            adding completed apps to the list of shown apps.
						 */
						var addCompleted = function(except) {
							var i = 1;
							angular.forEach($scope.appSteps, function(step, key) {
								if (step.appSetupCompleted && key !== except) {
									step.fadeDelay = i * 200;
									i++;
									$scope.apps.push(step);
								}
							});

							if ($scope.apps.length < Object.keys($scope.appSteps).length) {
								$scope.apps.push({
									showMore: true,
									fadeDelay: i * 200
								});
							}
						};

						userPrefService.getLoadedUserPrefs()['finally'](function() {
							var markedAsComplete = {};
							if (angular.isDefined(cv.userPref.markedAsCompleteSetups)) {
								try {
									markedAsComplete = JSON.parse(cv.userPref.markedAsCompleteSetups);
								} catch (e) {
									$log.error(e);
								}
							}

							var checkIfCompleted = [];
							angular.forEach($scope.appSteps, function(step, key) {
								if (!markedAsComplete[key]) {
									var promise = setupService.getSetupStepsForApp(key);
									promise.success(function(data) {
										if (angular.isArray(data)) {
											step.appSetupCompleted = data.every(function(finished) {
												return finished;
											});
										}
									});
									checkIfCompleted.push(promise);
								} else {
									$scope.appSteps[key].appSetupCompleted = true;
								}
							});

							var addAppsToShow = function() {
								if (angular.isDefined($scope.appSteps[cvApp.acApp]) && $scope.appSteps[cvApp.acApp].showAll) {
									$scope.apps.push($scope.appSteps[cvApp.acApp]);
									var i = 1;
									angular.forEach($scope.appSteps, function(step, key) {
										if (key != cvApp.acApp) {
											step.fadeDelay = i * 200;
											i++;
											$scope.apps.push(step);
										}
									});
								} else {
									$scope.apps.push($scope.appSteps[cvApp.acApp]);
									addCompleted(cvApp.acApp);
								}

								$scope.allSetupsCompleted =
									$scope.appSteps.ADMIN_CONSOLE.appSetupCompleted &&
									$scope.appSteps.ENDPOINT.appSetupCompleted &&
									$scope.appSteps.VSA.appSetupCompleted &&
									$scope.appSteps.DBS.appSetupCompleted &&
									$scope.appSteps.EBS.appSetupCompleted &&
									$scope.appSteps.CAPPS.appSetupCompleted;
							};

							if (checkIfCompleted.length > 0) {
								$q.all(checkIfCompleted)['finally'](addAppsToShow);
							} else {
								addAppsToShow(cvApp.acApp);
							}
						});

						/**
						 * Push all completed apps on to the apps that are shown in
						 * the Getting Started page.
						 */
						this.pushMoreApps = function() {
							var i = 1;
							angular.forEach($scope.appSteps, function(step, i) {
								if (!step.appSetupCompleted && $scope.apps.indexOf(step) < 0) {
									step.fadeDelay = i * 200;
									i++;
									$scope.apps.push(step);
								}
							});
						};
					}
				]
			};
		}
	]);

	mod.directive('cvAppSetup', [
		'$timeout',
		'$route',
		function($timeout, $route) {
			return {
				restrict: 'E',
				require: '^cvAppTiles',
				templateUrl: appUtil.appRoot + 'modules/setup/partials/appSetup.jsp',
				scope: {
					cvAppOptions: '='
				},
				compile: function(element) {
					element.hide();
					return {
						post: function(scope, element, attr, controller) {
							if (angular.isDefined(scope.cvAppOptions)) {
								element
									.find('svg')
									.first()
									.append(scope.cvAppOptions.appIcon);
								$timeout(
									function() {
										element.fadeIn(800);
									},
									angular.isDefined(scope.cvAppOptions.fadeDelay) ? scope.cvAppOptions.fadeDelay : 200
								);
							}

							/**
							 * Handle a user clicking on the app setup.
							 */
							scope.handleClick = function() {
								if (!scope.cvAppOptions.showMore) {
									if (scope.cvAppOptions.appSetupCompleted) {
										window.location.href = window.location.origin + scope.cvAppOptions.appLinkBase + '/#/dashboard';
									} else {
										window.location.href = window.location.origin + scope.cvAppOptions.appLinkBase + '?forceSetup=true';
									}
									$route.reload();
								} else {
									element.fadeOut(function() {
										controller.pushMoreApps();
										scope.$apply();
									});
								}
							};
						}
					};
				}
			};
		}
	]);
})();
